*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9000()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9000(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9000=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9001()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9001(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9001=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9002()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9002(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9002=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9003()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9003(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9003=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9004()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9004(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9004=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9005()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9005(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9005=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9006()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9006(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9006=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9007()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9007(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9007=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9008()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U536/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(536).EQ.0) CALL CC9008(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9008=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9009()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9009(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9009=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F900()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC900(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(4*P1-C(4))+C(3))-C(1)-C(2)*P1
      F900=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9010()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9010(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9010=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9011()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9011(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9011=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9012()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9012(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9012=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9013()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9013(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9013=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9014()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9014(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9014=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9015()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9015(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9015=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9016()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9016(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9016=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9017()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9017(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9017=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9018()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U537/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(537).EQ.0) CALL CC9018(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9018=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9019()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U538/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(538).EQ.0) CALL CC9019(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9019=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F901()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC901(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F901=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9020()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U538/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(538).EQ.0) CALL CC9020(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9020=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9021()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H3  |!  H3 | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U538/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(538).EQ.0) CALL CC9021(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F9021=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9022()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U538/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(538).EQ.0) CALL CC9022(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9022=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9023()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H3  |!  H3 | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U538/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(538).EQ.0) CALL CC9023(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9023=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9024()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H3   !  H3 | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U538/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(538).EQ.0) CALL CC9024(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9024=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9025()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9025(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9025=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9026()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9026(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9026=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9027()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9027(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9027=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9028()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9028(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9028=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9029()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  d  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9029(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9029=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F902()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC902(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F902=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9030()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  s  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9030(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9030=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9031()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  b  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9031(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9031=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9032()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9032(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9032=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9033()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9033(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9033=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9034()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9034(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9034=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9035()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  d  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9035(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9035=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9036()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  s  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9036(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9036=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9037()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  b  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9037(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9037=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9038()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9038(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9038=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9039()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9039(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9039=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F903()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  Z  | ~o2                      
*                =====@-------!-----@---2-@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC903(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))+C(1)
      F903=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9040()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  d  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9040(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9040=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9041()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  s  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9041(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9041=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9042()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  b  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9042(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9042=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9043()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9043(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9043=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9044()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  d  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9044(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9044=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9045()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  s  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9045(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9045=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9046()
*                             !  C          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  b  | ~C1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9046(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9046=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9047()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  d  |  H+   !  H+ |  d  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9047(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9047=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9048()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  d  |  H+   !  H+ |  s  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9048(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9048=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9049()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  d  |  H+   !  H+ |  b  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9049(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9049=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F904()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC904(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(4*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F904=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9050()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  s  |  H+   !  H+ |  s  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9050(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9050=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9051()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  s  |  H+   !  H+ |  b  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9051(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9051=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9052()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  b  |  H+   !  H+ |  b  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U539/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(539).EQ.0) CALL CC9052(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9052=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9053()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9053(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9053=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9054()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9054(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9054=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9055()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9055(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9055=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9056()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  s  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9056(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9056=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9057()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9057(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9057=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9058()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9058(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9058=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9059()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9059(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9059=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F905()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  H3 | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC905(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F905=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9060()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  s  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9060(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9060=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9061()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9061(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9061=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9062()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9062(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9062=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9063()
*                 ~1+    S    !  S          ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  h    !  h  |  s  | ~C1                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9063(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9063=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9064()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9064(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9064=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9065()
*              ~1+          S    !  S          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  s  |  h    !  h  |  s  | ~C1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9065(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9065=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9066()
*                 ~1+          S    !  S    ~1+                      
*                ==>==\     /==<====!==<==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  s  |  h    !  h  | ~C1                      
*                --<--@==<==@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9066(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9066=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9067()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U540/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(540).EQ.0) CALL CC9067(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9067=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9068()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9068(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9068=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9069()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9069(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9069=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F906()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC906(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F906=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9070()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9070(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9070=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9071()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  s  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9071(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9071=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9072()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9072(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9072=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9073()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9073(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9073=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9074()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9074(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9074=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9075()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  s  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9075(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9075=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9076()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9076(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9076=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9077()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9077(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9077=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9078()
*                 ~1+    S    !  S          ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  H    !  H  |  s  | ~C1                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9078(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9078=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9079()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9079(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9079=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F907()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC907(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F907=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9080()
*              ~1+          S    !  S          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  s  |  H    !  H  |  s  | ~C1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9080(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9080=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9081()
*                 ~1+          S    !  S    ~1+                      
*                ==>==\     /==<====!==<==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  s  |  H    !  H  | ~C1                      
*                --<--@==<==@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9081(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9081=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9082()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U541/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(541).EQ.0) CALL CC9082(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9082=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9083()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9083(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9083=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9084()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9084(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9084=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9085()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  s  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9085(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9085=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9086()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H3  |!  H3 | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9086(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9086=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9087()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9087(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9087=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9088()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  s  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9088(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9088=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9089()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H3  |!  H3 | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9089(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9089=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F908()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC908(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F908=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9090()
*              ~1+          S    !  S          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  s  |  H3   !  H3 |  s  | ~C1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9090(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9090=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9091()
*                 ~1+          S    !  S    ~1+                      
*                ==>==\     /==<====!==<==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  s  |  H3   !  H3 | ~C1                      
*                --<--@==<==@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9091(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9091=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9092()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H3   !  H3 | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U542/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(542).EQ.0) CALL CC9092(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9092=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9093()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  d  |  H+   !  H+ |  d  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U543/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(543).EQ.0) CALL CC9093(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9093=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9094()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  d  |  H+   !  H+ |  s  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U543/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(543).EQ.0) CALL CC9094(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9094=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9095()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  d  |  H+   !  H+ |  b  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U543/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(543).EQ.0) CALL CC9095(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9095=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9096()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  s  |  H+   !  H+ |  s  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U543/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(543).EQ.0) CALL CC9096(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9096=RNUM*(TOTNUM/TOTDEN)*Q2(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9097()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  s  |  H+   !  H+ |  b  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U543/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(543).EQ.0) CALL CC9097(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9097=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9098()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  b  |  H+   !  H+ |  b  | ~C1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U543/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(543).EQ.0) CALL CC9098(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9098=RNUM*(TOTNUM/TOTDEN)*Q2(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9099()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9099(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9099=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F909()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC909(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F909=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F90()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o1 |  H    !  H  |  H3 | ~o1                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC90(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F90=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9100()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9100(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9100=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9101()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9101(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9101=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9102()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  b  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9102(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9102=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9103()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9103(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9103=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9104()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9104(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9104=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9105()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9105(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9105=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9106()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  b  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9106(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9106=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9107()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    h   |!  h  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9107(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9107=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9108()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9108(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9108=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9109()
*                 ~1+    B    !  B          ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  h    !  h  |  b  | ~C1                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9109(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9109=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F910()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC910(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+4*P1-8*P2)+P2*(4*P2-C(5))+C(2))+P2*(C(6)*P2-C(4
     >))-C(1)
      F910=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9110()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9110(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9110=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9111()
*              ~1+          B    !  B          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  b  |  h    !  h  |  b  | ~C1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9111(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9111=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9112()
*                 ~1+          B    !  B    ~1+                      
*                ==>==\     /==<====!==<==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  b  |  h    !  h  | ~C1                      
*                --<--@==<==@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9112(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9112=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9113()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U544/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(544).EQ.0) CALL CC9113(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9113=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9114()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9114(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9114=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9115()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9115(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9115=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9116()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9116(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9116=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9117()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  b  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9117(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9117=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9118()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9118(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9118=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9119()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9119(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9119=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F911()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC911(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F911=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9120()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9120(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9120=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9121()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  b  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9121(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9121=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9122()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H   |!  H  | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9122(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9122=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9123()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9123(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9123=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9124()
*                 ~1+    B    !  B          ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  H    !  H  |  b  | ~C1                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9124(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9124=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9125()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9125(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9125=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9126()
*              ~1+          B    !  B          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  b  |  H    !  H  |  b  | ~C1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9126(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9126=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9127()
*                 ~1+          B    !  B    ~1+                      
*                ==>==\     /==<====!==<==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  b  |  H    !  H  | ~C1                      
*                --<--@==<==@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9127(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9127=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9128()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U545/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(545).EQ.0) CALL CC9128(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9128=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9129()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9129(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9129=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F912()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  Z  | ~o2                      
*                =====@------+!-----@---2-@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  Z   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC912(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+P2*(C(4)+C(7)*P2)-C
     >(1)
      F912=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9130()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9130(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9130=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9131()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  b  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9131(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9131=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9132()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H3  |!  H3 | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9132(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9132=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9133()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9133(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9133=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9134()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  b  | ~C1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9134(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9134=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9135()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H3  |!  H3 | ~C1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~C1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9135(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9135=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9136()
*              ~1+          B    !  B          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  b  |  H3   !  H3 |  b  | ~C1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9136(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9136=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9137()
*                 ~1+          B    !  B    ~1+                      
*                ==>==\     /==<====!==<==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  b  |  H3   !  H3 | ~C1                      
*                --<--@==<==@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9137(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9137=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9138()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H3   !  H3 | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U546/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(546).EQ.0) CALL CC9138(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9138=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9139()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U547/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(547).EQ.0) CALL CC9139(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F9139=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F913()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC913(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+8*P1-16*P2)+P2*(8*P2-C(5))+C(2))+P2*(C(6)*P2-C(
     >4))-C(1)
      F913=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9140()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    A   |!  A  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U547/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(547).EQ.0) CALL CC9140(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(3)*(P2-P1)+C(2))-C(1)-C(2)*P1
      F9140=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9141()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  u    !  u  |  u  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U547/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(547).EQ.0) CALL CC9141(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F9141=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9142()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  A    !  A  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U547/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(547).EQ.0) CALL CC9142(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9142=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9143()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    u   |!  u  |  u  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U547/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(547).EQ.0) CALL CC9143(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(3)*(P2-P1)+C(2))+C(1)-C(2)*P2
      F9143=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9144()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  u    !  u  |  u  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U547/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(547).EQ.0) CALL CC9144(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P1)
      F9144=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9145()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U548/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(548).EQ.0) CALL CC9145(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F9145=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9146()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    A   |!  A  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U548/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(548).EQ.0) CALL CC9146(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F9146=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9147()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  c    !  c  |  c  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U548/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(548).EQ.0) CALL CC9147(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F9147=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9148()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  A    !  A  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U548/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(548).EQ.0) CALL CC9148(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9148=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9149()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    c   |!  c  |  c  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U548/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(548).EQ.0) CALL CC9149(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F9149=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F914()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  H3 | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  Z   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC914(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F914=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9150()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  c    !  c  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U548/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(548).EQ.0) CALL CC9150(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F9150=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9151()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U549/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(549).EQ.0) CALL CC9151(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F9151=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9152()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    A   |!  A  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U549/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(549).EQ.0) CALL CC9152(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F9152=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9153()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  t    !  t  |  t  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U549/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(549).EQ.0) CALL CC9153(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F9153=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9154()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  A    !  A  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U549/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(549).EQ.0) CALL CC9154(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9154=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9155()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    t   |!  t  |  t  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U549/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(549).EQ.0) CALL CC9155(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F9155=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9156()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  t    !  t  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U549/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(549).EQ.0) CALL CC9156(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F9156=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9157()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(550).EQ.0) CALL CC9157(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(4)*P1-C(3))+C(2)*P1-C(1)
      F9157=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9158()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(550).EQ.0) CALL CC9158(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9158=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9159()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    Z   |!  Z  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(550).EQ.0) CALL CC9159(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)-C(1)
      F9159=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F915()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC915(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F915=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9160()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  u    !  u  |  u  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(550).EQ.0) CALL CC9160(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F9160=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9161()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(550).EQ.0) CALL CC9161(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9161=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9162()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    Z   |!  Z  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(550).EQ.0) CALL CC9162(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9162=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9163()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  u    !  u  |  u  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(550).EQ.0) CALL CC9163(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F9163=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9164()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  Z    !  Z  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(550).EQ.0) CALL CC9164(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9164=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9165()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    u   |!  u  |  u  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(550).EQ.0) CALL CC9165(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9165=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9166()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  u    !  u  |  u  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U550/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(550).EQ.0) CALL CC9166(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F9166=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9167()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(551).EQ.0) CALL CC9167(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(4)*P1-C(3))+C(2)*P1-C(1)
      F9167=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9168()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(551).EQ.0) CALL CC9168(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9168=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9169()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    Z   |!  Z  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(551).EQ.0) CALL CC9169(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)-C(1)
      F9169=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F916()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC916(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)-C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F916=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9170()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  c    !  c  |  c  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(551).EQ.0) CALL CC9170(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F9170=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9171()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(551).EQ.0) CALL CC9171(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9171=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9172()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    Z   |!  Z  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(551).EQ.0) CALL CC9172(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9172=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9173()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  c    !  c  |  c  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(551).EQ.0) CALL CC9173(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F9173=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9174()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  Z    !  Z  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(551).EQ.0) CALL CC9174(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9174=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9175()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    c   |!  c  |  c  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(551).EQ.0) CALL CC9175(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9175=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9176()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  c    !  c  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U551/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(551).EQ.0) CALL CC9176(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F9176=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9177()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(552).EQ.0) CALL CC9177(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(4)*P1-C(3))+C(2)*P1-C(1)
      F9177=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9178()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(552).EQ.0) CALL CC9178(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9178=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9179()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    Z   |!  Z  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(552).EQ.0) CALL CC9179(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)-C(1)
      F9179=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F917()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC917(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F917=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9180()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  t    !  t  |  t  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(552).EQ.0) CALL CC9180(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F9180=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9181()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(552).EQ.0) CALL CC9181(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9181=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9182()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    Z   |!  Z  | ~s1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(552).EQ.0) CALL CC9182(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9182=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9183()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  t    !  t  |  t  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(552).EQ.0) CALL CC9183(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F9183=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9184()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  Z    !  Z  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(552).EQ.0) CALL CC9184(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9184=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9185()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    t   |!  t  |  t  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(552).EQ.0) CALL CC9185(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9185=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9186()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  t    !  t  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U552/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(552).EQ.0) CALL CC9186(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F9186=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9187()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  d    !  d  |  u  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U553/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(553).EQ.0) CALL CC9187(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9187=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9188()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  d    !  d  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U553/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(553).EQ.0) CALL CC9188(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9188=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9189()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  d    !  d  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U553/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(553).EQ.0) CALL CC9189(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9189=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F918()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC918(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)-C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F918=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(10)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9190()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  d    !  d  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U553/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(553).EQ.0) CALL CC9190(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9190=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9191()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  d    !  d  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U553/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(553).EQ.0) CALL CC9191(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9191=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9192()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  d    !  d  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U553/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(553).EQ.0) CALL CC9192(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9192=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9193()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9193(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9193=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9194()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9194(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9194=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9195()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9195(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9195=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9196()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9196(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9196=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9197()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  u  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9197(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9197=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9198()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  c  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9198(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9198=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9199()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  t  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9199(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9199=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F919()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC919(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+4*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F919=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F91()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC91(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F91=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9200()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9200(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9200=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9201()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9201(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9201=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9202()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9202(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9202=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9203()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  u  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9203(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9203=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9204()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  c  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9204(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9204=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9205()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  t  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9205(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9205=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9206()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9206(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9206=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9207()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9207(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9207=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9208()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  u  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9208(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9208=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9209()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  c  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9209(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9209=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F920()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  Z  | ~o2                      
*                =====@-------!-----@---2-@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC920(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)-C(5)*P2)+P2*(C(4)+C(7)*P2)+C(1)
      F920=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9210()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  t  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9210(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9210=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9211()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9211(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9211=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9212()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  u  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9212(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9212=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9213()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  c  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9213(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9213=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9214()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  t  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9214(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9214=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9215()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  s    !  s  |  u  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9215(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9215=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9216()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  s    !  s  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9216(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9216=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9217()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  s    !  s  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9217(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9217=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9218()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  s    !  s  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9218(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9218=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9219()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  s    !  s  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9219(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9219=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F921()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC921(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F921=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9220()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  s    !  s  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U554/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(554).EQ.0) CALL CC9220(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9220=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9221()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  b    !  b  |  u  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U555/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(555).EQ.0) CALL CC9221(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9221=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9222()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  b    !  b  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U555/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(555).EQ.0) CALL CC9222(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9222=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9223()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  b    !  b  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U555/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(555).EQ.0) CALL CC9223(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9223=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9224()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  b    !  b  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U555/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(555).EQ.0) CALL CC9224(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9224=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9225()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  b    !  b  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U555/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(555).EQ.0) CALL CC9225(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9225=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9226()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  b    !  b  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U555/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(555).EQ.0) CALL CC9226(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9226=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9227()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  G    !  G  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U556/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(556).EQ.0) CALL CC9227(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9227=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9228()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    u   |!  u  |  u  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U556/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(556).EQ.0) CALL CC9228(C)
      S1=A(146)**2
      TOTNUM=+C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P1*(C(3)*(P2-P1)+C(2))+C(1)-C(2)*P2
      F9228=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9229()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  u    !  u  |  u  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U556/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(556).EQ.0) CALL CC9229(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P1)
      F9229=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F922()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  H3 | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC922(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))+C(5)*P2-C(2))-C(1)-C(4)*P2
      F922=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9230()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  G    !  G  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U557/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(557).EQ.0) CALL CC9230(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9230=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9231()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    c   |!  c  |  c  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U557/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(557).EQ.0) CALL CC9231(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F9231=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9232()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  c    !  c  |  c  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U557/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(557).EQ.0) CALL CC9232(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F9232=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9233()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  G    !  G  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U558/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(558).EQ.0) CALL CC9233(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9233=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9234()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    t   |!  t  |  t  | ~s1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U558/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(558).EQ.0) CALL CC9234(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F9234=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9235()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  t    !  t  |  t  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U558/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(558).EQ.0) CALL CC9235(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F9235=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9236()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9236(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9236=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9237()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9237(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9237=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9238()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9238(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9238=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9239()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9239(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9239=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F923()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC923(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F923=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9240()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9240(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9240=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9241()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9241(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9241=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9242()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9242(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9242=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9243()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9243(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9243=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9244()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9244(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9244=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9245()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U559/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(559).EQ.0) CALL CC9245(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9245=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9246()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9246(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9246=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9247()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9247(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9247=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9248()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9248(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9248=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9249()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9249(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9249=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F924()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC924(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F924=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9250()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9250(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9250=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9251()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9251(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9251=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9252()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9252(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9252=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9253()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9253(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9253=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9254()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9254(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9254=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9255()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U560/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(560).EQ.0) CALL CC9255(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9255=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9256()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U561/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(561).EQ.0) CALL CC9256(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9256=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9257()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U561/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(561).EQ.0) CALL CC9257(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9257=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9258()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H3  |!  H3 | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U561/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(561).EQ.0) CALL CC9258(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F9258=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9259()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U561/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(561).EQ.0) CALL CC9259(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9259=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F925()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC925(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F925=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9260()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H3  |!  H3 | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U561/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(561).EQ.0) CALL CC9260(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9260=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9261()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H3   !  H3 | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U561/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(561).EQ.0) CALL CC9261(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9261=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9262()
*              ~1+          d    !  d          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  H+   !  H+ |  c  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U562/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(562).EQ.0) CALL CC9262(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9262=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9263()
*              ~1+          d    !  d          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  H+   !  H+ |  t  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U562/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(562).EQ.0) CALL CC9263(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9263=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9264()
*              ~1+          d    !  d          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  H+   !  H+ |  t  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U562/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(562).EQ.0) CALL CC9264(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9264=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9265()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9265(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9265=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9266()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9266(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9266=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9267()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9267(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9267=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9268()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  c  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9268(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9268=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9269()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9269(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9269=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F926()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC926(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F926=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9270()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9270(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9270=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9271()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9271(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9271=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9272()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  c  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9272(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9272=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9273()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9273(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9273=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9274()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9274(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9274=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9275()
*                 ~1+    c    !  c          ~1+                      
*                ==>==@==>====!==>==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~s1 |  h    !  h  |  c  | ~s1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9275(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9275=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9276()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9276(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9276=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9277()
*              ~1+          c    !  c          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  h    !  h  |  c  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9277(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9277=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9278()
*                 ~1+          c    !  c    ~1+                      
*                ==>==\     /==>====!==>==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  c  |  h    !  h  | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9278(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9278=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9279()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U563/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(563).EQ.0) CALL CC9279(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9279=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F927()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-2-----!---2-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  H    !  H  |  Z  | ~o2                   
*             =====@-1---@-------!-----@---3-@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC927(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(-C(3)-C(4)*P1)+C(6)*P2-C(2))+P2*(C(5)+C(7)*P2)-C(1)
      F927=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9280()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9280(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9280=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9281()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9281(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9281=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9282()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9282(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9282=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9283()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  c  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9283(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9283=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9284()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9284(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9284=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9285()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9285(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9285=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9286()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9286(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9286=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9287()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  c  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9287(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9287=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9288()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9288(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9288=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9289()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9289(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9289=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F928()
*                                   !  H    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o1          Z   |!  Z  | ~o2                      
*                =====\     /-2----+!---2-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H   |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC928(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+P2*(C(4)+C(7)*P2)+C
     >(1)
      F928=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9290()
*                 ~1+    c    !  c          ~1+                      
*                ==>==@==>====!==>==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~s1 |  H    !  H  |  c  | ~s1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9290(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9290=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9291()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9291(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9291=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9292()
*              ~1+          c    !  c          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  H    !  H  |  c  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9292(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9292=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9293()
*                 ~1+          c    !  c    ~1+                      
*                ==>==\     /==>====!==>==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  c  |  H    !  H  | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9293(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9293=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9294()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U564/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(564).EQ.0) CALL CC9294(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9294=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9295()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9295(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9295=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9296()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9296(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9296=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9297()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  c  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9297(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9297=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9298()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H3  |!  H3 | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9298(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9298=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9299()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9299(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9299=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F929()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-2-----!---2-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  H    !  H  |  H3 | ~o2                   
*             =====@-1---@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC929(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(-C(3)-C(4)*P1)+C(6)*P2-C(2))+C(5)*P2-C(1)
      F929=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F92()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC92(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F92=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9300()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  c  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9300(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9300=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9301()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H3  |!  H3 | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9301(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9301=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9302()
*              ~1+          c    !  c          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  H3   !  H3 |  c  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9302(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9302=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9303()
*                 ~1+          c    !  c    ~1+                      
*                ==>==\     /==>====!==>==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  c  |  H3   !  H3 | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9303(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9303=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9304()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H3   !  H3 | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U565/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(565).EQ.0) CALL CC9304(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9304=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9305()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9305(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9305=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9306()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9306(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9306=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9307()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9307(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9307=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9308()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9308(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9308=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9309()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  u  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9309(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9309=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F930()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-2-----!---2-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  Z  |  H    !  H  | ~o2                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC930(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)+C(5)*P2)+P2*(C(4)+C(7)*P2)+C(1)
      F930=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9310()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  c  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9310(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9310=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9311()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  t  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9311(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9311=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9312()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9312(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9312=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9313()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9313(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9313=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9314()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9314(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9314=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9315()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  u  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9315(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9315=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9316()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  c  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9316(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9316=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9317()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  t  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9317(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9317=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9318()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9318(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9318=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9319()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9319(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9319=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F931()
*                                   !  H    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o1          Z   |!  Z  | ~o2                      
*                =====\     /-2----+!---2-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H   |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC931(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)+C(5)*P2)+P2*(C(4)+C(7)*P2)+C
     >(1)
      F931=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9320()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  u  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9320(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9320=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9321()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  c  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9321(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9321=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9322()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  t  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9322(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9322=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9323()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9323(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9323=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9324()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  u  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9324(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9324=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9325()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  c  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9325(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9325=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9326()
*                             !  s          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  t  | ~s1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9326(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9326=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9327()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  H+   !  H+ |  u  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9327(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9327=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9328()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  H+   !  H+ |  c  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9328(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9328=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9329()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  H+   !  H+ |  t  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9329(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9329=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F932()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-2-----!---2-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  Z  |  H    !  H  | ~o2                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC932(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)+C(5)*P2)+P2*(C(4)+C(7)*P2)+C(1)
      F932=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9330()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  H+   !  H+ |  c  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9330(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9330=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9331()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  H+   !  H+ |  t  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9331(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9331=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9332()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  H+   !  H+ |  t  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U566/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(566).EQ.0) CALL CC9332(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9332=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9333()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9333(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9333=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9334()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9334(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9334=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9335()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9335(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9335=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9336()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  t  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9336(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9336=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9337()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9337(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9337=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9338()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9338(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9338=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9339()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9339(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9339=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F933()
*                                   !  H    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o1          Z   |!  Z  | ~o2                      
*                =====\     /-2----+!---2-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H   |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC933(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)+C(5)*P2)+P2*(C(4)+C(7)*P2)+C
     >(1)
      F933=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9340()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  t  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9340(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9340=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9341()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    h   |!  h  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9341(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9341=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9342()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9342(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9342=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9343()
*                 ~1+    t    !  t          ~1+                      
*                ==>==@==>====!==>==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~s1 |  h    !  h  |  t  | ~s1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9343(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9343=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9344()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9344(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9344=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9345()
*              ~1+          t    !  t          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  h    !  h  |  t  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9345(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9345=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9346()
*                 ~1+          t    !  t    ~1+                      
*                ==>==\     /==>====!==>==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  t  |  h    !  h  | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9346(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9346=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9347()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U567/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(567).EQ.0) CALL CC9347(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9347=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9348()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9348(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9348=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9349()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9349(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9349=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F934()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC934(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+4*P1-8*P2)+P2*(4*P2-C(5))+C(2))+P2*(C(4)-C(6)*P
     >2)-C(1)
      F934=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9350()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9350(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9350=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9351()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  t  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9351(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9351=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9352()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9352(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9352=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9353()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9353(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9353=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9354()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9354(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9354=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9355()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  t  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9355(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9355=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9356()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H   |!  H  | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9356(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9356=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9357()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9357(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9357=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9358()
*                 ~1+    t    !  t          ~1+                      
*                ==>==@==>====!==>==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~s1 |  H    !  H  |  t  | ~s1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9358(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9358=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9359()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9359(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9359=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F935()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  H3 | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~o2 |  Z   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC935(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F935=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9360()
*              ~1+          t    !  t          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  H    !  H  |  t  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9360(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9360=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9361()
*                 ~1+          t    !  t    ~1+                      
*                ==>==\     /==>====!==>==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  t  |  H    !  H  | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9361(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F9361=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9362()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U568/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(568).EQ.0) CALL CC9362(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9362=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9363()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9363(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9363=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9364()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9364(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9364=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9365()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  t  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9365(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9365=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9366()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H3  |!  H3 | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9366(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9366=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9367()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9367(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9367=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9368()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  t  | ~s1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9368(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9368=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9369()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H3  |!  H3 | ~s1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9369(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9369=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F936()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC936(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F936=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9370()
*              ~1+          t    !  t          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  H3   !  H3 |  t  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9370(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9370=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9371()
*                 ~1+          t    !  t    ~1+                      
*                ==>==\     /==>====!==>==@==>==                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  t  |  H3   !  H3 | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9371(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9371=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9372()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H3   !  H3 | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U569/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(569).EQ.0) CALL CC9372(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9372=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9373()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  H+   !  H+ |  u  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U570/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(570).EQ.0) CALL CC9373(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9373=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9374()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  H+   !  H+ |  c  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U570/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(570).EQ.0) CALL CC9374(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9374=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9375()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  u  |  H+   !  H+ |  t  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U570/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(570).EQ.0) CALL CC9375(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9375=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9376()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  H+   !  H+ |  c  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U570/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(570).EQ.0) CALL CC9376(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9376=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9377()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  c  |  H+   !  H+ |  t  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U570/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(570).EQ.0) CALL CC9377(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9377=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9378()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  t  |  H+   !  H+ |  t  | ~s1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U570/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(570).EQ.0) CALL CC9378(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F9378=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9379()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9379(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(12*P2-C(4)-4*P1)+P2*(C(3)-12*P2)-C(2))+P2*(P2*(4*P2-
     >C(4))+C(2))-C(1)
      F9379=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F937()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC937(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)-C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F937=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9380()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9380(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9380=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9381()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9381(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9381=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9382()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9382(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9382=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9383()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9383(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9383=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9384()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9384(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9384=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9385()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9385(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9385=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9386()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9386(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9386=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9387()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9387(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9387=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9388()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U571/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(571).EQ.0) CALL CC9388(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9388=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9389()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9389(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9389=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F938()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC938(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F938=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9390()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9390(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9390=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9391()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9391(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9391=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9392()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9392(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9392=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9393()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9393(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9393=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9394()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9394(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9394=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9395()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9395(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9395=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9396()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9396(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9396=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9397()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9397(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9397=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9398()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9398(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9398=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9399()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9399(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9399=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F939()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC939(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)-C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F939=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F93()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC93(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F93=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9400()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9400(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9400=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9401()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9401(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9401=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9402()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9402(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9402=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9403()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9403(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9403=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9404()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9404(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9404=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9405()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9405(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9405=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9406()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9406(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9406=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9407()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9407(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9407=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9408()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9408(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9408=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9409()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9409(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9409=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F940()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  H    !  H  |  H3 | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC940(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(P1*(C(3)+4*P1)+C(2))+C(1)
      F940=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9410()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9410(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9410=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9411()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9411(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9411=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9412()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9412(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9412=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9413()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9413(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9413=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9414()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    W+  |!  W+ | ~S1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(572).EQ.0) CALL CC9414(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9414=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9415()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9415(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9415=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9416()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9416(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9416=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9417()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9417(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9417=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9418()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9418(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9418=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9419()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9419(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9419=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F941()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  H3 |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC941(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))-C(2)-C(5)*P2)-C(1)-C(4)*P2
      F941=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9420()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9420(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9420=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9421()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9421(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9421=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9422()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9422(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9422=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9423()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9423(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9423=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9424()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U572/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(572).EQ.0) CALL CC9424(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9424=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9425()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9425(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9425=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9426()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9426(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9426=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9427()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9427(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9427=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9428()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9428(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9428=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9429()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9429(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9429=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F942()
*                                   !  H    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o1          Z   |!  Z  | ~o2                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  H   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC942(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)+C(3))+C(2)+C(5)*P2)+C(1)+C(4)*P2
      F942=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9430()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9430(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9430=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9431()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9431(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9431=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9432()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9432(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9432=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9433()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9433(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9433=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9434()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U573/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(573).EQ.0) CALL CC9434(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9434=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9435()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9435(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+P2
      F9435=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9436()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9436(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9436=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9437()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9437(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9437=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9438()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9438(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9438=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9439()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9439(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9439=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F943()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  H3 |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC943(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))-C(2)-C(5)*P2)-C(1)-C(4)*P2
      F943=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9440()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9440(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9440=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9441()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9441(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9441=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9442()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9442(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9442=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9443()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9443(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9443=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9444()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9444(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9444=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9445()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9445(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9445=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9446()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9446(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9446=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9447()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9447(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9447=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9448()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9448(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9448=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9449()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U574/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(574).EQ.0) CALL CC9449(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9449=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F944()
*                                   !  H    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o1          Z   |!  Z  | ~o2                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  H   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC944(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)+C(3))+C(2)+C(5)*P2)+C(1)+C(4)*P2
      F944=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9450()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9450(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9450=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9451()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9451(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9451=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9452()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9452(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9452=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9453()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9453(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9453=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9454()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9454(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9454=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9455()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9455(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9455=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9456()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9456(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9456=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9457()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9457(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9457=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9458()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9458(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9458=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9459()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9459(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9459=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F945()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC945(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+4*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F945=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9460()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9460(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9460=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9461()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9461(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9461=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9462()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9462(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9462=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9463()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9463(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9463=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9464()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9464(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9464=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9465()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9465(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9465=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9466()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9466(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9466=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9467()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9467(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9467=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9468()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9468(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9468=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9469()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9469(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9469=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F946()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC946(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F946=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9470()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9470(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9470=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9471()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9471(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9471=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9472()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9472(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9472=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9473()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9473(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9473=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9474()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9474(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9474=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9475()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9475(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9475=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9476()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9476(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9476=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9477()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9477(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9477=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9478()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9478(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9478=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9479()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    H+  |!  H+ | ~S1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~S1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9479(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9479=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F947()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC947(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F947=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9480()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9480(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9480=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9481()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9481(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9481=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9482()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9482(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9482=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9483()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9483(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9483=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9484()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9484(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9484=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9485()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9485(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9485=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9486()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9486(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9486=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9487()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9487(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9487=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9488()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9488(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9488=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9489()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9489(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9489=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F948()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC948(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F948=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9490()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9490(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9490=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9491()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9491(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9491=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9492()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9492(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9492=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9493()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9493(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9493=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9494()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U575/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(575).EQ.0) CALL CC9494(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9494=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9495()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9495(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9495=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9496()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9496(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9496=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9497()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9497(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9497=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9498()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9498(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9498=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9499()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9499(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9499=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F949()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC949(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(4*P1-C(3)-8*P2)+P2*(C(5)+4*P2)+C(2))+P2*(C(4)-C(6)*P
     >2)-C(1)
      F949=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F94()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC94(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F94=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9500()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9500(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9500=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9501()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9501(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9501=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9502()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9502(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9502=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9503()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9503(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9503=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9504()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9504(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9504=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9505()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9505(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9505=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9506()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9506(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9506=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9507()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9507(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9507=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9508()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9508(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9508=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9509()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U576/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(576).EQ.0) CALL CC9509(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9509=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F950()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC950(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F950=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(7)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9510()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9510(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(12*P2-C(4)-4*P1)+P2*(C(3)-12*P2)-C(2))+P2*(P2*(4*P2-
     >C(4))+C(2))-C(1)
      F9510=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9511()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9511(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9511=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9512()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9512(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9512=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9513()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9513(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9513=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9514()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9514(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9514=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9515()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9515(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9515=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9516()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9516(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9516=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9517()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9517(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9517=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9518()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9518(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9518=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9519()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U577/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(577).EQ.0) CALL CC9519(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9519=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F951()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC951(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)+C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F951=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9520()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9520(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9520=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9521()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9521(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9521=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9522()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9522(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9522=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9523()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9523(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9523=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9524()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9524(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9524=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9525()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9525(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9525=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9526()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9526(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9526=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9527()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9527(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9527=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9528()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9528(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9528=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9529()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U578/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(578).EQ.0) CALL CC9529(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9529=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F952()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC952(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+4*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F952=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9530()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9530(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9530=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9531()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9531(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9531=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9532()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9532(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9532=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9533()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9533(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9533=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9534()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9534(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9534=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9535()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9535(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9535=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9536()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9536(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9536=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9537()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9537(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9537=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9538()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9538(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9538=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9539()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9539(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9539=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F953()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC953(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F953=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9540()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9540(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9540=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9541()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9541(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9541=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9542()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9542(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9542=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9543()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9543(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9543=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9544()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9544(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9544=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9545()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9545(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9545=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9546()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9546(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9546=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9547()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9547(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9547=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9548()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9548(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9548=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9549()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9549(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9549=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F954()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U29/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(29).EQ.0) CALL CC954(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(4*P1-C(3)-8*P2)+P2*(C(5)+4*P2)+C(2))+P2*(C(4)-C(6)*P
     >2)-C(1)
      F954=RNUM*(TOTNUM/TOTDEN)*Q2(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9550()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9550(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9550=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9551()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9551(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9551=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9552()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9552(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9552=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9553()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9553(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9553=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9554()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9554(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9554=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9555()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    W+  |!  W+ | ~t1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(579).EQ.0) CALL CC9555(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F9555=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9556()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9556(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9556=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9557()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9557(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9557=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9558()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9558(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9558=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9559()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9559(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9559=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F955()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC955(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)+4*P1)+C(3))-C(1)-C(2)*P1
      F955=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9560()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9560(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9560=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9561()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9561(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9561=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9562()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9562(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9562=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9563()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9563(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9563=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9564()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9564(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9564=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9565()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U579/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(579).EQ.0) CALL CC9565(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9565=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9566()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9566(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+P2
      F9566=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9567()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9567(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9567=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9568()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9568(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9568=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9569()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9569(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9569=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F956()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC956(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C(1)
      F956=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9570()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9570(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9570=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9571()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9571(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9571=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9572()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9572(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9572=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9573()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9573(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9573=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9574()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9574(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9574=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9575()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9575(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9575=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9576()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9576(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9576=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9577()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9577(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9577=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9578()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9578(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9578=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9579()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9579(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9579=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F957()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC957(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)+C(5)*P2)+C(2)*P1-C(1)
      F957=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9580()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U580/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(580).EQ.0) CALL CC9580(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F9580=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9581()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9581(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9581=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9582()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9582(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9582=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9583()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9583(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9583=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9584()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9584(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9584=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9585()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9585(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9585=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9586()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9586(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9586=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9587()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9587(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9587=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9588()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9588(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9588=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9589()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9589(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9589=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F958()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  h  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC958(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F958=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9590()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9590(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9590=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9591()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9591(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9591=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9592()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9592(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9592=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9593()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9593(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9593=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9594()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9594(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9594=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9595()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U581/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(581).EQ.0) CALL CC9595(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9595=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9596()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9596(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9596=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9597()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9597(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9597=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9598()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9598(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9598=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9599()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9599(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9599=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F959()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  H  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC959(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F959=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F95()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC95(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F95=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9600()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9600(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9600=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9601()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9601(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9601=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9602()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9602(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9602=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9603()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9603(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9603=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9604()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9604(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9604=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9605()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9605(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9605=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9606()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9606(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9606=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9607()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9607(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9607=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9608()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9608(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9608=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9609()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9609(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9609=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F960()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC960(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(4*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C(1)
      F960=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9610()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9610(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9610=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9611()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9611(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9611=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9612()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9612(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9612=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9613()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9613(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9613=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9614()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9614(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9614=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9615()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9615(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9615=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9616()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9616(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9616=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9617()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9617(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9617=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9618()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9618(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9618=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9619()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9619(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9619=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F961()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC961(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)+C(5)*P2)+C(2)*P1-C(1)
      F961=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9620()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9620(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F9620=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9621()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9621(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9621=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9622()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9622(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9622=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9623()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9623(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9623=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9624()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9624(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9624=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9625()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    H+  |!  H+ | ~t1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9625(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F9625=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9626()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9626(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9626=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9627()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9627(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9627=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9628()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9628(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9628=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9629()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9629(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9629=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F962()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC962(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)+C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F962=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9630()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9630(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9630=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9631()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9631(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9631=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9632()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9632(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9632=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9633()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9633(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9633=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9634()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9634(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9634=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9635()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9635(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9635=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9636()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9636(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9636=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9637()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9637(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9637=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9638()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9638(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9638=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9639()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9639(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9639=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F963()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC963(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)+C(5)*P2)+C(2)*P1-C(1)
      F963=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9640()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U582/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(582).EQ.0) CALL CC9640(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F9640=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9641()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~T1 |  D    !  D  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U583/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(583).EQ.0) CALL CC9641(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F9641=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9642()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    A   |!  A  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U583/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(583).EQ.0) CALL CC9642(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(3)*(P2-P1)+C(2))-C(1)-C(2)*P1
      F9642=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9643()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~T1 |  D    !  D  |  d  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U583/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(583).EQ.0) CALL CC9643(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F9643=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9644()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~T1 |  A    !  A  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U583/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(583).EQ.0) CALL CC9644(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9644=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9645()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    D   |!  D  |  d  | ~T1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~T1 |  A   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U583/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(583).EQ.0) CALL CC9645(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(3)*(P2-P1)+C(2))+C(1)-C(2)*P2
      F9645=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9646()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  d  |  D    !  D  |  d  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U583/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(583).EQ.0) CALL CC9646(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P1)
      F9646=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9647()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~T1 |  S    !  S  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U584/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(584).EQ.0) CALL CC9647(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F9647=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9648()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    A   |!  A  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U584/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(584).EQ.0) CALL CC9648(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F9648=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9649()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~T1 |  S    !  S  |  s  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U584/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(584).EQ.0) CALL CC9649(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F9649=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F964()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC964(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)+C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F964=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9650()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~T1 |  A    !  A  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U584/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(584).EQ.0) CALL CC9650(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9650=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9651()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    S   |!  S  |  s  | ~T1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~T1 |  A   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U584/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(584).EQ.0) CALL CC9651(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F9651=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9652()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  s  |  S    !  S  |  s  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U584/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(584).EQ.0) CALL CC9652(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F9652=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9653()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~T1 |  B    !  B  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U585/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(585).EQ.0) CALL CC9653(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F9653=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9654()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    A   |!  A  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U585/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(585).EQ.0) CALL CC9654(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F9654=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9655()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~T1 |  B    !  B  |  b  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U585/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(585).EQ.0) CALL CC9655(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F9655=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9656()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~T1 |  A    !  A  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U585/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(585).EQ.0) CALL CC9656(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F9656=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9657()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    B   |!  B  |  b  | ~T1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~T1 |  A   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U585/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(585).EQ.0) CALL CC9657(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F9657=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9658()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  b  |  B    !  B  |  b  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U585/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(585).EQ.0) CALL CC9658(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F9658=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9659()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~T1 |  D    !  D  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9659(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F9659=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F965()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC965(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+4*P1-8*P2)+P2*(4*P2-C(5))+C(2))+P2*(C(6)*P2-C(4
     >))+C(1)
      F965=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9660()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~T1 |  D    !  D  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9660(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9660=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9661()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(586).EQ.0) CALL CC9661(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F9661=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9662()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~T1 |  D    !  D  |  d  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9662(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F9662=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9663()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(586).EQ.0) CALL CC9663(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F9663=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9664()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~T1 |  D    !  D  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9664(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9664=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9665()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~T1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(586).EQ.0) CALL CC9665(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9665=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9666()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~T1 |  D    !  D  |  d  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9666(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F9666=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9667()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~T1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(586).EQ.0) CALL CC9667(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9667=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9668()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9668(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9668=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9669()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    D   |!  D  |  d  | ~T1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~T1 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(586).EQ.0) CALL CC9669(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9669=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F966()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC966(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F966=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9670()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9670(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9670=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9671()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  d  |  D    !  D  |  d  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9671(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F9671=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9672()
*                                   !  D    ~1+                      
*                                  /!==<==@==>==                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~1+          Z   |!  Z  | ~T1                      
*                ==>==\     /-1----+!---1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~T1 |  d  |  D   |!                                
*                --<--@==<==@==<===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(586).EQ.0) CALL CC9672(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9672=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9673()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U586/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(586).EQ.0) CALL CC9673(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9673=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9674()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~T1 |  S    !  S  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9674(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F9674=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9675()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~T1 |  S    !  S  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9675(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9675=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9676()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(587).EQ.0) CALL CC9676(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F9676=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9677()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~T1 |  S    !  S  |  s  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9677(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F9677=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9678()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(587).EQ.0) CALL CC9678(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F9678=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9679()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~T1 |  S    !  S  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9679(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9679=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F967()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  h  | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  Z   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC967(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)-C(3))+C(5)*P2-C(2))+C(1)+C(4)*P2
      F967=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9680()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~T1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(587).EQ.0) CALL CC9680(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9680=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9681()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~T1 |  S    !  S  |  s  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9681(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F9681=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9682()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~T1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(587).EQ.0) CALL CC9682(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9682=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9683()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9683(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9683=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9684()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    S   |!  S  |  s  | ~T1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~T1 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(587).EQ.0) CALL CC9684(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9684=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9685()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9685(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9685=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9686()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  s  |  S    !  S  |  s  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9686(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F9686=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9687()
*                                   !  S    ~1+                      
*                                  /!==<==@==>==                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~1+          Z   |!  Z  | ~T1                      
*                ==>==\     /-1----+!---1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~T1 |  s  |  S   |!                                
*                --<--@==<==@==<===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(587).EQ.0) CALL CC9687(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9687=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9688()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U587/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(587).EQ.0) CALL CC9688(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9688=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9689()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~T1 |  B    !  B  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9689(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F9689=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F968()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  H  | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  Z   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC968(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)-C(3))+C(5)*P2-C(2))+C(1)+C(4)*P2
      F968=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9690()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~T1 |  B    !  B  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9690(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9690=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9691()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(588).EQ.0) CALL CC9691(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F9691=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9692()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~T1 |  B    !  B  |  b  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9692(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F9692=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9693()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~T1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(588).EQ.0) CALL CC9693(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F9693=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9694()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~T1 |  B    !  B  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9694(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F9694=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9695()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~T1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(588).EQ.0) CALL CC9695(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9695=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9696()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~T1 |  B    !  B  |  b  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9696(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F9696=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9697()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    Z   |!  Z  | ~T1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~T1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(588).EQ.0) CALL CC9697(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F9697=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9698()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9698(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9698=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9699()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    B   |!  B  |  b  | ~T1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~T1 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(588).EQ.0) CALL CC9699(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9699=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F969()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC969(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+8*P1-16*P2)+P2*(8*P2-C(5))+C(2))+P2*(C(6)*P2-C(
     >4))+C(1)
      F969=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F96()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC96(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F96=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9700()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9700(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9700=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9701()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  b  |  B    !  B  |  b  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9701(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F9701=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9702()
*                                   !  B    ~1+                      
*                                  /!==<==@==>==                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~1+          Z   |!  Z  | ~T1                      
*                ==>==\     /-1----+!---1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~T1 |  b  |  B   |!                                
*                --<--@==<==@==<===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(588).EQ.0) CALL CC9702(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F9702=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9703()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~T1 |  Z    !  Z  | ~T1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U588/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(588).EQ.0) CALL CC9703(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F9703=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9704()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  d  |  U    !  U  |  d  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U589/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(589).EQ.0) CALL CC9704(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9704=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9705()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  d  |  U    !  U  |  s  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U589/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(589).EQ.0) CALL CC9705(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9705=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9706()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  d  |  U    !  U  |  b  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U589/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(589).EQ.0) CALL CC9706(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9706=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9707()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  s  |  U    !  U  |  s  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U589/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(589).EQ.0) CALL CC9707(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9707=RNUM*(TOTNUM/TOTDEN)*Q2(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9708()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  s  |  U    !  U  |  b  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U589/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(589).EQ.0) CALL CC9708(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9708=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9709()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  b  |  U    !  U  |  b  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U589/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(589).EQ.0) CALL CC9709(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9709=RNUM*(TOTNUM/TOTDEN)*Q2(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F970()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC970(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F970=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9710()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  d  |  C    !  C  |  d  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U590/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(590).EQ.0) CALL CC9710(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9710=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9711()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  d  |  C    !  C  |  s  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U590/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(590).EQ.0) CALL CC9711(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9711=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9712()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  d  |  C    !  C  |  b  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U590/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(590).EQ.0) CALL CC9712(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9712=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9713()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  s  |  C    !  C  |  s  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U590/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(590).EQ.0) CALL CC9713(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9713=RNUM*(TOTNUM/TOTDEN)*Q2(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9714()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  s  |  C    !  C  |  b  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U590/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(590).EQ.0) CALL CC9714(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9714=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9715()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~T1 |  b  |  C    !  C  |  b  | ~T1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U590/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(590).EQ.0) CALL CC9715(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F9715=RNUM*(TOTNUM/TOTDEN)*Q2(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9716()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U591/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(591).EQ.0) CALL CC9716(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9716=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9717()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U591/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(591).EQ.0) CALL CC9717(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9717=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9718()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U591/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(591).EQ.0) CALL CC9718(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9718=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9719()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U591/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(591).EQ.0) CALL CC9719(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F9719=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F971()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U30/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(30).EQ.0) CALL CC971(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+8*P1-16*P2)+P2*(8*P2-C(5))+C(2))+P2*(C(6)*P2-C(
     >4))+C(1)
      F971=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9720()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~T1 |  T    !  T  |  d  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U591/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(591).EQ.0) CALL CC9720(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9720=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9721()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~T1 |  T    !  T  |  s  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U591/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(591).EQ.0) CALL CC9721(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9721=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F9722()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~T1 |  T    !  T  |  b  | ~T1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U591/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(591).EQ.0) CALL CC9722(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F9722=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)
      RETURN
     