*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8000()
*              ~1+          E2   !  E2         ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N2 |  e2 |  H3   !  H3 |  e2 | ~N2                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U447/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(447).EQ.0) CALL CC8000(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8000=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8001()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8001(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8001=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8002()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8002(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8002=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8003()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8003(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8003=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8004()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8004(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8004=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8005()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~1+    W+  |!  W+ | ~n3                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(448).EQ.0) CALL CC8005(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8005=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8006()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~1+    W+  |!  W+ | ~n3                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(448).EQ.0) CALL CC8006(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8006=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8007()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8007(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8007=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8008()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8008(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8008=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8009()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8009(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8009=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F800()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  H  | ~o1                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~o1 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC800(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F800=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8010()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~1+    W+  |!  W+ | ~n3                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(448).EQ.0) CALL CC8010(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8010=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8011()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~1+    W+  |!  W+ | ~n3                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(448).EQ.0) CALL CC8011(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8011=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8012()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8012(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8012=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8013()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8013(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8013=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8014()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~1+    W+  |!  W+ | ~n3                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(448).EQ.0) CALL CC8014(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8014=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8015()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~1+    W+  |!  W+ | ~n3                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(448).EQ.0) CALL CC8015(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8015=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8016()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8016(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8016=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8017()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~1+    W+  |!  W+ | ~n3                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(448).EQ.0) CALL CC8017(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8017=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8018()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~1+    W+  |!  W+ | ~n3                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(448).EQ.0) CALL CC8018(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8018=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8019()
*                    ~1+    n3   !  n3   ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~n3 |  W+   !  W+ | ~n3                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8019(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8019=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F801()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~o1 |  H+   !  H+ | ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC801(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F801=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8020()
*                    ~1+    n3   !  n3   ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~n3 |  W+   !  W+ | ~n3                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8020(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8020=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8021()
*                    ~1+    n3   !  n3   ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~n3 |  W+   !  W+ | ~n3                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(448).EQ.0) CALL CC8021(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8021=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8022()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8022(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8022=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8023()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8023(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8023=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8024()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8024(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8024=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8025()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8025(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8025=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8026()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~1+    H+  |!  H+ | ~n3                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8026(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8026=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8027()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~1+    H+  |!  H+ | ~n3                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8027(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8027=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8028()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8028(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8028=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8029()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8029(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8029=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F802()
*                                !  H+   ~o1                         
*                               /!-->--@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~2+|-P6                          
*                    ~o1    H-  |!  H- | ~o1                         
*                   =====@--<---+!--<--@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~o1 |  H+  |!                                   
*                   =====@-->---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC802(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F802=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8030()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8030(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8030=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8031()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~1+    H+  |!  H+ | ~n3                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8031(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8031=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8032()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~1+    H+  |!  H+ | ~n3                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8032(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8032=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8033()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8033(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8033=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8034()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8034(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8034=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8035()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~1+    H+  |!  H+ | ~n3                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8035(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8035=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8036()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~1+    H+  |!  H+ | ~n3                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8036(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8036=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8037()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8037(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8037=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8038()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~1+    H+  |!  H+ | ~n3                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8038(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8038=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8039()
*                                !  n3   ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~1+    H+  |!  H+ | ~n3                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8039(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8039=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F803()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o1 |  H+   !  H+ |  Z  | ~o1                      
*                =====@-->----!-->--@---1-@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC803(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F803=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8040()
*                    ~1+    n3   !  n3   ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~n3 |  H+   !  H+ | ~n3                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8040(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8040=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8041()
*                    ~1+    n3   !  n3   ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~n3 |  H+   !  H+ | ~n3                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8041(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8041=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8042()
*                    ~1+    n3   !  n3   ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~n3 |  H+   !  H+ | ~n3                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(449).EQ.0) CALL CC8042(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8042=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8043()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U450/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(450).EQ.0) CALL CC8043(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F8043=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8044()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~N3 |  E3   !  E3 |  e3 | ~N3                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U450/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(450).EQ.0) CALL CC8044(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F8044=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8045()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  e3 |  E3   !  E3 |  e3 | ~N3                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U450/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(450).EQ.0) CALL CC8045(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8045=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8046()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(451).EQ.0) CALL CC8046(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F8046=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8047()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(451).EQ.0) CALL CC8047(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8047=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8048()
*                                !  E3   ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~1+    Z   |!  Z  | ~N3                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~N3 |  E3  |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(451).EQ.0) CALL CC8048(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F8048=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8049()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~N3 |  E3   !  E3 |  e3 | ~N3                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(451).EQ.0) CALL CC8049(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F8049=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F804()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o1 |  H+   !  H+ |  h  | ~o1                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC804(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F804=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8050()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(451).EQ.0) CALL CC8050(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8050=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8051()
*                                !  E3   ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~1+    Z   |!  Z  | ~N3                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~N3 |  E3  |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(451).EQ.0) CALL CC8051(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F8051=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8052()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~N3 |  E3   !  E3 |  e3 | ~N3                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(451).EQ.0) CALL CC8052(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F8052=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8053()
*                    ~1+    E3   !  E3   ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  Z    !  Z  | ~N3                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(451).EQ.0) CALL CC8053(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8053=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8054()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    E3  |!  E3 |  e3 | ~N3                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n3|P5    |!                                      
*                 ~N3 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(451).EQ.0) CALL CC8054(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F8054=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8055()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  e3 |  E3   !  E3 |  e3 | ~N3                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U451/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(451).EQ.0) CALL CC8055(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F8055=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8056()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8056(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8056=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8057()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8057(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8057=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8058()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8058(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8058=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8059()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8059(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8059=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F805()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o1 |  H+   !  H+ |  H  | ~o1                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC805(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F805=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8060()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~N3 |  N3   !  N3 |  e3 | ~N3                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8060(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8060=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8061()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8061(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8061=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8062()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8062(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8062=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8063()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8063(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8063=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8064()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~N3 |  N3   !  N3 |  e3 | ~N3                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8064(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8064=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8065()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8065(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8065=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8066()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8066(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8066=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8067()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~N3 |  N3   !  N3 |  e3 | ~N3                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8067(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8067=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8068()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8068(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8068=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8069()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~N3 |  N3   !  N3 |  e3 | ~N3                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8069(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8069=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F806()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~o1 |  H-   !  H- | ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC806(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F806=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8070()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  e3 |  N3   !  N3 |  e3 | ~N3                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U452/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(452).EQ.0) CALL CC8070(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8070=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8071()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8071(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8071=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8072()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8072(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8072=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8073()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8073(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8073=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8074()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8074(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8074=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8075()
*                             !  N3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  e3 | ~N3                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8075(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8075=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8076()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8076(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8076=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8077()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8077(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8077=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8078()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8078(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8078=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8079()
*                             !  N3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  e3 | ~N3                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8079(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8079=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F807()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  Z  | ~o1                      
*                =====@-->---+!-->--@---1-@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o1 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC807(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F807=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8080()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8080(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8080=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8081()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8081(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8081=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8082()
*                             !  N3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  e3 | ~N3                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8082(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8082=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8083()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8083(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8083=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8084()
*                             !  N3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  e3 | ~N3                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8084(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8084=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8085()
*              ~1+          N3   !  N3         ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  e3 |  H+   !  H+ |  e3 | ~N3                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U453/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(453).EQ.0) CALL CC8085(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8085=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8086()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8086(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8086=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8087()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8087(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8087=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8088()
*                                !  E3   ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~1+    h   |!  h  | ~N3                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~N3 |  E3  |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8088(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8088=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8089()
*                             !  E3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  e3 | ~N3                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~N3 |  E3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8089(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8089=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F808()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  h  | ~o1                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o1 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC808(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F808=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8090()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8090(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8090=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8091()
*                                !  E3   ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~1+    h   |!  h  | ~N3                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~N3 |  E3  |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8091(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8091=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8092()
*                             !  E3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  e3 | ~N3                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~N3 |  E3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8092(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8092=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8093()
*                    ~1+    E3   !  E3   ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  h    !  h  | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8093(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8093=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8094()
*                 ~1+    E3   !  E3         ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n3|P5     !     |     |                          
*                 ~N3 |  h    !  h  |  e3 | ~N3                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8094(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8094=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8095()
*              ~1+          E3   !  E3         ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  e3 |  h    !  h  |  e3 | ~N3                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U454/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(454).EQ.0) CALL CC8095(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8095=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8096()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8096(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8096=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8097()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8097(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8097=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8098()
*                                !  E3   ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~1+    H   |!  H  | ~N3                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~N3 |  E3  |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8098(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8098=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8099()
*                             !  E3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  e3 | ~N3                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~N3 |  E3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8099(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8099=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F809()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  H  | ~o1                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o1 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC809(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F809=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F80()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC80(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F80=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8100()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8100(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8100=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8101()
*                                !  E3   ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~1+    H   |!  H  | ~N3                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~N3 |  E3  |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8101(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8101=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8102()
*                             !  E3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  e3 | ~N3                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~N3 |  E3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8102(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8102=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8103()
*                    ~1+    E3   !  E3   ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  H    !  H  | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8103(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8103=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8104()
*                 ~1+    E3   !  E3         ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n3|P5     !     |     |                          
*                 ~N3 |  H    !  H  |  e3 | ~N3                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8104(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8104=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8105()
*              ~1+          E3   !  E3         ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  e3 |  H    !  H  |  e3 | ~N3                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U455/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(455).EQ.0) CALL CC8105(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8105=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8106()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U456/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(456).EQ.0) CALL CC8106(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8106=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8107()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U456/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(456).EQ.0) CALL CC8107(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8107=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8108()
*                             !  E3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  e3 | ~N3                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~N3 |  E3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U456/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(456).EQ.0) CALL CC8108(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8108=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8109()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U456/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(456).EQ.0) CALL CC8109(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8109=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F810()
*              ~o1          H-   !  H-         ~o1                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  H+   !  H+ |  Z  | ~o1                   
*             =====@-1---@-->----!-->--@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC810(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F810=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8110()
*                             !  E3         ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  e3 | ~N3                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~N3 |  E3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U456/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(456).EQ.0) CALL CC8110(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8110=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8111()
*              ~1+          E3   !  E3         ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  e3 |  H3   !  H3 |  e3 | ~N3                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U456/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(456).EQ.0) CALL CC8111(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8111=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8112()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8112(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8112=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8113()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8113(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8113=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8114()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8114(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8114=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8115()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8115(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8115=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8116()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8116(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8116=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8117()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8117(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8117=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8118()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8118(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8118=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8119()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8119(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8119=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F811()
*              ~o1          H-   !  H-         ~o1                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  H+   !  H+ |  h  | ~o1                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC811(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F811=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8120()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8120(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8120=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8121()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8121(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8121=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8122()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8122(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8122=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8123()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8123(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8123=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8124()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8124(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8124=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8125()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8125(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8125=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8126()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8126(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8126=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8127()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8127(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8127=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8128()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8128(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8128=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8129()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8129(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8129=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F812()
*              ~o1          H-   !  H-         ~o1                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  H+   !  H+ |  H  | ~o1                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC812(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F812=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8130()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8130(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8130=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8131()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8131(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8131=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8132()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8132(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8132=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8133()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8133(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8133=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8134()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8134(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8134=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8135()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8135(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8135=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8136()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8136(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8136=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8137()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    W+  |!  W+ | ~u1                         
*                   ==>==@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(457).EQ.0) CALL CC8137(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8137=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8138()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8138(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(12*P2-C(4)-4*P1)+P2*(C(3)-12*P2)-C(2))+P2*(P2*(4*P2-
     >C(4))+C(2))-C(1)
      F8138=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8139()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8139(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8139=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F813()
*              ~o1          H-   !  H-         ~o1                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H  |  H+   !  H+ |  H  | ~o1                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U26/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(26).EQ.0) CALL CC813(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F813=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8140()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8140(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8140=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8141()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8141(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8141=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8142()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8142(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8142=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8143()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8143(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8143=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8144()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8144(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8144=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8145()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8145(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8145=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8146()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8146(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8146=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8147()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U457/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(457).EQ.0) CALL CC8147(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8147=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8148()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8148(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8148=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8149()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8149(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8149=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F814()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC814(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(8*(P2-P1)+C(7))-C(5)-C(6)*P1)+C(4)*P1-C(3))+C(1)
     >+C(2)*P1
      F814=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8150()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8150(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8150=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8151()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8151(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8151=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8152()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8152(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8152=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8153()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8153(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8153=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8154()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8154(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8154=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8155()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8155(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8155=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8156()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8156(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8156=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8157()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U458/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(458).EQ.0) CALL CC8157(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8157=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8158()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8158(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8158=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8159()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8159(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8159=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F815()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC815(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F815=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8160()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8160(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8160=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8161()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8161(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8161=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8162()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8162(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8162=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8163()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8163(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8163=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8164()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8164(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8164=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8165()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8165(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8165=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8166()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8166(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8166=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8167()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U459/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(459).EQ.0) CALL CC8167(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8167=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8168()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8168(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8168=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8169()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8169(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8169=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F816()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC816(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(16*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)+C(1
     >)-C(2)*P1
      F816=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8170()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8170(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8170=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8171()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8171(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8171=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8172()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8172(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8172=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8173()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8173(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8173=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8174()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8174(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8174=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8175()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8175(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8175=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8176()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8176(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8176=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8177()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8177(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8177=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8178()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8178(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8178=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8179()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8179(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8179=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F817()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC817(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+8*P1-16*P2)+P2*(8*P2-C(9))+C(7))+P1*(-C(5)-
     >C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F817=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8180()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8180(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8180=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8181()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8181(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8181=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8182()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8182(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8182=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8183()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8183(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8183=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8184()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8184(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8184=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8185()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8185(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8185=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8186()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8186(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8186=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8187()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8187(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8187=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8188()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8188(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8188=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8189()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8189(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8189=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F818()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  Z    !  Z  |  h  | ~o2                      
*                =====@-2-----!---2-@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC818(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P2*(C(8)*P2-C(5)-C(6)*P1)+C(2)+C(3)*P1)+P2*(C(7)*P2-C(4)
     >)+C(1)
      F818=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8190()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8190(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8190=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8191()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8191(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8191=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8192()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8192(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8192=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8193()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8193(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8193=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8194()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8194(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8194=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8195()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8195(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8195=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8196()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8196(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8196=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8197()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~1+    H+  |!  H+ | ~u1                         
*                   ==>==@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8197(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8197=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8198()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8198(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+P2
      F8198=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8199()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8199(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8199=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F819()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  Z    !  Z  |  H  | ~o2                      
*                =====@-2-----!---2-@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC819(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P2*(C(8)*P2-C(5)-C(6)*P1)+C(2)+C(3)*P1)+P2*(C(7)*P2-C(4)
     >)+C(1)
      F819=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F81()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o1 |  Z    !  Z  | ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC81(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(4*P1-C(3)-8*P2)+P2*(C(5)+4*P2)+C(2))+P2*(C(4)-C(6)*P
     >2)-C(1)
      F81=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8200()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8200(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8200=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8201()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8201(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8201=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8202()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8202(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8202=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8203()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8203(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8203=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8204()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8204(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8204=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8205()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8205(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8205=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8206()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8206(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8206=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8207()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8207(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8207=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8208()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8208(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8208=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8209()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8209(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8209=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F820()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC820(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(16*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)+C(1
     >)-C(2)*P1
      F820=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8210()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8210(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8210=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8211()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8211(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8211=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8212()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U460/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(460).EQ.0) CALL CC8212(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8212=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8213()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8213(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8213=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8214()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8214(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8214=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8215()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8215(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8215=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8216()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8216(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8216=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8217()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8217(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8217=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8218()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8218(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8218=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8219()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8219(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8219=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F821()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC821(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F821=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8220()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8220(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8220=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8221()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8221(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8221=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8222()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8222(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8222=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8223()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8223(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8223=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8224()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8224(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8224=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8225()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8225(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8225=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8226()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8226(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8226=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8227()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U461/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(461).EQ.0) CALL CC8227(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8227=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8228()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8228(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8228=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8229()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8229(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8229=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F822()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC822(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(16*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)+C(1
     >)-C(2)*P1
      F822=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8230()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8230(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8230=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8231()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8231(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8231=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8232()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8232(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8232=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8233()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8233(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8233=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8234()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8234(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8234=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8235()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8235(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8235=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8236()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8236(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8236=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8237()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8237(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8237=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8238()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8238(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8238=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8239()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8239(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8239=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F823()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC823(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F823=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8240()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8240(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8240=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8241()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8241(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8241=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8242()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U462/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(462).EQ.0) CALL CC8242(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8242=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8243()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U463/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(463).EQ.0) CALL CC8243(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(2)+2*P1)+C(1)
      F8243=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8244()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    A   |!  A  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U463/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(463).EQ.0) CALL CC8244(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)+C(2))-C(1)-C(2)*P1
      F8244=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8245()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~U1 |  D    !  D  |  d  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U463/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(463).EQ.0) CALL CC8245(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P2)+C(1)+C(3)*P2
      F8245=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8246()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  A    !  A  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U463/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(463).EQ.0) CALL CC8246(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(2*P1-C(2)-4*P2)+P2*(C(2)+2*P2)-C(1)
      F8246=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8247()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    D   |!  D  |  d  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  A   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U463/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(463).EQ.0) CALL CC8247(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(2*(P2-P1)+C(2))+C(1)-C(2)*P2
      F8247=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8248()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  D    !  D  |  d  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U463/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(463).EQ.0) CALL CC8248(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P2*(C(1)+2*P1)
      F8248=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8249()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U464/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(464).EQ.0) CALL CC8249(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F8249=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F824()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC824(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(8*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)+C(1)
     >-C(2)*P1
      F824=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8250()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    A   |!  A  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U464/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(464).EQ.0) CALL CC8250(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F8250=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8251()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~U1 |  S    !  S  |  s  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U464/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(464).EQ.0) CALL CC8251(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F8251=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8252()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  A    !  A  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U464/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(464).EQ.0) CALL CC8252(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F8252=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8253()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    S   |!  S  |  s  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  A   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U464/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(464).EQ.0) CALL CC8253(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F8253=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8254()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  S    !  S  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U464/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(464).EQ.0) CALL CC8254(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8254=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8255()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U465/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(465).EQ.0) CALL CC8255(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F8255=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8256()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    A   |!  A  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U465/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(465).EQ.0) CALL CC8256(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F8256=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8257()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~U1 |  B    !  B  |  b  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U465/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(465).EQ.0) CALL CC8257(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F8257=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8258()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  A    !  A  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U465/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(465).EQ.0) CALL CC8258(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F8258=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8259()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    B   |!  B  |  b  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  A   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U465/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(465).EQ.0) CALL CC8259(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F8259=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F825()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC825(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F825=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8260()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  B    !  B  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U465/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(465).EQ.0) CALL CC8260(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8260=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8261()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(466).EQ.0) CALL CC8261(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F8261=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8262()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(466).EQ.0) CALL CC8262(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8262=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8263()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    Z   |!  Z  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(466).EQ.0) CALL CC8263(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F8263=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8264()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~U1 |  D    !  D  |  d  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(466).EQ.0) CALL CC8264(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F8264=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8265()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(466).EQ.0) CALL CC8265(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8265=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8266()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    Z   |!  Z  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(466).EQ.0) CALL CC8266(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F8266=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8267()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~U1 |  D    !  D  |  d  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(466).EQ.0) CALL CC8267(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F8267=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8268()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  Z    !  Z  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(466).EQ.0) CALL CC8268(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8268=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8269()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    D   |!  D  |  d  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(466).EQ.0) CALL CC8269(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F8269=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F826()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  Z    !  Z  |  h  | ~o2                      
*                =====@-2-----!---2-@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC826(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P2*(C(8)*P2-C(5)-C(6)*P1)+C(2)+C(3)*P1)+P2*(C(7)*P2-C(4)
     >)+C(1)
      F826=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8270()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  D    !  D  |  d  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U466/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(466).EQ.0) CALL CC8270(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F8270=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8271()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(467).EQ.0) CALL CC8271(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F8271=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8272()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(467).EQ.0) CALL CC8272(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8272=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8273()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    Z   |!  Z  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(467).EQ.0) CALL CC8273(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F8273=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8274()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~U1 |  S    !  S  |  s  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(467).EQ.0) CALL CC8274(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F8274=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8275()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(467).EQ.0) CALL CC8275(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8275=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8276()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    Z   |!  Z  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(467).EQ.0) CALL CC8276(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F8276=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8277()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~U1 |  S    !  S  |  s  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(467).EQ.0) CALL CC8277(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F8277=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8278()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  Z    !  Z  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(467).EQ.0) CALL CC8278(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8278=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8279()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    S   |!  S  |  s  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(467).EQ.0) CALL CC8279(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F8279=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F827()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  Z    !  Z  |  H  | ~o2                      
*                =====@-2-----!---2-@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC827(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P2*(C(8)*P2-C(5)-C(6)*P1)+C(2)+C(3)*P1)+P2*(C(7)*P2-C(4)
     >)+C(1)
      F827=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8280()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  S    !  S  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U467/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(467).EQ.0) CALL CC8280(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F8280=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8281()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(468).EQ.0) CALL CC8281(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F8281=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8282()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(468).EQ.0) CALL CC8282(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8282=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8283()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    Z   |!  Z  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(468).EQ.0) CALL CC8283(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)+C(1)
      F8283=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8284()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~U1 |  B    !  B  |  b  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(468).EQ.0) CALL CC8284(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F8284=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8285()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(468).EQ.0) CALL CC8285(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8285=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8286()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    Z   |!  Z  | ~U1                         
*                   ==>==@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(468).EQ.0) CALL CC8286(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F8286=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8287()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~U1 |  B    !  B  |  b  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(468).EQ.0) CALL CC8287(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F8287=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8288()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  Z    !  Z  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(468).EQ.0) CALL CC8288(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8288=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8289()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    B   |!  B  |  b  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(468).EQ.0) CALL CC8289(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F8289=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F828()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC828(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(16*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)+C(1
     >)-C(2)*P1
      F828=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8290()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  B    !  B  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U468/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(468).EQ.0) CALL CC8290(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F8290=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8291()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8291(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8291=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8292()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8292(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8292=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8293()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8293(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8293=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8294()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8294(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8294=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8295()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  d  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8295(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8295=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8296()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  s  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8296(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8296=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8297()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  b  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8297(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8297=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8298()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8298(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8298=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8299()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8299(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8299=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F829()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC829(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F829=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F82()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC82(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F82=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
     >*Q0(6)*Q0(7)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8300()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8300(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8300=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8301()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  d  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8301(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8301=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8302()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  s  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8302(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8302=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8303()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  b  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8303(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8303=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8304()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8304(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8304=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8305()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8305(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8305=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8306()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  d  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8306(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8306=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8307()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  s  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8307(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8307=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8308()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  b  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8308(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8308=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8309()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8309(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8309=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F830()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC830(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(16*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)+C(1
     >)-C(2)*P1
      F830=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8310()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  d  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8310(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8310=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8311()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  s  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8311(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8311=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8312()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~U1 |  U    !  U  |  b  | ~U1                      
*                --<--@==<====!==<==@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8312(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8312=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8313()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  U    !  U  |  d  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8313(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8313=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8314()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  U    !  U  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8314(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8314=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8315()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  U    !  U  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8315(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8315=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8316()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  U    !  U  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8316(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8316=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8317()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  U    !  U  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8317(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8317=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8318()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  U    !  U  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U469/ Q0(4),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(469).EQ.0) CALL CC8318(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8318=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8319()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  C    !  C  |  d  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U470/ Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(470).EQ.0) CALL CC8319(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8319=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F831()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC831(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F831=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8320()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  C    !  C  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U470/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(470).EQ.0) CALL CC8320(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8320=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8321()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  C    !  C  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U470/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(470).EQ.0) CALL CC8321(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8321=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8322()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  C    !  C  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U470/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(470).EQ.0) CALL CC8322(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8322=RNUM*(TOTNUM/TOTDEN)*Q2(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8323()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  C    !  C  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U470/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(470).EQ.0) CALL CC8323(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8323=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8324()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  C    !  C  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U470/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(470).EQ.0) CALL CC8324(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8324=RNUM*(TOTNUM/TOTDEN)*Q2(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8325()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  T    !  T  |  d  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U471/ Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(471).EQ.0) CALL CC8325(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8325=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8326()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  T    !  T  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U471/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(471).EQ.0) CALL CC8326(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8326=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8327()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  T    !  T  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U471/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(471).EQ.0) CALL CC8327(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8327=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8328()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  T    !  T  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U471/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(471).EQ.0) CALL CC8328(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8328=RNUM*(TOTNUM/TOTDEN)*Q2(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8329()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  T    !  T  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U471/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(471).EQ.0) CALL CC8329(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8329=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F832()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-2-----!---2-\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  Z    !  Z  |  h  | ~o2                   
*             =====@-----@-1-----!---1-@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC832(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(P1*(C(3)+4*P1)+C(2))-C(1)
      F832=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8330()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  T    !  T  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U471/ Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(471).EQ.0) CALL CC8330(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8330=RNUM*(TOTNUM/TOTDEN)*Q2(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8331()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  G    !  G  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U472/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(472).EQ.0) CALL CC8331(C)
      S1=A(146)**2
      TOTNUM=+C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P1*(2*P1-C(2)-4*P2)+P2*(C(2)+2*P2)-C(1)
      F8331=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8332()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    D   |!  D  |  d  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  G   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U472/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(472).EQ.0) CALL CC8332(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P1*(2*(P2-P1)+C(2))+C(1)-C(2)*P2
      F8332=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8333()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  D    !  D  |  d  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U472/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(472).EQ.0) CALL CC8333(C)
      S1=A(146)**2
      TOTNUM=+C(3)*S1
      TOTDEN=+C(2)
      RNUM=+P2*(C(1)+2*P1)
      F8333=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8334()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  G    !  G  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U473/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(473).EQ.0) CALL CC8334(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F8334=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8335()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    S   |!  S  |  s  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  G   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U473/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(473).EQ.0) CALL CC8335(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F8335=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8336()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  S    !  S  |  s  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U473/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(473).EQ.0) CALL CC8336(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8336=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8337()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  G    !  G  | ~U1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U474/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(474).EQ.0) CALL CC8337(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F8337=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8338()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    B   |!  B  |  b  | ~U1                      
*                ==>==@==<===+!==<==@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~U1 |  G   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U474/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(474).EQ.0) CALL CC8338(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F8338=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8339()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  B    !  B  |  b  | ~U1                   
*             --<--@==<==@==<====!==<==@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U474/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(474).EQ.0) CALL CC8339(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8339=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F833()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-2-----!---2-\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  Z    !  Z  |  H  | ~o2                   
*             =====@-----@-1-----!---1-@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC833(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(P1*(C(3)+4*P1)+C(2))-C(1)
      F833=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8340()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8340(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8340=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8341()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8341(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8341=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8342()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8342(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8342=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8343()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8343(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8343=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8344()
*                             !  U          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  s  | ~U1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~U1 |  U   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8344(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8344=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8345()
*                             !  U          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  b  | ~U1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~U1 |  U   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8345(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8345=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8346()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8346(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8346=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8347()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8347(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8347=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8348()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8348(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8348=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8349()
*                             !  U          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  s  | ~U1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~U1 |  U   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8349(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8349=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F834()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-2-----!---2-@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  h  |  Z    !  Z  | ~o2                      
*                =====@-----@-1-----!---1-@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC834(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(C(7)*P2-C(3)-C(4)*P1)+P2*(C(6)+C(9)*P2)-C(2))+P2*(C(
     >5)+C(8)*P2)+C(1)
      F834=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8350()
*                             !  U          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  b  | ~U1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~U1 |  U   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8350(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8350=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8351()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8351(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8351=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8352()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8352(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8352=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8353()
*                             !  U          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  s  | ~U1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~U1 |  U   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8353(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8353=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8354()
*                             !  U          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  b  | ~U1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~U1 |  U   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8354(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8354=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8355()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8355(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8355=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8356()
*                             !  U          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  s  | ~U1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~U1 |  U   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8356(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8356=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8357()
*                             !  U          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  b  | ~U1                      
*                ==>==@-->---+!-->--@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~U1 |  U   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8357(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8357=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8358()
*              ~1+          U    !  U          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  H+   !  H+ |  s  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8358(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8358=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8359()
*              ~1+          U    !  U          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  H+   !  H+ |  b  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8359(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8359=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F835()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-2-----!---2-@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  h  |  Z    !  Z  | ~o2                      
*                =====@-----@-1-----!---1-@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC835(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(C(7)*P2-C(3)-C(4)*P1)+P2*(C(6)+C(9)*P2)-C(2))+P2*(C(
     >5)+C(8)*P2)+C(1)
      F835=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8360()
*              ~1+          U    !  U          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  H+   !  H+ |  b  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U475/ Q0(4),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(475).EQ.0) CALL CC8360(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8360=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8361()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U476/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(476).EQ.0) CALL CC8361(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8361=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8362()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U476/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(476).EQ.0) CALL CC8362(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8362=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8363()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    h   |!  h  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U476/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(476).EQ.0) CALL CC8363(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+4*P2-C(1)-2*P1
      F8363=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8364()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U476/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(476).EQ.0) CALL CC8364(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8364=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8365()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    h   |!  h  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U476/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(476).EQ.0) CALL CC8365(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8365=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8366()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  h    !  h  | ~U1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U476/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(476).EQ.0) CALL CC8366(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+P2
      F8366=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8367()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U477/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(477).EQ.0) CALL CC8367(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8367=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8368()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U477/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(477).EQ.0) CALL CC8368(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8368=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8369()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H   |!  H  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U477/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(477).EQ.0) CALL CC8369(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+4*P2-C(1)-2*P1
      F8369=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F836()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-2-----!---2-\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  Z    !  Z  |  H  | ~o2                   
*             =====@-----@-1-----!---1-@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC836(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(P1*(C(3)+4*P1)+C(2))-C(1)
      F836=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8370()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U477/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(477).EQ.0) CALL CC8370(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8370=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8371()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H   |!  H  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U477/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(477).EQ.0) CALL CC8371(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8371=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8372()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  H    !  H  | ~U1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U477/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(477).EQ.0) CALL CC8372(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+P2
      F8372=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8373()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U478/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(478).EQ.0) CALL CC8373(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8373=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8374()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U478/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(478).EQ.0) CALL CC8374(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8374=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8375()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U478/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(478).EQ.0) CALL CC8375(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8375=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8376()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  H+   !  H+ |  d  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U479/ Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(479).EQ.0) CALL CC8376(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8376=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8377()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  H+   !  H+ |  s  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U479/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(479).EQ.0) CALL CC8377(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8377=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8378()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  H+   !  H+ |  b  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U479/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(479).EQ.0) CALL CC8378(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8378=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8379()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  H+   !  H+ |  s  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U479/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(479).EQ.0) CALL CC8379(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8379=RNUM*(TOTNUM/TOTDEN)*Q2(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F837()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-2-----!---2-@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  H  |  Z    !  Z  | ~o2                      
*                =====@-----@-1-----!---1-@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC837(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(C(7)*P2-C(3)-C(4)*P1)+P2*(C(6)+C(9)*P2)-C(2))+P2*(C(
     >5)+C(8)*P2)+C(1)
      F837=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8380()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  H+   !  H+ |  b  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U479/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(479).EQ.0) CALL CC8380(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8380=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8381()
*              ~1+          C    !  C          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  H+   !  H+ |  b  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U479/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(479).EQ.0) CALL CC8381(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8381=RNUM*(TOTNUM/TOTDEN)*Q2(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8382()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8382(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8382=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8383()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8383(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8383=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8384()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    h   |!  h  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8384(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8384=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8385()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  s  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~U1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8385(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8385=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8386()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8386(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8386=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8387()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    h   |!  h  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8387(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8387=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8388()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  s  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~U1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8388(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8388=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8389()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  h    !  h  | ~U1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8389(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8389=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F838()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-2-----!---2-@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  H  |  Z    !  Z  | ~o2                      
*                =====@-----@-1-----!---1-@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC838(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(C(7)*P2-C(3)-C(4)*P1)+P2*(C(6)+C(9)*P2)-C(2))+P2*(C(
     >5)+C(8)*P2)+C(1)
      F838=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8390()
*                 ~1+    S    !  S          ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~u1|P5     !     |     |                          
*                 ~U1 |  h    !  h  |  s  | ~U1                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8390(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8390=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8391()
*              ~1+          S    !  S          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  h    !  h  |  s  | ~U1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U480/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(480).EQ.0) CALL CC8391(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8391=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8392()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8392(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8392=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8393()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8393(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8393=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8394()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H   |!  H  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8394(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8394=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8395()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  s  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~U1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8395(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8395=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8396()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8396(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8396=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8397()
*                                !  S    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H   |!  H  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  S   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8397(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8397=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8398()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  s  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~U1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8398(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8398=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8399()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  H    !  H  | ~U1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8399(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8399=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F839()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC839(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(8*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)-C(1)
     >-C(2)*P1
      F839=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F83()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o1 |  Z    !  Z  | ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC83(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)+C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F83=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8400()
*                 ~1+    S    !  S          ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~u1|P5     !     |     |                          
*                 ~U1 |  H    !  H  |  s  | ~U1                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8400(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8400=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8401()
*              ~1+          S    !  S          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  H    !  H  |  s  | ~U1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U481/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(481).EQ.0) CALL CC8401(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8401=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8402()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U482/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(482).EQ.0) CALL CC8402(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8402=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8403()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U482/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(482).EQ.0) CALL CC8403(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8403=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8404()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  s  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~U1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U482/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(482).EQ.0) CALL CC8404(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8404=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8405()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U482/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(482).EQ.0) CALL CC8405(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8405=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8406()
*                             !  S          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  s  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~U1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U482/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(482).EQ.0) CALL CC8406(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8406=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8407()
*              ~1+          S    !  S          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  H3   !  H3 |  s  | ~U1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U482/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(482).EQ.0) CALL CC8407(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8407=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8408()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  H+   !  H+ |  d  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U483/ Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(483).EQ.0) CALL CC8408(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8408=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8409()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  H+   !  H+ |  s  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U483/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(483).EQ.0) CALL CC8409(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8409=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F840()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC840(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F840=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8410()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  d  |  H+   !  H+ |  b  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U483/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(483).EQ.0) CALL CC8410(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8410=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8411()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  H+   !  H+ |  s  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U483/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(483).EQ.0) CALL CC8411(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8411=RNUM*(TOTNUM/TOTDEN)*Q2(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8412()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  s  |  H+   !  H+ |  b  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U483/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(483).EQ.0) CALL CC8412(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8412=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8413()
*              ~1+          T    !  T          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  H+   !  H+ |  b  | ~U1                   
*             --<--@==<==@-->----!-->--@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U483/ Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(483).EQ.0) CALL CC8413(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8413=RNUM*(TOTNUM/TOTDEN)*Q2(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8414()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8414(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8414=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8415()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8415(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8415=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8416()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    h   |!  h  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8416(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8416=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8417()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  b  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~U1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8417(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8417=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8418()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8418(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8418=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8419()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    h   |!  h  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8419(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8419=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F841()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC841(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(16*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)-C(1
     >)-C(2)*P1
      F841=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8420()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  b  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~U1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8420(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8420=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8421()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  h    !  h  | ~U1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8421(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8421=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8422()
*                 ~1+    B    !  B          ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~u1|P5     !     |     |                          
*                 ~U1 |  h    !  h  |  b  | ~U1                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8422(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8422=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8423()
*              ~1+          B    !  B          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  h    !  h  |  b  | ~U1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U484/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(484).EQ.0) CALL CC8423(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8423=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8424()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8424(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8424=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8425()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8425(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8425=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8426()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H   |!  H  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~U1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8426(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8426=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8427()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  b  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~U1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8427(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8427=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8428()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8428(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8428=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8429()
*                                !  B    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H   |!  H  | ~U1                         
*                   ==>==@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~U1 |  B   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8429(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8429=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F842()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC842(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F842=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8430()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  b  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~U1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8430(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8430=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8431()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~U1 |  H    !  H  | ~U1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8431(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8431=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8432()
*                 ~1+    B    !  B          ~1+                      
*                ==>==@==<====!==<==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~u1|P5     !     |     |                          
*                 ~U1 |  H    !  H  |  b  | ~U1                      
*                --<--@-------!-----@==<==@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8432(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8432=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8433()
*              ~1+          B    !  B          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  H    !  H  |  b  | ~U1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U485/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(485).EQ.0) CALL CC8433(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8433=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8434()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U486/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(486).EQ.0) CALL CC8434(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8434=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8435()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U486/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(486).EQ.0) CALL CC8435(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8435=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8436()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  b  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~U1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U486/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(486).EQ.0) CALL CC8436(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8436=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8437()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U486/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(486).EQ.0) CALL CC8437(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8437=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8438()
*                             !  B          ~1+                      
*                            /!==<==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  b  | ~U1                      
*                ==>==@------+!-----@==<==@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~U1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U486/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(486).EQ.0) CALL CC8438(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8438=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8439()
*              ~1+          B    !  B          ~1+                   
*             ==>==\     /==<====!==<==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~U1 |  b  |  H3   !  H3 |  b  | ~U1                   
*             --<--@==<==@-------!-----@==<==@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U486/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(486).EQ.0) CALL CC8439(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8439=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F843()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(27).EQ.0) CALL CC843(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(8*(P2-P1)+C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)-C(1)
     >-C(2)*P1
      F843=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8440()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U487/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(487).EQ.0) CALL CC8440(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(2)+2*P1)+C(1)
      F8440=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8441()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    A   |!  A  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U487/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(487).EQ.0) CALL CC8441(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)+C(2))-C(1)-C(2)*P1
      F8441=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8442()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~d1 |  u    !  u  |  u  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U487/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(487).EQ.0) CALL CC8442(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P2)+C(1)+C(3)*P2
      F8442=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8443()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  A    !  A  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U487/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(487).EQ.0) CALL CC8443(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(2*P1-C(2)-4*P2)+P2*(C(2)+2*P2)-C(1)
      F8443=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8444()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    u   |!  u  |  u  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U487/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(487).EQ.0) CALL CC8444(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(2*(P2-P1)+C(2))+C(1)-C(2)*P2
      F8444=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8445()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  u    !  u  |  u  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U487/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(487).EQ.0) CALL CC8445(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P2*(C(1)+2*P1)
      F8445=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8446()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U488/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(488).EQ.0) CALL CC8446(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F8446=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8447()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    A   |!  A  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U488/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(488).EQ.0) CALL CC8447(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F8447=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8448()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~d1 |  c    !  c  |  c  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U488/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(488).EQ.0) CALL CC8448(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F8448=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8449()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  A    !  A  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U488/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(488).EQ.0) CALL CC8449(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F8449=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F844()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U27/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(27).EQ.0) CALL CC844(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+16*P1-32*P2)+P2*(16*P2-C(9))+C(7))+P1*(-C(5
     >)-C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F844=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8450()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    c   |!  c  |  c  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U488/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(488).EQ.0) CALL CC8450(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F8450=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8451()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  c    !  c  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U488/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(488).EQ.0) CALL CC8451(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8451=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8452()
*                    ~1+    A    !  A    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(489).EQ.0) CALL CC8452(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P1)+C(1)
      F8452=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8453()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    A   |!  A  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(489).EQ.0) CALL CC8453(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F8453=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8454()
*                 ~1+    A    !  A          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~d1 |  t    !  t  |  t  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(489).EQ.0) CALL CC8454(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F8454=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8455()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  A    !  A  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(489).EQ.0) CALL CC8455(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F8455=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8456()
*                             !  A          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    t   |!  t  |  t  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(489).EQ.0) CALL CC8456(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F8456=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8457()
*              ~1+          A    !  A          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  t    !  t  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(489).EQ.0) CALL CC8457(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8457=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8458()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(490).EQ.0) CALL CC8458(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(4)*P1-C(3))+C(2)*P1-C(1)
      F8458=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8459()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(490).EQ.0) CALL CC8459(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8459=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F845()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC845(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(4*P1-C(4))+C(3))-C(1)-C(2)*P1
      F845=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8460()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    Z   |!  Z  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(490).EQ.0) CALL CC8460(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)-C(1)
      F8460=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8461()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~d1 |  u    !  u  |  u  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(490).EQ.0) CALL CC8461(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F8461=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8462()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(490).EQ.0) CALL CC8462(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8462=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8463()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    Z   |!  Z  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(490).EQ.0) CALL CC8463(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F8463=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8464()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~d1 |  u    !  u  |  u  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(490).EQ.0) CALL CC8464(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F8464=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8465()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  Z    !  Z  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(490).EQ.0) CALL CC8465(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8465=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8466()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    u   |!  u  |  u  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(490).EQ.0) CALL CC8466(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F8466=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8467()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  u    !  u  |  u  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U490/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(490).EQ.0) CALL CC8467(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F8467=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8468()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(491).EQ.0) CALL CC8468(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(4)*P1-C(3))+C(2)*P1-C(1)
      F8468=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8469()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(491).EQ.0) CALL CC8469(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8469=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F846()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC846(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F846=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8470()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    Z   |!  Z  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(491).EQ.0) CALL CC8470(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)-C(1)
      F8470=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8471()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~d1 |  c    !  c  |  c  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(491).EQ.0) CALL CC8471(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F8471=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8472()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(491).EQ.0) CALL CC8472(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8472=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8473()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    Z   |!  Z  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(491).EQ.0) CALL CC8473(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F8473=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8474()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~d1 |  c    !  c  |  c  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(491).EQ.0) CALL CC8474(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F8474=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8475()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  Z    !  Z  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(491).EQ.0) CALL CC8475(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8475=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8476()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    c   |!  c  |  c  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(491).EQ.0) CALL CC8476(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F8476=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8477()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  c    !  c  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U491/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(491).EQ.0) CALL CC8477(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F8477=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8478()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(492).EQ.0) CALL CC8478(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(4)*P1-C(3))+C(2)*P1-C(1)
      F8478=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8479()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(492).EQ.0) CALL CC8479(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8479=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F847()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC847(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F847=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8480()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    Z   |!  Z  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(492).EQ.0) CALL CC8480(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(C(
     >2)-C(3)*P1)-C(1)
      F8480=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8481()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~d1 |  t    !  t  |  t  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(492).EQ.0) CALL CC8481(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))-C
     >(1)
      F8481=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8482()
*                    ~1+    Z    !  Z    ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(492).EQ.0) CALL CC8482(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F8482=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8483()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    Z   |!  Z  | ~d1                         
*                   ==>==@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(492).EQ.0) CALL CC8483(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))-C(4))+P1*(C(
     >2)+C(3)*P1)+C(1)
      F8483=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8484()
*                 ~1+    Z    !  Z          ~1+                      
*                ==>==@-1-----!---1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~d1 |  t    !  t  |  t  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(492).EQ.0) CALL CC8484(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))-C(2)-C(3)*P1)+P2*(C(6)*P2-C(4))-C
     >(1)
      F8484=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8485()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  Z    !  Z  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(492).EQ.0) CALL CC8485(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8485=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8486()
*                             !  Z          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    t   |!  t  |  t  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(492).EQ.0) CALL CC8486(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F8486=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8487()
*              ~1+          Z    !  Z          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  t    !  t  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(492).EQ.0) CALL CC8487(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F8487=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8488()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8488(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8488=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8489()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8489(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8489=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F848()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  h    !  h  |  Z  | ~o2                      
*                =====@-------!-----@---2-@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC848(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))+C(1)
      F848=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8490()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8490(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8490=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8491()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8491(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8491=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8492()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  u  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8492(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8492=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8493()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  c  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8493(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8493=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8494()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  t  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8494(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8494=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8495()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8495(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8495=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8496()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8496(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8496=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8497()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8497(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8497=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8498()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  u  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8498(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8498=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8499()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  c  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8499(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8499=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F849()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC849(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(4*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F849=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F84()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC84(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+4*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F84=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8500()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  t  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8500(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8500=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8501()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8501(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8501=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8502()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8502(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8502=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8503()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  u  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8503(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8503=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8504()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  c  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8504(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8504=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8505()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  t  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8505(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8505=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8506()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8506(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8506=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8507()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  u  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8507(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8507=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8508()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  c  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8508(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8508=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8509()
*                 ~1+    W+   !  W+         ~1+                      
*                ==>==@-1>----!-->1-\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  t  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8509(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F8509=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F850()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  h    !  h  |  H3 | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC850(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F850=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8510()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  d    !  d  |  u  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8510(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8510=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8511()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  d    !  d  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8511(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8511=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8512()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  d    !  d  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8512(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8512=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8513()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  d    !  d  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8513(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8513=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8514()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  d    !  d  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8514(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8514=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8515()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  d    !  d  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U493/ Q0(5),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(493).EQ.0) CALL CC8515(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8515=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8516()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  s    !  s  |  u  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U494/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(494).EQ.0) CALL CC8516(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8516=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8517()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  s    !  s  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U494/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(494).EQ.0) CALL CC8517(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8517=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8518()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  s    !  s  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U494/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(494).EQ.0) CALL CC8518(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8518=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8519()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  s    !  s  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U494/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(494).EQ.0) CALL CC8519(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8519=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F851()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC851(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F851=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8520()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  s    !  s  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U494/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(494).EQ.0) CALL CC8520(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8520=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8521()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  s    !  s  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U494/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(494).EQ.0) CALL CC8521(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8521=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8522()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  b    !  b  |  u  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U495/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(495).EQ.0) CALL CC8522(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8522=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8523()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  b    !  b  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U495/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(495).EQ.0) CALL CC8523(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8523=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8524()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  b    !  b  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U495/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(495).EQ.0) CALL CC8524(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8524=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8525()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  b    !  b  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U495/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(495).EQ.0) CALL CC8525(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8525=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8526()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  b    !  b  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U495/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(495).EQ.0) CALL CC8526(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8526=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8527()
*              ~1+          W+   !  W+         ~1+                   
*             ==>==\     /-1>----!-->1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  b    !  b  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U495/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(495).EQ.0) CALL CC8527(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F8527=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8528()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  G    !  G  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U496/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(496).EQ.0) CALL CC8528(C)
      S1=A(146)**2
      TOTNUM=+C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P1*(2*P1-C(2)-4*P2)+P2*(C(2)+2*P2)-C(1)
      F8528=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8529()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    u   |!  u  |  u  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U496/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(496).EQ.0) CALL CC8529(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P1*(2*(P2-P1)+C(2))+C(1)-C(2)*P2
      F8529=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F852()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC852(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F852=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8530()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  u    !  u  |  u  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U496/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(496).EQ.0) CALL CC8530(C)
      S1=A(146)**2
      TOTNUM=+C(3)*S1
      TOTDEN=+C(2)
      RNUM=+P2*(C(1)+2*P1)
      F8530=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8531()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  G    !  G  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U497/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(497).EQ.0) CALL CC8531(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F8531=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8532()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    c   |!  c  |  c  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U497/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(497).EQ.0) CALL CC8532(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F8532=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8533()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  c    !  c  |  c  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U497/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(497).EQ.0) CALL CC8533(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8533=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8534()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  G    !  G  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U498/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(498).EQ.0) CALL CC8534(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F8534=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8535()
*                             !  G          ~1+                      
*                            /!---1-\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    t   |!  t  |  t  | ~d1                      
*                ==>==@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U498/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(498).EQ.0) CALL CC8535(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F8535=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8536()
*              ~1+          G    !  G          ~1+                   
*             ==>==\     /-1-----!---1-\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  t    !  t  |  t  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U498/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(498).EQ.0) CALL CC8536(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F8536=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8537()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U499/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(499).EQ.0) CALL CC8537(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8537=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8538()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U499/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(499).EQ.0) CALL CC8538(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8538=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8539()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    h   |!  h  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U499/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(499).EQ.0) CALL CC8539(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+4*P2-C(1)-2*P1
      F8539=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F853()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC853(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F853=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8540()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U499/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(499).EQ.0) CALL CC8540(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8540=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8541()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    h   |!  h  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U499/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(499).EQ.0) CALL CC8541(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8541=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8542()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  h    !  h  | ~d1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U499/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(499).EQ.0) CALL CC8542(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+P2
      F8542=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8543()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U500/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(500).EQ.0) CALL CC8543(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8543=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8544()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U500/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(500).EQ.0) CALL CC8544(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8544=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8545()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H   |!  H  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U500/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(500).EQ.0) CALL CC8545(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+4*P2-C(1)-2*P1
      F8545=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8546()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U500/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(500).EQ.0) CALL CC8546(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8546=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8547()
*                                !  u    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H   |!  H  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U500/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(500).EQ.0) CALL CC8547(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8547=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8548()
*                    ~1+    u    !  u    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  H    !  H  | ~d1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U500/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(500).EQ.0) CALL CC8548(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+P2
      F8548=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8549()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U501/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(501).EQ.0) CALL CC8549(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8549=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F854()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC854(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F854=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8550()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U501/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(501).EQ.0) CALL CC8550(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8550=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8551()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  u    !  u  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U501/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(501).EQ.0) CALL CC8551(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8551=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8552()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8552(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8552=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8553()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8553(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8553=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8554()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8554(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8554=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8555()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8555(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8555=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8556()
*                             !  d          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  c  | ~d1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~d1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8556(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8556=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8557()
*                             !  d          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  t  | ~d1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~d1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8557(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8557=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8558()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8558(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8558=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8559()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8559(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8559=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F855()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC855(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+4*P1-8*P2)+P2*(4*P2-C(5))+C(2))+P2*(C(6)*P2-C(4
     >))-C(1)
      F855=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8560()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8560(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8560=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8561()
*                             !  d          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  c  | ~d1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~d1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8561(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8561=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8562()
*                             !  d          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  t  | ~d1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~d1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8562(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8562=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8563()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8563(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8563=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8564()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8564(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8564=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8565()
*                             !  d          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  c  | ~d1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~d1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8565(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8565=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8566()
*                             !  d          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  t  | ~d1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~d1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8566(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8566=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8567()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8567(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8567=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8568()
*                             !  d          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  c  | ~d1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~d1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8568(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8568=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8569()
*                             !  d          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H+  |!  H+ |  t  | ~d1                      
*                ==>==@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~d1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8569(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8569=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F856()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC856(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F856=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8570()
*              ~1+          d    !  d          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  H+   !  H+ |  c  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8570(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8570=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8571()
*              ~1+          d    !  d          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  H+   !  H+ |  t  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8571(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8571=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8572()
*              ~1+          d    !  d          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  H+   !  H+ |  t  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U502/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(502).EQ.0) CALL CC8572(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8572=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8573()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8573(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8573=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8574()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8574(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8574=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8575()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    h   |!  h  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8575(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8575=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8576()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  c  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~d1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8576(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8576=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8577()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8577(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8577=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8578()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    h   |!  h  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8578(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8578=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8579()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  c  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~d1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8579(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8579=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F857()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  Z  | ~o2                      
*                =====@------+!-----@---2-@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  Z   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC857(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+P2*(C(4)+C(7)*P2)-C
     >(1)
      F857=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8580()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  h    !  h  | ~d1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8580(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8580=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8581()
*                 ~1+    c    !  c          ~1+                      
*                ==>==@==>====!==>==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~d1 |  h    !  h  |  c  | ~d1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8581(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8581=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8582()
*              ~1+          c    !  c          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  h    !  h  |  c  | ~d1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U503/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(503).EQ.0) CALL CC8582(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8582=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8583()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8583(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8583=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8584()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8584(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8584=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8585()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H   |!  H  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8585(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8585=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8586()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  c  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~d1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8586(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8586=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8587()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8587(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8587=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8588()
*                                !  c    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H   |!  H  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8588(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8588=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8589()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  c  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~d1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8589(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8589=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F858()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC858(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+8*P1-16*P2)+P2*(8*P2-C(5))+C(2))+P2*(C(6)*P2-C(
     >4))-C(1)
      F858=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8590()
*                    ~1+    c    !  c    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  H    !  H  | ~d1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8590(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8590=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8591()
*                 ~1+    c    !  c          ~1+                      
*                ==>==@==>====!==>==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~d1 |  H    !  H  |  c  | ~d1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8591(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8591=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8592()
*              ~1+          c    !  c          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  H    !  H  |  c  | ~d1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U504/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(504).EQ.0) CALL CC8592(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8592=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8593()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U505/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(505).EQ.0) CALL CC8593(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8593=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8594()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U505/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(505).EQ.0) CALL CC8594(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8594=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8595()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  c  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~d1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U505/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(505).EQ.0) CALL CC8595(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8595=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8596()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  c    !  c  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U505/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(505).EQ.0) CALL CC8596(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8596=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8597()
*                             !  c          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  c  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~d1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U505/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(505).EQ.0) CALL CC8597(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8597=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8598()
*              ~1+          c    !  c          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  H3   !  H3 |  c  | ~d1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U505/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(505).EQ.0) CALL CC8598(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8598=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8599()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  H+   !  H+ |  u  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U506/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(506).EQ.0) CALL CC8599(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8599=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F859()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  H3 | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  Z   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC859(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F859=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F85()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC85(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F85=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8600()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  H+   !  H+ |  c  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U506/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(506).EQ.0) CALL CC8600(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8600=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8601()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  H+   !  H+ |  t  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U506/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(506).EQ.0) CALL CC8601(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8601=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8602()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  H+   !  H+ |  c  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U506/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(506).EQ.0) CALL CC8602(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8602=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8603()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  H+   !  H+ |  t  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U506/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(506).EQ.0) CALL CC8603(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8603=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8604()
*              ~1+          s    !  s          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  H+   !  H+ |  t  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U506/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(506).EQ.0) CALL CC8604(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8604=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8605()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8605(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8605=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8606()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8606(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8606=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8607()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    h   |!  h  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8607(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8607=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8608()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  t  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~d1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8608(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8608=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8609()
*                    ~1+    h    !  h    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8609(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8609=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F860()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC860(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F860=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8610()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    h   |!  h  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8610(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8610=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8611()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    h   |!  h  |  t  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~d1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8611(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8611=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8612()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  h    !  h  | ~d1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8612(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8612=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8613()
*                 ~1+    t    !  t          ~1+                      
*                ==>==@==>====!==>==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~d1 |  h    !  h  |  t  | ~d1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8613(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8613=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8614()
*              ~1+          t    !  t          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  h    !  h  |  t  | ~d1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U507/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(507).EQ.0) CALL CC8614(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8614=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8615()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8615(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8615=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8616()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8616(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8616=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8617()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H   |!  H  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~d1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8617(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8617=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8618()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  t  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~d1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8618(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8618=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8619()
*                    ~1+    H    !  H    ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8619(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8619=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F861()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC861(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)-C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F861=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8620()
*                                !  t    ~1+                         
*                               /!==>==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~1+    H   |!  H  | ~d1                         
*                   ==>==@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~d1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8620(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8620=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8621()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H   |!  H  |  t  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~d1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8621(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8621=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8622()
*                    ~1+    t    !  t    ~1+                         
*                   ==>==@==>====!==>==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  H    !  H  | ~d1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8622(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F8622=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8623()
*                 ~1+    t    !  t          ~1+                      
*                ==>==@==>====!==>==\     /==>==                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~d1 |  H    !  H  |  t  | ~d1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8623(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F8623=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8624()
*              ~1+          t    !  t          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  H    !  H  |  t  | ~d1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U508/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(508).EQ.0) CALL CC8624(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8624=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8625()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U509/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(509).EQ.0) CALL CC8625(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8625=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8626()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U509/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(509).EQ.0) CALL CC8626(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8626=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8627()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  t  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~d1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U509/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(509).EQ.0) CALL CC8627(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8627=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8628()
*                    ~1+    H3   !  H3   ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~d1 |  t    !  t  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U509/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(509).EQ.0) CALL CC8628(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8628=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8629()
*                             !  t          ~1+                      
*                            /!==>==\     /==>==                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~1+    H3  |!  H3 |  t  | ~d1                      
*                ==>==@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~d1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U509/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(509).EQ.0) CALL CC8629(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8629=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F862()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC862(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F862=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8630()
*              ~1+          t    !  t          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  H3   !  H3 |  t  | ~d1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U509/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(509).EQ.0) CALL CC8630(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8630=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8631()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  H+   !  H+ |  u  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U510/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(510).EQ.0) CALL CC8631(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8631=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8632()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  H+   !  H+ |  c  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U510/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(510).EQ.0) CALL CC8632(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8632=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8633()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  u  |  H+   !  H+ |  t  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U510/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(510).EQ.0) CALL CC8633(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8633=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8634()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  H+   !  H+ |  c  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U510/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(510).EQ.0) CALL CC8634(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8634=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8635()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  c  |  H+   !  H+ |  t  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U510/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(510).EQ.0) CALL CC8635(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8635=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8636()
*              ~1+          b    !  b          ~1+                   
*             ==>==\     /==>====!==>==\     /==>==                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  t  |  H+   !  H+ |  t  | ~d1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U510/ Q0(1),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(510).EQ.0) CALL CC8636(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F8636=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8637()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8637(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8637=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8638()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8638(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8638=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8639()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8639(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8639=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F863()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  Z    !  Z  | ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC863(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)-C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F863=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(10)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8640()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8640(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8640=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8641()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8641(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8641=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8642()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8642(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8642=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8643()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8643(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8643=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8644()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8644(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8644=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8645()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8645(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8645=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8646()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8646(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8646=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8647()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8647(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8647=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8648()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8648(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8648=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8649()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8649(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8649=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F864()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC864(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+4*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F864=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8650()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8650(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8650=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8651()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8651(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8651=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8652()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8652(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8652=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8653()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8653(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8653=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8654()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8654(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8654=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8655()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8655(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8655=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8656()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8656(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8656=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8657()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8657(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8657=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8658()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8658(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)-C(4)*P1)+C(1)+C(2)*P1
      F8658=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8659()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8659(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8659=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F865()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  h    !  h  |  Z  | ~o2                      
*                =====@-------!-----@---2-@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC865(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)-C(5)*P2)+P2*(C(4)+C(7)*P2)+C(1)
      F865=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8660()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8660(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8660=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8661()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8661(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8661=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8662()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    W+  |!  W+ | ~D1                         
*                   ==>==@-1>---+!-->1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(511).EQ.0) CALL CC8662(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)+C(1)
      F8662=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8663()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8663(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(12*P2-C(4)-4*P1)+P2*(C(3)-12*P2)-C(2))+P2*(P2*(4*P2-
     >C(4))+C(2))-C(1)
      F8663=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8664()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8664(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8664=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8665()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8665(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8665=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8666()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8666(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8666=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8667()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8667(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8667=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8668()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8668(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8668=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8669()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8669(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8669=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F866()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC866(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F866=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8670()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8670(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8670=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8671()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8671(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8671=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8672()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U511/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(511).EQ.0) CALL CC8672(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8672=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8673()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8673(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8673=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8674()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8674(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8674=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8675()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8675(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8675=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8676()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8676(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8676=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8677()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8677(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8677=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8678()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8678(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8678=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8679()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8679(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8679=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F867()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  h    !  h  |  H3 | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC867(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))+C(5)*P2-C(2))-C(1)-C(4)*P2
      F867=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8680()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8680(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8680=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8681()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8681(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8681=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8682()
*                    ~1+    S    !  S    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U512/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(512).EQ.0) CALL CC8682(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8682=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8683()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8683(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8683=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8684()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8684(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8684=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8685()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8685(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8685=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8686()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8686(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8686=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8687()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8687(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8687=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8688()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8688(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8688=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8689()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8689(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8689=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F868()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC868(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F868=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8690()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8690(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8690=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8691()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8691(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8691=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8692()
*                    ~1+    B    !  B    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~D1 |  W+   !  W+ | ~D1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U513/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(513).EQ.0) CALL CC8692(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F8692=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8693()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8693(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8693=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8694()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8694(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8694=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8695()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8695(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8695=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8696()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8696(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8696=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8697()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8697(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8697=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8698()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8698(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8698=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8699()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8699(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8699=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F869()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC869(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F869=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F86()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o1 |  Z    !  Z  | ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC86(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(4*P1-C(3)-8*P2)+P2*(C(5)+4*P2)+C(2))+P2*(C(4)-C(6)*P
     >2)-C(1)
      F86=RNUM*(TOTNUM/TOTDEN)*Q2(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8700()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8700(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8700=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8701()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8701(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8701=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8702()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8702(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8702=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8703()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8703(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8703=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8704()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8704(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8704=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8705()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8705(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8705=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8706()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8706(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8706=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8707()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8707(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8707=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8708()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8708(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8708=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8709()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8709(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8709=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F870()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC870(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F870=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8710()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8710(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8710=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8711()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8711(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8711=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8712()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8712(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8712=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8713()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8713(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8713=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8714()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8714(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8714=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8715()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8715(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8715=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8716()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8716(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8716=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8717()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8717(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F8717=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8718()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8718(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8718=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8719()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8719(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8719=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F871()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o2                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U28/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(28).EQ.0) CALL CC871(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F871=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8720()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8720(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8720=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8721()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8721(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8721=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8722()
*                                !  D    ~1+                         
*                               /!==<==@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~1+    H+  |!  H+ | ~D1                         
*                   ==>==@-->---+!-->--@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~D1 |  D   |!                                   
*                   --<--@==<===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8722(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F8722=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8723()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~D1 |  H+   !  H+ | ~D1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8723(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+P2
      F8723=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8724()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~D1 |  H+   !  H+ | ~D1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8724(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8724=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8725()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c2|-P6                          
*                    ~D1 |  H+   !  H+ | ~D1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(514).EQ.0) CALL CC8725(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F8725=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F8726()
*                    ~1+    D    !  D    ~1+                         
*                   ==>==@==<====!==<==@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~D1 |  H+   !  H+ | ~D1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U514/ Q0(9),Q1(9),Q2(9)
      DIMENSION C(3)                                                 