*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6000()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U313/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(313).EQ.0) CALL CC6000(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6000=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6001()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U313/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(313).EQ.0) CALL CC6001(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6001=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6002()
*              ~o2          s    !  s          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~c1 |  c  |  H+   !  H+ |  c  | ~c1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U313/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(313).EQ.0) CALL CC6002(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6002=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6003()
*                 ~o2          s    !  s    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~c1 |  c  |  H+   !  H+ | ~c1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U313/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(313).EQ.0) CALL CC6003(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6003=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6004()
*                 ~o2          s    !  s    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~c1 |  c  |  H+   !  H+ | ~c1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U313/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(313).EQ.0) CALL CC6004(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6004=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6005()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U313/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(313).EQ.0) CALL CC6005(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6005=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6006()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U313/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(313).EQ.0) CALL CC6006(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6006=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6007()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U313/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(313).EQ.0) CALL CC6007(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6007=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6008()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6008(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6008=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6009()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6009(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6009=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F600()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC600(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F600=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6010()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  c  | ~c1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~c1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6010(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6010=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6011()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~c1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6011(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6011=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6012()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~c1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6012(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6012=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6013()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6013(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6013=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6014()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  c  | ~c1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~c1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6014(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6014=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6015()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6015(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6015=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6016()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6016(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6016=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6017()
*              ~o2          b    !  b          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~c1 |  c  |  H+   !  H+ |  c  | ~c1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6017(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6017=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6018()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~c1 |  c  |  H+   !  H+ | ~c1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6018(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6018=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6019()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~c1 |  c  |  H+   !  H+ | ~c1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6019(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6019=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F601()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC601(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F601=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6020()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6020(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6020=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6021()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6021(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6021=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6022()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U314/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(314).EQ.0) CALL CC6022(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6022=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6023()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  A    !  A  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U315/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(315).EQ.0) CALL CC6023(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F6023=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6024()
*                             !  A          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    s   |!  s  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U315/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(315).EQ.0) CALL CC6024(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F6024=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6025()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  s    !  s  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U315/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(315).EQ.0) CALL CC6025(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F6025=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6026()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6026(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6026=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6027()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6027(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6027=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6028()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6028(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6028=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6029()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6029(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6029=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F602()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    H   |!  H  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC602(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F602=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6030()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    Z   |!  Z  | ~s1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(316).EQ.0) CALL CC6030(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6030=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6031()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6031(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6031=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6032()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6032(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F6032=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6033()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6033(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6033=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6034()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6034(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6034=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6035()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    Z   |!  Z  | ~s1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(316).EQ.0) CALL CC6035(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6035=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6036()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6036(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6036=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6037()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6037(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6037=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6038()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6038(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6038=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6039()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    Z   |!  Z  | ~s1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(316).EQ.0) CALL CC6039(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6039=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F603()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC603(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(1)-C(2)*P1
      F603=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6040()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6040(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F6040=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6041()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6041(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6041=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6042()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    Z   |!  Z  | ~s1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(316).EQ.0) CALL CC6042(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6042=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6043()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6043(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F6043=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6044()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  Z    !  Z  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6044(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6044=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6045()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    s   |!  s  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(316).EQ.0) CALL CC6045(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F6045=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6046()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  s    !  s  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U316/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(316).EQ.0) CALL CC6046(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F6046=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6047()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(317).EQ.0) CALL CC6047(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6047=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6048()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(317).EQ.0) CALL CC6048(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6048=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6049()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(317).EQ.0) CALL CC6049(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6049=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F604()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H   |!  H  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC604(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F604=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6050()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  u    !  u  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(317).EQ.0) CALL CC6050(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6050=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6051()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(317).EQ.0) CALL CC6051(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6051=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6052()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(317).EQ.0) CALL CC6052(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6052=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6053()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  u    !  u  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(317).EQ.0) CALL CC6053(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6053=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6054()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(317).EQ.0) CALL CC6054(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6054=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6055()
*                             !  W-         ~o2                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    u   |!  u  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~s1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(317).EQ.0) CALL CC6055(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6055=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6056()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  u    !  u  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U317/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(317).EQ.0) CALL CC6056(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6056=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6057()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(318).EQ.0) CALL CC6057(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6057=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6058()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(318).EQ.0) CALL CC6058(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6058=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6059()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(318).EQ.0) CALL CC6059(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6059=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F605()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC605(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(1)-C(2)*P1
      F605=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6060()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  c    !  c  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(318).EQ.0) CALL CC6060(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6060=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6061()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(318).EQ.0) CALL CC6061(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6061=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6062()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(318).EQ.0) CALL CC6062(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6062=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6063()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  c    !  c  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(318).EQ.0) CALL CC6063(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6063=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6064()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(318).EQ.0) CALL CC6064(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6064=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6065()
*                             !  W-         ~o2                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    c   |!  c  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~s1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(318).EQ.0) CALL CC6065(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6065=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6066()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  c    !  c  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U318/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(318).EQ.0) CALL CC6066(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6066=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6067()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6067(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6067=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6068()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6068(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6068=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6069()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  t    !  t  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6069(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6069=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F606()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC606(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F606=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6070()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(319).EQ.0) CALL CC6070(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6070=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6071()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(319).EQ.0) CALL CC6071(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6071=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6072()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6072(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6072=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6073()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  t    !  t  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6073(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6073=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6074()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(319).EQ.0) CALL CC6074(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6074=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6075()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(319).EQ.0) CALL CC6075(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6075=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6076()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  t    !  t  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6076(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6076=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6077()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t1|-P6                       
*                 ~o2          W-  |!  W- | ~s1                      
*                =====\     /-1<---+!--<1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~s1 |  s  |  t   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(319).EQ.0) CALL CC6077(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6077=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6078()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~o2          W-  |!  W- | ~s1                      
*                =====\     /-1<---+!--<1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~s1 |  s  |  t   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(319).EQ.0) CALL CC6078(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6078=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6079()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6079(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6079=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F607()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC607(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F607=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6080()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6080(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6080=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6081()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U319/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(319).EQ.0) CALL CC6081(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6081=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6082()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  G    !  G  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U320/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(320).EQ.0) CALL CC6082(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F6082=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6083()
*                             !  G          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    s   |!  s  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U320/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(320).EQ.0) CALL CC6083(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F6083=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6084()
*              ~o2          G    !  G          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  s    !  s  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U320/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(320).EQ.0) CALL CC6084(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F6084=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6085()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6085(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6085=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6086()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6086(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6086=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6087()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6087(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6087=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6088()
*                             !  u          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  u   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6088(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6088=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6089()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6089(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6089=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F608()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC608(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F608=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6090()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6090(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6090=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6091()
*                             !  u          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  u   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6091(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6091=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6092()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6092(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F6092=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6093()
*                 ~o2    u    !  u          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~u1|P5     !     |     |                          
*                 ~s1 |  H-   !  H- |  s  | ~s1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6093(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6093=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6094()
*              ~o2          u    !  u          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H-   !  H- |  s  | ~s1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U321/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(321).EQ.0) CALL CC6094(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6094=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6095()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6095(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6095=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6096()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6096(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6096=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6097()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6097(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6097=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6098()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6098(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6098=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6099()
*                             !  c          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6099(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6099=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F609()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC609(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F609=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F60()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o1 |  H3 |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC60(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F60=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6100()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6100(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6100=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6101()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6101(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6101=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6102()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6102(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6102=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6103()
*                             !  c          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6103(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6103=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6104()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6104(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6104=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6105()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6105(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6105=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6106()
*                 ~o2    c    !  c          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~s1 |  H-   !  H- |  s  | ~s1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6106(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6106=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6107()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6107(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6107=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6108()
*                 ~o2    c    !  c          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c2|P5     !     |     |                          
*                 ~s1 |  H-   !  H- |  s  | ~s1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6108(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6108=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6109()
*              ~o2          c    !  c          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H-   !  H- |  s  | ~s1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U322/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(322).EQ.0) CALL CC6109(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6109=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F610()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC610(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F610=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6110()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6110(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6110=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6111()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6111(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6111=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6112()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6112(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6112=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6113()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6113(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6113=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6114()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6114(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6114=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6115()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6115(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6115=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6116()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6116(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6116=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6117()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6117(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6117=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6118()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6118(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6118=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6119()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6119(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6119=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F611()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H   |!  H  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC611(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F611=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(7)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6120()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6120(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6120=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6121()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6121(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6121=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6122()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6122(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6122=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6123()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6123(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6123=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6124()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6124(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6124=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6125()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6125(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6125=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6126()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6126(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6126=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6127()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6127(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6127=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6128()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6128(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6128=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6129()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6129(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6129=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F612()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC612(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(1)-C(2)*P1
      F612=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6130()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6130(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6130=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6131()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6131(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6131=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6132()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6132(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6132=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6133()
*                 ~o2    s    !  s          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~s1 |  h    !  h  |  s  | ~s1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6133(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6133=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6134()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6134(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6134=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6135()
*              ~o2          s    !  s          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  h    !  h  |  s  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6135(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6135=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6136()
*                 ~o2          s    !  s    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  s  |  h    !  h  | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6136(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6136=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6137()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U323/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(323).EQ.0) CALL CC6137(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6137=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6138()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6138(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6138=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6139()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6139(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6139=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F613()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC613(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F613=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6140()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6140(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6140=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6141()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6141(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6141=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6142()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6142(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6142=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6143()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6143(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6143=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6144()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6144(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6144=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6145()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6145(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6145=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6146()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6146(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6146=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6147()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6147(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6147=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6148()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6148(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6148=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6149()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6149(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6149=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F614()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC614(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F614=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6150()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6150(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6150=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6151()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6151(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6151=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6152()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6152(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6152=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6153()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6153(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6153=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6154()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6154(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6154=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6155()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6155(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6155=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6156()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6156(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6156=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6157()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6157(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6157=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6158()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6158(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6158=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6159()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6159(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6159=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F615()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC615(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F615=RNUM*(TOTNUM/TOTDEN)*Q2(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6160()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6160(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6160=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6161()
*                 ~o2    s    !  s          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~s1 |  H    !  H  |  s  | ~s1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6161(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6161=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6162()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6162(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6162=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6163()
*              ~o2          s    !  s          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H    !  H  |  s  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6163(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6163=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6164()
*                 ~o2          s    !  s    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  s  |  H    !  H  | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6164(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6164=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6165()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U324/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(324).EQ.0) CALL CC6165(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6165=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6166()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6166(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6166=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6167()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6167(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6167=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6168()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6168(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6168=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6169()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6169(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6169=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F616()
*              ~o1          h    !  h          ~o1                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  H3   !  H3 |  Z  | ~o1                   
*             =====@-1---@-------!-----@---2-@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC616(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F616=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6170()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6170(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6170=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6171()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H3  |!  H3 | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6171(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6171=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6172()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6172(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6172=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6173()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6173(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6173=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6174()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6174(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6174=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6175()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6175(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6175=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6176()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H3  |!  H3 | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6176(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6176=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6177()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6177(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6177=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6178()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6178(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6178=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6179()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6179(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6179=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F617()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o1|-P6                       
*                 ~o1 |  Z  |  H3   !  H3 | ~o1                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC617(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F617=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6180()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H3  |!  H3 | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6180(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6180=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6181()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6181(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6181=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6182()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6182(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6182=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6183()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H3  |!  H3 | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6183(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6183=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6184()
*              ~o2          s    !  s          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H3   !  H3 |  s  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6184(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6184=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6185()
*                 ~o2          s    !  s    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  s  |  H3   !  H3 | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6185(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6185=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6186()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H3   !  H3 | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U325/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(325).EQ.0) CALL CC6186(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6186=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6187()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6187(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6187=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6188()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6188(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6188=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6189()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6189(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6189=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F618()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o1|-P6                       
*                 ~o1          h   |!  h  | ~o1                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC618(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F618=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6190()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6190(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6190=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6191()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6191(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6191=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6192()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6192(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6192=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6193()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6193(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6193=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6194()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6194(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6194=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6195()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6195(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6195=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6196()
*              ~o2          t    !  t          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H-   !  H- |  s  | ~s1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6196(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6196=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6197()
*                 ~o2          t    !  t    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t1|-P6                       
*                 ~s1 |  s  |  H-   !  H- | ~s1                      
*                -->--@==>==@--<----!--<--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6197(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6197=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6198()
*                 ~o2          t    !  t    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~s1 |  s  |  H-   !  H- | ~s1                      
*                -->--@==>==@--<----!--<--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6198(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6198=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6199()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6199(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6199=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F619()
*              ~o1          h    !  h          ~o1                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  H3   !  H3 |  H3 | ~o1                   
*             =====@-1---@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC619(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F619=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F61()
*                                   !  h    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  h   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC61(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)+C(3))+C(2)+C(5)*P2)+C(1)+C(4)*P2
      F61=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6200()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6200(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6200=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6201()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U326/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(326).EQ.0) CALL CC6201(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6201=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6202()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  A    !  A  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U327/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(327).EQ.0) CALL CC6202(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F6202=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6203()
*                             !  A          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    t   |!  t  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~t1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U327/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(327).EQ.0) CALL CC6203(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F6203=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6204()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  t    !  t  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U327/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(327).EQ.0) CALL CC6204(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F6204=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6205()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6205(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6205=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6206()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6206(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6206=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6207()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6207(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6207=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6208()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6208(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6208=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6209()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6209(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6209=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F620()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o1 |  Z  |  H3   !  H3 | ~o1                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC620(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F620=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6210()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~t1 |  t    !  t  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6210(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6210=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6211()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6211(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6211=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6212()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6212(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F6212=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6213()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6213(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6213=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6214()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6214(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6214=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6215()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6215(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6215=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6216()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~t1 |  t    !  t  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6216(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6216=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6217()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6217(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6217=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6218()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6218(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6218=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6219()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6219(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6219=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F621()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o1          h   |!  h  | ~o1                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC621(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F621=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6220()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6220(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6220=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6221()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~t1 |  t    !  t  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6221(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F6221=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6222()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6222(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6222=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6223()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6223(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6223=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6224()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6224(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6224=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6225()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~t1 |  t    !  t  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6225(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F6225=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6226()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6226(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6226=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6227()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  Z    !  Z  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6227(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6227=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6228()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    t   |!  t  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~t1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6228(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F6228=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6229()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~t1 |  Z    !  Z  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6229(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6229=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F622()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o1 |  Z  |  H3   !  H3 | ~o1                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC622(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F622=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6230()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  t    !  t  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6230(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F6230=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6231()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~o2          Z   |!  Z  | ~t1                      
*                =====\     /-1----+!---1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~t1 |  t  |  t   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(328).EQ.0) CALL CC6231(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F6231=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6232()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~t1 |  Z    !  Z  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U328/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(328).EQ.0) CALL CC6232(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6232=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6233()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(329).EQ.0) CALL CC6233(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6233=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6234()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(329).EQ.0) CALL CC6234(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6234=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6235()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(329).EQ.0) CALL CC6235(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6235=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6236()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~t1 |  d    !  d  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(329).EQ.0) CALL CC6236(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6236=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6237()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(329).EQ.0) CALL CC6237(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6237=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6238()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(329).EQ.0) CALL CC6238(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6238=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6239()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~t1 |  d    !  d  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(329).EQ.0) CALL CC6239(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6239=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F623()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o1          h   |!  h  | ~o1                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC623(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F623=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6240()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(329).EQ.0) CALL CC6240(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6240=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6241()
*                             !  W+         ~o2                      
*                            /!-->1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    d   |!  d  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~t1 |  W+  |!                                      
*                -->--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(329).EQ.0) CALL CC6241(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6241=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6242()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  d    !  d  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U329/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(329).EQ.0) CALL CC6242(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6242=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6243()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(330).EQ.0) CALL CC6243(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6243=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6244()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(330).EQ.0) CALL CC6244(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6244=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6245()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(330).EQ.0) CALL CC6245(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6245=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6246()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~t1 |  s    !  s  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(330).EQ.0) CALL CC6246(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6246=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6247()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(330).EQ.0) CALL CC6247(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6247=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6248()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(330).EQ.0) CALL CC6248(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6248=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6249()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~t1 |  s    !  s  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(330).EQ.0) CALL CC6249(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6249=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F624()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o1 |  Z  |  H3   !  H3 | ~o1                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC624(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F624=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6250()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(330).EQ.0) CALL CC6250(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6250=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6251()
*                             !  W+         ~o2                      
*                            /!-->1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    s   |!  s  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~t1 |  W+  |!                                      
*                -->--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(330).EQ.0) CALL CC6251(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6251=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6252()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  s    !  s  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U330/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(330).EQ.0) CALL CC6252(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6252=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6253()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6253(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6253=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6254()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6254(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6254=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6255()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~t1 |  b    !  b  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6255(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6255=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6256()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(331).EQ.0) CALL CC6256(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6256=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6257()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(331).EQ.0) CALL CC6257(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6257=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6258()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6258(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6258=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6259()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~t1 |  b    !  b  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6259(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6259=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F625()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o1          h   |!  h  | ~o1                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC625(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F625=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6260()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(331).EQ.0) CALL CC6260(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6260=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6261()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(331).EQ.0) CALL CC6261(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6261=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6262()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  b    !  b  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6262(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6262=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6263()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o2          W+  |!  W+ | ~t1                      
*                =====\     /-1>---+!-->1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~t1 |  t  |  b   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(331).EQ.0) CALL CC6263(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6263=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6264()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o2          W+  |!  W+ | ~t1                      
*                =====\     /-1>---+!-->1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~t1 |  t  |  b   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(331).EQ.0) CALL CC6264(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6264=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6265()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6265(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6265=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6266()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6266(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6266=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6267()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U331/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(331).EQ.0) CALL CC6267(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6267=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6268()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  G    !  G  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U332/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(332).EQ.0) CALL CC6268(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F6268=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6269()
*                             !  G          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    t   |!  t  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~t1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U332/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(332).EQ.0) CALL CC6269(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F6269=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F626()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC626(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F626=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6270()
*              ~o2          G    !  G          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  t    !  t  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U332/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(332).EQ.0) CALL CC6270(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F6270=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6271()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6271(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6271=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6272()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6272(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6272=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6273()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6273(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6273=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6274()
*                             !  d          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~t1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6274(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6274=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6275()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6275(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6275=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6276()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6276(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6276=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6277()
*                             !  d          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~t1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6277(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6277=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6278()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6278(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F6278=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6279()
*                 ~o2    d    !  d          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~t1 |  H+   !  H+ |  t  | ~t1                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6279(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6279=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F627()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC627(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F627=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6280()
*              ~o2          d    !  d          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H+   !  H+ |  t  | ~t1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U333/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(333).EQ.0) CALL CC6280(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6280=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6281()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6281(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6281=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6282()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6282(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6282=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6283()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6283(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6283=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6284()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6284(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6284=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6285()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~t1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6285(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6285=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6286()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6286(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6286=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6287()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6287(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6287=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6288()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6288(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6288=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6289()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~t1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6289(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6289=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F628()
*                 ~o1    h    !  h          ~o1                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o1 |  H3   !  H3 |  H3 | ~o1                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC628(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F628=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6290()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6290(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6290=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6291()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6291(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6291=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6292()
*                 ~o2    s    !  s          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~t1 |  H+   !  H+ |  t  | ~t1                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6292(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6292=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6293()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6293(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6293=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6294()
*                 ~o2    s    !  s          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s2|P5     !     |     |                          
*                 ~t1 |  H+   !  H+ |  t  | ~t1                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6294(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6294=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6295()
*              ~o2          s    !  s          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H+   !  H+ |  t  | ~t1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U334/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(334).EQ.0) CALL CC6295(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6295=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6296()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6296(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6296=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6297()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6297(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6297=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6298()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6298(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6298=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6299()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6299(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6299=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F629()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC629(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F629=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F62()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o1 |  H3 |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC62(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F62=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6300()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6300(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6300=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6301()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6301(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6301=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6302()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6302(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6302=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6303()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6303(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6303=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6304()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6304(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6304=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6305()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6305(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6305=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6306()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6306(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6306=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6307()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6307(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6307=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6308()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6308(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6308=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6309()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6309(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6309=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F630()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC630(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F630=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6310()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6310(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6310=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6311()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6311(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6311=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6312()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6312(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6312=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6313()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6313(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6313=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6314()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6314(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6314=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6315()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6315(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6315=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6316()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6316(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6316=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6317()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6317(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6317=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6318()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  h    !  h  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6318(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6318=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6319()
*                 ~o2    t    !  t          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~t1|P5     !     |     |                          
*                 ~t1 |  h    !  h  |  t  | ~t1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6319(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6319=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F631()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC631(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F631=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6320()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~t1 |  h    !  h  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6320(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6320=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6321()
*              ~o2          t    !  t          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  h    !  h  |  t  | ~t1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6321(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6321=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6322()
*                 ~o2          t    !  t    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~t1 |  t  |  h    !  h  | ~t1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6322(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6322=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6323()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~t1 |  h    !  h  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U335/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(335).EQ.0) CALL CC6323(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6323=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6324()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6324(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6324=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6325()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6325(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6325=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6326()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6326(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6326=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6327()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6327(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6327=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6328()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6328(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6328=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6329()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6329(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6329=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F632()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC632(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F632=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6330()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6330(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6330=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6331()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6331(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6331=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6332()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6332(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6332=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6333()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6333(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6333=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6334()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6334(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6334=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6335()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6335(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6335=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6336()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6336(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6336=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6337()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6337(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6337=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6338()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6338(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6338=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6339()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6339(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6339=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F633()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC633(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F633=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6340()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6340(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6340=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6341()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6341(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6341=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6342()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6342(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6342=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6343()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6343(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6343=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6344()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6344(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6344=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6345()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6345(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6345=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6346()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  H    !  H  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6346(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6346=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6347()
*                 ~o2    t    !  t          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~t1|P5     !     |     |                          
*                 ~t1 |  H    !  H  |  t  | ~t1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6347(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6347=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6348()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~t1 |  H    !  H  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6348(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6348=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6349()
*              ~o2          t    !  t          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H    !  H  |  t  | ~t1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6349(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6349=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F634()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC634(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F634=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(10)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6350()
*                 ~o2          t    !  t    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~t1 |  t  |  H    !  H  | ~t1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6350(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6350=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6351()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~t1 |  H    !  H  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U336/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(336).EQ.0) CALL CC6351(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6351=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6352()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6352(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6352=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6353()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6353(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6353=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6354()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6354(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6354=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6355()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6355(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6355=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6356()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6356(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6356=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6357()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H3  |!  H3 | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6357(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6357=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6358()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6358(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6358=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6359()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6359(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6359=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F635()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC635(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F635=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6360()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6360(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6360=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6361()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6361(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6361=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6362()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H3  |!  H3 | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6362(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6362=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6363()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6363(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6363=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6364()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6364(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6364=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6365()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6365(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6365=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6366()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H3  |!  H3 | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6366(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6366=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6367()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6367(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6367=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6368()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6368(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6368=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6369()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H3  |!  H3 | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6369(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6369=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F636()
*                             !  h          ~o1                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  H3 | ~o1                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o1 |  h   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC636(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F636=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6370()
*              ~o2          t    !  t          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H3   !  H3 |  t  | ~t1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6370(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6370=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6371()
*                 ~o2          t    !  t    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~t1 |  t  |  H3   !  H3 | ~t1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6371(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6371=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6372()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~t1 |  H3   !  H3 | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U337/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(337).EQ.0) CALL CC6372(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6372=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6373()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6373(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6373=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6374()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6374(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6374=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6375()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~t1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6375(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6375=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6376()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6376(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6376=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6377()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6377(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6377=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6378()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6378(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6378=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6379()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~t1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6379(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6379=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F637()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    H3  |!  H3 | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC637(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F637=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6380()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6380(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6380=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6381()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6381(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6381=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6382()
*              ~o2          b    !  b          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H+   !  H+ |  t  | ~t1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6382(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6382=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6383()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~t1 |  t  |  H+   !  H+ | ~t1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6383(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6383=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6384()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~t1 |  t  |  H+   !  H+ | ~t1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6384(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6384=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6385()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6385(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6385=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6386()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6386(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6386=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6387()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U338/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(338).EQ.0) CALL CC6387(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6387=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6388()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  A    !  A  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U339/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(339).EQ.0) CALL CC6388(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F6388=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6389()
*                             !  A          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    b   |!  b  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~b1|P5    |!                                      
*                 ~b1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U339/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(339).EQ.0) CALL CC6389(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F6389=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F638()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC638(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F638=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6390()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  b    !  b  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U339/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(339).EQ.0) CALL CC6390(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F6390=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6391()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6391(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6391=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6392()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6392(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6392=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6393()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6393(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6393=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6394()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6394(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6394=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6395()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6395(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6395=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6396()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~b1 |  b    !  b  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6396(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6396=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6397()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6397(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6397=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6398()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6398(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F6398=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6399()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6399(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6399=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F639()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    H3  |!  H3 | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC639(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F639=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F63()
*                                   !  h    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  h   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC63(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)+C(3))+C(2)+C(5)*P2)+C(1)+C(4)*P2
      F63=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6400()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6400(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6400=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6401()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6401(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6401=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6402()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~b1 |  b    !  b  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6402(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6402=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6403()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6403(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6403=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6404()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6404(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6404=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6405()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6405(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6405=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6406()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6406(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6406=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6407()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~b1 |  b    !  b  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6407(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F6407=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6408()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6408(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6408=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6409()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6409(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F6409=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F640()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC640(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F640=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6410()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6410(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6410=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6411()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~b1 |  b    !  b  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6411(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F6411=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6412()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6412(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6412=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6413()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  Z    !  Z  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6413(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6413=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6414()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    b   |!  b  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~b1|P5    |!                                      
*                 ~b1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6414(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F6414=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6415()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~b1 |  Z    !  Z  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6415(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6415=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6416()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  b    !  b  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6416(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F6416=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6417()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o2          Z   |!  Z  | ~b1                      
*                =====\     /-1----+!---1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~b1 |  b  |  b   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(340).EQ.0) CALL CC6417(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F6417=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6418()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~b1 |  Z    !  Z  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U340/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(340).EQ.0) CALL CC6418(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6418=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6419()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(341).EQ.0) CALL CC6419(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6419=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F641()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H3  |!  H3 | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC641(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F641=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6420()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(341).EQ.0) CALL CC6420(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6420=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6421()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(341).EQ.0) CALL CC6421(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6421=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6422()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~b1 |  u    !  u  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(341).EQ.0) CALL CC6422(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6422=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6423()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(341).EQ.0) CALL CC6423(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6423=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6424()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(341).EQ.0) CALL CC6424(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6424=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6425()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~b1 |  u    !  u  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(341).EQ.0) CALL CC6425(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6425=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6426()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(341).EQ.0) CALL CC6426(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6426=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6427()
*                             !  W-         ~o2                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    u   |!  u  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~b1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(341).EQ.0) CALL CC6427(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6427=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6428()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  u    !  u  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U341/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(341).EQ.0) CALL CC6428(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6428=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6429()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(342).EQ.0) CALL CC6429(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6429=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F642()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC642(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F642=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6430()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(342).EQ.0) CALL CC6430(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6430=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6431()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(342).EQ.0) CALL CC6431(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6431=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6432()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~b1 |  c    !  c  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(342).EQ.0) CALL CC6432(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6432=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6433()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(342).EQ.0) CALL CC6433(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6433=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6434()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(342).EQ.0) CALL CC6434(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6434=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6435()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~b1 |  c    !  c  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(342).EQ.0) CALL CC6435(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6435=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6436()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(342).EQ.0) CALL CC6436(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6436=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6437()
*                             !  W-         ~o2                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    c   |!  c  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~b1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(342).EQ.0) CALL CC6437(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6437=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6438()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  c    !  c  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U342/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(342).EQ.0) CALL CC6438(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6438=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6439()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6439(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6439=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F643()
*              ~o1          h    !  h          ~o1                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H3 |  H3   !  H3 |  H3 | ~o1                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC643(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F643=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6440()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6440(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6440=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6441()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(343).EQ.0) CALL CC6441(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6441=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6442()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(343).EQ.0) CALL CC6442(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6442=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6443()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~b1 |  t    !  t  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6443(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6443=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6444()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6444(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F6444=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6445()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(343).EQ.0) CALL CC6445(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6445=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6446()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(343).EQ.0) CALL CC6446(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F6446=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6447()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~b1 |  t    !  t  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6447(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F6447=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6448()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6448(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6448=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6449()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6449(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6449=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F644()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o1 |  H3 |  H3   !  H3 | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC644(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F644=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6450()
*                             !  W-         ~o2                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    t   |!  t  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~b1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(343).EQ.0) CALL CC6450(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6450=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6451()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6451(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F6451=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6452()
*                             !  W-         ~o2                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    t   |!  t  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t2|P5    |!                                      
*                 ~b1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(343).EQ.0) CALL CC6452(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F6452=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6453()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  t    !  t  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U343/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(343).EQ.0) CALL CC6453(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F6453=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6454()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  G    !  G  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U344/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(344).EQ.0) CALL CC6454(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F6454=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6455()
*                             !  G          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    b   |!  b  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~b1|P5    |!                                      
*                 ~b1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U344/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(344).EQ.0) CALL CC6455(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F6455=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6456()
*              ~o2          G    !  G          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  b    !  b  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U344/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(344).EQ.0) CALL CC6456(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F6456=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6457()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6457(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6457=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6458()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6458(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6458=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6459()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6459(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6459=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F645()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o1          h   |!  h  | ~o1                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC645(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F645=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6460()
*                             !  u          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~b1 |  u   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6460(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6460=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6461()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6461(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6461=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6462()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6462(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6462=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6463()
*                             !  u          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~b1 |  u   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6463(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6463=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6464()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6464(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F6464=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6465()
*                 ~o2    u    !  u          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~u1|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6465(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6465=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6466()
*              ~o2          u    !  u          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H-   !  H- |  b  | ~b1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U345/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(345).EQ.0) CALL CC6466(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6466=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6467()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6467(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6467=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6468()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6468(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6468=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6469()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6469(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6469=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F646()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o1 |  H3 |  H3   !  H3 | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC646(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F646=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6470()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6470(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6470=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6471()
*                             !  c          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~b1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6471(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6471=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6472()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6472(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6472=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6473()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6473(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6473=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6474()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6474(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6474=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6475()
*                             !  c          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~b1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6475(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6475=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6476()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6476(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6476=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6477()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6477(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6477=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6478()
*                 ~o2    c    !  c          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6478(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6478=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6479()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6479(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6479=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F647()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o1          h   |!  h  | ~o1                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC647(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F647=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6480()
*                 ~o2    c    !  c          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c2|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6480(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6480=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6481()
*              ~o2          c    !  c          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H-   !  H- |  b  | ~b1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U346/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(346).EQ.0) CALL CC6481(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6481=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6482()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6482(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6482=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6483()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6483(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6483=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6484()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6484(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6484=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6485()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6485(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6485=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6486()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~b1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6486(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6486=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6487()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6487(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6487=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6488()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6488(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6488=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6489()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6489(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6489=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F648()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o1 |  H3 |  H3   !  H3 | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC648(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F648=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6490()
*                             !  t          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~b1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6490(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6490=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6491()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6491(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6491=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6492()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6492(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6492=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6493()
*                 ~o2    t    !  t          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~t1|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6493(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6493=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6494()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6494(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6494=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6495()
*                 ~o2    t    !  t          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~t2|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6495(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6495=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6496()
*              ~o2          t    !  t          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H-   !  H- |  b  | ~b1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U347/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(347).EQ.0) CALL CC6496(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6496=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6497()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6497(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6497=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6498()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6498(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6498=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6499()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6499(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6499=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F649()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o1          h   |!  h  | ~o1                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC649(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F649=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F64()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o1 |  H3 |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC64(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F64=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6500()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6500(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6500=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6501()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6501(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6501=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6502()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6502(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6502=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6503()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6503(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6503=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6504()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6504(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6504=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6505()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6505(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6505=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6506()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6506(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6506=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6507()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6507(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6507=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6508()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6508(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6508=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6509()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6509(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6509=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F650()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC650(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F650=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6510()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6510(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6510=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6511()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6511(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6511=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6512()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6512(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6512=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6513()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6513(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6513=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6514()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6514(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6514=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6515()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6515(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6515=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6516()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6516(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6516=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6517()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6517(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6517=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6518()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6518(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6518=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6519()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  h    !  h  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6519(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6519=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F651()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC651(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F651=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6520()
*                 ~o2    b    !  b          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~b1|P5     !     |     |                          
*                 ~b1 |  h    !  h  |  b  | ~b1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6520(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6520=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6521()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~b1 |  h    !  h  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6521(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6521=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6522()
*              ~o2          b    !  b          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  h    !  h  |  b  | ~b1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6522(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6522=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6523()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~b1 |  b  |  h    !  h  | ~b1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6523(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6523=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6524()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~b1 |  h    !  h  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U348/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(348).EQ.0) CALL CC6524(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6524=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6525()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6525(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6525=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6526()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6526(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6526=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6527()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6527(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6527=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6528()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6528(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6528=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6529()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6529(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6529=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F652()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC652(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F652=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6530()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6530(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6530=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6531()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6531(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6531=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6532()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6532(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6532=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6533()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6533(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6533=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6534()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6534(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6534=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6535()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6535(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6535=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6536()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6536(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6536=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6537()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6537(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6537=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6538()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6538(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6538=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6539()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6539(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6539=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F653()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC653(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F653=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6540()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6540(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6540=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6541()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6541(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6541=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6542()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6542(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6542=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6543()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6543(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6543=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6544()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6544(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6544=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6545()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6545(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F6545=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6546()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6546(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6546=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6547()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  H    !  H  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6547(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6547=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6548()
*                 ~o2    b    !  b          ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~b1|P5     !     |     |                          
*                 ~b1 |  H    !  H  |  b  | ~b1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6548(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6548=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6549()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~b1 |  H    !  H  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6549(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6549=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F654()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC654(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F654=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6550()
*              ~o2          b    !  b          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H    !  H  |  b  | ~b1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6550(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6550=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6551()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~b1 |  b  |  H    !  H  | ~b1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6551(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6551=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6552()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~b1 |  H    !  H  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U349/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(349).EQ.0) CALL CC6552(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6552=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6553()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6553(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6553=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6554()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6554(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6554=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6555()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6555(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6555=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6556()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6556(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6556=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6557()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6557(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6557=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6558()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H3  |!  H3 | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6558(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6558=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6559()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6559(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6559=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F655()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC655(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F655=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6560()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6560(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6560=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6561()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6561(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6561=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6562()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6562(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6562=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6563()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H3  |!  H3 | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6563(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6563=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6564()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6564(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6564=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6565()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6565(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6565=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6566()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6566(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6566=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6567()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H3  |!  H3 | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6567(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6567=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6568()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6568(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6568=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6569()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6569(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6569=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F656()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC656(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F656=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6570()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H3  |!  H3 | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6570(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F6570=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6571()
*              ~o2          b    !  b          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H3   !  H3 |  b  | ~b1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6571(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F6571=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6572()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~b1 |  b  |  H3   !  H3 | ~b1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6572(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F6572=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6573()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~b1 |  H3   !  H3 | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U350/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(350).EQ.0) CALL CC6573(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F6573=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6574()
*                    ~o2    U    !  U    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                     ~g |  u    !  u  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6574(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6574=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6575()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    U   |!  U  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u1|P5    |!                                   
*                     ~g |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6575(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6575=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6576()
*                    ~o2    U    !  U    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u2|-P6                          
*                     ~g |  u    !  u  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6576(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6576=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6577()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o2    U   |!  U  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u1|P5    |!                                   
*                     ~g |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6577(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6577=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6578()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                     ~g |  U    !  U  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6578(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F6578=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6579()
*                                !  U    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o2    u   |!  u  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~u1|P5    |!                                   
*                     ~g |  U   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6579(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6579=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F657()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    H3  |!  H3 | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC657(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F657=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6580()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u2|-P6                          
*                     ~g |  U    !  U  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6580(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F6580=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6581()
*                    ~o2    U    !  U    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u2|P5     !  ~u2|-P6                          
*                     ~g |  u    !  u  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6581(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6581=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6582()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o2    U   |!  U  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u2|P5    |!                                   
*                     ~g |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6582(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6582=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6583()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u2|P5     !  ~u2|-P6                          
*                     ~g |  U    !  U  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U351/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(351).EQ.0) CALL CC6583(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F6583=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6584()
*                    ~o2    D    !  D    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6584(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6584=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6585()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    D   |!  D  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d1|P5    |!                                   
*                     ~g |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6585(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6585=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6586()
*                    ~o2    D    !  D    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d2|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6586(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6586=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6587()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o2    D   |!  D  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d1|P5    |!                                   
*                     ~g |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6587(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6587=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6588()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  D    !  D  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6588(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F6588=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6589()
*                                !  D    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o2    d   |!  d  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~d1|P5    |!                                   
*                     ~g |  D   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6589(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6589=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F658()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC658(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F658=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6590()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d2|-P6                          
*                     ~g |  D    !  D  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6590(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F6590=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6591()
*                    ~o2    D    !  D    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6591(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6591=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6592()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o2    D   |!  D  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d2|P5    |!                                   
*                     ~g |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6592(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6592=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6593()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                     ~g |  D    !  D  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U352/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(352).EQ.0) CALL CC6593(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F6593=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6594()
*                    ~o2    C    !  C    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6594(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6594=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6595()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    C   |!  C  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                     ~g |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6595(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6595=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6596()
*                    ~o2    C    !  C    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6596(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6596=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6597()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    C   |!  C  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                     ~g |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6597(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6597=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6598()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                     ~g |  C    !  C  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6598(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6598=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6599()
*                                !  C    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    c   |!  c  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                     ~g |  C   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6599(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6599=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F659()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H3  |!  H3 | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC659(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F659=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F65()
*                                   !  h    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  h   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC65(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)+C(3))+C(2)+C(5)*P2)+C(1)+C(4)*P2
      F65=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6600()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                     ~g |  C    !  C  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6600(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6600=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6601()
*                    ~o2    C    !  C    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6601(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6601=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6602()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    C   |!  C  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c2|P5    |!                                   
*                     ~g |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6602(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6602=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6603()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                     ~g |  C    !  C  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U353/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(353).EQ.0) CALL CC6603(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6603=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6604()
*                    ~o2    S    !  S    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                     ~g |  s    !  s  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6604(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6604=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6605()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    S   |!  S  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                     ~g |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6605(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6605=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6606()
*                    ~o2    S    !  S    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                     ~g |  s    !  s  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6606(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6606=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6607()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    S   |!  S  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                     ~g |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6607(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6607=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6608()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                     ~g |  S    !  S  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6608(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6608=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6609()
*                                !  S    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    s   |!  s  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~s1|P5    |!                                   
*                     ~g |  S   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6609(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6609=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F660()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC660(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F660=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6610()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                     ~g |  S    !  S  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6610(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6610=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6611()
*                    ~o2    S    !  S    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                     ~g |  s    !  s  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6611(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6611=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6612()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    S   |!  S  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s2|P5    |!                                   
*                     ~g |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6612(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6612=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6613()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                     ~g |  S    !  S  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U354/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(354).EQ.0) CALL CC6613(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6613=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6614()
*                    ~o2    T    !  T    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6614(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6614=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6615()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    T   |!  T  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t1|P5    |!                                   
*                     ~g |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6615(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6615=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6616()
*                    ~o2    T    !  T    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6616(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6616=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6617()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    T   |!  T  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t1|P5    |!                                   
*                     ~g |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6617(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6617=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6618()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                     ~g |  T    !  T  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6618(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6618=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6619()
*                                !  T    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    t   |!  t  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~t1|P5    |!                                   
*                     ~g |  T   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6619(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6619=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F661()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC661(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F661=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6620()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                     ~g |  T    !  T  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6620(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6620=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6621()
*                    ~o2    T    !  T    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6621(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6621=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6622()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    T   |!  T  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t2|P5    |!                                   
*                     ~g |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6622(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6622=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6623()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                     ~g |  T    !  T  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U355/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(355).EQ.0) CALL CC6623(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6623=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6624()
*                    ~o2    B    !  B    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                     ~g |  b    !  b  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6624(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6624=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6625()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    B   |!  B  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b1|P5    |!                                   
*                     ~g |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6625(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6625=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6626()
*                    ~o2    B    !  B    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                     ~g |  b    !  b  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6626(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6626=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6627()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    B   |!  B  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b1|P5    |!                                   
*                     ~g |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6627(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6627=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6628()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                     ~g |  B    !  B  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6628(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6628=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6629()
*                                !  B    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    b   |!  b  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~b1|P5    |!                                   
*                     ~g |  B   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6629(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6629=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F662()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC662(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F662=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6630()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                     ~g |  B    !  B  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6630(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6630=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6631()
*                    ~o2    B    !  B    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                     ~g |  b    !  b  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6631(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F6631=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6632()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    B   |!  B  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b2|P5    |!                                   
*                     ~g |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6632(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F6632=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6633()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                     ~g |  B    !  B  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U356/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(356).EQ.0) CALL CC6633(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F6633=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6634()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6634(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6634=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6635()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6635(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)+C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6635=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6636()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6636(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6636=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6637()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6637(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)-C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6637=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6638()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6638(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6638=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6639()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6639(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)-C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6639=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F663()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC663(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F663=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6640()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6640(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6640=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6641()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6641(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)-C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6641=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6642()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6642(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6642=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6643()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6643(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)+C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6643=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6644()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6644(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6644=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6645()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6645(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)-C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6645=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6646()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6646(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6646=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6647()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6647(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)-C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6647=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6648()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6648(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6648=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6649()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6649(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)+C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6649=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F664()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC664(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F664=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6650()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6650(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6650=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6651()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6651(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)-C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6651=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6652()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6652(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)-C(7))+C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(1)+C(2)*P1
      F6652=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6653()
*                                !  W+   ~1+                         
*                               /!-->2-@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U357/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(357).EQ.0) CALL CC6653(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(11)*P2-C(9))-C(7))
     >+P1*(C(5)+C(6)*P1)+C(4))+P1*(-C(2)-C(3)*P1)+C(1)
      F6653=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6654()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6654(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6654=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6655()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6655(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6655=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6656()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6656(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6656=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6657()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6657(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6657=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6658()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6658(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6658=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6659()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6659(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6659=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F665()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC665(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F665=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6660()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6660(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6660=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6661()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6661(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6661=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6662()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6662(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6662=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6663()
*                                !  W+   ~1+                         
*                               /!-->1-@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-1>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6663(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6663=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6664()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6664(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6664=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6665()
*                                !  W+   ~1+                         
*                               /!-->1-@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-1>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6665(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6665=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6666()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6666(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6666=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6667()
*                                !  W+   ~1+                         
*                               /!-->1-@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-1>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6667(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6667=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6668()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6668(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6668=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6669()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6669(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6669=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F666()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H3  |!  H3 | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC666(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F666=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(7)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6670()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6670(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6670=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6671()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6671(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6671=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6672()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6672(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6672=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6673()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6673(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6673=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6674()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6674(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6674=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6675()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6675(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6675=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6676()
*                                !  W+   ~1+                         
*                               /!-->1-@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-1>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6676(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6676=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6677()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6677(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6677=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6678()
*                                !  W+   ~1+                         
*                               /!-->1-@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-1>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6678(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6678=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6679()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6679(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6679=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F667()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC667(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F667=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6680()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6680(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6680=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6681()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6681(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6681=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6682()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6682(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6682=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6683()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6683(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6683=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6684()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6684(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6684=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6685()
*                                !  W+   ~1+                         
*                               /!-->1-@==>==                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~1+ |  W+  |!                                   
*                   ==>==@-1>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6685(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6685=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6686()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6686(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6686=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6687()
*                    ~1+    W+   !  W+   ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6687(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(1)-C(2)*P1
      F6687=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6688()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    W+  |!  W+ | ~1+                         
*                   ==>==@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(358).EQ.0) CALL CC6688(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F6688=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6689()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U358/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(358).EQ.0) CALL CC6689(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F6689=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F668()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o1 |  H3   !  H3 | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC668(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F668=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6690()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6690(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6690=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6691()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6691(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F6691=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6692()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6692(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6692=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6693()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6693(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(2)*P1-C(1)
      F6693=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6694()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6694(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6694=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6695()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6695(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(2)*P1-C(1)
      F6695=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6696()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6696(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6696=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6697()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6697(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(2)*P1-C(1)
      F6697=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6698()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6698(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6698=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6699()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6699(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F6699=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F669()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o1 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U22/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(22).EQ.0) CALL CC669(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F669=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F66()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC66(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+4*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F66=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6700()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6700(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6700=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6701()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6701(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(2)*P1-C(1)
      F6701=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6702()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6702(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6702=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6703()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6703(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(2)*P1-C(1)
      F6703=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6704()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6704(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6704=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6705()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6705(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F6705=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6706()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6706(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6706=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6707()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~1+ |  H+  |!                                   
*                   ==>==@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6707(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(2)*P1-C(1)
      F6707=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6708()
*                    ~1+    H+   !  H+   ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U359/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(359).EQ.0) CALL CC6708(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)-C(2)*P1
      F6708=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F6709()
*                                !  H+   ~1+                         
*                               /!-->--@==>==                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~1+    H+  |!  H+ | ~1+                         
*                   ==>==@-->---+!-->--@==>==                        
*                     P1 |  P3  |!  P3    P2                         
* 