*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5000()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(241).EQ.0) CALL CC5000(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5000=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5001()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    Z   |!  Z  | ~e1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(241).EQ.0) CALL CC5001(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5001=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5002()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~e1 |  e1   !  e1 |  e1 | ~e1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(241).EQ.0) CALL CC5002(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5002=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5003()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(241).EQ.0) CALL CC5003(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5003=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5004()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    Z   |!  Z  | ~e1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(241).EQ.0) CALL CC5004(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5004=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5005()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~e1 |  e1   !  e1 |  e1 | ~e1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(241).EQ.0) CALL CC5005(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5005=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5006()
*                    ~o2    e1   !  e1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~e1 |  Z    !  Z  | ~e1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(241).EQ.0) CALL CC5006(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5006=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5007()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e1  |!  e1 |  e1 | ~e1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~e1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(241).EQ.0) CALL CC5007(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F5007=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5008()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e1 |  e1 |  e1   !  e1 |  e1 | ~e1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U241/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(241).EQ.0) CALL CC5008(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F5008=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5009()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~e1 |  n1   !  n1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(242).EQ.0) CALL CC5009(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5009=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F500()
*                 ~o1          B    !  B    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~o1 |  Z  |  b    !  b  | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC500(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F500=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5010()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~e1 |  n1   !  n1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(242).EQ.0) CALL CC5010(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5010=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5011()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~e1 |  n1   !  n1 |  e1 | ~e1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(242).EQ.0) CALL CC5011(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5011=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5012()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    W-  |!  W- | ~e1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~e1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(242).EQ.0) CALL CC5012(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5012=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5013()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~e1 |  n1   !  n1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(242).EQ.0) CALL CC5013(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5013=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5014()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~e1 |  n1   !  n1 |  e1 | ~e1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(242).EQ.0) CALL CC5014(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5014=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5015()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    W-  |!  W- | ~e1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~e1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(242).EQ.0) CALL CC5015(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5015=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5016()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e1 |  e1 |  n1   !  n1 |  e1 | ~e1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(242).EQ.0) CALL CC5016(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5016=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5017()
*                                   !  n1   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~n1|-P6                       
*                 ~o2          W-  |!  W- | ~e1                      
*                =====\     /-1<---+!--<1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~e1 |  e1 |  n1  |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(242).EQ.0) CALL CC5017(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5017=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5018()
*                    ~o2    n1   !  n1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~e1 |  W-   !  W- | ~e1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U242/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(242).EQ.0) CALL CC5018(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5018=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5019()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~e1 |  n1   !  n1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U243/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(243).EQ.0) CALL CC5019(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5019=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F501()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o1          B   |!  B  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  b   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC501(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F501=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5020()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~e1 |  n1   !  n1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U243/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(243).EQ.0) CALL CC5020(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5020=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5021()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    H-  |!  H- | ~e1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~e1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U243/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(243).EQ.0) CALL CC5021(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5021=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5022()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~e1 |  n1   !  n1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U243/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(243).EQ.0) CALL CC5022(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5022=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5023()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    H-  |!  H- | ~e1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~e1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U243/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(243).EQ.0) CALL CC5023(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5023=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5024()
*                    ~o2    n1   !  n1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~e1 |  H-   !  H- | ~e1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U243/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(243).EQ.0) CALL CC5024(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5024=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5025()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5025(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5025=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5026()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5026(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5026=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5027()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5027(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5027=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5028()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5028(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5028=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5029()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    h   |!  h  | ~e1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5029(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5029=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F502()
*                 ~o1          B    !  B    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~o1 |  Z  |  b    !  b  | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC502(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F502=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5030()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5030(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5030=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5031()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5031(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5031=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5032()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5032(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5032=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5033()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    h   |!  h  | ~e1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5033(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5033=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5034()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5034(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5034=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5035()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5035(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5035=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5036()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    h   |!  h  | ~e1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5036(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5036=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5037()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5037(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5037=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5038()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    h   |!  h  | ~e1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5038(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5038=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5039()
*                    ~o2    e1   !  e1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~e1 |  h    !  h  | ~e1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U244/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(244).EQ.0) CALL CC5039(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5039=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F503()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o1          B   |!  B  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  b   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC503(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F503=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5040()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5040(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5040=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5041()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5041(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5041=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5042()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5042(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5042=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5043()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5043(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5043=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5044()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    H   |!  H  | ~e1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5044(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5044=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5045()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5045(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5045=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5046()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5046(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5046=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5047()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5047(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5047=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5048()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    H   |!  H  | ~e1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5048(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5048=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5049()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5049(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5049=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F504()
*              ~o1          B    !  B          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  b    !  b  |  h  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC504(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F504=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5050()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5050(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5050=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5051()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    H   |!  H  | ~e1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5051(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5051=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5052()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5052(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5052=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5053()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    H   |!  H  | ~e1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5053(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5053=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5054()
*                    ~o2    e1   !  e1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~e1 |  H    !  H  | ~e1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U245/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(245).EQ.0) CALL CC5054(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5054=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5055()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5055(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5055=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5056()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5056(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5056=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5057()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5057(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5057=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5058()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5058(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5058=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5059()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5059(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5059=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F505()
*              ~o1          B    !  B          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  b    !  b  |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC505(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F505=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5060()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5060(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5060=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5061()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5061(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5061=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5062()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5062(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5062=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5063()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5063(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5063=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5064()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e1 |  e1   !  e1 | ~e1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U246/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(246).EQ.0) CALL CC5064(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5064=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5065()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~e2 |  A    !  A  | ~e2                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U247/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(247).EQ.0) CALL CC5065(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F5065=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5066()
*                             !  A          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e2  |!  e2 |  e2 | ~e2                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e2|P5    |!                                      
*                 ~e2 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U247/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(247).EQ.0) CALL CC5066(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F5066=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5067()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e2 |  e2 |  e2   !  e2 |  e2 | ~e2                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U247/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(247).EQ.0) CALL CC5067(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F5067=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5068()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5068(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5068=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5069()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5069(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5069=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F506()
*                 ~o1          B    !  B    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~o1 |  h  |  b    !  b  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC506(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F506=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5070()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5070(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5070=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5071()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5071(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5071=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5072()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    Z   |!  Z  | ~e2                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(248).EQ.0) CALL CC5072(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5072=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5073()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~e2 |  e2   !  e2 |  e2 | ~e2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5073(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5073=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5074()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5074(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F5074=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5075()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5075(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5075=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5076()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5076(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5076=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5077()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    Z   |!  Z  | ~e2                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(248).EQ.0) CALL CC5077(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5077=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5078()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~e2 |  e2   !  e2 |  e2 | ~e2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5078(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5078=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5079()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5079(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5079=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F507()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o1          B   |!  B  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC507(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F507=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5080()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5080(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5080=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5081()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    Z   |!  Z  | ~e2                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(248).EQ.0) CALL CC5081(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5081=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5082()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~e2 |  e2   !  e2 |  e2 | ~e2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5082(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F5082=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5083()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5083(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5083=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5084()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    Z   |!  Z  | ~e2                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(248).EQ.0) CALL CC5084(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5084=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5085()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~e2 |  e2   !  e2 |  e2 | ~e2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5085(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F5085=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5086()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~e2 |  Z    !  Z  | ~e2                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5086(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5086=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5087()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e2  |!  e2 |  e2 | ~e2                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e2|P5    |!                                      
*                 ~e2 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(248).EQ.0) CALL CC5087(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F5087=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5088()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e2 |  e2 |  e2   !  e2 |  e2 | ~e2                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U248/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(248).EQ.0) CALL CC5088(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F5088=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5089()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~e2 |  n2   !  n2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(249).EQ.0) CALL CC5089(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5089=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F508()
*                 ~o1          B    !  B    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~o1 |  h  |  b    !  b  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC508(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F508=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5090()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~e2 |  n2   !  n2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(249).EQ.0) CALL CC5090(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5090=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5091()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~e2 |  n2   !  n2 |  e2 | ~e2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(249).EQ.0) CALL CC5091(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5091=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5092()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    W-  |!  W- | ~e2                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~e2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(249).EQ.0) CALL CC5092(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5092=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5093()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~e2 |  n2   !  n2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(249).EQ.0) CALL CC5093(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5093=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5094()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~e2 |  n2   !  n2 |  e2 | ~e2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(249).EQ.0) CALL CC5094(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5094=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5095()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    W-  |!  W- | ~e2                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~e2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(249).EQ.0) CALL CC5095(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5095=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5096()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e2 |  e2 |  n2   !  n2 |  e2 | ~e2                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(249).EQ.0) CALL CC5096(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5096=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5097()
*                                   !  n2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~n2|-P6                       
*                 ~o2          W-  |!  W- | ~e2                      
*                =====\     /-1<---+!--<1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~e2 |  e2 |  n2  |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(249).EQ.0) CALL CC5097(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5097=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5098()
*                    ~o2    n2   !  n2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n2|P5     !  ~n2|-P6                          
*                    ~e2 |  W-   !  W- | ~e2                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U249/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(249).EQ.0) CALL CC5098(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5098=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5099()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~e2 |  n2   !  n2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5099(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5099=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F509()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o1          B   |!  B  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC509(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F509=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F50()
*                                   !  h    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-2----+!---2-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  h   |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC50(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))+C
     >(1)
      F50=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(10)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5100()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~e2 |  n2   !  n2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5100(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5100=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5101()
*                             !  n2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  e2 | ~e2                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~e2 |  n2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5101(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5101=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5102()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    H-  |!  H- | ~e2                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~e2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5102(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5102=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5103()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~e2 |  n2   !  n2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5103(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5103=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5104()
*                             !  n2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  e2 | ~e2                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~e2 |  n2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5104(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5104=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5105()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    H-  |!  H- | ~e2                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~e2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5105(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5105=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5106()
*              ~o2          n2   !  n2         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e2 |  e2 |  H-   !  H- |  e2 | ~e2                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5106(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5106=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5107()
*                 ~o2          n2   !  n2   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~n2|-P6                       
*                 ~e2 |  e2 |  H-   !  H- | ~e2                      
*                -->--@==>==@--<----!--<--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5107(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5107=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5108()
*                    ~o2    n2   !  n2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n2|P5     !  ~n2|-P6                          
*                    ~e2 |  H-   !  H- | ~e2                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U250/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(250).EQ.0) CALL CC5108(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5108=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5109()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5109(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5109=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F510()
*              ~o1          B    !  B          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H  |  b    !  b  |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC510(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F510=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5110()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5110(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5110=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5111()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5111(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5111=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5112()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5112(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5112=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5113()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    h   |!  h  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5113(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5113=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5114()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5114(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5114=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5115()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    h   |!  h  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5115(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5115=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5116()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5116(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5116=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5117()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5117(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5117=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5118()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5118(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5118=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5119()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    h   |!  h  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5119(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5119=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F511()
*                 ~o1          B    !  B    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~o1 |  H  |  b    !  b  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC511(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F511=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5120()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5120(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5120=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5121()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    h   |!  h  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5121(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5121=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5122()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5122(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5122=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5123()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5123(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5123=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5124()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    h   |!  h  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5124(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5124=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5125()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5125(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5125=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5126()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    h   |!  h  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5126(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5126=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5127()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5127(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5127=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5128()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    h   |!  h  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5128(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5128=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5129()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5129(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5129=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F512()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o1          B   |!  B  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC512(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F512=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5130()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    h   |!  h  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5130(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5130=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5131()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~e2 |  h    !  h  | ~e2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5131(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5131=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5132()
*                 ~o2    e2   !  e2         ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e2|P5     !     |     |                          
*                 ~e2 |  h    !  h  |  e2 | ~e2                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5132(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5132=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5133()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e5|-P6                          
*                    ~e2 |  h    !  h  | ~e2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5133(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5133=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5134()
*              ~o2          e2   !  e2         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e2 |  e2 |  h    !  h  |  e2 | ~e2                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5134(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5134=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5135()
*                 ~o2          e2   !  e2   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~e2 |  e2 |  h    !  h  | ~e2                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5135(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5135=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5136()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e5|P5     !  ~e5|-P6                          
*                    ~e2 |  h    !  h  | ~e2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U251/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(251).EQ.0) CALL CC5136(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5136=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5137()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5137(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5137=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5138()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5138(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5138=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5139()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5139(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5139=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F513()
*                 ~o1          B    !  B    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~o1 |  H  |  b    !  b  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC513(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F513=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5140()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5140(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5140=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5141()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    H   |!  H  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5141(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5141=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5142()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5142(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5142=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5143()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H   |!  H  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5143(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5143=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5144()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5144(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5144=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5145()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5145(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5145=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5146()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5146(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5146=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5147()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    H   |!  H  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5147(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5147=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5148()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5148(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5148=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5149()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H   |!  H  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5149(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5149=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F514()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o1          B   |!  B  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC514(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F514=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5150()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5150(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5150=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5151()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5151(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5151=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5152()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    H   |!  H  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5152(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5152=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5153()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5153(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5153=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5154()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H   |!  H  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5154(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5154=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5155()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5155(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5155=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5156()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    H   |!  H  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5156(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5156=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5157()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5157(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5157=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5158()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H   |!  H  | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5158(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5158=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5159()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~e2 |  H    !  H  | ~e2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5159(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5159=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F515()
*              ~o1          B    !  B          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H3 |  b    !  b  |  H3 | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC515(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F515=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5160()
*                 ~o2    e2   !  e2         ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e2|P5     !     |     |                          
*                 ~e2 |  H    !  H  |  e2 | ~e2                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5160(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5160=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5161()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e5|-P6                          
*                    ~e2 |  H    !  H  | ~e2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5161(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5161=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5162()
*              ~o2          e2   !  e2         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e2 |  e2 |  H    !  H  |  e2 | ~e2                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5162(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5162=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5163()
*                 ~o2          e2   !  e2   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~e2 |  e2 |  H    !  H  | ~e2                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5163(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5163=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5164()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e5|P5     !  ~e5|-P6                          
*                    ~e2 |  H    !  H  | ~e2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U252/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(252).EQ.0) CALL CC5164(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5164=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5165()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5165(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5165=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5166()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5166(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5166=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5167()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5167(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5167=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5168()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5168(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5168=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5169()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5169(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5169=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F516()
*                 ~o1          B    !  B    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~o1 |  H3 |  b    !  b  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC516(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F516=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5170()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H3  |!  H3 | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5170(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5170=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5171()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5171(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5171=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5172()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5172(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5172=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5173()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5173(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5173=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5174()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5174(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5174=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5175()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H3  |!  H3 | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5175(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5175=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5176()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5176(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5176=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5177()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5177(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5177=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5178()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5178(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5178=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5179()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H3  |!  H3 | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5179(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5179=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F517()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o1          B   |!  B  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC517(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F517=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5180()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e2 |  e2   !  e2 | ~e2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5180(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5180=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5181()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  e2 | ~e2                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~e2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5181(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5181=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5182()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H3  |!  H3 | ~e2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5182(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5182=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5183()
*              ~o2          e2   !  e2         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e2 |  e2 |  H3   !  H3 |  e2 | ~e2                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5183(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5183=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5184()
*                 ~o2          e2   !  e2   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~e2 |  e2 |  H3   !  H3 | ~e2                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5184(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5184=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5185()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e5|P5     !  ~e5|-P6                          
*                    ~e2 |  H3   !  H3 | ~e2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U253/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(253).EQ.0) CALL CC5185(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5185=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5186()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~e3 |  A    !  A  | ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U254/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(254).EQ.0) CALL CC5186(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F5186=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5187()
*                             !  A          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e3  |!  e3 |  e3 | ~e3                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e3|P5    |!                                      
*                 ~e3 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U254/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(254).EQ.0) CALL CC5187(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F5187=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5188()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e3 |  e3 |  e3   !  e3 |  e3 | ~e3                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U254/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(254).EQ.0) CALL CC5188(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F5188=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5189()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5189(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5189=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F518()
*                 ~o1          B    !  B    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~o1 |  H3 |  b    !  b  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC518(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F518=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5190()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5190(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5190=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5191()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5191(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5191=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5192()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5192(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5192=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5193()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    Z   |!  Z  | ~e3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5193(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5193=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5194()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~e3 |  e3   !  e3 |  e3 | ~e3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5194(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5194=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5195()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    Z   |!  Z  | ~e3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5195(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5195=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5196()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5196(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F5196=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5197()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5197(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5197=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5198()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5198(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5198=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5199()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    Z   |!  Z  | ~e3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5199(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5199=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F519()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o1          B   |!  B  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC519(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F519=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F51()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o1 |  Z    !  Z  | ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC51(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+4*P1-8*P2)+P2*(C(5)+4*P2)-C(2))+P2*(C(4)-C(6)*P
     >2)-C(1)
      F51=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5200()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~e3 |  e3   !  e3 |  e3 | ~e3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5200(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5200=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5201()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    Z   |!  Z  | ~e3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5201(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5201=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5202()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5202(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5202=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5203()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5203(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5203=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5204()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    Z   |!  Z  | ~e3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5204(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5204=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5205()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~e3 |  e3   !  e3 |  e3 | ~e3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5205(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F5205=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5206()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    Z   |!  Z  | ~e3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5206(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5206=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5207()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5207(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5207=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5208()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    Z   |!  Z  | ~e3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5208(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5208=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5209()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~e3 |  e3   !  e3 |  e3 | ~e3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5209(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F5209=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F520()
*                    ~o1    B    !  B    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~o1 |  b    !  b  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC520(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F520=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5210()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    Z   |!  Z  | ~e3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5210(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5210=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5211()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~e3 |  Z    !  Z  | ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5211(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5211=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5212()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e3  |!  e3 |  e3 | ~e3                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e3|P5    |!                                      
*                 ~e3 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5212(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F5212=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5213()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~e3 |  Z    !  Z  | ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5213(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5213=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5214()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e3 |  e3 |  e3   !  e3 |  e3 | ~e3                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5214(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F5214=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5215()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o2          Z   |!  Z  | ~e3                      
*                =====\     /-1----+!---1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~e3 |  e3 |  e3  |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(255).EQ.0) CALL CC5215(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F5215=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5216()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~e3 |  Z    !  Z  | ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U255/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(255).EQ.0) CALL CC5216(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5216=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5217()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~e3 |  n3   !  n3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(256).EQ.0) CALL CC5217(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5217=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5218()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~e3 |  n3   !  n3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(256).EQ.0) CALL CC5218(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5218=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5219()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~e3 |  n3   !  n3 |  e3 | ~e3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(256).EQ.0) CALL CC5219(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5219=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F521()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    B   |!  B  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b1|P5    |!                                   
*                    ~o1 |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC521(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F521=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5220()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    W-  |!  W- | ~e3                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~e3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(256).EQ.0) CALL CC5220(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5220=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5221()
*                    ~o2    W-   !  W-   ~o2                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~e3 |  n3   !  n3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(256).EQ.0) CALL CC5221(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5221=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5222()
*                 ~o2    W-   !  W-         ~o2                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~e3 |  n3   !  n3 |  e3 | ~e3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(256).EQ.0) CALL CC5222(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5222=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5223()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    W-  |!  W- | ~e3                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~e3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(256).EQ.0) CALL CC5223(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5223=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5224()
*              ~o2          W-   !  W-         ~o2                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e3 |  e3 |  n3   !  n3 |  e3 | ~e3                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(256).EQ.0) CALL CC5224(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5224=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5225()
*                                   !  n3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~n3|-P6                       
*                 ~o2          W-  |!  W- | ~e3                      
*                =====\     /-1<---+!--<1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~e3 |  e3 |  n3  |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(256).EQ.0) CALL CC5225(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5225=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5226()
*                    ~o2    n3   !  n3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~e3 |  W-   !  W- | ~e3                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U256/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(256).EQ.0) CALL CC5226(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5226=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5227()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~e3 |  n3   !  n3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5227(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5227=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5228()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~e3 |  n3   !  n3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5228(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5228=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5229()
*                             !  n3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  e3 | ~e3                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~e3 |  n3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5229(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5229=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F522()
*                    ~o1    B    !  B    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~o1 |  b    !  b  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC522(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F522=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5230()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    H-  |!  H- | ~e3                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~e3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5230(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5230=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5231()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~e3 |  n3   !  n3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5231(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5231=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5232()
*                             !  n3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H-  |!  H- |  e3 | ~e3                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~e3 |  n3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5232(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5232=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5233()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    H-  |!  H- | ~e3                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~e3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5233(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5233=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5234()
*              ~o2          n3   !  n3         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e3 |  e3 |  H-   !  H- |  e3 | ~e3                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5234(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5234=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5235()
*                 ~o2          n3   !  n3   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~n3|-P6                       
*                 ~e3 |  e3 |  H-   !  H- | ~e3                      
*                -->--@==>==@--<----!--<--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5235(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5235=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5236()
*                    ~o2    n3   !  n3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~e3 |  H-   !  H- | ~e3                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U257/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(257).EQ.0) CALL CC5236(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5236=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5237()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5237(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5237=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5238()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5238(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5238=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5239()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5239(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5239=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F523()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    B   |!  B  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b1|P5    |!                                   
*                    ~o1 |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC523(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F523=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5240()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5240(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5240=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5241()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    h   |!  h  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5241(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5241=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5242()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5242(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5242=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5243()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    h   |!  h  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5243(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5243=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5244()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5244(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5244=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5245()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5245(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5245=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5246()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5246(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5246=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5247()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    h   |!  h  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5247(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5247=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5248()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5248(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5248=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5249()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    h   |!  h  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5249(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5249=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F524()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~o1 |  B    !  B  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC524(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F524=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5250()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5250(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5250=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5251()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5251(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5251=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5252()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    h   |!  h  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5252(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5252=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5253()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5253(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5253=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5254()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    h   |!  h  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5254(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5254=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5255()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5255(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5255=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5256()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    h   |!  h  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5256(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5256=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5257()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    h   |!  h  |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5257(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5257=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5258()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    h   |!  h  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5258(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5258=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5259()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~e3 |  h    !  h  | ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5259(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5259=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F525()
*                                !  B    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    b   |!  b  | ~o1                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~b1|P5    |!                                   
*                    ~o1 |  B   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC525(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F525=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5260()
*                 ~o2    e3   !  e3         ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~e3 |  h    !  h  |  e3 | ~e3                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5260(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5260=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5261()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~e3 |  h    !  h  | ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5261(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5261=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5262()
*              ~o2          e3   !  e3         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e3 |  e3 |  h    !  h  |  e3 | ~e3                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5262(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5262=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5263()
*                 ~o2          e3   !  e3   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~e3 |  e3 |  h    !  h  | ~e3                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5263(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5263=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5264()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~e3 |  h    !  h  | ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U258/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(258).EQ.0) CALL CC5264(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5264=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5265()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5265(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5265=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5266()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5266(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5266=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5267()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5267(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5267=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5268()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5268(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5268=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5269()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    H   |!  H  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5269(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5269=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F526()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~o1 |  B    !  B  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC526(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F526=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5270()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5270(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5270=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5271()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H   |!  H  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5271(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5271=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5272()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5272(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5272=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5273()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5273(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5273=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5274()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5274(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5274=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5275()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    H   |!  H  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5275(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5275=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5276()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5276(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5276=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5277()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H   |!  H  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5277(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5277=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5278()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5278(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5278=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5279()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5279(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5279=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F527()
*                    ~o1    B    !  B    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~o1 |  b    !  b  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC527(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F527=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5280()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    H   |!  H  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5280(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5280=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5281()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5281(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5281=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5282()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H   |!  H  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5282(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5282=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5283()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5283(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5283=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5284()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    H   |!  H  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5284(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5284=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5285()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5285(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5285=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5286()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H   |!  H  | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5286(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5286=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5287()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~e3 |  H    !  H  | ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5287(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5287=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5288()
*                 ~o2    e3   !  e3         ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~e3 |  H    !  H  |  e3 | ~e3                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5288(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5288=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5289()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~e3 |  H    !  H  | ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5289(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5289=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F528()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    B   |!  B  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b2|P5    |!                                   
*                    ~o1 |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC528(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F528=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5290()
*              ~o2          e3   !  e3         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e3 |  e3 |  H    !  H  |  e3 | ~e3                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5290(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5290=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5291()
*                 ~o2          e3   !  e3   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~e3 |  e3 |  H    !  H  | ~e3                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5291(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5291=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5292()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~e3 |  H    !  H  | ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U259/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(259).EQ.0) CALL CC5292(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5292=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5293()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5293(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5293=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5294()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5294(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5294=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5295()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5295(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5295=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5296()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5296(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5296=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5297()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5297(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5297=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5298()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H3  |!  H3 | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5298(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5298=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5299()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5299(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5299=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F529()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~o1 |  B    !  B  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U19/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(19).EQ.0) CALL CC529(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F529=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F52()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  H3 | ~o1                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o1 |  Z   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC52(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F52=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5300()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5300(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5300=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5301()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5301(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5301=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5302()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5302(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5302=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5303()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H3  |!  H3 | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5303(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5303=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5304()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5304(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5304=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5305()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5305(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5305=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5306()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5306(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5306=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5307()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H3  |!  H3 | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5307(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5307=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5308()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~e3 |  e3   !  e3 | ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5308(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5308=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5309()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  e3 | ~e3                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~e3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5309(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5309=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F530()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC530(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F530=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5310()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H3  |!  H3 | ~e3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~e3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5310(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F5310=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5311()
*              ~o2          e3   !  e3         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~e3 |  e3 |  H3   !  H3 |  e3 | ~e3                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5311(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5311=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5312()
*                 ~o2          e3   !  e3   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~e3 |  e3 |  H3   !  H3 | ~e3                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5312(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5312=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5313()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~e3 |  H3   !  H3 | ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U260/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(260).EQ.0) CALL CC5313(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5313=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5314()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5314(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5314=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5315()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5315(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5315=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5316()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5316(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5316=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5317()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5317(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5317=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5318()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    Z   |!  Z  | ~n1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(261).EQ.0) CALL CC5318(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5318=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5319()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~n1 |  n1   !  n1 |  n1 | ~n1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5319(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5319=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F531()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC531(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F531=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5320()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5320(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F5320=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5321()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5321(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5321=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5322()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5322(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5322=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5323()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    Z   |!  Z  | ~n1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(261).EQ.0) CALL CC5323(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5323=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5324()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~n1 |  n1   !  n1 |  n1 | ~n1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5324(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5324=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5325()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5325(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5325=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5326()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5326(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5326=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5327()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    Z   |!  Z  | ~n1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(261).EQ.0) CALL CC5327(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5327=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5328()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~n1 |  n1   !  n1 |  n1 | ~n1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5328(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5328=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5329()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5329(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5329=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F532()
*                 ~o1    h    !  h          ~o1                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o1 |  h    !  h  |  h  | ~o1                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC532(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)+2*P2
      F532=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5330()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    Z   |!  Z  | ~n1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(261).EQ.0) CALL CC5330(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5330=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5331()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~n1 |  n1   !  n1 |  n1 | ~n1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5331(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5331=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5332()
*                    ~o2    n1   !  n1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~n1 |  Z    !  Z  | ~n1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5332(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5332=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5333()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    n1  |!  n1 |  n1 | ~n1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n1|P5    |!                                      
*                 ~n1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(261).EQ.0) CALL CC5333(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F5333=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5334()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~n1 |  n1 |  n1   !  n1 |  n1 | ~n1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U261/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(261).EQ.0) CALL CC5334(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F5334=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5335()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(262).EQ.0) CALL CC5335(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5335=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5336()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(262).EQ.0) CALL CC5336(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5336=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5337()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    W+  |!  W+ | ~n1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~n1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(262).EQ.0) CALL CC5337(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5337=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5338()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~n1 |  e1   !  e1 |  n1 | ~n1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(262).EQ.0) CALL CC5338(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5338=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5339()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(262).EQ.0) CALL CC5339(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5339=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F533()
*                 ~o1    h    !  h          ~o1                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o1 |  h    !  h  |  H  | ~o1                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC533(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)+2*P2
      F533=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5340()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    W+  |!  W+ | ~n1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~n1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(262).EQ.0) CALL CC5340(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5340=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5341()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~n1 |  e1   !  e1 |  n1 | ~n1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(262).EQ.0) CALL CC5341(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5341=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5342()
*                    ~o2    e1   !  e1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~n1 |  W+   !  W+ | ~n1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(262).EQ.0) CALL CC5342(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5342=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5343()
*                             !  W+         ~o2                      
*                            /!-->1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e1  |!  e1 |  n1 | ~n1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~n1 |  W+  |!                                      
*                -->--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(262).EQ.0) CALL CC5343(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5343=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5344()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~n1 |  n1 |  e1   !  e1 |  n1 | ~n1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U262/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(262).EQ.0) CALL CC5344(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5344=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5345()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5345(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5345=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5346()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5346(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5346=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5347()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5347(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5347=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5348()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5348(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5348=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5349()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    h   |!  h  | ~n1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5349(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5349=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F534()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC534(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F534=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5350()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5350(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5350=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5351()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5351(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5351=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5352()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5352(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5352=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5353()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    h   |!  h  | ~n1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5353(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5353=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5354()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5354(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5354=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5355()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5355(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5355=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5356()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    h   |!  h  | ~n1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5356(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5356=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5357()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5357(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5357=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5358()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    h   |!  h  | ~n1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5358(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5358=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5359()
*                    ~o2    n1   !  n1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~n1 |  h    !  h  | ~n1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U263/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(263).EQ.0) CALL CC5359(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5359=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F535()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC535(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F535=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5360()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5360(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5360=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5361()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5361(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5361=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5362()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5362(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5362=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5363()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5363(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5363=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5364()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    H   |!  H  | ~n1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5364(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5364=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5365()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5365(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5365=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5366()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5366(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5366=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5367()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5367(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5367=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5368()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    H   |!  H  | ~n1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5368(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5368=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5369()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5369(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5369=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F536()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC536(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F536=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5370()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5370(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5370=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5371()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    H   |!  H  | ~n1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5371(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5371=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5372()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5372(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5372=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5373()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    H   |!  H  | ~n1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5373(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5373=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5374()
*                    ~o2    n1   !  n1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~n1 |  H    !  H  | ~n1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U264/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(264).EQ.0) CALL CC5374(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5374=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5375()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5375(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5375=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5376()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5376(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5376=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5377()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5377(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5377=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5378()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5378(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5378=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5379()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5379(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5379=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F537()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC537(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F537=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5380()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5380(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5380=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5381()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5381(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5381=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5382()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5382(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5382=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5383()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5383(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5383=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5384()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U265/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(265).EQ.0) CALL CC5384(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5384=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5385()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U266/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(266).EQ.0) CALL CC5385(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5385=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5386()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U266/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(266).EQ.0) CALL CC5386(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5386=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5387()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    H+  |!  H+ | ~n1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~n1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U266/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(266).EQ.0) CALL CC5387(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5387=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5388()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U266/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(266).EQ.0) CALL CC5388(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5388=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5389()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    H+  |!  H+ | ~n1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~n1 |  e1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U266/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(266).EQ.0) CALL CC5389(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5389=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F538()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC538(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F538=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5390()
*                    ~o2    e1   !  e1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~n1 |  H+   !  H+ | ~n1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U266/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(266).EQ.0) CALL CC5390(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5390=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5391()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5391(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5391=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5392()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5392(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5392=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5393()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5393(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5393=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5394()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5394(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5394=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5395()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    Z   |!  Z  | ~n2                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(267).EQ.0) CALL CC5395(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5395=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5396()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~n2 |  n2   !  n2 |  n2 | ~n2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5396(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5396=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5397()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5397(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F5397=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5398()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5398(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5398=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5399()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5399(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5399=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F539()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC539(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F539=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F53()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC53(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F53=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5400()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    Z   |!  Z  | ~n2                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(267).EQ.0) CALL CC5400(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5400=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5401()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~n2 |  n2   !  n2 |  n2 | ~n2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5401(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5401=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5402()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5402(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5402=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5403()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5403(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5403=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5404()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    Z   |!  Z  | ~n2                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(267).EQ.0) CALL CC5404(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5404=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5405()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~n2 |  n2   !  n2 |  n2 | ~n2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5405(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5405=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5406()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5406(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5406=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5407()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    Z   |!  Z  | ~n2                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(267).EQ.0) CALL CC5407(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5407=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5408()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~n2 |  n2   !  n2 |  n2 | ~n2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5408(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5408=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5409()
*                    ~o2    n2   !  n2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n2|P5     !  ~n2|-P6                          
*                    ~n2 |  Z    !  Z  | ~n2                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5409(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5409=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F540()
*              ~o1          h    !  h          ~o1                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  h    !  h  |  h  | ~o1                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC540(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F540=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5410()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    n2  |!  n2 |  n2 | ~n2                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n2|P5    |!                                      
*                 ~n2 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(267).EQ.0) CALL CC5410(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F5410=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5411()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~n2 |  n2 |  n2   !  n2 |  n2 | ~n2                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U267/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(267).EQ.0) CALL CC5411(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F5411=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5412()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(268).EQ.0) CALL CC5412(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5412=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5413()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(268).EQ.0) CALL CC5413(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5413=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5414()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    W+  |!  W+ | ~n2                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~n2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(268).EQ.0) CALL CC5414(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5414=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5415()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~n2 |  e2   !  e2 |  n2 | ~n2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(268).EQ.0) CALL CC5415(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5415=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5416()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(268).EQ.0) CALL CC5416(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5416=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5417()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    W+  |!  W+ | ~n2                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~n2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(268).EQ.0) CALL CC5417(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5417=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5418()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~n2 |  e2   !  e2 |  n2 | ~n2                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(268).EQ.0) CALL CC5418(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5418=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5419()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~n2 |  W+   !  W+ | ~n2                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(268).EQ.0) CALL CC5419(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5419=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F541()
*              ~o1          h    !  h          ~o1                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  h    !  h  |  H  | ~o1                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC541(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F541=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5420()
*                             !  W+         ~o2                      
*                            /!-->1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e2  |!  e2 |  n2 | ~n2                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e2|P5    |!                                      
*                 ~n2 |  W+  |!                                      
*                -->--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(268).EQ.0) CALL CC5420(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5420=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5421()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~n2 |  n2 |  e2   !  e2 |  n2 | ~n2                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U268/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(268).EQ.0) CALL CC5421(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5421=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5422()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5422(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5422=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5423()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5423(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5423=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5424()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5424(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5424=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5425()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5425(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5425=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5426()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    h   |!  h  | ~n2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5426(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5426=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5427()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5427(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5427=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5428()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5428(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5428=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5429()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5429(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5429=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F542()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o1 |  h  |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC542(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F542=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5430()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    h   |!  h  | ~n2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5430(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5430=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5431()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5431(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5431=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5432()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5432(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5432=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5433()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    h   |!  h  | ~n2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5433(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5433=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5434()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5434(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5434=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5435()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    h   |!  h  | ~n2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5435(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5435=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5436()
*                    ~o2    n2   !  n2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n2|P5     !  ~n2|-P6                          
*                    ~n2 |  h    !  h  | ~n2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U269/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(269).EQ.0) CALL CC5436(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5436=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5437()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5437(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5437=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5438()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5438(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5438=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5439()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5439(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5439=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F543()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o1 |  h  |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC543(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F543=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5440()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5440(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5440=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5441()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    H   |!  H  | ~n2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5441(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5441=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5442()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5442(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5442=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5443()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5443(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5443=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5444()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5444(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5444=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5445()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    H   |!  H  | ~n2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5445(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5445=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5446()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5446(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5446=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5447()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5447(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5447=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5448()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    H   |!  H  | ~n2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5448(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5448=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5449()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5449(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5449=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F544()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o1 |  h  |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC544(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F544=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5450()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    H   |!  H  | ~n2                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~n2 |  n2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5450(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5450=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5451()
*                    ~o2    n2   !  n2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n2|P5     !  ~n2|-P6                          
*                    ~n2 |  H    !  H  | ~n2                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U270/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(270).EQ.0) CALL CC5451(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5451=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5452()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5452(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5452=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5453()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5453(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5453=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5454()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5454(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5454=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5455()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5455(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5455=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5456()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5456(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5456=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5457()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5457(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5457=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5458()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5458(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5458=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5459()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5459(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5459=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F545()
*              ~o1          h    !  h          ~o1                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H  |  h    !  h  |  H  | ~o1                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC545(C)
      TOTNUM=+C(2)
      TOTDEN=+2
      RNUM=+P1-C(1)
      F545=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5460()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5460(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5460=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5461()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U271/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(271).EQ.0) CALL CC5461(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5461=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5462()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5462(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5462=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5463()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5463(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5463=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5464()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    H+  |!  H+ | ~n2                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~n2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5464(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5464=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5465()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H+  |!  H+ | ~n2                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~n2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5465(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5465=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5466()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  n2 | ~n2                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~n2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5466(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5466=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5467()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5467(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5467=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5468()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    H+  |!  H+ | ~n2                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~n2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5468(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5468=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5469()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    H+  |!  H+ | ~n2                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~n2 |  e2  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5469(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5469=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F546()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o1 |  H  |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC546(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F546=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5470()
*                             !  e2         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  n2 | ~n2                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~n2 |  e2  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5470(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5470=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5471()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~n2 |  H+   !  H+ | ~n2                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5471(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5471=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5472()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e5|-P6                          
*                    ~n2 |  H+   !  H+ | ~n2                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5472(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5472=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5473()
*                 ~o2    e2   !  e2         ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e2|P5     !     |     |                          
*                 ~n2 |  H+   !  H+ |  n2 | ~n2                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5473(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F5473=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5474()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e5|P5     !  ~e5|-P6                          
*                    ~n2 |  H+   !  H+ | ~n2                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5474(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5474=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5475()
*                 ~o2    e2   !  e2         ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e5|P5     !     |     |                          
*                 ~n2 |  H+   !  H+ |  n2 | ~n2                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5475(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F5475=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5476()
*              ~o2          e2   !  e2         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~n2 |  n2 |  H+   !  H+ |  n2 | ~n2                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U272/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(272).EQ.0) CALL CC5476(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5476=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5477()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5477(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5477=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5478()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5478(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5478=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5479()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5479(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5479=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F547()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o1 |  H  |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC547(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F547=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5480()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5480(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5480=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5481()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    Z   |!  Z  | ~n3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(273).EQ.0) CALL CC5481(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5481=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5482()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~n3 |  n3   !  n3 |  n3 | ~n3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5482(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5482=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5483()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5483(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F5483=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5484()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5484(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5484=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5485()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5485(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5485=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5486()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    Z   |!  Z  | ~n3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(273).EQ.0) CALL CC5486(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5486=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5487()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~n3 |  n3   !  n3 |  n3 | ~n3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5487(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5487=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5488()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5488(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5488=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5489()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5489(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5489=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F548()
*                 ~o1          h    !  h    ~o1                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o1 |  H  |  h    !  h  | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC548(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F548=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5490()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    Z   |!  Z  | ~n3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(273).EQ.0) CALL CC5490(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5490=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5491()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~n3 |  n3   !  n3 |  n3 | ~n3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5491(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5491=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5492()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5492(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5492=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5493()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    Z   |!  Z  | ~n3                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(273).EQ.0) CALL CC5493(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5493=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5494()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~n3 |  n3   !  n3 |  n3 | ~n3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5494(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5494=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5495()
*                    ~o2    n3   !  n3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~n3 |  Z    !  Z  | ~n3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5495(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5495=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5496()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    n3  |!  n3 |  n3 | ~n3                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n3|P5    |!                                      
*                 ~n3 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(273).EQ.0) CALL CC5496(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F5496=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5497()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~n3 |  n3 |  n3   !  n3 |  n3 | ~n3                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U273/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(273).EQ.0) CALL CC5497(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F5497=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5498()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5498(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5498=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5499()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5499(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5499=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F549()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC549(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F549=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F54()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o1 |  Z    !  Z  | ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC54(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)-C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F54=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5500()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    W+  |!  W+ | ~n3                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(274).EQ.0) CALL CC5500(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5500=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5501()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    W+  |!  W+ | ~n3                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(274).EQ.0) CALL CC5501(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5501=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5502()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~n3 |  e3   !  e3 |  n3 | ~n3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5502(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5502=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5503()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5503(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5503=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5504()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    W+  |!  W+ | ~n3                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(274).EQ.0) CALL CC5504(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5504=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5505()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    W+  |!  W+ | ~n3                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(274).EQ.0) CALL CC5505(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5505=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5506()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~n3 |  e3   !  e3 |  n3 | ~n3                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5506(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5506=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5507()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~n3 |  W+   !  W+ | ~n3                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5507(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5507=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5508()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~n3 |  W+   !  W+ | ~n3                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5508(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5508=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5509()
*                             !  W+         ~o2                      
*                            /!-->1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e3  |!  e3 |  n3 | ~n3                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e3|P5    |!                                      
*                 ~n3 |  W+  |!                                      
*                -->--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(274).EQ.0) CALL CC5509(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5509=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F550()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC550(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F550=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5510()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~n3 |  W+   !  W+ | ~n3                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5510(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5510=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5511()
*                             !  W+         ~o2                      
*                            /!-->1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    e3  |!  e3 |  n3 | ~n3                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e6|P5    |!                                      
*                 ~n3 |  W+  |!                                      
*                -->--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(274).EQ.0) CALL CC5511(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5511=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5512()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~n3 |  n3 |  e3   !  e3 |  n3 | ~n3                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U274/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(274).EQ.0) CALL CC5512(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5512=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5513()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5513(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5513=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5514()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5514(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5514=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5515()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5515(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5515=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5516()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5516(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5516=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5517()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    h   |!  h  | ~n3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5517(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5517=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5518()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5518(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5518=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5519()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5519(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5519=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F551()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC551(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F551=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5520()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5520(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5520=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5521()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    h   |!  h  | ~n3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5521(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5521=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5522()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5522(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5522=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5523()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5523(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5523=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5524()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    h   |!  h  | ~n3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5524(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5524=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5525()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5525(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5525=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5526()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    h   |!  h  | ~n3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5526(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5526=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5527()
*                    ~o2    n3   !  n3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~n3 |  h    !  h  | ~n3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U275/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(275).EQ.0) CALL CC5527(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5527=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5528()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5528(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5528=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5529()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5529(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5529=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F552()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC552(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F552=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5530()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5530(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5530=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5531()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5531(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5531=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5532()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    H   |!  H  | ~n3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5532(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5532=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5533()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5533(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5533=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5534()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5534(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5534=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5535()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5535(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5535=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5536()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    H   |!  H  | ~n3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5536(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5536=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5537()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5537(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5537=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5538()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5538(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5538=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5539()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    H   |!  H  | ~n3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5539(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5539=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F553()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC553(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F553=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5540()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5540(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5540=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5541()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    H   |!  H  | ~n3                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~n3 |  n3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5541(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5541=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5542()
*                    ~o2    n3   !  n3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~n3 |  H    !  H  | ~n3                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U276/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(276).EQ.0) CALL CC5542(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5542=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5543()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5543(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5543=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5544()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5544(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5544=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5545()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5545(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5545=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5546()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5546(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5546=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5547()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5547(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5547=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5548()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5548(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5548=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5549()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5549(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5549=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F554()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC554(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F554=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5550()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5550(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5550=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5551()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5551(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5551=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5552()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U277/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(277).EQ.0) CALL CC5552(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5552=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5553()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5553(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5553=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5554()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5554(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5554=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5555()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    H+  |!  H+ | ~n3                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5555(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5555=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5556()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H+  |!  H+ | ~n3                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5556(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5556=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5557()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  n3 | ~n3                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~n3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5557(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5557=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5558()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5558(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5558=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5559()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    H+  |!  H+ | ~n3                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5559(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5559=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F555()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC555(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F555=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5560()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    H+  |!  H+ | ~n3                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5560(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5560=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5561()
*                             !  e3         ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  n3 | ~n3                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~n3 |  e3  |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5561(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5561=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5562()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~n3 |  H+   !  H+ | ~n3                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5562(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5562=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5563()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~n3 |  H+   !  H+ | ~n3                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5563(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5563=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5564()
*                 ~o2    e3   !  e3         ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~n3 |  H+   !  H+ |  n3 | ~n3                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5564(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F5564=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5565()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~n3 |  H+   !  H+ | ~n3                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5565(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5565=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5566()
*                 ~o2    e3   !  e3         ~o2                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e6|P5     !     |     |                          
*                 ~n3 |  H+   !  H+ |  n3 | ~n3                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5566(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F5566=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5567()
*              ~o2          e3   !  e3         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~n3 |  n3 |  H+   !  H+ |  n3 | ~n3                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U278/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(278).EQ.0) CALL CC5567(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5567=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5568()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~u1 |  A    !  A  | ~u1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U279/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(279).EQ.0) CALL CC5568(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F5568=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5569()
*                             !  A          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    u   |!  u  |  u  | ~u1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~u1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U279/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(279).EQ.0) CALL CC5569(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(3)*(P2-P1)+C(2))+C(1)-C(2)*P2
      F5569=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F556()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC556(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F556=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5570()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~u1 |  u  |  u    !  u  |  u  | ~u1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U279/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(279).EQ.0) CALL CC5570(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P1)
      F5570=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5571()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5571(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5571=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5572()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5572(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5572=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5573()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5573(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5573=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5574()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5574(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5574=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5575()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    Z   |!  Z  | ~u1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(280).EQ.0) CALL CC5575(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5575=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5576()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~u1 |  u    !  u  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5576(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5576=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5577()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5577(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F5577=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5578()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5578(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5578=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5579()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5579(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5579=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F557()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC557(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F557=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5580()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    Z   |!  Z  | ~u1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(280).EQ.0) CALL CC5580(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5580=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5581()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~u1 |  u    !  u  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5581(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5581=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5582()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5582(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5582=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5583()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5583(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5583=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5584()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    Z   |!  Z  | ~u1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(280).EQ.0) CALL CC5584(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5584=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5585()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~u1 |  u    !  u  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5585(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5585=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5586()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5586(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5586=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5587()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    Z   |!  Z  | ~u1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(280).EQ.0) CALL CC5587(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5587=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5588()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~u1 |  u    !  u  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5588(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5588=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5589()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~u1 |  Z    !  Z  | ~u1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5589(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5589=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F558()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC558(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F558=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5590()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    u   |!  u  |  u  | ~u1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~u1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(280).EQ.0) CALL CC5590(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F5590=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5591()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~u1 |  u  |  u    !  u  |  u  | ~u1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U280/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(280).EQ.0) CALL CC5591(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F5591=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5592()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(281).EQ.0) CALL CC5592(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5592=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5593()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(281).EQ.0) CALL CC5593(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5593=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5594()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~u1 |  d    !  d  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(281).EQ.0) CALL CC5594(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5594=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5595()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    W+  |!  W+ | ~u1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(281).EQ.0) CALL CC5595(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5595=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5596()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(281).EQ.0) CALL CC5596(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5596=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5597()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~u1 |  d    !  d  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(281).EQ.0) CALL CC5597(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5597=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5598()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    W+  |!  W+ | ~u1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(281).EQ.0) CALL CC5598(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5598=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5599()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~u1 |  u  |  d    !  d  |  u  | ~u1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(281).EQ.0) CALL CC5599(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5599=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F559()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC559(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F559=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F55()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  Z   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC55(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F55=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5600()
*                                   !  d    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~d1|-P6                       
*                 ~o2          W+  |!  W+ | ~u1                      
*                =====\     /-1>---+!-->1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~u1 |  u  |  d   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(281).EQ.0) CALL CC5600(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5600=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5601()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U281/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(281).EQ.0) CALL CC5601(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5601=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5602()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(282).EQ.0) CALL CC5602(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5602=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5603()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(282).EQ.0) CALL CC5603(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5603=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5604()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~u1 |  s    !  s  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(282).EQ.0) CALL CC5604(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5604=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5605()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    W+  |!  W+ | ~u1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(282).EQ.0) CALL CC5605(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5605=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5606()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(282).EQ.0) CALL CC5606(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5606=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5607()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~u1 |  s    !  s  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(282).EQ.0) CALL CC5607(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5607=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5608()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    W+  |!  W+ | ~u1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(282).EQ.0) CALL CC5608(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5608=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5609()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~u1 |  u  |  s    !  s  |  u  | ~u1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(282).EQ.0) CALL CC5609(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5609=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F560()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U20/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(20).EQ.0) CALL CC560(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F560=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5610()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o2          W+  |!  W+ | ~u1                      
*                =====\     /-1>---+!-->1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~u1 |  u  |  s   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(282).EQ.0) CALL CC5610(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5610=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5611()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U282/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(282).EQ.0) CALL CC5611(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5611=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5612()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5612(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5612=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5613()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5613(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5613=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5614()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~u1 |  b    !  b  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5614(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5614=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5615()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    W+  |!  W+ | ~u1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(283).EQ.0) CALL CC5615(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5615=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5616()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    W+  |!  W+ | ~u1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(283).EQ.0) CALL CC5616(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5616=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5617()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5617(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5617=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5618()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~u1 |  b    !  b  |  u  | ~u1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5618(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5618=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5619()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    W+  |!  W+ | ~u1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(283).EQ.0) CALL CC5619(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5619=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F561()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC561(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F561=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5620()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    W+  |!  W+ | ~u1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(283).EQ.0) CALL CC5620(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5620=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5621()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~u1 |  u  |  b    !  b  |  u  | ~u1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5621(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F5621=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5622()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o2          W+  |!  W+ | ~u1                      
*                =====\     /-1>---+!-->1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~u1 |  u  |  b   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(283).EQ.0) CALL CC5622(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5622=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5623()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o2          W+  |!  W+ | ~u1                      
*                =====\     /-1>---+!-->1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~u1 |  u  |  b   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(283).EQ.0) CALL CC5623(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F5623=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5624()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5624(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5624=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5625()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5625(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5625=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5626()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~u1 |  W+   !  W+ | ~u1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U283/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(283).EQ.0) CALL CC5626(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F5626=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5627()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~u1 |  G    !  G  | ~u1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U284/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(284).EQ.0) CALL CC5627(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F5627=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5628()
*                             !  G          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    u   |!  u  |  u  | ~u1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~u1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U284/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(284).EQ.0) CALL CC5628(C)
      S1=A(146)**2
      TOTNUM=+C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P1*(C(3)*(P2-P1)+C(2))+C(1)-C(2)*P2
      F5628=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5629()
*              ~o2          G    !  G          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~u1 |  u  |  u    !  u  |  u  | ~u1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U284/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(284).EQ.0) CALL CC5629(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P1)
      F5629=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F562()
*                 ~o1    h    !  h          ~o1                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o1 |  H    !  H  |  h  | ~o1                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC562(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*P1-C(1)+4*P2
      F562=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5630()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5630(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5630=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5631()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5631(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5631=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5632()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5632(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5632=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5633()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5633(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5633=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5634()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    h   |!  h  | ~u1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5634(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5634=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5635()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5635(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5635=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5636()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5636(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5636=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5637()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5637(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5637=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5638()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    h   |!  h  | ~u1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5638(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5638=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5639()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5639(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5639=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F563()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC563(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F563=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5640()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5640(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5640=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5641()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    h   |!  h  | ~u1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5641(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5641=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5642()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5642(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5642=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5643()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    h   |!  h  | ~u1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5643(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5643=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5644()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~u1 |  h    !  h  | ~u1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U285/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(285).EQ.0) CALL CC5644(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5644=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5645()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5645(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5645=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5646()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5646(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5646=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5647()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5647(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5647=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5648()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5648(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5648=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5649()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    H   |!  H  | ~u1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5649(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5649=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F564()
*                 ~o1    h    !  h          ~o1                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o1 |  H    !  H  |  H  | ~o1                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC564(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*P1-C(1)+4*P2
      F564=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5650()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5650(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5650=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5651()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5651(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5651=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5652()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5652(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5652=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5653()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    H   |!  H  | ~u1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5653(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5653=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5654()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5654(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5654=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5655()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5655(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5655=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5656()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    H   |!  H  | ~u1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5656(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5656=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5657()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5657(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5657=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5658()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    H   |!  H  | ~u1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~u1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5658(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5658=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5659()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~u1 |  H    !  H  | ~u1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U286/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(286).EQ.0) CALL CC5659(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5659=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F565()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC565(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F565=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5660()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5660(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5660=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5661()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5661(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5661=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5662()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5662(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5662=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5663()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5663(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5663=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5664()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5664(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5664=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5665()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5665(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5665=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5666()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5666(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5666=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5667()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5667(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5667=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5668()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5668(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5668=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5669()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U287/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(287).EQ.0) CALL CC5669(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5669=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F566()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC566(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F566=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5670()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U288/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(288).EQ.0) CALL CC5670(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5670=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5671()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U288/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(288).EQ.0) CALL CC5671(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5671=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5672()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U288/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(288).EQ.0) CALL CC5672(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5672=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5673()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U288/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(288).EQ.0) CALL CC5673(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5673=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5674()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U288/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(288).EQ.0) CALL CC5674(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5674=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5675()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U288/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(288).EQ.0) CALL CC5675(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F5675=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5676()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5676(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5676=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5677()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5677(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5677=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5678()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  u  | ~u1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~u1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5678(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5678=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5679()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5679(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5679=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F567()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC567(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F567=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5680()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5680(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5680=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5681()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5681(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5681=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5682()
*                             !  s          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  u  | ~u1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~u1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5682(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5682=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5683()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5683(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5683=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5684()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5684(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5684=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5685()
*              ~o2          s    !  s          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~u1 |  u  |  H+   !  H+ |  u  | ~u1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5685(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5685=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5686()
*                 ~o2          s    !  s    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~u1 |  u  |  H+   !  H+ | ~u1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5686(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F5686=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5687()
*                 ~o2          s    !  s    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~u1 |  u  |  H+   !  H+ | ~u1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5687(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F5687=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5688()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5688(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5688=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5689()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5689(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5689=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F568()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC568(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F568=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5690()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U289/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(289).EQ.0) CALL CC5690(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5690=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5691()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5691(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5691=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5692()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5692(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5692=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5693()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  u  | ~u1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~u1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5693(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5693=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5694()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5694(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5694=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5695()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~u1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5695(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5695=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5696()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5696(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F5696=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5697()
*                             !  b          ~o2                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  u  | ~u1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~u1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5697(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5697=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5698()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5698(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5698=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5699()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    H+  |!  H+ | ~u1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~u1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5699(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F5699=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F569()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC569(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F569=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F56()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o1 |  Z    !  Z  | ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC56(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*P1-C(3)-16*P2)+P2*(C(5)+8*P2)-C(2))+P2*(C(4)-C(6)*
     >P2)-C(1)
      F56=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5700()
*              ~o2          b    !  b          ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~u1 |  u  |  H+   !  H+ |  u  | ~u1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5700(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F5700=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5701()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~u1 |  u  |  H+   !  H+ | ~u1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5701(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F5701=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5702()
*                 ~o2          b    !  b    ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~u1 |  u  |  H+   !  H+ | ~u1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5702(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F5702=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5703()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5703(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5703=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5704()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5704(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5704=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5705()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~u1 |  H+   !  H+ | ~u1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U290/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(290).EQ.0) CALL CC5705(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F5705=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5706()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~d1 |  A    !  A  | ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U291/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(291).EQ.0) CALL CC5706(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F5706=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5707()
*                             !  A          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    d   |!  d  |  d  | ~d1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~d1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U291/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(291).EQ.0) CALL CC5707(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(3)*(P2-P1)+C(2))+C(1)-C(2)*P2
      F5707=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5708()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~d1 |  d  |  d    !  d  |  d  | ~d1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U291/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(291).EQ.0) CALL CC5708(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P1)
      F5708=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5709()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5709(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5709=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F570()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    h   |!  h  | ~o1                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC570(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F570=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5710()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5710(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F5710=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5711()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5711(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5711=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5712()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5712(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5712=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5713()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    Z   |!  Z  | ~d1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~d1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(292).EQ.0) CALL CC5713(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5713=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5714()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  d  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5714(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5714=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5715()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5715(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F5715=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5716()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5716(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5716=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5717()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5717(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5717=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5718()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    Z   |!  Z  | ~d1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~d1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(292).EQ.0) CALL CC5718(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5718=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5719()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  d  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5719(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5719=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F571()
*              ~o1          h    !  h          ~o1                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  H    !  H  |  h  | ~o1                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U21/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(21).EQ.0) CALL CC571(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F571=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5720()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5720(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5720=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5721()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5721(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5721=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5722()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    Z   |!  Z  | ~d1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~d1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(292).EQ.0) CALL CC5722(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5722=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5723()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  d  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5723(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5723=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5724()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5724(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F5724=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5725()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    Z   |!  Z  | ~d1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~d1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(292).EQ.0) CALL CC5725(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F5725=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F5726()
*                 ~o2    Z    !  Z          ~o2                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~d1 |  d    !  d  |  d  | ~d1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U292/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(292).EQ.0) CALL CC5726(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F5726=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*****************************