*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4000()
*                                   !  n1   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~n1|-P6                       
*                 ~o2          N1  |!  N1 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  n1  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U199/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(199).EQ.0) CALL CC4000(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4000=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4001()
*                    ~o2    N1   !  N1   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~o2 |  n1   !  n1 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U199/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(199).EQ.0) CALL CC4001(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4001=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4002()
*                                !  n1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~o2    N1  |!  N1 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~n1|P5    |!                                   
*                    ~o2 |  n1  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U199/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(199).EQ.0) CALL CC4002(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4002=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4003()
*                    ~o2    n1   !  n1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~o2 |  N1   !  N1 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U199/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(199).EQ.0) CALL CC4003(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4003=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4004()
*              ~o2          N2   !  N2         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  n2   !  n2 |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U200/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(200).EQ.0) CALL CC4004(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(1)+P1-2*P2)+P2*(2*P2-C(2))
      F4004=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4005()
*                 ~o2          N2   !  N2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~n2|-P6                       
*                 ~o2 |  Z  |  n2   !  n2 | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U200/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(200).EQ.0) CALL CC4005(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4005=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4006()
*                                   !  n2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~n2|-P6                       
*                 ~o2          N2  |!  N2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  n2  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U200/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(200).EQ.0) CALL CC4006(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4006=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4007()
*                    ~o2    N2   !  N2   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n2|P5     !  ~n2|-P6                          
*                    ~o2 |  n2   !  n2 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U200/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(200).EQ.0) CALL CC4007(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4007=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4008()
*                                !  n2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n2|-P6                          
*                    ~o2    N2  |!  N2 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~n2|P5    |!                                   
*                    ~o2 |  n2  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U200/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(200).EQ.0) CALL CC4008(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4008=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4009()
*                    ~o2    n2   !  n2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n2|P5     !  ~n2|-P6                          
*                    ~o2 |  N2   !  N2 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U200/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(200).EQ.0) CALL CC4009(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4009=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F400()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o1    D   |!  D  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d2|P5    |!                                   
*                    ~o1 |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U15/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(15).EQ.0) CALL CC400(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F400=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4010()
*              ~o2          N3   !  N3         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  n3   !  n3 |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U201/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(201).EQ.0) CALL CC4010(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(1)+P1-2*P2)+P2*(2*P2-C(2))
      F4010=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4011()
*                 ~o2          N3   !  N3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~n3|-P6                       
*                 ~o2 |  Z  |  n3   !  n3 | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U201/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(201).EQ.0) CALL CC4011(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4011=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4012()
*                                   !  n3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~n3|-P6                       
*                 ~o2          N3  |!  N3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  n3  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U201/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(201).EQ.0) CALL CC4012(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4012=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4013()
*                    ~o2    N3   !  N3   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~o2 |  n3   !  n3 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U201/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(201).EQ.0) CALL CC4013(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4013=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4014()
*                                !  n3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~o2    N3  |!  N3 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~n3|P5    |!                                   
*                    ~o2 |  n3  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U201/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(201).EQ.0) CALL CC4014(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4014=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4015()
*                    ~o2    n3   !  n3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~o2 |  N3   !  N3 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U201/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(201).EQ.0) CALL CC4015(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4015=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4016()
*              ~o2          E1   !  E1         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  e1   !  e1 |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4016(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(1)+C(2)*P1-C(4)*P2)+P2*(C(4)*P2-C(3))
      F4016=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4017()
*                 ~o2          E1   !  E1   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e1|-P6                       
*                 ~o2 |  Z  |  e1   !  e1 | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4017(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4017=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4018()
*                                   !  e1   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e1|-P6                       
*                 ~o2          E1  |!  E1 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  e1  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4018(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4018=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4019()
*                 ~o2          E1   !  E1   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e4|-P6                       
*                 ~o2 |  Z  |  e1   !  e1 | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4019(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4019=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F401()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                    ~o1 |  D    !  D  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U15/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(15).EQ.0) CALL CC401(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F401=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4020()
*                                   !  e1   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e4|-P6                       
*                 ~o2          E1  |!  E1 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  e1  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4020(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4020=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4021()
*                    ~o2    E1   !  E1   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~o2 |  e1   !  e1 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4021(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4021=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4022()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e1|-P6                          
*                    ~o2    E1  |!  E1 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e1|P5    |!                                   
*                    ~o2 |  e1  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4022(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4022=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4023()
*                    ~o2    E1   !  E1   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e1|P5     !  ~e4|-P6                          
*                    ~o2 |  e1   !  e1 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4023(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4023=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4024()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e4|-P6                          
*                    ~o2    E1  |!  E1 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e1|P5    |!                                   
*                    ~o2 |  e1  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4024(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4024=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4025()
*                    ~o2    e1   !  e1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~o2 |  E1   !  E1 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4025(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4025=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4026()
*                                !  E1   ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e4|-P6                          
*                    ~o2    e1  |!  e1 | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e1|P5    |!                                   
*                    ~o2 |  E1  |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4026(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4026=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4027()
*                    ~o2    e1   !  e1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e4|-P6                          
*                    ~o2 |  E1   !  E1 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4027(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4027=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4028()
*                    ~o2    E1   !  E1   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e4|P5     !  ~e4|-P6                          
*                    ~o2 |  e1   !  e1 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4028(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4028=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4029()
*                                !  e1   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e4|-P6                          
*                    ~o2    E1  |!  E1 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e4|P5    |!                                   
*                    ~o2 |  e1  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4029(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4029=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F402()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  c    !  c  |  Z  | ~o1                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC402(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F402=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4030()
*                    ~o2    e1   !  e1   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e4|P5     !  ~e4|-P6                          
*                    ~o2 |  E1   !  E1 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U202/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(202).EQ.0) CALL CC4030(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4030=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4031()
*              ~o2          E2   !  E2         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  e2   !  e2 |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4031(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F4031=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4032()
*              ~o2          E2   !  E2         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  e2   !  e2 |  H3 | ~o2                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4032(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F4032=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4033()
*                 ~o2          E2   !  E2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e2|-P6                       
*                 ~o2 |  Z  |  e2   !  e2 | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4033(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4033=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4034()
*                                   !  e2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e2|-P6                       
*                 ~o2          E2  |!  E2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  e2  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4034(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4034=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4035()
*                 ~o2          E2   !  E2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~o2 |  Z  |  e2   !  e2 | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4035(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4035=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4036()
*                                   !  e2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e5|-P6                       
*                 ~o2          E2  |!  E2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  e2  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4036(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4036=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4037()
*              ~o2          E2   !  E2         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  e2   !  e2 |  h  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4037(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4037=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4038()
*              ~o2          E2   !  E2         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  e2   !  e2 |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4038(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4038=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4039()
*                 ~o2          E2   !  E2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e2|-P6                       
*                 ~o2 |  h  |  e2   !  e2 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4039(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4039=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F403()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  c    !  c  |  H3 | ~o1                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC403(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F403=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4040()
*                                   !  e2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e2|-P6                       
*                 ~o2          E2  |!  E2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4040(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4040=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4041()
*                 ~o2          E2   !  E2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~o2 |  h  |  e2   !  e2 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4041(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4041=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4042()
*                                   !  e2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e5|-P6                       
*                 ~o2          E2  |!  E2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4042(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4042=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4043()
*              ~o2          E2   !  E2         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  e2   !  e2 |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4043(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4043=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4044()
*                 ~o2          E2   !  E2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e2|-P6                       
*                 ~o2 |  H  |  e2   !  e2 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4044(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4044=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4045()
*                                   !  e2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e2|-P6                       
*                 ~o2          E2  |!  E2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4045(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4045=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4046()
*                 ~o2          E2   !  E2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~o2 |  H  |  e2   !  e2 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4046(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4046=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4047()
*                                   !  e2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e5|-P6                       
*                 ~o2          E2  |!  E2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4047(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4047=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4048()
*              ~o2          E2   !  E2         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  e2   !  e2 |  H3 | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4048(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F4048=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4049()
*                 ~o2          E2   !  E2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e2|-P6                       
*                 ~o2 |  H3 |  e2   !  e2 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4049(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4049=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F404()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o1 |  Z  |  c    !  c  | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC404(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F404=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4050()
*                                   !  e2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e2|-P6                       
*                 ~o2          E2  |!  E2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4050(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4050=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4051()
*                 ~o2          E2   !  E2   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~o2 |  H3 |  e2   !  e2 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4051(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4051=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4052()
*                                   !  e2   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e5|-P6                       
*                 ~o2          E2  |!  E2 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4052(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4052=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4053()
*                    ~o2    E2   !  E2   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~o2 |  e2   !  e2 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4053(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4053=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4054()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o2    E2  |!  E2 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e2|P5    |!                                   
*                    ~o2 |  e2  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4054(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4054=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4055()
*                    ~o2    E2   !  E2   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e2|P5     !  ~e5|-P6                          
*                    ~o2 |  e2   !  e2 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4055(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4055=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4056()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    E2  |!  E2 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e2|P5    |!                                   
*                    ~o2 |  e2  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4056(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4056=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4057()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~o2 |  E2   !  E2 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4057(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4057=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4058()
*                                !  E2   ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    e2  |!  e2 | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e2|P5    |!                                   
*                    ~o2 |  E2  |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4058(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4058=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4059()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e5|-P6                          
*                    ~o2 |  E2   !  E2 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4059(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4059=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F405()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o1          C   |!  C  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  c   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC405(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F405=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4060()
*                    ~o2    E2   !  E2   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e5|P5     !  ~e5|-P6                          
*                    ~o2 |  e2   !  e2 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4060(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4060=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4061()
*                                !  e2   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o2    E2  |!  E2 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e5|P5    |!                                   
*                    ~o2 |  e2  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4061(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4061=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4062()
*                    ~o2    e2   !  e2   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e5|P5     !  ~e5|-P6                          
*                    ~o2 |  E2   !  E2 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U203/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(203).EQ.0) CALL CC4062(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4062=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4063()
*              ~o2          E3   !  E3         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  e3   !  e3 |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4063(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F4063=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4064()
*              ~o2          E3   !  E3         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  e3   !  e3 |  H3 | ~o2                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4064(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F4064=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4065()
*                 ~o2          E3   !  E3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~o2 |  Z  |  e3   !  e3 | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4065(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4065=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4066()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e3|-P6                       
*                 ~o2          E3  |!  E3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  e3  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4066(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4066=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4067()
*                 ~o2          E3   !  E3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~o2 |  Z  |  e3   !  e3 | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4067(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4067=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4068()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o2          E3  |!  E3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  e3  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4068(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4068=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4069()
*              ~o2          E3   !  E3         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  e3   !  e3 |  h  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4069(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4069=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F406()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o1 |  Z  |  c    !  c  | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC406(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F406=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4070()
*              ~o2          E3   !  E3         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  e3   !  e3 |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4070(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4070=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4071()
*                 ~o2          E3   !  E3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~o2 |  h  |  e3   !  e3 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4071(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4071=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4072()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e3|-P6                       
*                 ~o2          E3  |!  E3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4072(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4072=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4073()
*                 ~o2          E3   !  E3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~o2 |  h  |  e3   !  e3 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4073(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4073=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4074()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o2          E3  |!  E3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4074(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4074=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4075()
*              ~o2          E3   !  E3         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  e3   !  e3 |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4075(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4075=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4076()
*                 ~o2          E3   !  E3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~o2 |  H  |  e3   !  e3 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4076(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4076=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4077()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e3|-P6                       
*                 ~o2          E3  |!  E3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4077(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4077=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4078()
*                 ~o2          E3   !  E3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~o2 |  H  |  e3   !  e3 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4078(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4078=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4079()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o2          E3  |!  E3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4079(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4079=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F407()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o1          C   |!  C  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  c   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC407(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F407=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4080()
*              ~o2          E3   !  E3         ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  e3   !  e3 |  H3 | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4080(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F4080=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4081()
*                 ~o2          E3   !  E3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~o2 |  H3 |  e3   !  e3 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4081(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4081=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4082()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e3|-P6                       
*                 ~o2          E3  |!  E3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4082(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4082=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4083()
*                 ~o2          E3   !  E3   ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~o2 |  H3 |  e3   !  e3 | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4083(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4083=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4084()
*                                   !  e3   ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o2          E3  |!  E3 | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4084(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4084=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4085()
*                    ~o2    E3   !  E3   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~o2 |  e3   !  e3 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4085(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4085=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4086()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o2    E3  |!  E3 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e3|P5    |!                                   
*                    ~o2 |  e3  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4086(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4086=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4087()
*                    ~o2    E3   !  E3   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~o2 |  e3   !  e3 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4087(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4087=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4088()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    E3  |!  E3 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e3|P5    |!                                   
*                    ~o2 |  e3  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4088(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4088=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4089()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~o2 |  E3   !  E3 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4089(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4089=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F408()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  c    !  c  |  h  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC408(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F408=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4090()
*                                !  E3   ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    e3  |!  e3 | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e3|P5    |!                                   
*                    ~o2 |  E3  |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4090(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4090=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4091()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~o2 |  E3   !  E3 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4091(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4091=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4092()
*                    ~o2    E3   !  E3   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~o2 |  e3   !  e3 | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4092(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4092=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4093()
*                                !  e3   ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o2    E3  |!  E3 | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e6|P5    |!                                   
*                    ~o2 |  e3  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4093(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4093=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4094()
*                    ~o2    e3   !  e3   ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~o2 |  E3   !  E3 | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U204/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(204).EQ.0) CALL CC4094(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4094=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4095()
*              ~o2          U    !  U          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  u    !  u  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4095(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(1)+C(2)*P1-C(4)*P2)+P2*(C(4)*P2-C(3))
      F4095=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4096()
*                 ~o2          U    !  U    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~u1|-P6                       
*                 ~o2 |  Z  |  u    !  u  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4096(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4096=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4097()
*                                   !  u    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~u1|-P6                       
*                 ~o2          U   |!  U  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  u   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4097(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4097=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4098()
*                 ~o2          U    !  U    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~u2|-P6                       
*                 ~o2 |  Z  |  u    !  u  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4098(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4098=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4099()
*                                   !  u    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~u2|-P6                       
*                 ~o2          U   |!  U  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  u   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4099(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4099=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F409()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  c    !  c  |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC409(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F409=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F40()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC40(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F40=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4100()
*                    ~o2    U    !  U    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~o2 |  u    !  u  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4100(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4100=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4101()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o2    U   |!  U  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u1|P5    |!                                   
*                    ~o2 |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4101(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4101=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4102()
*                    ~o2    U    !  U    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u2|-P6                          
*                    ~o2 |  u    !  u  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4102(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4102=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4103()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o2    U   |!  U  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u1|P5    |!                                   
*                    ~o2 |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4103(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4103=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4104()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~o2 |  U    !  U  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4104(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4104=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4105()
*                                !  U    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o2    u   |!  u  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~u1|P5    |!                                   
*                    ~o2 |  U   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4105(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4105=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4106()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u2|-P6                          
*                    ~o2 |  U    !  U  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4106(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4106=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4107()
*                    ~o2    U    !  U    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u2|P5     !  ~u2|-P6                          
*                    ~o2 |  u    !  u  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4107(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4107=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4108()
*                                !  u    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o2    U   |!  U  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u2|P5    |!                                   
*                    ~o2 |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4108(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4108=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4109()
*                    ~o2    u    !  u    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u2|P5     !  ~u2|-P6                          
*                    ~o2 |  U    !  U  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U205/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(205).EQ.0) CALL CC4109(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4109=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F410()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o1 |  h  |  c    !  c  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC410(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F410=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4110()
*              ~o2          D    !  D          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  d    !  d  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4110(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(1)+C(2)*P1-C(4)*P2)+P2*(C(4)*P2-C(3))
      F4110=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4111()
*                 ~o2          D    !  D    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~d1|-P6                       
*                 ~o2 |  Z  |  d    !  d  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4111(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4111=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4112()
*                                   !  d    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~d1|-P6                       
*                 ~o2          D   |!  D  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  d   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4112(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4112=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4113()
*                 ~o2          D    !  D    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~d2|-P6                       
*                 ~o2 |  Z  |  d    !  d  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4113(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4113=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4114()
*                                   !  d    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~d2|-P6                       
*                 ~o2          D   |!  D  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  d   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4114(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+C(3)*S1-C(1)-C(2)*P1
      F4114=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4115()
*                    ~o2    D    !  D    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~o2 |  d    !  d  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4115(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4115=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4116()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o2    D   |!  D  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d1|P5    |!                                   
*                    ~o2 |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4116(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4116=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4117()
*                    ~o2    D    !  D    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d2|-P6                          
*                    ~o2 |  d    !  d  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4117(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4117=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4118()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o2    D   |!  D  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d1|P5    |!                                   
*                    ~o2 |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4118(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4118=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4119()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~o2 |  D    !  D  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4119(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4119=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F411()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o1          C   |!  C  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC411(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F411=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4120()
*                                !  D    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o2    d   |!  d  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~d1|P5    |!                                   
*                    ~o2 |  D   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4120(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4120=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4121()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d2|-P6                          
*                    ~o2 |  D    !  D  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4121(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4121=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4122()
*                    ~o2    D    !  D    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                    ~o2 |  d    !  d  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4122(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4122=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4123()
*                                !  d    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o2    D   |!  D  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d2|P5    |!                                   
*                    ~o2 |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4123(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4123=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4124()
*                    ~o2    d    !  d    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                    ~o2 |  D    !  D  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U206/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(206).EQ.0) CALL CC4124(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F4124=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4125()
*              ~o2          C    !  C          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  c    !  c  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4125(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F4125=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4126()
*              ~o2          C    !  C          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  c    !  c  |  H3 | ~o2                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4126(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F4126=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4127()
*                 ~o2          C    !  C    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o2 |  Z  |  c    !  c  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4127(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4127=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4128()
*                                   !  c    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o2          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  c   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4128(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4128=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4129()
*                 ~o2          C    !  C    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o2 |  Z  |  c    !  c  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4129(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4129=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F412()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o1 |  h  |  c    !  c  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC412(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F412=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4130()
*                                   !  c    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o2          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  c   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4130(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4130=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4131()
*              ~o2          C    !  C          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  c    !  c  |  h  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4131(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4131=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4132()
*              ~o2          C    !  C          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  c    !  c  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4132(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4132=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4133()
*                 ~o2          C    !  C    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o2 |  h  |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4133(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4133=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4134()
*                                   !  c    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o2          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4134(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4134=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4135()
*                 ~o2          C    !  C    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o2 |  h  |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4135(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4135=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4136()
*                                   !  c    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o2          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4136(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4136=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4137()
*              ~o2          C    !  C          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  c    !  c  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4137(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4137=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4138()
*                 ~o2          C    !  C    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o2 |  H  |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4138(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4138=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4139()
*                                   !  c    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o2          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4139(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4139=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F413()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o1          C   |!  C  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC413(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F413=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4140()
*                 ~o2          C    !  C    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o2 |  H  |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4140(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4140=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4141()
*                                   !  c    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o2          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4141(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4141=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4142()
*              ~o2          C    !  C          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  c    !  c  |  H3 | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4142(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F4142=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4143()
*                 ~o2          C    !  C    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o2 |  H3 |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4143(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4143=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4144()
*                                   !  c    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o2          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4144(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4144=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4145()
*                 ~o2          C    !  C    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o2 |  H3 |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4145(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4145=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4146()
*                                   !  c    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o2          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4146(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4146=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4147()
*                    ~o2    C    !  C    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~o2 |  c    !  c  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4147(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4147=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4148()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o2    C   |!  C  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~o2 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4148(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4148=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4149()
*                    ~o2    C    !  C    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~o2 |  c    !  c  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4149(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4149=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F414()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H  |  c    !  c  |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC414(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F414=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4150()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    C   |!  C  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~o2 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4150(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4150=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4151()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~o2 |  C    !  C  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4151(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4151=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4152()
*                                !  C    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    c   |!  c  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~o2 |  C   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4152(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4152=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4153()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~o2 |  C    !  C  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4153(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4153=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4154()
*                    ~o2    C    !  C    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~o2 |  c    !  c  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4154(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4154=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4155()
*                                !  c    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o2    C   |!  C  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c2|P5    |!                                   
*                    ~o2 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4155(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4155=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4156()
*                    ~o2    c    !  c    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~o2 |  C    !  C  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U207/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(207).EQ.0) CALL CC4156(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4156=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4157()
*              ~o2          S    !  S          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  s    !  s  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4157(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F4157=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4158()
*              ~o2          S    !  S          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  s    !  s  |  H3 | ~o2                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4158(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F4158=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4159()
*                 ~o2          S    !  S    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o2 |  Z  |  s    !  s  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4159(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4159=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F415()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o1 |  H  |  c    !  c  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC415(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F415=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4160()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o2          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  s   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4160(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4160=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4161()
*                 ~o2          S    !  S    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o2 |  Z  |  s    !  s  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4161(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4161=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4162()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o2          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  s   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4162(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4162=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4163()
*              ~o2          S    !  S          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  s    !  s  |  h  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4163(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4163=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4164()
*              ~o2          S    !  S          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  s    !  s  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4164(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4164=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4165()
*                 ~o2          S    !  S    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o2 |  h  |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4165(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4165=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4166()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o2          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4166(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4166=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4167()
*                 ~o2          S    !  S    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o2 |  h  |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4167(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4167=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4168()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o2          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4168(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4168=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4169()
*              ~o2          S    !  S          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  s    !  s  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4169(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4169=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F416()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o1          C   |!  C  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC416(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F416=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4170()
*                 ~o2          S    !  S    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o2 |  H  |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4170(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4170=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4171()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o2          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4171(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4171=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4172()
*                 ~o2          S    !  S    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o2 |  H  |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4172(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4172=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4173()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o2          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4173(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4173=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4174()
*              ~o2          S    !  S          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  s    !  s  |  H3 | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4174(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F4174=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4175()
*                 ~o2          S    !  S    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o2 |  H3 |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4175(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4175=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4176()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o2          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4176(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4176=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4177()
*                 ~o2          S    !  S    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o2 |  H3 |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4177(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4177=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4178()
*                                   !  s    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o2          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4178(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4178=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4179()
*                    ~o2    S    !  S    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~o2 |  s    !  s  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4179(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4179=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F417()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o1 |  H  |  c    !  c  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC417(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F417=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4180()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o2    S   |!  S  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                    ~o2 |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4180(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4180=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4181()
*                    ~o2    S    !  S    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~o2 |  s    !  s  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4181(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4181=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4182()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    S   |!  S  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                    ~o2 |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4182(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4182=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4183()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~o2 |  S    !  S  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4183(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4183=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4184()
*                                !  S    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    s   |!  s  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~s1|P5    |!                                   
*                    ~o2 |  S   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4184(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4184=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4185()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~o2 |  S    !  S  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4185(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4185=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4186()
*                    ~o2    S    !  S    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~o2 |  s    !  s  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4186(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4186=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4187()
*                                !  s    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o2    S   |!  S  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s2|P5    |!                                   
*                    ~o2 |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4187(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4187=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4188()
*                    ~o2    s    !  s    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~o2 |  S    !  S  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U208/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(208).EQ.0) CALL CC4188(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4188=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4189()
*              ~o2          T    !  T          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  t    !  t  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4189(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F4189=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F418()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o1          C   |!  C  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC418(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F418=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4190()
*              ~o2          T    !  T          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  t    !  t  |  H3 | ~o2                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4190(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F4190=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4191()
*                 ~o2          T    !  T    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t1|-P6                       
*                 ~o2 |  Z  |  t    !  t  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4191(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4191=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4192()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t1|-P6                       
*                 ~o2          T   |!  T  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  t   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4192(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4192=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4193()
*                 ~o2          T    !  T    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~o2 |  Z  |  t    !  t  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4193(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4193=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4194()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~o2          T   |!  T  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  t   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4194(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4194=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4195()
*              ~o2          T    !  T          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  t    !  t  |  h  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4195(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4195=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4196()
*              ~o2          T    !  T          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  t    !  t  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4196(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4196=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4197()
*                 ~o2          T    !  T    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t1|-P6                       
*                 ~o2 |  h  |  t    !  t  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4197(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4197=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4198()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t1|-P6                       
*                 ~o2          T   |!  T  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  t   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4198(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4198=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4199()
*                 ~o2          T    !  T    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~o2 |  h  |  t    !  t  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4199(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4199=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F419()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H3 |  c    !  c  |  H3 | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC419(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F419=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F41()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC41(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F41=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4200()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~o2          T   |!  T  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  t   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4200(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4200=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4201()
*              ~o2          T    !  T          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  t    !  t  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4201(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4201=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4202()
*                 ~o2          T    !  T    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t1|-P6                       
*                 ~o2 |  H  |  t    !  t  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4202(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4202=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4203()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t1|-P6                       
*                 ~o2          T   |!  T  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  t   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4203(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4203=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4204()
*                 ~o2          T    !  T    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~o2 |  H  |  t    !  t  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4204(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4204=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4205()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~o2          T   |!  T  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  t   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4205(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4205=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4206()
*              ~o2          T    !  T          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  t    !  t  |  H3 | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4206(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F4206=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4207()
*                 ~o2          T    !  T    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t1|-P6                       
*                 ~o2 |  H3 |  t    !  t  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4207(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4207=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4208()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t1|-P6                       
*                 ~o2          T   |!  T  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  t   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4208(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4208=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4209()
*                 ~o2          T    !  T    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~o2 |  H3 |  t    !  t  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4209(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4209=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F420()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o1 |  H3 |  c    !  c  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC420(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F420=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4210()
*                                   !  t    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~o2          T   |!  T  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  t   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4210(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4210=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4211()
*                    ~o2    T    !  T    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~o2 |  t    !  t  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4211(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4211=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4212()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o2    T   |!  T  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t1|P5    |!                                   
*                    ~o2 |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4212(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4212=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4213()
*                    ~o2    T    !  T    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~o2 |  t    !  t  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4213(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4213=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4214()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    T   |!  T  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t1|P5    |!                                   
*                    ~o2 |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4214(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4214=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4215()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~o2 |  T    !  T  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4215(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4215=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4216()
*                                !  T    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    t   |!  t  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~t1|P5    |!                                   
*                    ~o2 |  T   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4216(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4216=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4217()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~o2 |  T    !  T  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4217(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4217=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4218()
*                    ~o2    T    !  T    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~o2 |  t    !  t  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4218(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4218=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4219()
*                                !  t    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o2    T   |!  T  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t2|P5    |!                                   
*                    ~o2 |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4219(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4219=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F421()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o1          C   |!  C  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC421(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F421=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4220()
*                    ~o2    t    !  t    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~o2 |  T    !  T  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U209/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(209).EQ.0) CALL CC4220(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4220=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4221()
*              ~o2          B    !  B          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  b    !  b  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4221(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F4221=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4222()
*              ~o2          B    !  B          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  b    !  b  |  H3 | ~o2                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4222(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F4222=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4223()
*                 ~o2          B    !  B    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~o2 |  Z  |  b    !  b  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4223(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4223=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4224()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o2          B   |!  B  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  b   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4224(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4224=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4225()
*                 ~o2          B    !  B    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~o2 |  Z  |  b    !  b  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4225(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F4225=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4226()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o2          B   |!  B  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  b   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4226(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F4226=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4227()
*              ~o2          B    !  B          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  b    !  b  |  h  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4227(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4227=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4228()
*              ~o2          B    !  B          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  b    !  b  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4228(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4228=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4229()
*                 ~o2          B    !  B    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~o2 |  h  |  b    !  b  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4229(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4229=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F422()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o1 |  H3 |  c    !  c  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC422(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F422=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4230()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o2          B   |!  B  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4230(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4230=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4231()
*                 ~o2          B    !  B    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~o2 |  h  |  b    !  b  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4231(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4231=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4232()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o2          B   |!  B  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4232(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4232=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4233()
*              ~o2          B    !  B          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  b    !  b  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4233(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F4233=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4234()
*                 ~o2          B    !  B    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~o2 |  H  |  b    !  b  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4234(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4234=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4235()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o2          B   |!  B  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4235(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4235=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4236()
*                 ~o2          B    !  B    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~o2 |  H  |  b    !  b  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4236(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4236=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4237()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o2          B   |!  B  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4237(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F4237=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4238()
*              ~o2          B    !  B          ~o2                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  b    !  b  |  H3 | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4238(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F4238=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4239()
*                 ~o2          B    !  B    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~o2 |  H3 |  b    !  b  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4239(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4239=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F423()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o1          C   |!  C  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC423(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F423=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4240()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o2          B   |!  B  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4240(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4240=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4241()
*                 ~o2          B    !  B    ~o2                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~o2 |  H3 |  b    !  b  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4241(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4241=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4242()
*                                   !  b    ~o2                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o2          B   |!  B  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  b   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4242(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F4242=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4243()
*                    ~o2    B    !  B    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~o2 |  b    !  b  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4243(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4243=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4244()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o2    B   |!  B  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b1|P5    |!                                   
*                    ~o2 |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4244(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4244=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4245()
*                    ~o2    B    !  B    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~o2 |  b    !  b  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4245(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4245=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4246()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    B   |!  B  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b1|P5    |!                                   
*                    ~o2 |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4246(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4246=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4247()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~o2 |  B    !  B  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4247(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4247=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4248()
*                                !  B    ~o2                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    b   |!  b  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~b1|P5    |!                                   
*                    ~o2 |  B   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4248(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4248=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4249()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~o2 |  B    !  B  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4249(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4249=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F424()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~o1 |  c    !  c  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC424(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F424=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4250()
*                    ~o2    B    !  B    ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~o2 |  b    !  b  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4250(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F4250=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4251()
*                                !  b    ~o2                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o2    B   |!  B  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~b2|P5    |!                                   
*                    ~o2 |  b   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4251(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4251=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4252()
*                    ~o2    b    !  b    ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~o2 |  B    !  B  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U210/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(210).EQ.0) CALL CC4252(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F4252=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4253()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4253(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4253=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4254()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4254(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4254=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4255()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4255(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4255=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4256()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4256(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4256=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4257()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  h    !  h  |  h  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4257(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4257=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4258()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  h    !  h  |  H  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4258(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4258=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4259()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4259(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4259=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F425()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    C   |!  C  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~o1 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC425(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F425=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4260()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4260(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4260=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4261()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4261(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4261=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4262()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4262(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4262=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4263()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4263(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4263=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4264()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4264(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4264=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4265()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  h    !  h  |  h  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4265(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)+2*P2
      F4265=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4266()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  h    !  h  |  H  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4266(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)+2*P2
      F4266=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4267()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4267(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4267=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4268()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4268(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4268=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4269()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4269(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4269=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F426()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~o1 |  c    !  c  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC426(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F426=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4270()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4270(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4270=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4271()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  h    !  h  |  h  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4271(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F4271=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4272()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  h    !  h  |  H  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4272(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F4272=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4273()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  h  |  h    !  h  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4273(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4273=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4274()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  h  |  h    !  h  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4274(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4274=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4275()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  h    !  h  |  H  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4275(C)
      TOTNUM=+C(2)
      TOTDEN=+2
      RNUM=+P1-C(1)
      F4275=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4276()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  H  |  h    !  h  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4276(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4276=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4277()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  H  |  h    !  h  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4277(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4277=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4278()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4278(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4278=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4279()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4279(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4279=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F427()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    C   |!  C  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~o1 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC427(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F427=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4280()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4280(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4280=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4281()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4281(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4281=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4282()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4282(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4282=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4283()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U211/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(211).EQ.0) CALL CC4283(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4283=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4284()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4284(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4284=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4285()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4285(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4285=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4286()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4286(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4286=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4287()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  h  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4287(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4287=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4288()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4288(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4288=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4289()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  H  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4289(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4289=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F428()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~o1 |  C    !  C  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC428(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F428=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4290()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4290(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4290=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4291()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4291(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4291=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4292()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4292(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4292=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4293()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4293(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4293=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4294()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4294(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4294=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4295()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4295(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4295=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4296()
*                             !  h          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  h  | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  h   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4296(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4296=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4297()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4297(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4297=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4298()
*                             !  h          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  H  | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  h   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4298(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4298=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4299()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4299(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4299=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F429()
*                                !  C    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    c   |!  c  | ~o1                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~o1 |  C   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC429(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F429=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F42()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-2-----!---2-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  h    !  h  |  Z  | ~o1                   
*             =====@-1---@-------!-----@---3-@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC42(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(-C(3)-C(4)*P1)-C(2)-C(6)*P2)+P2*(C(6)*P2-C(5))-C(1)
      F42=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4300()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4300(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4300=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4301()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4301(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4301=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4302()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4302(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4302=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(10)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4303()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4303(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4303=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4304()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  h  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4304(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*P1-C(1)+4*P2
      F4304=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4305()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4305(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4305=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4306()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  H  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4306(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*P1-C(1)+4*P2
      F4306=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4307()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4307(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4307=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4308()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4308(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4308=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4309()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4309(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4309=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F430()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~o1 |  C    !  C  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC430(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F430=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4310()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4310(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4310=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4311()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H    !  H  |  h  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4311(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F4311=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4312()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  H   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4312(C)
      TOTNUM=-C(2)
      TOTDEN=+1
      RNUM=+C(1)-6*P1+4*P2
      F4312=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4313()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H    !  H  |  H  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4313(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F4313=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4314()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  h  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4314(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4314=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4315()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  H   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4315(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4315=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4316()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  h  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4316(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4316=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4317()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  H   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4317(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4317=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4318()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4318(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4318=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4319()
*                             !  h          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H   |!  H  |  H  | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~o2 |  h   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4319(C)
      TOTNUM=-C(2)
      TOTDEN=+1
      RNUM=+C(1)-6*P1+4*P2
      F4319=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F431()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~o1 |  c    !  c  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC431(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F431=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4320()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4320(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4320=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4321()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4321(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4321=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4322()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4322(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4322=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4323()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4323(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4323=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4324()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  H    !  H  |  H  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4324(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F4324=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4325()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  H  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4325(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4325=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4326()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  H   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4326(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4326=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4327()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  H  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4327(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4327=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4328()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  H   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4328(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4328=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4329()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4329(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4329=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F432()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    C   |!  C  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c2|P5    |!                                   
*                    ~o1 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC432(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F432=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4330()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4330(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4330=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4331()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4331(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4331=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4332()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4332(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4332=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4333()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4333(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4333=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4334()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4334(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4334=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4335()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4335(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4335=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4336()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4336(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4336=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4337()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4337(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4337=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4338()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U212/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(212).EQ.0) CALL CC4338(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4338=RNUM*(TOTNUM/TOTDEN)*Q2(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4339()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4339(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4339=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F433()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~o1 |  C    !  C  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U16/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(16).EQ.0) CALL CC433(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F433=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4340()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4340(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4340=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4341()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  Z  | ~o2                      
*                =====@-------!-----@---1-@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4341(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4341=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4342()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4342(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4342=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4343()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4343(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4343=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4344()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  H3 | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4344(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4344=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4345()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4345(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4345=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4346()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4346(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4346=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4347()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4347(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4347=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4348()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4348(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4348=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4349()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4349(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4349=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F434()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  s    !  s  |  Z  | ~o1                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC434(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F434=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4350()
*                             !  h          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  Z  | ~o2                      
*                =====@------+!-----@---1-@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  h   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4350(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4350=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4351()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4351(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4351=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4352()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4352(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4352=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4353()
*                             !  h          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  H3 | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  h   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4353(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4353=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4354()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4354(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4354=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4355()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4355(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4355=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4356()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4356(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4356=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4357()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4357(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4357=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(10)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4358()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  H3   !  H3 |  Z  | ~o2                   
*             =====@-1---@-------!-----@---2-@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4358(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4358=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4359()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o2 |  Z  |  H3   !  H3 | ~o2                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4359(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4359=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F435()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  s    !  s  |  H3 | ~o1                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC435(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F435=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4360()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4360(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4360=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4361()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  H3   !  H3 |  H3 | ~o2                   
*             =====@-1---@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4361(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4361=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4362()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  Z  |  H3   !  H3 | ~o2                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4362(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4362=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4363()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4363(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4363=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4364()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  Z  |  H3   !  H3 | ~o2                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4364(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4364=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4365()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4365(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4365=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4366()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4366(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4366=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4367()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4367(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4367=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4368()
*                 ~o2    h    !  h          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  H3 | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4368(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F4368=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4369()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4369(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4369=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F436()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o1 |  Z  |  s    !  s  | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC436(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F436=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4370()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4370(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4370=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4371()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4371(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4371=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4372()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4372(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4372=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4373()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4373(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4373=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4374()
*                             !  h          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  H3 | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~o2 |  h   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4374(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F4374=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4375()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4375(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4375=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4376()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4376(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4376=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4377()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4377(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4377=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4378()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4378(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4378=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4379()
*              ~o2          h    !  h          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  H3   !  H3 |  H3 | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4379(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F4379=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F437()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o1          S   |!  S  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  s   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC437(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F437=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4380()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  H3 |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4380(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4380=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4381()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4381(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4381=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4382()
*                 ~o2          h    !  h    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  H3 |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4382(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4382=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4383()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          h   |!  h  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4383(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4383=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4384()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4384(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4384=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4385()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4385(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4385=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4386()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4386(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4386=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4387()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4387(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4387=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4388()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4388(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4388=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4389()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4389(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4389=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F438()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o1 |  Z  |  s    !  s  | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC438(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F438=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4390()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4390(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4390=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4391()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4391(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4391=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4392()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    h   |!  h  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4392(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4392=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4393()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  h    !  h  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U213/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(213).EQ.0) CALL CC4393(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4393=RNUM*(TOTNUM/TOTDEN)*Q2(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4394()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4394(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4394=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4395()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4395(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4395=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4396()
*                 ~o2    H    !  H          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  h  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4396(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4396=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4397()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4397(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4397=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4398()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4398(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4398=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4399()
*                 ~o2    H    !  H          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  H  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4399(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4399=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F439()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o1          S   |!  S  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  s   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC439(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F439=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F43()
*                                   !  h    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o1|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-2----+!---2-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  h   |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC43(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(8*(P2-P1)-C(3))+C(5)*P2-C(2))+P2*(C(4)+C(6)*P2)-C(1)
      F43=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4400()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4400(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4400=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4401()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4401(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4401=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4402()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4402(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4402=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4403()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4403(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4403=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4404()
*              ~o2          H    !  H          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H    !  H  |  h  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4404(C)
      TOTNUM=+C(2)
      TOTDEN=+2
      RNUM=+P1-C(1)
      F4404=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4405()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o2 |  h  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4405(C)
      TOTNUM=-C(2)
      TOTDEN=+1
      RNUM=+C(1)-3*P1+2*P2
      F4405=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4406()
*              ~o2          H    !  H          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H    !  H  |  H  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4406(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F4406=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4407()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  h  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4407(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4407=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4408()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  h  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4408(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4408=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4409()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4409(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4409=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F440()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  s    !  s  |  h  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC440(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F440=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4410()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4410(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4410=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4411()
*                 ~o2    H    !  H          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  H    !  H  |  H  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4411(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)+2*P2
      F4411=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4412()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4412(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4412=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4413()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4413(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4413=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4414()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4414(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4414=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4415()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4415(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4415=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4416()
*              ~o2          H    !  H          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  H    !  H  |  H  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4416(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F4416=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4417()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  H  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4417(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4417=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4418()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  H  |  H    !  H  | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4418(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4418=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4419()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4419(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4419=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F441()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  s    !  s  |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC441(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F441=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4420()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4420(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4420=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4421()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4421(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4421=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4422()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4422(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(2)*P1-C(1)
      F4422=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4423()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4423(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)-C(2)*P1
      F4423=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4424()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U214/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(214).EQ.0) CALL CC4424(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4424=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4425()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4425(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4425=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4426()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4426(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4426=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4427()
*                 ~o2    H    !  H          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  Z  | ~o2                      
*                =====@-------!-----@---1-@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4427(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4427=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4428()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4428(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4428=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4429()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4429(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4429=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F442()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o1 |  h  |  s    !  s  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC442(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F442=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4430()
*                 ~o2    H    !  H          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  H3 | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4430(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4430=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4431()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4431(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4431=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4432()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4432(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4432=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4433()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4433(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4433=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4434()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4434(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4434=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4435()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4435(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4435=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4436()
*                             !  H          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  Z  | ~o2                      
*                =====@------+!-----@---1-@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  H   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4436(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4436=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4437()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4437(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4437=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4438()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4438(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4438=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4439()
*                             !  H          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  H3 | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~o2 |  H   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4439(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4439=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F443()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o1          S   |!  S  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC443(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F443=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4440()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4440(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4440=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4441()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4441(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4441=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4442()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4442(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4442=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4443()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4443(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4443=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(10)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4444()
*              ~o2          H    !  H          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  H3   !  H3 |  Z  | ~o2                   
*             =====@-1---@-------!-----@---2-@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4444(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4444=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4445()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o2 |  Z  |  H3   !  H3 | ~o2                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4445(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4445=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4446()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o2          H   |!  H  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4446(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4446=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4447()
*              ~o2          H    !  H          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  H3   !  H3 |  H3 | ~o2                   
*             =====@-1---@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4447(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4447=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4448()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  Z  |  H3   !  H3 | ~o2                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4448(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4448=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4449()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          H   |!  H  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4449(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4449=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F444()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o1 |  h  |  s    !  s  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC444(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F444=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4450()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  Z  |  H3   !  H3 | ~o2                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4450(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4450=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4451()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          H   |!  H  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  H3  |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4451(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4451=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4452()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4452(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4452=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4453()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4453(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4453=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4454()
*                 ~o2    H    !  H          ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  H3 | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4454(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F4454=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4455()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4455(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4455=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4456()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4456(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4456=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4457()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4457(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4457=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4458()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4458(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4458=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4459()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4459(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4459=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F445()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o1          S   |!  S  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC445(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F445=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4460()
*                             !  H          ~o2                      
*                            /!-----\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H3  |!  H3 |  H3 | ~o2                      
*                =====@------+!-----@-----@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~o2 |  H   |!                                      
*                =====@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4460(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F4460=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4461()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4461(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4461=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4462()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4462(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4462=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4463()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4463(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4463=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4464()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4464(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4464=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4465()
*              ~o2          H    !  H          ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  H3   !  H3 |  H3 | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4465(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F4465=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4466()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  H3 |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4466(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4466=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4467()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          H   |!  H  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4467(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4467=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4468()
*                 ~o2          H    !  H    ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  H3 |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4468(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4468=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4469()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          H   |!  H  | ~o2                      
*                =====\     /------+!-----@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4469(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F4469=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F446()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H  |  s    !  s  |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC446(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F446=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4470()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4470(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4470=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4471()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4471(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4471=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4472()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4472(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4472=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4473()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4473(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4473=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4474()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4474(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4474=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4475()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4475(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4475=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(7)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4476()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4476(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(4*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4476=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4477()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4477(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4477=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4478()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H   |!  H  | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4478(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4478=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4479()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  H    !  H  | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U215/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(215).EQ.0) CALL CC4479(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))-C(1)-C(2)*P1
      F4479=RNUM*(TOTNUM/TOTDEN)*Q2(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F447()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o1 |  H  |  s    !  s  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC447(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F447=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4480()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4480(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4480=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4481()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4481(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4481=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4482()
*                 ~o2    H3   !  H3         ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  h  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4482(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F4482=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4483()
*                 ~o2    H3   !  H3         ~o2                      
*                =====@-------!-----\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o2 |  H3   !  H3 |  H  | ~o2                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4483(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F4483=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4484()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4484(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4484=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4485()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4485(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4485=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4486()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4486(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4486=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4487()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4487(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4487=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4488()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4488(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4488=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4489()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4489(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4489=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(10)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F448()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o1          S   |!  S  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC448(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F448=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4490()
*              ~o2          H3   !  H3         ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H3   !  H3 |  h  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4490(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F4490=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4491()
*              ~o2          H3   !  H3         ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H3   !  H3 |  H  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4491(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F4491=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4492()
*                 ~o2          H3   !  H3   ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o2 |  h  |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4492(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F4492=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4493()
*                 ~o2          H3   !  H3   ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  h  |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4493(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4493=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4494()
*                 ~o2          H3   !  H3   ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  h  |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4494(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4494=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(10)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4495()
*              ~o2          H3   !  H3         ~o2                   
*             =====\     /-------!-----\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  H3   !  H3 |  H  | ~o2                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4495(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+P1-C(1)
      F4495=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4496()
*                 ~o2          H3   !  H3   ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o2 |  H  |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4496(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F4496=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4497()
*                 ~o2          H3   !  H3   ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o2 |  H  |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4497(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4497=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4498()
*                 ~o2          H3   !  H3   ~o2                      
*                =====\     /-------!-----@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~o2 |  H  |  H3   !  H3 | ~o2                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4498(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4498=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4499()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4499(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4499=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F449()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o1 |  H  |  s    !  s  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC449(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F449=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F44()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-2-----!---2-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  h    !  h  |  H3 | ~o1                   
*             =====@-1---@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC44(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(P1*(C(3)+8*P1)+C(2))+C(1)
      F44=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4500()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4500(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4500=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4501()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4501(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4501=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4502()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4502(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4502=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4503()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4503(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4503=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4504()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4504(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4504=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4505()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4505(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4505=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4506()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4506(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4506=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4507()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4507(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4507=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4508()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4508(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4508=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4509()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o2 |  H3   !  H3 | ~o2                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4509(C)
      TOTNUM=-C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)+C(3))+C(1)-C(2)*P1
      F4509=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F450()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o1          S   |!  S  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC450(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F450=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4510()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U216/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(216).EQ.0) CALL CC4510(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P2*(2*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4510=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4511()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~o2 |  H+   !  H+ | ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4511(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4511=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4512()
*                                !  H+   ~o2                         
*                               /!-->--@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~1+|-P6                          
*                    ~o2    H-  |!  H- | ~o2                         
*                   =====@--<---+!--<--@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~o2 |  H+  |!                                   
*                   =====@-->---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4512(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4512=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4513()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~o2 |  H+   !  H+ | ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4513(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4513=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4514()
*                                !  H+   ~o2                         
*                               /!-->--@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~2+|-P6                          
*                    ~o2    H-  |!  H- | ~o2                         
*                   =====@--<---+!--<--@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~o2 |  H+  |!                                   
*                   =====@-->---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4514(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4514=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4515()
*                 ~o2    H-   !  H-         ~o2                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  Z  | ~o2                      
*                =====@-->----!-->--@---1-@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4515(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4515=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4516()
*                 ~o2    H-   !  H-         ~o2                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  h  | ~o2                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4516(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4516=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4517()
*                 ~o2    H-   !  H-         ~o2                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  H  | ~o2                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4517(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4517=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4518()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~o2 |  H-   !  H- | ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4518(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4518=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4519()
*                                !  H-   ~o2                         
*                               /!--<--@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~2+|-P6                          
*                    ~o2    H+  |!  H+ | ~o2                         
*                   =====@-->---+!-->--@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~o2 |  H-  |!                                   
*                   =====@--<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4519(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4519=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F451()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H3 |  s    !  s  |  H3 | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC451(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F451=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4520()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~o2 |  H-   !  H- | ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4520(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4520=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4521()
*                             !  H-         ~o2                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  Z  | ~o2                      
*                =====@-->---+!-->--@---1-@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4521(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4521=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4522()
*                             !  H-         ~o2                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  h  | ~o2                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4522(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4522=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4523()
*                             !  H-         ~o2                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  H  | ~o2                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4523(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4523=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4524()
*                    ~o2    H-   !  H-   ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~o2 |  H+   !  H+ | ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4524(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))-C(1)-C(2)*P1
      F4524=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4525()
*                                !  H+   ~o2                         
*                               /!-->--@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~2+|-P6                          
*                    ~o2    H-  |!  H- | ~o2                         
*                   =====@--<---+!--<--@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~o2 |  H+  |!                                   
*                   =====@-->---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4525(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F4525=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4526()
*                 ~o2    H-   !  H-         ~o2                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  Z  | ~o2                      
*                =====@-->----!-->--@---1-@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4526(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4526=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4527()
*                 ~o2    H-   !  H-         ~o2                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  h  | ~o2                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4527(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4527=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4528()
*                 ~o2    H-   !  H-         ~o2                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  H  | ~o2                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4528(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F4528=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4529()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~o2 |  H-   !  H- | ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4529(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4529=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F452()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o1 |  H3 |  s    !  s  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC452(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F452=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4530()
*                             !  H-         ~o2                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  Z  | ~o2                      
*                =====@-->---+!-->--@---1-@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4530(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4530=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4531()
*                             !  H-         ~o2                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  h  | ~o2                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4531(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4531=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4532()
*                             !  H-         ~o2                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  H  | ~o2                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4532(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F4532=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4533()
*              ~o2          H-   !  H-         ~o2                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  H+   !  H+ |  Z  | ~o2                   
*             =====@-1---@-->----!-->--@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4533(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4533=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4534()
*              ~o2          H-   !  H-         ~o2                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H+   !  H+ |  h  | ~o2                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4534(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F4534=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4535()
*              ~o2          H-   !  H-         ~o2                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H+   !  H+ |  H  | ~o2                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4535(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F4535=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4536()
*              ~o2          H-   !  H-         ~o2                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  H+   !  H+ |  H  | ~o2                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U217/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(217).EQ.0) CALL CC4536(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F4536=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4537()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  A    !  A  | ~1+                         
*                   ==>==@-2-----!---2-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U218/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(218).EQ.0) CALL CC4537(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)+C(2))+P2*(-C
     >(4)-C(7)*P2)+C(1)
      F4537=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4538()
*                             !  A          ~o2                      
*                            /!---2-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    W+  |!  W+ |  W+ | ~1+                      
*                =====@-1>---+!-->1-@-->3-@==>==                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~1+ |  A   |!                                      
*                ==>==@-2----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U218/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(218).EQ.0) CALL CC4538(C)
      TOTNUM=+C(12)
      TOTDEN=+C(11)
      RNUM=+P1*(P1*(C(3)-C(4)*P1+C(7)*P2)+P2*(-C(6)-C(9)*P2)+C(2))+P2*(P
     >2*(C(8)+C(10)*P2)+C(5))-C(1)
      F4538=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4539()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-3-----!---3-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  W+   !  W+ |  W+ | ~1+                   
*             ==>==@-1>--@-2>----!-->2-@-->4-@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U218/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(218).EQ.0) CALL CC4539(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(C(4)*P1-C(3)-C(7)*P2)+P2*(C(6)+C(9)*P2)-C(2))+P2*(-C
     >(5)-C(8)*P2)+C(1)
      F4539=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F453()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o1          S   |!  S  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC453(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F453=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4540()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  A    !  A  | ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U219/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(219).EQ.0) CALL CC4540(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F4540=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4541()
*                             !  A          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  H+ | ~1+                      
*                =====@-->---+!-->--@-->--@==>==                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~1+ |  A   |!                                      
*                ==>==@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U219/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(219).EQ.0) CALL CC4541(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F4541=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4542()
*              ~o2          A    !  A          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  H+ |  H+   !  H+ |  H+ | ~1+                   
*             ==>==@-->--@-->----!-->--@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U219/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(219).EQ.0) CALL CC4542(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+C(3)*P1)-C(1)
      F4542=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4543()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-2-----!---2-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4543(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P2*(P1*(P1*(C(7)-C(12)*P1+C(11)*P2)+P2*(-C(9)-C(11)*P2)-C(6)
     >)+P2*(P2*(C(10)+C(12)*P2)+C(8))+C(5))+P1*(P1*(C(3)-C(4)*P1)-C(2))-
     >C(1)
      F4543=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4544()
*                             !  Z          ~o2                      
*                            /!---2-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    W+  |!  W+ |  W+ | ~1+                      
*                =====@-1>---+!-->1-@-->3-@==>==                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~1+ |  Z   |!                                      
*                ==>==@-2----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4544(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P1*(P2*(P1*(C(12)*P1-C(7)-C(10)*P2)+P2*(C(9)+C(12)*P2)+C(6))
     >+P1*(C(4)*P1-C(3))+C(2))+P2*(P2*(-C(8)-C(11)*P2)-C(5))+C(1)
      F4544=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4545()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-2-----!---2-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4545(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P2*(P1*(P1*(C(7)-C(12)*P1+C(11)*P2)+P2*(-C(9)-C(11)*P2)-C(6)
     >)+P2*(P2*(C(10)+C(12)*P2)+C(8))+C(5))+P1*(P1*(C(3)-C(4)*P1)-C(2))-
     >C(1)
      F4545=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4546()
*                                !  Z    ~o2                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4546(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F4546=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4547()
*                                !  Z    ~o2                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4547(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F4547=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4548()
*                                !  Z    ~o2                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4548(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F4548=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4549()
*                                !  Z    ~o2                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4549(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F4549=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F454()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o1 |  H3 |  s    !  s  | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC454(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F454=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4550()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-3-----!---3-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  W+   !  W+ |  W+ | ~1+                   
*             ==>==@-1>--@-2>----!-->2-@-->4-@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4550(C)
      TOTNUM=+C(12)
      TOTDEN=+C(11)
      RNUM=+P1*(P1*(P2*(C(10)*(P2-P1)+C(7))+C(3)-C(4)*P1)+P2*(-C(6)-C(9)
     >*P2)-C(2))+P2*(C(5)+C(8)*P2)-C(1)
      F4550=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4551()
*                                   !  W+   ~o2                      
*                                  /!-->2-@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~2+|-P6                       
*                 ~o2          Z   |!  Z  | ~1+                      
*                =====\     /-3----+!---3-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  W+  |!                                
*                ==>==@-1>--@-2>---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4551(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P1*(P2*(P1*(C(12)*P1-C(7)-C(10)*P2)+P2*(C(9)+C(12)*P2)+C(6))
     >+P1*(C(4)*P1-C(3))+C(2))+P2*(P2*(-C(8)-C(11)*P2)-C(5))+C(1)
      F4551=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4552()
*                 ~o2          Z    !  Z    ~o2                      
*                =====\     /-3-----!---3-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o1|-P6                       
*                 ~1+ |  W+ |  W+   !  W+ | ~1+                      
*                ==>==@-1>--@-2>----!-->2-@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4552(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P1*(P2*(C(10)*(P2-P1)+C(8))+C(5)-C(6)*P1)+P2*(-C(7)-C(9)
     >*P2)+C(4))+P1*(C(3)*P1-C(2))+C(1)
      F4552=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4553()
*                 ~o2          Z    !  Z    ~o2                      
*                =====\     /-3-----!---3-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~1+ |  W+ |  W+   !  W+ | ~1+                      
*                ==>==@-1>--@-2>----!-->2-@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4553(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P1*(P2*(C(10)*(P2-P1)+C(8))+C(5)-C(6)*P1)+P2*(-C(7)-C(9)
     >*P2)+C(4))+P1*(C(3)*P1-C(2))+C(1)
      F4553=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4554()
*                 ~o2          Z    !  Z    ~o2                      
*                =====\     /-3-----!---3-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~1+ |  W+ |  W+   !  W+ | ~1+                      
*                ==>==@-1>--@-2>----!-->2-@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4554(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P1*(P2*(C(10)*(P2-P1)+C(8))+C(5)-C(6)*P1)+P2*(-C(7)-C(9)
     >*P2)+C(4))+P1*(C(3)*P1-C(2))+C(1)
      F4554=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4555()
*                 ~o2          Z    !  Z    ~o2                      
*                =====\     /-3-----!---3-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~1+ |  W+ |  W+   !  W+ | ~1+                      
*                ==>==@-1>--@-2>----!-->2-@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4555(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P1*(P2*(C(10)*(P2-P1)+C(8))+C(5)-C(6)*P1)+P2*(-C(7)-C(9)
     >*P2)+C(4))+P1*(C(3)*P1-C(2))+C(1)
      F4555=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4556()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-2-----!---2-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4556(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P2*(P1*(P1*(C(7)-C(12)*P1+C(11)*P2)+P2*(-C(9)-C(11)*P2)-C(6)
     >)+P2*(P2*(C(10)+C(12)*P2)+C(8))+C(5))+P1*(P1*(C(3)-C(4)*P1)-C(2))-
     >C(1)
      F4556=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4557()
*                                !  Z    ~o2                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4557(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F4557=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4558()
*                                !  Z    ~o2                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4558(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F4558=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4559()
*                                !  Z    ~o2                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4559(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F4559=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F455()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o1          S   |!  S  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC455(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F455=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4560()
*                                !  Z    ~o2                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4560(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F4560=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4561()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4561(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))-C(5)-C(6)*P1)+C(4)*P1-C(3))+C
     >(2)*P1-C(1)
      F4561=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4562()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4562(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))-C(5)-C(6)*P1)+C(4)*P1-C(3))+C
     >(2)*P1-C(1)
      F4562=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4563()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4563(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F4563=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4564()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4564(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F4564=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4565()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4565(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))-C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(2)*P1-C(1)
      F4565=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4566()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4566(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F4566=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4567()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4567(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F4567=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4568()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4568(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F4568=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4569()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4569(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F4569=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F456()
*                    ~o1    S    !  S    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~o1 |  s    !  s  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC456(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F456=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4570()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U220/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(220).EQ.0) CALL CC4570(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F4570=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4571()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(221).EQ.0) CALL CC4571(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4571=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4572()
*                             !  Z          ~o2                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o2    H+  |!  H+ |  H+ | ~1+                      
*                =====@-->---+!-->--@-->--@==>==                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~1+ |  Z   |!                                      
*                ==>==@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4572(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(1)-C(4)*P2
      F4572=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4573()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(221).EQ.0) CALL CC4573(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4573=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4574()
*                                !  Z    ~o2                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4574(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F4574=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4575()
*                                !  Z    ~o2                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4575(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F4575=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4576()
*                                !  Z    ~o2                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4576(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F4576=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4577()
*                                !  Z    ~o2                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4577(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F4577=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4578()
*              ~o2          Z    !  Z          ~o2                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  H+ |  H+   !  H+ |  H+ | ~1+                   
*             ==>==@-->--@-->----!-->--@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4578(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(C(3)+C(4)*P1)+C(2))-C(1)
      F4578=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4579()
*                                   !  H+   ~o2                      
*                                  /!-->--@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~2+|-P6                       
*                 ~o2          Z   |!  Z  | ~1+                      
*                =====\     /-1----+!---1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H+  |!                                
*                ==>==@-->--@-->---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4579(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(1)-C(4)*P2
      F4579=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F457()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    S   |!  S  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                    ~o1 |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC457(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F457=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4580()
*                 ~o2          Z    !  Z    ~o2                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o1|-P6                       
*                 ~1+ |  H+ |  H+   !  H+ | ~1+                      
*                ==>==@-->--@-->----!-->--@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4580(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F4580=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4581()
*                 ~o2          Z    !  Z    ~o2                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~1+ |  H+ |  H+   !  H+ | ~1+                      
*                ==>==@-->--@-->----!-->--@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4581(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F4581=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4582()
*                 ~o2          Z    !  Z    ~o2                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~1+ |  H+ |  H+   !  H+ | ~1+                      
*                ==>==@-->--@-->----!-->--@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4582(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F4582=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4583()
*                 ~o2          Z    !  Z    ~o2                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~1+ |  H+ |  H+   !  H+ | ~1+                      
*                ==>==@-->--@-->----!-->--@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4583(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F4583=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4584()
*                    ~o2    H+   !  H+   ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(221).EQ.0) CALL CC4584(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4584=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4585()
*                                !  Z    ~o2                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4585(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F4585=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4586()
*                                !  Z    ~o2                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4586(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F4586=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4587()
*                                !  Z    ~o2                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4587(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F4587=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4588()
*                                !  Z    ~o2                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4588(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F4588=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4589()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4589(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(5)*P2-C(3))-C(1)-C(2)*P1
      F4589=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F458()
*                    ~o1    S    !  S    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~o1 |  s    !  s  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC458(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F458=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4590()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4590(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(5)*P2-C(3))-C(1)-C(2)*P1
      F4590=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4591()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4591(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F4591=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4592()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4592(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F4592=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4593()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4593(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*P1-C(4))+C(3))-C(1)-C(2)*P1
      F4593=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4594()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4594(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F4594=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4595()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4595(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F4595=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4596()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4596(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F4596=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4597()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4597(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F4597=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4598()
*                    ~o2    Z    !  Z    ~o2                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  H+   !  H+ | ~1+                         
*                   ==>==@-->----!-->--@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U221/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(221).EQ.0) CALL CC4598(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(4)+C(6)*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F4598=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4599()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  h    !  h  | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4599(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4599=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F459()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    S   |!  S  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                    ~o1 |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC459(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F459=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F45()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-2-----!---2-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o1 |  Z  |  h    !  h  | ~o1                      
*                =====@-1---@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC45(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))+C(1)
      F45=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4600()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~1+ |  h    !  h  |  W+ | ~1+                      
*                ==>==@-------!-----@-->2-@==>==                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4600(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+P2*(C(4)+C(7)*P2)-C(1)
      F4600=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4601()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~1+ |  h    !  h  |  H+ | ~1+                      
*                ==>==@-------!-----@-->--@==>==                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4601(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4601=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4602()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~1+ |  h    !  h  | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4602(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4602=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4603()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  h   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4603(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4603=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4604()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  h   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4604(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4604=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4605()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  h   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4605(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4605=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4606()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  h   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4606(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4606=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4607()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-2>----!-->2-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  h    !  h  |  W+ | ~1+                   
*             ==>==@-1>--@-------!-----@-->3-@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4607(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(4)*P1)-C(2)-C(6)*P2)+P2*(C(7)*P2-C(5))+C(1)
      F4607=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4608()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-2>----!-->2-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  h    !  h  |  H+ | ~1+                   
*             ==>==@-1>--@-------!-----@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4608(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(4)*P1-C(3))+C(2)+C(6)*P2)+C(5)*P2-C(1)
      F4608=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4609()
*                 ~o2          W+   !  W+   ~o2                      
*                =====\     /-2>----!-->2-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~2+|-P6                       
*                 ~1+ |  W+ |  h    !  h  | ~1+                      
*                ==>==@-1>--@-------!-----@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4609(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+P2*(C(4)+C(7)*P2)-C(1)
      F4609=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F460()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~o1 |  S    !  S  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC460(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F460=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4610()
*                                   !  h    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o1|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-2>---+!-->2-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  h   |!                                
*                ==>==@-1>--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4610(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))-C(2)-C(5)*P2)+P2*(C(4)+C(7)*P2)-C
     >(1)
      F4610=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4611()
*                                   !  h    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-2>---+!-->2-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  h   |!                                
*                ==>==@-1>--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4611(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))-C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))-C
     >(1)
      F4611=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4612()
*                                   !  h    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-2>---+!-->2-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  h   |!                                
*                ==>==@-1>--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4612(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))-C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))-C
     >(1)
      F4612=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4613()
*                                   !  h    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-2>---+!-->2-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  h   |!                                
*                ==>==@-1>--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4613(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))-C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))-C
     >(1)
      F4613=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4614()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  H+ |  h    !  h  |  H+ | ~1+                   
*             ==>==@-->--@-------!-----@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4614(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(C(4)*P1-C(3))+C(2))-C(1)
      F4614=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4615()
*                 ~o2          W+   !  W+   ~o2                      
*                =====\     /-1>----!-->1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~2+|-P6                       
*                 ~1+ |  H+ |  h    !  h  | ~1+                      
*                ==>==@-->--@-------!-----@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4615(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4615=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4616()
*                                   !  h    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o1|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  h   |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4616(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4616=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4617()
*                                   !  h    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  h   |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4617(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4617=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4618()
*                                   !  h    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  h   |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4618(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4618=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4619()
*                                   !  h    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  h   |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4619(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4619=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F461()
*                                !  S    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    s   |!  s  | ~o1                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~s1|P5    |!                                   
*                    ~o1 |  S   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC461(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F461=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4620()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~1+ |  h    !  h  | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4620(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4620=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4621()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  h   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4621(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4621=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4622()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  h   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4622(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4622=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4623()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  h   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4623(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4623=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4624()
*                                !  h    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  h   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(222).EQ.0) CALL CC4624(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4624=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4625()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4625(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4625=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4626()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4626(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4626=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4627()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4627(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4627=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4628()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4628(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4628=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4629()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4629(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4629=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F462()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~o1 |  S    !  S  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC462(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F462=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4630()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4630(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4630=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4631()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4631(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4631=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4632()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4632(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4632=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4633()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4633(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4633=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4634()
*                    ~o2    h    !  h    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U222/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(222).EQ.0) CALL CC4634(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4634=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4635()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  H    !  H  | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4635(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4635=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4636()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~1+ |  H    !  H  |  W+ | ~1+                      
*                ==>==@-------!-----@-->2-@==>==                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4636(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+P2*(C(4)+C(7)*P2)-C(1)
      F4636=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4637()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~1+ |  H    !  H  |  H+ | ~1+                      
*                ==>==@-------!-----@-->--@==>==                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4637(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4637=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4638()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~1+ |  H    !  H  | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4638(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4638=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4639()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  H   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4639(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4639=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F463()
*                    ~o1    S    !  S    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~o1 |  s    !  s  | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC463(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F463=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4640()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  H   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4640(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4640=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4641()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  H   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4641(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4641=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4642()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  H   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4642(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4642=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4643()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-2>----!-->2-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  H    !  H  |  W+ | ~1+                   
*             ==>==@-1>--@-------!-----@-->3-@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4643(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(4)*P1)-C(2)-C(6)*P2)+P2*(C(7)*P2-C(5))+C(1)
      F4643=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4644()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-2>----!-->2-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  H    !  H  |  H+ | ~1+                   
*             ==>==@-1>--@-------!-----@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4644(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(4)*P1-C(3))+C(2)+C(6)*P2)+C(5)*P2-C(1)
      F4644=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4645()
*                 ~o2          W+   !  W+   ~o2                      
*                =====\     /-2>----!-->2-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~2+|-P6                       
*                 ~1+ |  W+ |  H    !  H  | ~1+                      
*                ==>==@-1>--@-------!-----@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4645(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+P2*(C(4)+C(7)*P2)-C(1)
      F4645=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4646()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o1|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-2>---+!-->2-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  H   |!                                
*                ==>==@-1>--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4646(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))-C(2)-C(5)*P2)+P2*(C(4)+C(7)*P2)-C
     >(1)
      F4646=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4647()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-2>---+!-->2-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  H   |!                                
*                ==>==@-1>--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4647(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))-C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))-C
     >(1)
      F4647=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4648()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-2>---+!-->2-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  H   |!                                
*                ==>==@-1>--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4648(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))-C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))-C
     >(1)
      F4648=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4649()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-2>---+!-->2-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  H   |!                                
*                ==>==@-1>--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4649(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))-C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))-C
     >(1)
      F4649=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F464()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    S   |!  S  | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s2|P5    |!                                   
*                    ~o1 |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC464(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F464=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4650()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  H+ |  H    !  H  |  H+ | ~1+                   
*             ==>==@-->--@-------!-----@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4650(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(C(4)*P1-C(3))+C(2))-C(1)
      F4650=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4651()
*                 ~o2          W+   !  W+   ~o2                      
*                =====\     /-1>----!-->1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~2+|-P6                       
*                 ~1+ |  H+ |  H    !  H  | ~1+                      
*                ==>==@-->--@-------!-----@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4651(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4651=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4652()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o1|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H   |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4652(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4652=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4653()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H   |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4653(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4653=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4654()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H   |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4654(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4654=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4655()
*                                   !  H    ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H   |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4655(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4655=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4656()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~1+ |  H    !  H  | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4656(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4656=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4657()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  H   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4657(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4657=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4658()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  H   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4658(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4658=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4659()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  H   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4659(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4659=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F465()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~o1 |  S    !  S  | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U17/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(17).EQ.0) CALL CC465(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F465=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4660()
*                                !  H    ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  H   |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(223).EQ.0) CALL CC4660(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)+C
     >(1)
      F4660=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4661()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4661(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4661=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4662()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4662(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4662=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4663()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4663(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4663=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4664()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4664(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4664=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4665()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4665(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4665=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4666()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4666(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4666=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4667()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4667(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4667=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4668()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4668(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4668=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4669()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4669(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4669=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F466()
*              ~o1          T    !  T          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  t    !  t  |  Z  | ~o1                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U18/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(18).EQ.0) CALL CC466(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F466=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4670()
*                    ~o2    H    !  H    ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U223/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(223).EQ.0) CALL CC4670(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)+C(1)
      F4670=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4671()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  H3   !  H3 | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4671(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4671=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4672()
*                 ~o2    W+   !  W+         ~o2                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~1+ |  H3   !  H3 |  H+ | ~1+                      
*                ==>==@-------!-----@-->--@==>==                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4672(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4672=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4673()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~1+ |  H3   !  H3 | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4673(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4673=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4674()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  H3  |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4674(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)-C
     >(1)
      F4674=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4675()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  H3  |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4675(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)-C
     >(1)
      F4675=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4676()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  H3  |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4676(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)-C
     >(1)
      F4676=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4677()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  H3  |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4677(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)-C
     >(1)
      F4677=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4678()
*              ~o2          W+   !  W+         ~o2                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  H+ |  H3   !  H3 |  H+ | ~1+                   
*             ==>==@-->--@-------!-----@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4678(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(C(4)*P1-C(3))+C(2))-C(1)
      F4678=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4679()
*                 ~o2          W+   !  W+   ~o2                      
*                =====\     /-1>----!-->1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~2+|-P6                       
*                 ~1+ |  H+ |  H3   !  H3 | ~1+                      
*                ==>==@-->--@-------!-----@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4679(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4679=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F467()
*              ~o1          T    !  T          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  t    !  t  |  H3 | ~o1                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U18/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(18).EQ.0) CALL CC467(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F467=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4680()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o1|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H3  |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4680(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4680=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4681()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H3  |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4681(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F4681=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4682()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H3  |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4682(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(4)*P2-C(1)
      F4682=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4683()
*                                   !  H3   ~o2                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o2          W+  |!  W+ | ~1+                      
*                =====\     /-1>---+!-->1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H3  |!                                
*                ==>==@-->--@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4683(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+C(4)*P2-C(1)
      F4683=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4684()
*                    ~o2    W+   !  W+   ~o2                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~1+ |  H3   !  H3 | ~1+                         
*                   ==>==@-------!-----@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4684(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)-C(5)*P2)-C(1)-C(2)*P1
      F4684=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4685()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  H3  |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4685(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)-C
     >(1)
      F4685=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4686()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  H3  |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4686(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)-C
     >(1)
      F4686=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4687()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  H3  |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4687(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)-C
     >(1)
      F4687=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4688()
*                                !  H3   ~o2                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o2    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  H3  |!                                   
*                   ==>==@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(224).EQ.0) CALL CC4688(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)+C(5))+C(3)*P1-C(2))+P2*(C(4)-C(6)*P2)-C
     >(1)
      F4688=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4689()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4689(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4689=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F468()
*                 ~o1          T    !  T    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~t1|-P6                       
*                 ~o1 |  Z  |  t    !  t  | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U18/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(18).EQ.0) CALL CC468(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F468=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4690()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4690(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4690=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4691()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4691(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4691=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4692()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4692(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4692=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4693()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4693(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4693=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4694()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4694(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4694=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4695()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4695(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4695=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4696()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4696(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4696=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4697()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4697(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4697=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4698()
*                    ~o2    H3   !  H3   ~o2                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-1>----!-->1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U224/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(224).EQ.0) CALL CC4698(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(5)+C(8)*P2)-C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F4698=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4699()
*              ~o2          n1   !  n1         ~o2                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  E1   !  E1 |  W+ | ~1+                   
*             ==>==@-1>--@==<====!==<==@-->2-@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U225/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(225).EQ.0) CALL CC4699(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F4699=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F469()
*                                   !  t    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~t1|-P6                       
*                 ~o1          T   |!  T  | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  t   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U18/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(18).EQ.0) CALL CC469(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F469=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F46()
*                                   !  h    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-2----+!---2-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  h   |!                                
*                =====@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC46(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)+C(3))+C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))+C
     >(1)
      F46=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4700()
*                                   !  E1   ~o2                      
*                                  /!==<==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~e1|-P6                       
*                 ~o2          n1  |!  n1 | ~1+                      
*                =====\     /==>===+!==>==@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  E1  |!                                
*                ==>==@-1>--@==<===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U225/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(225).EQ.0) CALL CC4700(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))+C(1)
      F4700=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4701()
*                 ~o2          n1   !  n1   ~o2                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~n1|-P6                       
*                 ~1+ |  W+ |  E1   !  E1 | ~1+                      
*                ==>==@-1>--@==<====!==<==@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U225/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(225).EQ.0) CALL CC4701(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*P2-C(3))+C(1)+C(2)*P1
      F4701=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F4702()
*                    ~o2    E1   !  E1   ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~1+ |  n1   !  n1 | ~1+                         
*                   ==>==@=