*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3000()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~c1 |  d    !  d  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U144/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(144).EQ.0) CALL CC3000(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3000=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3001()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U144/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(144).EQ.0) CALL CC3001(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3001=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3002()
*                             !  d          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  c  | ~c1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~c1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U144/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(144).EQ.0) CALL CC3002(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3002=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3003()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U144/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(144).EQ.0) CALL CC3003(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F3003=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3004()
*                 ~o1    d    !  d          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~c1 |  H+   !  H+ |  c  | ~c1                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U144/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(144).EQ.0) CALL CC3004(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3004=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3005()
*              ~o1          d    !  d          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~c1 |  c  |  H+   !  H+ |  c  | ~c1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U144/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(144).EQ.0) CALL CC3005(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3005=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3006()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3006(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3006=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3007()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3007(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3007=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3008()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3008(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3008=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3009()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3009(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3009=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F300()
*                    ~o1    E1   !  E1   ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e1|P5     !  ~e4|-P6                          
*                    ~o1 |  e1   !  e1 | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U11/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(11).EQ.0) CALL CC300(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F300=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3010()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    h   |!  h  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3010(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3010=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3011()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3011(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3011=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3012()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    h   |!  h  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3012(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3012=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3013()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3013(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3013=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3014()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3014(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3014=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3015()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3015(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3015=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3016()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    h   |!  h  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3016(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3016=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3017()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3017(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3017=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3018()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    h   |!  h  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3018(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3018=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3019()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3019(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3019=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F301()
*                                !  e1   ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e4|-P6                          
*                    ~o1    E1  |!  E1 | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e1|P5    |!                                   
*                    ~o1 |  e1  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U11/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(11).EQ.0) CALL CC301(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F301=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3020()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3020(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3020=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3021()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    h   |!  h  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3021(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3021=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3022()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3022(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3022=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3023()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    h   |!  h  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3023(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3023=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3024()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3024(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3024=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3025()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    h   |!  h  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3025(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3025=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3026()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3026(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3026=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3027()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    h   |!  h  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3027(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3027=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3028()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~c1 |  h    !  h  | ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3028(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3028=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3029()
*                 ~o1    c    !  c          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~c1 |  h    !  h  |  c  | ~c1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3029(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3029=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F302()
*                    ~o1    e1   !  e1   ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~o1 |  E1   !  E1 | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U11/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(11).EQ.0) CALL CC302(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F302=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3030()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~c1 |  h    !  h  | ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3030(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3030=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3031()
*              ~o1          c    !  c          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~c1 |  c  |  h    !  h  |  c  | ~c1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3031(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3031=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3032()
*                 ~o1          c    !  c    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~c1 |  c  |  h    !  h  | ~c1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3032(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3032=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3033()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~c1 |  h    !  h  | ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U145/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(145).EQ.0) CALL CC3033(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3033=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3034()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3034(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3034=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3035()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3035(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3035=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3036()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3036(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3036=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3037()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3037(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3037=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3038()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    H   |!  H  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3038(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3038=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3039()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3039(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3039=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F303()
*                                !  E1   ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e4|-P6                          
*                    ~o1    e1  |!  e1 | ~o1                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e1|P5    |!                                   
*                    ~o1 |  E1  |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U11/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(11).EQ.0) CALL CC303(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F303=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3040()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H   |!  H  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3040(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3040=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3041()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3041(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3041=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3042()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3042(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3042=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3043()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3043(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3043=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3044()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    H   |!  H  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3044(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3044=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3045()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3045(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3045=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3046()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H   |!  H  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3046(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3046=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3047()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3047(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3047=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3048()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3048(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3048=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3049()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    H   |!  H  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3049(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3049=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F304()
*                    ~o1    e1   !  e1   ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e4|-P6                          
*                    ~o1 |  E1   !  E1 | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U11/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(11).EQ.0) CALL CC304(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F304=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3050()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3050(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3050=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3051()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H   |!  H  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3051(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3051=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3052()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3052(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3052=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3053()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    H   |!  H  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3053(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3053=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3054()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3054(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3054=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3055()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H   |!  H  | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3055(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3055=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3056()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~c1 |  H    !  H  | ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3056(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3056=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3057()
*                 ~o1    c    !  c          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~c1 |  H    !  H  |  c  | ~c1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3057(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3057=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3058()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~c1 |  H    !  H  | ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3058(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3058=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3059()
*              ~o1          c    !  c          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~c1 |  c  |  H    !  H  |  c  | ~c1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3059(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3059=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F305()
*                    ~o1    E1   !  E1   ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e4|P5     !  ~e4|-P6                          
*                    ~o1 |  e1   !  e1 | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U11/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(11).EQ.0) CALL CC305(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F305=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3060()
*                 ~o1          c    !  c    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~c1 |  c  |  H    !  H  | ~c1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3060(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3060=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3061()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~c1 |  H    !  H  | ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U146/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(146).EQ.0) CALL CC3061(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3061=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3062()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3062(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3062=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3063()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3063(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3063=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3064()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3064(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3064=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3065()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3065(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3065=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3066()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3066(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3066=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3067()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H3  |!  H3 | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3067(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3067=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3068()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3068(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3068=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3069()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3069(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3069=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F306()
*                                !  e1   ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e4|-P6                          
*                    ~o1    E1  |!  E1 | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e4|P5    |!                                   
*                    ~o1 |  e1  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U11/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(11).EQ.0) CALL CC306(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F306=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3070()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3070(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3070=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3071()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3071(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3071=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3072()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H3  |!  H3 | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3072(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3072=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3073()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3073(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3073=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3074()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3074(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3074=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3075()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3075(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3075=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3076()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H3  |!  H3 | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3076(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3076=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3077()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3077(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3077=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3078()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  c  | ~c1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~c1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3078(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3078=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3079()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H3  |!  H3 | ~c1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3079(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3079=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F307()
*                    ~o1    e1   !  e1   ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e4|P5     !  ~e4|-P6                          
*                    ~o1 |  E1   !  E1 | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U11/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(11).EQ.0) CALL CC307(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+C(1)*S1
      F307=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3080()
*              ~o1          c    !  c          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~c1 |  c  |  H3   !  H3 |  c  | ~c1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3080(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3080=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3081()
*                 ~o1          c    !  c    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~c1 |  c  |  H3   !  H3 | ~c1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3081(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3081=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3082()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~c1 |  H3   !  H3 | ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U147/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(147).EQ.0) CALL CC3082(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3082=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3083()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~c1 |  s    !  s  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3083(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3083=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3084()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~c1 |  s    !  s  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3084(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3084=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3085()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  c  | ~c1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~c1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3085(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3085=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3086()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~c1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3086(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3086=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3087()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~c1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3087(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3087=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3088()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~c1 |  s    !  s  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3088(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3088=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3089()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  c  | ~c1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~c1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3089(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3089=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F308()
*              ~o1          E2   !  E2         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  e2   !  e2 |  Z  | ~o1                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC308(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F308=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3090()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3090(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3090=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3091()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3091(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3091=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3092()
*              ~o1          s    !  s          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~c1 |  c  |  H+   !  H+ |  c  | ~c1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3092(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3092=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3093()
*                 ~o1          s    !  s    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~c1 |  c  |  H+   !  H+ | ~c1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3093(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3093=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3094()
*                 ~o1          s    !  s    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~c1 |  c  |  H+   !  H+ | ~c1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3094(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3094=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3095()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3095(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3095=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3096()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3096(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3096=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3097()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U148/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(148).EQ.0) CALL CC3097(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3097=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3098()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3098(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3098=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3099()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3099(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3099=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F309()
*              ~o1          E2   !  E2         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  e2   !  e2 |  H3 | ~o1                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC309(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F309=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F30()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~o1 |  Z    !  Z  | ~o1                         
*                   =====@-2-----!---2-@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1).EQ.0) CALL CC30(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P2*(P2*(P2*(8*(P2-P1)-C(7))-C(5)-C(6)*P1)-C(3)-C(4)*P1)+C(1)
     >-C(2)*P1
      F30=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
     >*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3100()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  c  | ~c1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~c1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3100(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3100=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3101()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~c1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3101(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3101=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3102()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~c1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3102(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3102=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3103()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3103(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3103=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3104()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  c  | ~c1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~c1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3104(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3104=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3105()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3105(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3105=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3106()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H+  |!  H+ | ~c1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~c1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3106(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3106=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3107()
*              ~o1          b    !  b          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~c1 |  c  |  H+   !  H+ |  c  | ~c1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3107(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3107=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3108()
*                 ~o1          b    !  b    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~c1 |  c  |  H+   !  H+ | ~c1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3108(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3108=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3109()
*                 ~o1          b    !  b    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~c1 |  c  |  H+   !  H+ | ~c1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3109(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3109=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F310()
*                 ~o1          E2   !  E2   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e2|-P6                       
*                 ~o1 |  Z  |  e2   !  e2 | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC310(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F310=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3110()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3110(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3110=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3111()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3111(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3111=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3112()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~c1 |  H+   !  H+ | ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U149/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(149).EQ.0) CALL CC3112(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3112=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3113()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  A    !  A  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U150/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(150).EQ.0) CALL CC3113(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F3113=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3114()
*                             !  A          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    s   |!  s  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U150/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(150).EQ.0) CALL CC3114(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F3114=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3115()
*              ~o1          A    !  A          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  s    !  s  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U150/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(150).EQ.0) CALL CC3115(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F3115=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3116()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3116(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F3116=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3117()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3117(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3117=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3118()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3118(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3118=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3119()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3119(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3119=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F311()
*                                   !  e2   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e2|-P6                       
*                 ~o1          E2  |!  E2 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  e2  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC311(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F311=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3120()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    Z   |!  Z  | ~s1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(151).EQ.0) CALL CC3120(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3120=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3121()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3121(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3121=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3122()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3122(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3122=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3123()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3123(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3123=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3124()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3124(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3124=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3125()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    Z   |!  Z  | ~s1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(151).EQ.0) CALL CC3125(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3125=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3126()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3126(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3126=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3127()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3127(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3127=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3128()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3128(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3128=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3129()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    Z   |!  Z  | ~s1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(151).EQ.0) CALL CC3129(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3129=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F312()
*                 ~o1          E2   !  E2   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~o1 |  Z  |  e2   !  e2 | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC312(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F312=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3130()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3130(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3130=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3131()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3131(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3131=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3132()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    Z   |!  Z  | ~s1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(151).EQ.0) CALL CC3132(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3132=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3133()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~s1 |  s    !  s  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3133(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3133=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3134()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  Z    !  Z  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3134(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3134=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3135()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    s   |!  s  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(151).EQ.0) CALL CC3135(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F3135=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3136()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  s    !  s  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U151/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(151).EQ.0) CALL CC3136(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F3136=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3137()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(152).EQ.0) CALL CC3137(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3137=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3138()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(152).EQ.0) CALL CC3138(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3138=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3139()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(152).EQ.0) CALL CC3139(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3139=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F313()
*                                   !  e2   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e5|-P6                       
*                 ~o1          E2  |!  E2 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  e2  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC313(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F313=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3140()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  u    !  u  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(152).EQ.0) CALL CC3140(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3140=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3141()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(152).EQ.0) CALL CC3141(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3141=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3142()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(152).EQ.0) CALL CC3142(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3142=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3143()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  u    !  u  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(152).EQ.0) CALL CC3143(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3143=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3144()
*                    ~o1    u    !  u    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(152).EQ.0) CALL CC3144(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3144=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3145()
*                             !  W-         ~o1                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    u   |!  u  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~s1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(152).EQ.0) CALL CC3145(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3145=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3146()
*              ~o1          W-   !  W-         ~o1                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  u    !  u  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U152/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(152).EQ.0) CALL CC3146(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3146=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3147()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(153).EQ.0) CALL CC3147(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3147=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3148()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(153).EQ.0) CALL CC3148(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3148=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3149()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(153).EQ.0) CALL CC3149(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3149=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F314()
*              ~o1          E2   !  E2         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  e2   !  e2 |  h  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC314(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F314=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3150()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  c    !  c  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(153).EQ.0) CALL CC3150(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3150=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3151()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(153).EQ.0) CALL CC3151(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3151=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3152()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(153).EQ.0) CALL CC3152(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3152=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3153()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  c    !  c  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(153).EQ.0) CALL CC3153(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3153=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3154()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(153).EQ.0) CALL CC3154(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3154=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3155()
*                             !  W-         ~o1                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    c   |!  c  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~s1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(153).EQ.0) CALL CC3155(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3155=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3156()
*              ~o1          W-   !  W-         ~o1                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  c    !  c  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U153/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(153).EQ.0) CALL CC3156(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3156=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3157()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3157(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3157=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3158()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3158(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3158=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3159()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~s1 |  t    !  t  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3159(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3159=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F315()
*              ~o1          E2   !  E2         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  e2   !  e2 |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC315(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F315=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3160()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(154).EQ.0) CALL CC3160(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3160=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3161()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(154).EQ.0) CALL CC3161(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3161=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3162()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3162(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3162=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3163()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~s1 |  t    !  t  |  s  | ~s1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3163(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3163=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3164()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(154).EQ.0) CALL CC3164(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3164=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3165()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    W-  |!  W- | ~s1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(154).EQ.0) CALL CC3165(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3165=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3166()
*              ~o1          W-   !  W-         ~o1                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  t    !  t  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3166(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3166=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3167()
*                                   !  t    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t1|-P6                       
*                 ~o1          W-  |!  W- | ~s1                      
*                =====\     /-1<---+!--<1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~s1 |  s  |  t   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(154).EQ.0) CALL CC3167(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3167=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3168()
*                                   !  t    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~o1          W-  |!  W- | ~s1                      
*                =====\     /-1<---+!--<1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~s1 |  s  |  t   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(154).EQ.0) CALL CC3168(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3168=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3169()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3169(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3169=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F316()
*                 ~o1          E2   !  E2   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e2|-P6                       
*                 ~o1 |  h  |  e2   !  e2 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC316(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F316=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3170()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3170(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3170=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3171()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~s1 |  W-   !  W- | ~s1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U154/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(154).EQ.0) CALL CC3171(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3171=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3172()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  G    !  G  | ~s1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U155/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(155).EQ.0) CALL CC3172(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F3172=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3173()
*                             !  G          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    s   |!  s  |  s  | ~s1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~s1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U155/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(155).EQ.0) CALL CC3173(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F3173=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3174()
*              ~o1          G    !  G          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  s    !  s  |  s  | ~s1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U155/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(155).EQ.0) CALL CC3174(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F3174=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3175()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3175(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3175=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3176()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3176(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3176=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3177()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3177(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3177=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3178()
*                             !  u          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  u   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3178(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3178=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3179()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3179(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3179=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F317()
*                                   !  e2   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e2|-P6                       
*                 ~o1          E2  |!  E2 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC317(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F317=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3180()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3180(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3180=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3181()
*                             !  u          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  u   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3181(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3181=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3182()
*                    ~o1    u    !  u    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3182(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F3182=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3183()
*                 ~o1    u    !  u          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~u1|P5     !     |     |                          
*                 ~s1 |  H-   !  H- |  s  | ~s1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3183(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3183=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3184()
*              ~o1          u    !  u          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H-   !  H- |  s  | ~s1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U156/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(156).EQ.0) CALL CC3184(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3184=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3185()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3185(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3185=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3186()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3186(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3186=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3187()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3187(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3187=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3188()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3188(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3188=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3189()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3189(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3189=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F318()
*                 ~o1          E2   !  E2   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~o1 |  h  |  e2   !  e2 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC318(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F318=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3190()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3190(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3190=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3191()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3191(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3191=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3192()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3192(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3192=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3193()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3193(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3193=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3194()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3194(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3194=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3195()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3195(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3195=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3196()
*                 ~o1    c    !  c          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~s1 |  H-   !  H- |  s  | ~s1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3196(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3196=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3197()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3197(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3197=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3198()
*                 ~o1    c    !  c          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c2|P5     !     |     |                          
*                 ~s1 |  H-   !  H- |  s  | ~s1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3198(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3198=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3199()
*              ~o1          c    !  c          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H-   !  H- |  s  | ~s1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U157/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(157).EQ.0) CALL CC3199(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3199=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F319()
*                                   !  e2   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e5|-P6                       
*                 ~o1          E2  |!  E2 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC319(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F319=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F31()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o1 |  Z   |!                                   
*                   =====@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1).EQ.0) CALL CC31(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P2*(P1*(C(8)+8*P1-16*P2)+P2*(8*P2-C(9))+C(7))+P1*(-C(5)-
     >C(6)*P1)-C(4))+P1*(C(2)+C(3)*P1)+C(1)
      F31=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3200()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3200(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3200=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3201()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3201(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3201=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3202()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3202(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3202=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3203()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3203(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3203=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3204()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3204(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3204=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3205()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3205(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3205=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3206()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3206(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3206=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3207()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3207(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3207=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3208()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3208(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3208=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3209()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3209(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3209=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F320()
*              ~o1          E2   !  E2         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H  |  e2   !  e2 |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC320(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F320=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3210()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3210(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3210=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3211()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3211(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3211=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3212()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3212(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3212=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3213()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3213(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3213=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3214()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3214(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3214=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3215()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3215(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3215=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3216()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3216(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3216=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3217()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3217(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3217=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3218()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3218(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3218=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3219()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3219(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3219=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F321()
*                 ~o1          E2   !  E2   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e2|-P6                       
*                 ~o1 |  H  |  e2   !  e2 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC321(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F321=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3220()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3220(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3220=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3221()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    h   |!  h  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3221(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3221=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3222()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3222(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3222=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3223()
*                 ~o1    s    !  s          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~s1 |  h    !  h  |  s  | ~s1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3223(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3223=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3224()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3224(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3224=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3225()
*              ~o1          s    !  s          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  h    !  h  |  s  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3225(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3225=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3226()
*                 ~o1          s    !  s    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  s  |  h    !  h  | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3226(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3226=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3227()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  h    !  h  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U158/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(158).EQ.0) CALL CC3227(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3227=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3228()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3228(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3228=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3229()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3229(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3229=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F322()
*                                   !  e2   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e2|-P6                       
*                 ~o1          E2  |!  E2 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC322(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F322=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3230()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3230(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3230=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3231()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3231(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3231=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3232()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3232(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3232=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3233()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3233(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3233=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3234()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3234(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3234=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3235()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3235(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3235=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3236()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3236(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3236=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3237()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3237(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3237=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3238()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3238(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3238=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3239()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3239(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3239=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F323()
*                 ~o1          E2   !  E2   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~o1 |  H  |  e2   !  e2 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC323(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F323=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3240()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3240(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3240=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3241()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3241(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3241=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3242()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3242(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3242=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3243()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3243(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3243=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3244()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3244(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3244=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3245()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3245(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3245=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3246()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3246(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3246=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3247()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3247(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3247=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3248()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3248(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3248=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3249()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H   |!  H  | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3249(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3249=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F324()
*                                   !  e2   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e5|-P6                       
*                 ~o1          E2  |!  E2 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC324(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F324=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3250()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3250(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3250=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3251()
*                 ~o1    s    !  s          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~s1 |  H    !  H  |  s  | ~s1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3251(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3251=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3252()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3252(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3252=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3253()
*              ~o1          s    !  s          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H    !  H  |  s  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3253(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3253=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3254()
*                 ~o1          s    !  s    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  s  |  H    !  H  | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3254(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3254=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3255()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H    !  H  | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U159/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(159).EQ.0) CALL CC3255(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3255=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3256()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3256(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3256=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3257()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3257(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3257=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3258()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3258(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3258=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3259()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3259(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3259=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F325()
*              ~o1          E2   !  E2         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H3 |  e2   !  e2 |  H3 | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC325(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F325=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3260()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3260(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3260=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3261()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H3  |!  H3 | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3261(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3261=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3262()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3262(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3262=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3263()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3263(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3263=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3264()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3264(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3264=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3265()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3265(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3265=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3266()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H3  |!  H3 | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3266(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3266=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3267()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3267(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3267=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3268()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3268(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3268=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3269()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3269(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3269=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F326()
*                 ~o1          E2   !  E2   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e2|-P6                       
*                 ~o1 |  H3 |  e2   !  e2 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC326(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F326=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3270()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H3  |!  H3 | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3270(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3270=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3271()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3271(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3271=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3272()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  s  | ~s1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~s1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3272(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3272=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3273()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H3  |!  H3 | ~s1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~s1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3273(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3273=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3274()
*              ~o1          s    !  s          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H3   !  H3 |  s  | ~s1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3274(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3274=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3275()
*                 ~o1          s    !  s    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~s1 |  s  |  H3   !  H3 | ~s1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3275(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3275=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3276()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~s1 |  H3   !  H3 | ~s1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U160/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(160).EQ.0) CALL CC3276(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3276=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3277()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3277(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3277=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3278()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3278(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3278=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3279()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3279(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3279=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F327()
*                                   !  e2   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e2|-P6                       
*                 ~o1          E2  |!  E2 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC327(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F327=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3280()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3280(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3280=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3281()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3281(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3281=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3282()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3282(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3282=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3283()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  s  | ~s1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~s1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3283(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3283=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3284()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3284(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3284=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3285()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H-  |!  H- | ~s1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3285(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3285=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3286()
*              ~o1          t    !  t          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~s1 |  s  |  H-   !  H- |  s  | ~s1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3286(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3286=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3287()
*                 ~o1          t    !  t    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t1|-P6                       
*                 ~s1 |  s  |  H-   !  H- | ~s1                      
*                -->--@==>==@--<----!--<--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3287(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3287=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3288()
*                 ~o1          t    !  t    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~s1 |  s  |  H-   !  H- | ~s1                      
*                -->--@==>==@--<----!--<--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3288(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3288=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3289()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3289(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3289=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F328()
*                 ~o1          E2   !  E2   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e5|-P6                       
*                 ~o1 |  H3 |  e2   !  e2 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC328(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F328=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3290()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3290(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3290=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3291()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~s1 |  H-   !  H- | ~s1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U161/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(161).EQ.0) CALL CC3291(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3291=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3292()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  A    !  A  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U162/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(162).EQ.0) CALL CC3292(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F3292=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3293()
*                             !  A          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    t   |!  t  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~t1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U162/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(162).EQ.0) CALL CC3293(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F3293=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3294()
*              ~o1          A    !  A          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  t    !  t  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U162/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(162).EQ.0) CALL CC3294(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F3294=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3295()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3295(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F3295=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3296()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3296(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3296=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3297()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3297(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3297=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3298()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3298(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3298=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3299()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3299(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3299=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F329()
*                                   !  e2   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e5|-P6                       
*                 ~o1          E2  |!  E2 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  e2  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC329(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F329=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F32()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC32(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(4*P1-C(4))+C(3))-C(1)-C(2)*P1
      F32=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3300()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~t1 |  t    !  t  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3300(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3300=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3301()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3301(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3301=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3302()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3302(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3302=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3303()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3303(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3303=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3304()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3304(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3304=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3305()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3305(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3305=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3306()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~t1 |  t    !  t  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3306(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3306=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3307()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3307(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3307=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3308()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3308(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3308=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3309()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3309(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3309=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F330()
*                    ~o1    E2   !  E2   ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~o1 |  e2   !  e2 | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC330(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F330=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3310()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3310(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3310=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3311()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~t1 |  t    !  t  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3311(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3311=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3312()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3312(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3312=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3313()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3313(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3313=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3314()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3314(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3314=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3315()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~t1 |  t    !  t  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3315(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3315=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3316()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    Z   |!  Z  | ~t1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3316(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3316=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3317()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  Z    !  Z  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3317(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3317=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3318()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    t   |!  t  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~t1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3318(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F3318=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3319()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~t1 |  Z    !  Z  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3319(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3319=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F331()
*                                !  e2   ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e2|-P6                          
*                    ~o1    E2  |!  E2 | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e2|P5    |!                                   
*                    ~o1 |  e2  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC331(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F331=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3320()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  t    !  t  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3320(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F3320=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3321()
*                                   !  t    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~o1          Z   |!  Z  | ~t1                      
*                =====\     /-1----+!---1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~t1 |  t  |  t   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(163).EQ.0) CALL CC3321(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F3321=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3322()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~t1 |  Z    !  Z  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U163/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(163).EQ.0) CALL CC3322(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3322=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3323()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(164).EQ.0) CALL CC3323(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3323=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3324()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(164).EQ.0) CALL CC3324(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3324=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3325()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o1    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(164).EQ.0) CALL CC3325(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3325=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3326()
*                 ~o1    W+   !  W+         ~o1                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~t1 |  d    !  d  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(164).EQ.0) CALL CC3326(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3326=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3327()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(164).EQ.0) CALL CC3327(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3327=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3328()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o1    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(164).EQ.0) CALL CC3328(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3328=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3329()
*                 ~o1    W+   !  W+         ~o1                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~t1 |  d    !  d  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(164).EQ.0) CALL CC3329(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3329=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F332()
*                    ~o1    E2   !  E2   ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e2|P5     !  ~e5|-P6                          
*                    ~o1 |  e2   !  e2 | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC332(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F332=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3330()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(164).EQ.0) CALL CC3330(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3330=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3331()
*                             !  W+         ~o1                      
*                            /!-->1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    d   |!  d  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~t1 |  W+  |!                                      
*                -->--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(164).EQ.0) CALL CC3331(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3331=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3332()
*              ~o1          W+   !  W+         ~o1                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  d    !  d  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U164/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(164).EQ.0) CALL CC3332(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3332=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3333()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(165).EQ.0) CALL CC3333(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3333=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3334()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(165).EQ.0) CALL CC3334(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3334=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3335()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(165).EQ.0) CALL CC3335(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3335=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3336()
*                 ~o1    W+   !  W+         ~o1                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~t1 |  s    !  s  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(165).EQ.0) CALL CC3336(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3336=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3337()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(165).EQ.0) CALL CC3337(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3337=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3338()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(165).EQ.0) CALL CC3338(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3338=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3339()
*                 ~o1    W+   !  W+         ~o1                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~t1 |  s    !  s  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(165).EQ.0) CALL CC3339(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3339=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F333()
*                                !  e2   ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o1    E2  |!  E2 | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e2|P5    |!                                   
*                    ~o1 |  e2  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC333(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F333=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3340()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(165).EQ.0) CALL CC3340(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3340=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3341()
*                             !  W+         ~o1                      
*                            /!-->1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    s   |!  s  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~t1 |  W+  |!                                      
*                -->--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(165).EQ.0) CALL CC3341(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3341=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3342()
*              ~o1          W+   !  W+         ~o1                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  s    !  s  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U165/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(165).EQ.0) CALL CC3342(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3342=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3343()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3343(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3343=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3344()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3344(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3344=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3345()
*                 ~o1    W+   !  W+         ~o1                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~t1 |  b    !  b  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3345(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3345=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3346()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(166).EQ.0) CALL CC3346(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3346=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3347()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(166).EQ.0) CALL CC3347(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3347=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3348()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3348(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3348=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3349()
*                 ~o1    W+   !  W+         ~o1                      
*                =====@-1>----!-->1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~t1 |  b    !  b  |  t  | ~t1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3349(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3349=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F334()
*                    ~o1    e2   !  e2   ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e2|-P6                          
*                    ~o1 |  E2   !  E2 | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC334(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F334=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3350()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(166).EQ.0) CALL CC3350(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3350=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3351()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    W+  |!  W+ | ~t1                         
*                   =====@-1>---+!-->1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(166).EQ.0) CALL CC3351(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3351=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3352()
*              ~o1          W+   !  W+         ~o1                   
*             =====\     /-1>----!-->1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  b    !  b  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3352(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3352=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3353()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~o1          W+  |!  W+ | ~t1                      
*                =====\     /-1>---+!-->1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~t1 |  t  |  b   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(166).EQ.0) CALL CC3353(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3353=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3354()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o1          W+  |!  W+ | ~t1                      
*                =====\     /-1>---+!-->1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~t1 |  t  |  b   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(166).EQ.0) CALL CC3354(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3354=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3355()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3355(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3355=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3356()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3356(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3356=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3357()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  W+   !  W+ | ~t1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U166/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(166).EQ.0) CALL CC3357(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3357=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3358()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  G    !  G  | ~t1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U167/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(167).EQ.0) CALL CC3358(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F3358=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3359()
*                             !  G          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    t   |!  t  |  t  | ~t1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~t1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U167/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(167).EQ.0) CALL CC3359(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F3359=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F335()
*                                !  E2   ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o1    e2  |!  e2 | ~o1                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e2|P5    |!                                   
*                    ~o1 |  E2  |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC335(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F335=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3360()
*              ~o1          G    !  G          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  t    !  t  |  t  | ~t1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U167/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(167).EQ.0) CALL CC3360(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F3360=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3361()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3361(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3361=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3362()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3362(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3362=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3363()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3363(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3363=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3364()
*                             !  d          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~t1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3364(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3364=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3365()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3365(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3365=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3366()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  d   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3366(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3366=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3367()
*                             !  d          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~t1 |  d   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3367(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3367=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3368()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3368(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F3368=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3369()
*                 ~o1    d    !  d          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~t1 |  H+   !  H+ |  t  | ~t1                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3369(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3369=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F336()
*                    ~o1    e2   !  e2   ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e2|P5     !  ~e5|-P6                          
*                    ~o1 |  E2   !  E2 | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC336(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F336=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3370()
*              ~o1          d    !  d          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H+   !  H+ |  t  | ~t1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U168/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(168).EQ.0) CALL CC3370(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3370=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3371()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3371(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3371=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3372()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3372(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3372=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3373()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3373(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3373=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3374()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3374(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3374=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3375()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~t1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3375(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3375=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3376()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3376(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3376=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3377()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3377(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3377=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3378()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  s   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3378(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3378=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3379()
*                             !  s          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~t1 |  s   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3379(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3379=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F337()
*                    ~o1    E2   !  E2   ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e5|P5     !  ~e5|-P6                          
*                    ~o1 |  e2   !  e2 | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC337(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F337=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3380()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3380(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3380=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3381()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3381(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3381=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3382()
*                 ~o1    s    !  s          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~t1 |  H+   !  H+ |  t  | ~t1                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3382(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3382=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3383()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3383(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3383=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3384()
*                 ~o1    s    !  s          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s2|P5     !     |     |                          
*                 ~t1 |  H+   !  H+ |  t  | ~t1                      
*                -->--@-->----!-->--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3384(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3384=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3385()
*              ~o1          s    !  s          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H+   !  H+ |  t  | ~t1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U169/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(169).EQ.0) CALL CC3385(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3385=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3386()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3386(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3386=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3387()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3387(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3387=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3388()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3388(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3388=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3389()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3389(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3389=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F338()
*                                !  e2   ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e5|-P6                          
*                    ~o1    E2  |!  E2 | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e5|P5    |!                                   
*                    ~o1 |  e2  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC338(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F338=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3390()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3390(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3390=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3391()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3391(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3391=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3392()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3392(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3392=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3393()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3393(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3393=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3394()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3394(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3394=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3395()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3395(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3395=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3396()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3396(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3396=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3397()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3397(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3397=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3398()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3398(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3398=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3399()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3399(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3399=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F339()
*                    ~o1    e2   !  e2   ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e5|P5     !  ~e5|-P6                          
*                    ~o1 |  E2   !  E2 | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U12/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(12).EQ.0) CALL CC339(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F339=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F33()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o1 |  h    !  h  |  Z  | ~o1                      
*                =====@-------!-----@---2-@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC33(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)-8*P2)+C(2)-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F33=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3400()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3400(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3400=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3401()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3401(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3401=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3402()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3402(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3402=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3403()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3403(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3403=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3404()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3404(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3404=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3405()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3405(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3405=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3406()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3406(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3406=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3407()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    h   |!  h  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3407(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3407=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3408()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  h    !  h  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3408(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3408=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3409()
*                 ~o1    t    !  t          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~t1|P5     !     |     |                          
*                 ~t1 |  h    !  h  |  t  | ~t1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3409(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3409=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F340()
*              ~o1          E3   !  E3         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  e3   !  e3 |  Z  | ~o1                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC340(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F340=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3410()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~t1 |  h    !  h  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3410(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3410=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3411()
*              ~o1          t    !  t          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  h    !  h  |  t  | ~t1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3411(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3411=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3412()
*                 ~o1          t    !  t    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~t1 |  t  |  h    !  h  | ~t1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3412(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3412=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3413()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~t1 |  h    !  h  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U170/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(170).EQ.0) CALL CC3413(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3413=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3414()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3414(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3414=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3415()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3415(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3415=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3416()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3416(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3416=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3417()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3417(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3417=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3418()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3418(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3418=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3419()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3419(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3419=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F341()
*              ~o1          E3   !  E3         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  Z  |  e3   !  e3 |  H3 | ~o1                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC341(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F341=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3420()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3420(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3420=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3421()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3421(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3421=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3422()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3422(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3422=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3423()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3423(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3423=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3424()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3424(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3424=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3425()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3425(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3425=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3426()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3426(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3426=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3427()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3427(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3427=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3428()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3428(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3428=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3429()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3429(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3429=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F342()
*                 ~o1          E3   !  E3   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~o1 |  Z  |  e3   !  e3 | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC342(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F342=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3430()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3430(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3430=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3431()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3431(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3431=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3432()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3432(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3432=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3433()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3433(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3433=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3434()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3434(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3434=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3435()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H   |!  H  | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3435(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3435=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3436()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~t1 |  H    !  H  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3436(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3436=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3437()
*                 ~o1    t    !  t          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~t1|P5     !     |     |                          
*                 ~t1 |  H    !  H  |  t  | ~t1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3437(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3437=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3438()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~t1 |  H    !  H  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3438(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3438=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3439()
*              ~o1          t    !  t          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H    !  H  |  t  | ~t1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3439(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3439=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F343()
*                                   !  e3   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e3|-P6                       
*                 ~o1          E3  |!  E3 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  e3  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC343(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F343=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3440()
*                 ~o1          t    !  t    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~t1 |  t  |  H    !  H  | ~t1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3440(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3440=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3441()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~t1 |  H    !  H  | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U171/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(171).EQ.0) CALL CC3441(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3441=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3442()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3442(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3442=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3443()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3443(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3443=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3444()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3444(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3444=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3445()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3445(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3445=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3446()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3446(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3446=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3447()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H3  |!  H3 | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3447(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3447=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3448()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3448(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3448=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3449()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3449(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3449=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F344()
*                 ~o1          E3   !  E3   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~o1 |  Z  |  e3   !  e3 | ~o1                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC344(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F344=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3450()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3450(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3450=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3451()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3451(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3451=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3452()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H3  |!  H3 | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3452(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3452=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3453()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3453(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3453=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3454()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3454(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3454=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3455()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3455(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3455=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3456()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H3  |!  H3 | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3456(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3456=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3457()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3457(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3457=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3458()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  t  | ~t1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~t1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3458(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3458=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3459()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H3  |!  H3 | ~t1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~t1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3459(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3459=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F345()
*                                   !  e3   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o1          E3  |!  E3 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  Z  |  e3  |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC345(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F345=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3460()
*              ~o1          t    !  t          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H3   !  H3 |  t  | ~t1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3460(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3460=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3461()
*                 ~o1          t    !  t    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                 ~t1 |  t  |  H3   !  H3 | ~t1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3461(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3461=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3462()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~t1 |  H3   !  H3 | ~t1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U172/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(172).EQ.0) CALL CC3462(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3462=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3463()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3463(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3463=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3464()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3464(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3464=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3465()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~t1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3465(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3465=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3466()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3466(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3466=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3467()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3467(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3467=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3468()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3468(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3468=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3469()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  t  | ~t1                      
*                =====@-->---+!-->--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~t1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3469(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3469=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F346()
*              ~o1          E3   !  E3         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  e3   !  e3 |  h  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC346(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F346=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3470()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3470(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3470=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3471()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H+  |!  H+ | ~t1                         
*                   =====@-->---+!-->--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~t1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3471(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3471=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3472()
*              ~o1          b    !  b          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~t1 |  t  |  H+   !  H+ |  t  | ~t1                   
*             -->--@==>==@-->----!-->--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3472(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3472=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3473()
*                 ~o1          b    !  b    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~t1 |  t  |  H+   !  H+ | ~t1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3473(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3473=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3474()
*                 ~o1          b    !  b    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~t1 |  t  |  H+   !  H+ | ~t1                      
*                -->--@==>==@-->----!-->--@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3474(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3474=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3475()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3475(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3475=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3476()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3476(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3476=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3477()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~t1 |  H+   !  H+ | ~t1                         
*                   -->--@-->----!-->--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U173/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(173).EQ.0) CALL CC3477(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3477=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3478()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  A    !  A  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U174/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(174).EQ.0) CALL CC3478(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F3478=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3479()
*                             !  A          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    b   |!  b  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~b1|P5    |!                                      
*                 ~b1 |  A   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U174/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(174).EQ.0) CALL CC3479(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F3479=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F347()
*              ~o1          E3   !  E3         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  h  |  e3   !  e3 |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC347(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F347=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3480()
*              ~o1          A    !  A          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  b    !  b  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U174/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(174).EQ.0) CALL CC3480(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F3480=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3481()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3481(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(C(5)*(P2-P1)-C(4))-C(3))+C(1)+C(2)*P1
      F3481=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3482()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3482(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3482=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3483()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3483(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3483=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3484()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3484(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3484=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3485()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3485(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3485=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3486()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~b1 |  b    !  b  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3486(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3486=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3487()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3487(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3487=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3488()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3488(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3488=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3489()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3489(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3489=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F348()
*                 ~o1          E3   !  E3   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~o1 |  h  |  e3   !  e3 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC348(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F348=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3490()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3490(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3490=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3491()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3491(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3491=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3492()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o2|P5     !     |     |                          
*                 ~b1 |  b    !  b  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3492(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3492=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3493()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3493(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3493=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3494()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3494(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3494=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3495()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3495(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3495=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3496()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3496(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3496=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3497()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o3|P5     !     |     |                          
*                 ~b1 |  b    !  b  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3497(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3497=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3498()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3498(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3498=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3499()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3499(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))-C(3)-C(4)*P1)+C(1)-C(2)*P1
      F3499=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F349()
*                                   !  e3   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e3|-P6                       
*                 ~o1          E3  |!  E3 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC349(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F349=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F34()
*                                !  h    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~o1 |  h   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC34(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(4*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C(1)
      F34=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3500()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3500(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3500=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3501()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o4|P5     !     |     |                          
*                 ~b1 |  b    !  b  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3501(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)+C
     >(1)
      F3501=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3502()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    Z   |!  Z  | ~b1                         
*                   =====@-1----+!---1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3502(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3502=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3503()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  Z    !  Z  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3503(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3503=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3504()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    b   |!  b  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~b1|P5    |!                                      
*                 ~b1 |  Z   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3504(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F3504=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3505()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~b1 |  Z    !  Z  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3505(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3505=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3506()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  b    !  b  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3506(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F3506=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3507()
*                                   !  b    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~o1          Z   |!  Z  | ~b1                      
*                =====\     /-1----+!---1-@-->--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~b1 |  b  |  b   |!                                
*                -->--@==>==@==>===/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(175).EQ.0) CALL CC3507(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >7)*P2-C(4))+C(1)
      F3507=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3508()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~b1 |  Z    !  Z  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U175/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(175).EQ.0) CALL CC3508(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3508=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3509()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(176).EQ.0) CALL CC3509(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3509=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F350()
*                 ~o1          E3   !  E3   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~o1 |  h  |  e3   !  e3 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC350(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F350=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3510()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(176).EQ.0) CALL CC3510(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3510=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3511()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(176).EQ.0) CALL CC3511(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3511=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3512()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~b1 |  u    !  u  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(176).EQ.0) CALL CC3512(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3512=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3513()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(176).EQ.0) CALL CC3513(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3513=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3514()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(176).EQ.0) CALL CC3514(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3514=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3515()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~b1 |  u    !  u  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(176).EQ.0) CALL CC3515(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3515=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3516()
*                    ~o1    u    !  u    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(176).EQ.0) CALL CC3516(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3516=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3517()
*                             !  W-         ~o1                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    u   |!  u  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~u1|P5    |!                                      
*                 ~b1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(176).EQ.0) CALL CC3517(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3517=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3518()
*              ~o1          W-   !  W-         ~o1                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  u    !  u  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U176/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(176).EQ.0) CALL CC3518(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3518=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3519()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(177).EQ.0) CALL CC3519(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3519=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F351()
*                                   !  e3   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o1          E3  |!  E3 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC351(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F351=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3520()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(177).EQ.0) CALL CC3520(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3520=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3521()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(177).EQ.0) CALL CC3521(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3521=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3522()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~b1 |  c    !  c  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(177).EQ.0) CALL CC3522(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3522=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3523()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(177).EQ.0) CALL CC3523(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3523=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3524()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(177).EQ.0) CALL CC3524(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3524=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3525()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~b1 |  c    !  c  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(177).EQ.0) CALL CC3525(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3525=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3526()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(177).EQ.0) CALL CC3526(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3526=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3527()
*                             !  W-         ~o1                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    c   |!  c  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~b1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(177).EQ.0) CALL CC3527(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3527=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3528()
*              ~o1          W-   !  W-         ~o1                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  c    !  c  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U177/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(177).EQ.0) CALL CC3528(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3528=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3529()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3529(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3529=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F352()
*              ~o1          E3   !  E3         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H  |  e3   !  e3 |  H  | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC352(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))-C(1)
      F352=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3530()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3530(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3530=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3531()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(178).EQ.0) CALL CC3531(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3531=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3532()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(178).EQ.0) CALL CC3532(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3532=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3533()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~b1 |  t    !  t  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3533(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3533=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3534()
*                    ~o1    W-   !  W-   ~o1                         
*                   =====@-1<----!--<1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3534(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P2*(C(6)*(P2-P1)-C(5))+C(3)+C(4)*P1)+C(1)+C(2)*P1
      F3534=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3535()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(178).EQ.0) CALL CC3535(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3535=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3536()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    W-  |!  W- | ~b1                         
*                   =====@-1<---+!--<1-@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(178).EQ.0) CALL CC3536(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1*(-C
     >(2)-C(3)*P1)-C(1)
      F3536=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3537()
*                 ~o1    W-   !  W-         ~o1                      
*                =====@-1<----!--<1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~b1 |  t    !  t  |  b  | ~b1                      
*                -->--@==>====!==>==@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3537(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F3537=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3538()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3538(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3538=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3539()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3539(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3539=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F353()
*                 ~o1          E3   !  E3   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~o1 |  H  |  e3   !  e3 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC353(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F353=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3540()
*                             !  W-         ~o1                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    t   |!  t  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t1|P5    |!                                      
*                 ~b1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(178).EQ.0) CALL CC3540(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3540=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3541()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~b1 |  W-   !  W- | ~b1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3541(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))-C(1)
      F3541=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3542()
*                             !  W-         ~o1                      
*                            /!--<1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    t   |!  t  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~t2|P5    |!                                      
*                 ~b1 |  W-  |!                                      
*                -->--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(178).EQ.0) CALL CC3542(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))-C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F3542=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3543()
*              ~o1          W-   !  W-         ~o1                   
*             =====\     /-1<----!--<1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  t    !  t  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U178/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(178).EQ.0) CALL CC3543(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F3543=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3544()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  G    !  G  | ~b1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U179/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(179).EQ.0) CALL CC3544(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P1-C(2)-C(3)*P2)+P2*(C(2)+C(4)*P2)-C(1)
      F3544=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3545()
*                             !  G          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    b   |!  b  |  b  | ~b1                      
*                =====@==>===+!==>==@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~b1|P5    |!                                      
*                 ~b1 |  G   |!                                      
*                -->--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U179/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(179).EQ.0) CALL CC3545(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)+C(2))+C(1)-C(3)*P2
      F3545=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3546()
*              ~o1          G    !  G          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  b    !  b  |  b  | ~b1                   
*             -->--@==>==@==>====!==>==@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U179/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(179).EQ.0) CALL CC3546(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F3546=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3547()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3547(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3547=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3548()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3548(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3548=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3549()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3549(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3549=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F354()
*                                   !  e3   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e3|-P6                       
*                 ~o1          E3  |!  E3 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC354(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F354=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3550()
*                             !  u          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~b1 |  u   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3550(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3550=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3551()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  u    !  u  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3551(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3551=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3552()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  u   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3552(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3552=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3553()
*                             !  u          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~b1 |  u   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3553(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3553=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3554()
*                    ~o1    u    !  u    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3554(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)*P2
      F3554=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3555()
*                 ~o1    u    !  u          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~u1|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3555(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3555=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3556()
*              ~o1          u    !  u          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H-   !  H- |  b  | ~b1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U180/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(180).EQ.0) CALL CC3556(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3556=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3557()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3557(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3557=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3558()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3558(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3558=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3559()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3559(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3559=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F355()
*                 ~o1          E3   !  E3   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~o1 |  H  |  e3   !  e3 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC355(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F355=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3560()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3560(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3560=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3561()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~b1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3561(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3561=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3562()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  c    !  c  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3562(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3562=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3563()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3563(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3563=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3564()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3564(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3564=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3565()
*                             !  c          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~b1 |  c   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3565(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3565=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3566()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3566(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3566=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3567()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3567(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3567=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3568()
*                 ~o1    c    !  c          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3568(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3568=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3569()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3569(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3569=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F356()
*                                   !  e3   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o1          E3  |!  E3 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC356(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F356=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5
     >)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3570()
*                 ~o1    c    !  c          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c2|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3570(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3570=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3571()
*              ~o1          c    !  c          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H-   !  H- |  b  | ~b1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U181/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(181).EQ.0) CALL CC3571(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3571=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3572()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3572(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3572=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3573()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3573(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3573=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3574()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3574(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3574=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3575()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3575(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3575=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3576()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~b1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3576(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3576=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3577()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~b1 |  t    !  t  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3577(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3577=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3578()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3578(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3578=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3579()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    H-  |!  H- | ~b1                         
*                   =====@--<---+!--<--@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~b1 |  t   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3579(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3579=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F357()
*              ~o1          E3   !  E3         ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H3 |  e3   !  e3 |  H3 | ~o1                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC357(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F357=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3580()
*                             !  t          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H-  |!  H- |  b  | ~b1                      
*                =====@--<---+!--<--@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~b1 |  t   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3580(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3580=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3581()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3581(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3581=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3582()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3582(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3582=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3583()
*                 ~o1    t    !  t          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~t1|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3583(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3583=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3584()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~b1 |  H-   !  H- | ~b1                         
*                   -->--@--<----!--<--@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3584(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3584=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3585()
*                 ~o1    t    !  t          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~t2|P5     !     |     |                          
*                 ~b1 |  H-   !  H- |  b  | ~b1                      
*                -->--@--<----!--<--@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3585(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3585=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3586()
*              ~o1          t    !  t          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H-   !  H- |  b  | ~b1                   
*             -->--@==>==@--<----!--<--@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U182/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(182).EQ.0) CALL CC3586(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3586=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3587()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3587(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3587=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3588()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3588(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3588=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3589()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3589(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3589=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F358()
*                 ~o1          E3   !  E3   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~o1 |  H3 |  e3   !  e3 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC358(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F358=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3590()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3590(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3590=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3591()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3591(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3591=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3592()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3592(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3592=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3593()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3593(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3593=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3594()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3594(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3594=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3595()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3595(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3595=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3596()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3596(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3596=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3597()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3597(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3597=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3598()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3598(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3598=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3599()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3599(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3599=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F359()
*                                   !  e3   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e3|-P6                       
*                 ~o1          E3  |!  E3 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC359(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F359=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F35()
*                 ~o1    Z    !  Z          ~o1                      
*                =====@-1-----!---1-\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~o1|P5     !     |     |                          
*                 ~o1 |  h    !  h  |  H3 | ~o1                      
*                =====@-------!-----@-----@=====                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC35(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F35=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3600()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3600(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3600=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3601()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3601(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3601=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3602()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3602(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3602=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3603()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3603(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3603=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3604()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3604(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3604=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3605()
*                    ~o1    h    !  h    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3605(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3605=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3606()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3606(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3606=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3607()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    h   |!  h  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3607(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3607=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3608()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    h   |!  h  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3608(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3608=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3609()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  h    !  h  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3609(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3609=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F360()
*                 ~o1          E3   !  E3   ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~o1 |  H3 |  e3   !  e3 | ~o1                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC360(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F360=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3610()
*                 ~o1    b    !  b          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~b1|P5     !     |     |                          
*                 ~b1 |  h    !  h  |  b  | ~b1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3610(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3610=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3611()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~b1 |  h    !  h  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3611(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3611=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3612()
*              ~o1          b    !  b          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  h    !  h  |  b  | ~b1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3612(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3612=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3613()
*                 ~o1          b    !  b    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~b1 |  b  |  h    !  h  | ~b1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3613(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3613=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3614()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~b1 |  h    !  h  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U183/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(183).EQ.0) CALL CC3614(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3614=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3615()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3615(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3615=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3616()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3616(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3616=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3617()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3617(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3617=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3618()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3618(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3618=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3619()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3619(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3619=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F361()
*                                   !  e3   ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~o1          E3  |!  E3 | ~o1                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  e3  |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC361(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F361=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3620()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3620(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3620=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3621()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3621(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3621=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3622()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3622(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3622=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3623()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3623(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3623=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3624()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3624(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3624=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3625()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3625(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3625=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3626()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3626(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3626=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3627()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3627(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3627=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3628()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3628(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3628=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3629()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3629(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3629=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F362()
*                    ~o1    E3   !  E3   ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~o1 |  e3   !  e3 | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC362(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F362=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3630()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3630(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3630=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3631()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3631(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3631=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3632()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3632(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3632=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3633()
*                    ~o1    H    !  H    ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3633(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3633=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3634()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b1|-P6                          
*                    ~o1    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3634(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3634=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3635()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H   |!  H  |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3635(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F3635=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3636()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H   |!  H  | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3636(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3636=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3637()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~b1 |  H    !  H  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3637(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3637=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3638()
*                 ~o1    b    !  b          ~o1                      
*                =====@==>====!==>==\     /=====                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~b1|P5     !     |     |                          
*                 ~b1 |  H    !  H  |  b  | ~b1                      
*                -->--@-------!-----@==>==@-->--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3638(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3638=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3639()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~b1 |  H    !  H  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3639(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3639=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F363()
*                                !  e3   ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~o1    E3  |!  E3 | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e3|P5    |!                                   
*                    ~o1 |  e3  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC363(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F363=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3640()
*              ~o1          b    !  b          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H    !  H  |  b  | ~b1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3640(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3640=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3641()
*                 ~o1          b    !  b    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~b1 |  b  |  H    !  H  | ~b1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3641(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3641=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3642()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~b1 |  H    !  H  | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U184/ Q0(6),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(184).EQ.0) CALL CC3642(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3642=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3643()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3643(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3643=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3644()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3644(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3644=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3645()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3645(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3645=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3646()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3646(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3646=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3647()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3647(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3647=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3648()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H3  |!  H3 | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o1|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3648(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3648=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3649()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3649(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3649=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F364()
*                    ~o1    E3   !  E3   ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~o1 |  e3   !  e3 | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC364(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F364=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3650()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3650(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3650=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3651()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3651(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3651=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3652()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3652(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3652=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3653()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H3  |!  H3 | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o2|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3653(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3653=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3654()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3654(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3654=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3655()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3655(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3655=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3656()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3656(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3656=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3657()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H3  |!  H3 | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o3|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3657(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3657=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3658()
*                    ~o1    H3   !  H3   ~o1                         
*                   =====@-------!-----@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3658(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3658=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3659()
*                             !  b          ~o1                      
*                            /!==>==\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H3  |!  H3 |  b  | ~b1                      
*                =====@------+!-----@==>==@-->--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~b1 |  b   |!                                      
*                -->--@==>===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3659(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3659=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F365()
*                                !  e3   ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o1    E3  |!  E3 | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e3|P5    |!                                   
*                    ~o1 |  e3  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC365(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F365=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3660()
*                                !  b    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~b2|-P6                          
*                    ~o1    H3  |!  H3 | ~b1                         
*                   =====@------+!-----@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~o4|P5    |!                                   
*                    ~b1 |  b   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3660(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F3660=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3661()
*              ~o1          b    !  b          ~o1                   
*             =====\     /==>====!==>==\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~b1 |  b  |  H3   !  H3 |  b  | ~b1                   
*             -->--@==>==@-------!-----@==>==@-->--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3661(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F3661=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3662()
*                 ~o1          b    !  b    ~o1                      
*                =====\     /==>====!==>==@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~b1 |  b  |  H3   !  H3 | ~b1                      
*                -->--@==>==@-------!-----@-->--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3662(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F3662=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3663()
*                    ~o1    b    !  b    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~b1 |  H3   !  H3 | ~b1                         
*                   -->--@-------!-----@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U185/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(185).EQ.0) CALL CC3663(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P2
      F3663=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3664()
*                    ~o1    U    !  U    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                     ~g |  u    !  u  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3664(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3664=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3665()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u1|-P6                          
*                    ~o1    U   |!  U  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u1|P5    |!                                   
*                     ~g |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3665(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3665=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3666()
*                    ~o1    U    !  U    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u2|-P6                          
*                     ~g |  u    !  u  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3666(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3666=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3667()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o1    U   |!  U  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u1|P5    |!                                   
*                     ~g |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3667(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3667=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3668()
*                    ~o1    u    !  u    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                     ~g |  U    !  U  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3668(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F3668=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3669()
*                                !  U    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o1    u   |!  u  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~u1|P5    |!                                   
*                     ~g |  U   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3669(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3669=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F366()
*                    ~o1    e3   !  e3   ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~o1 |  E3   !  E3 | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC366(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F366=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3670()
*                    ~o1    u    !  u    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u2|-P6                          
*                     ~g |  U    !  U  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3670(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F3670=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3671()
*                    ~o1    U    !  U    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u2|P5     !  ~u2|-P6                          
*                     ~g |  u    !  u  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3671(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3671=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3672()
*                                !  u    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~u2|-P6                          
*                    ~o1    U   |!  U  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~u2|P5    |!                                   
*                     ~g |  u   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3672(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3672=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3673()
*                    ~o1    u    !  u    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u2|P5     !  ~u2|-P6                          
*                     ~g |  U    !  U  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U186/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(186).EQ.0) CALL CC3673(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F3673=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3674()
*                    ~o1    D    !  D    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3674(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3674=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3675()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o1    D   |!  D  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d1|P5    |!                                   
*                     ~g |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3675(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3675=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3676()
*                    ~o1    D    !  D    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d2|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3676(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3676=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3677()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o1    D   |!  D  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d1|P5    |!                                   
*                     ~g |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3677(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3677=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3678()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  D    !  D  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3678(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F3678=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3679()
*                                !  D    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o1    d   |!  d  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~d1|P5    |!                                   
*                     ~g |  D   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3679(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3679=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F367()
*                                !  E3   ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o1    e3  |!  e3 | ~o1                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e3|P5    |!                                   
*                    ~o1 |  E3  |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC367(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F367=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3680()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d2|-P6                          
*                     ~g |  D    !  D  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3680(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F3680=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3681()
*                    ~o1    D    !  D    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3681(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3681=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3682()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o1    D   |!  D  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d2|P5    |!                                   
*                     ~g |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3682(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3682=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3683()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                     ~g |  D    !  D  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U187/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(187).EQ.0) CALL CC3683(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F3683=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3684()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3684(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3684=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3685()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    C   |!  C  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                     ~g |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3685(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3685=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3686()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3686(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3686=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3687()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    C   |!  C  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                     ~g |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3687(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3687=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3688()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                     ~g |  C    !  C  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3688(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3688=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3689()
*                                !  C    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    c   |!  c  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                     ~g |  C   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3689(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3689=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F368()
*                    ~o1    e3   !  e3   ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~o1 |  E3   !  E3 | ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC368(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F368=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3690()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                     ~g |  C    !  C  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3690(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3690=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3691()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3691(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3691=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3692()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    C   |!  C  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c2|P5    |!                                   
*                     ~g |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3692(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3692=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3693()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                     ~g |  C    !  C  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U188/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(188).EQ.0) CALL CC3693(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3693=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3694()
*                    ~o1    S    !  S    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                     ~g |  s    !  s  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3694(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3694=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3695()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    S   |!  S  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                     ~g |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3695(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3695=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3696()
*                    ~o1    S    !  S    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                     ~g |  s    !  s  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3696(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3696=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3697()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    S   |!  S  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                     ~g |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3697(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3697=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3698()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                     ~g |  S    !  S  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3698(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3698=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3699()
*                                !  S    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    s   |!  s  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~s1|P5    |!                                   
*                     ~g |  S   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3699(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3699=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F369()
*                    ~o1    E3   !  E3   ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~o1 |  e3   !  e3 | ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC369(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F369=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F36()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~o1 |  h    !  h  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U2/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(2).EQ.0) CALL CC36(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F36=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7)
     >*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3700()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                     ~g |  S    !  S  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3700(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3700=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3701()
*                    ~o1    S    !  S    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                     ~g |  s    !  s  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3701(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3701=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3702()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    S   |!  S  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s2|P5    |!                                   
*                     ~g |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3702(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3702=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3703()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                     ~g |  S    !  S  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U189/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(189).EQ.0) CALL CC3703(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3703=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3704()
*                    ~o1    T    !  T    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3704(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3704=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3705()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t1|-P6                          
*                    ~o1    T   |!  T  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t1|P5    |!                                   
*                     ~g |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3705(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3705=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3706()
*                    ~o1    T    !  T    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3706(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3706=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3707()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    T   |!  T  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t1|P5    |!                                   
*                     ~g |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3707(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3707=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3708()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                     ~g |  T    !  T  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3708(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3708=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3709()
*                                !  T    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    t   |!  t  |  ~g                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~t1|P5    |!                                   
*                     ~g |  T   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3709(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3709=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F370()
*                                !  e3   ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~o1    E3  |!  E3 | ~o1                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e6|P5    |!                                   
*                    ~o1 |  e3  |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U13/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(13).EQ.0) CALL CC370(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F370=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3710()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                     ~g |  T    !  T  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3710(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3710=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3711()
*                    ~o1    T    !  T    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3711(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F3711=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3712()
*                                !  t    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~t2|-P6                          
*                    ~o1    T   |!  T  |  ~g                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~t2|P5    |!                                   
*                     ~g |  t   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3712(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))-C(1)-C(2)*P1
      F3712=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3713()
*                    ~o1    t    !  t    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                     ~g |  T    !  T  |  ~g                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U190/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(190).EQ.0) CALL CC3713(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F3713=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F3714()
*                    ~o1    B    !  B    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                     ~g |  b    !  b  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U191/ Q0(4),Q1(4),Q2(4)
      DIMENS