*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16000()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~B1 |  W+   !  W+ | ~B1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1412/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1412).EQ.0) CALL CC16000(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16000=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16001()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~B1 |  W+   !  W+ | ~B1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1412/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1412).EQ.0) CALL CC16001(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16001=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16002()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~B1 |  W+   !  W+ | ~B1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1412/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1412).EQ.0) CALL CC16002(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16002=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16003()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~B1 |  W+   !  W+ | ~B1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1412/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1412).EQ.0) CALL CC16003(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16003=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16004()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~B1 |  W+   !  W+ | ~B1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1412/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1412).EQ.0) CALL CC16004(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16004=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16005()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~B1 |  W+   !  W+ | ~B1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1412/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1412).EQ.0) CALL CC16005(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16005=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16006()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~B1 |  W+   !  W+ | ~B1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1412/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1412).EQ.0) CALL CC16006(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16006=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16007()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16007(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16007=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16008()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16008(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16008=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16009()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16009(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16009=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1600()
*                                !  H3   ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H3  |!  H3 | ~o2                         
*                   =====@------+!-----@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~o2 |  H3  |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U51/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(51).EQ.0) CALL CC1600(C)
      TOTNUM=+C(4)
      TOTDEN=+2
      RNUM=+P2*(4*(P2-P1)-C(3))+C(2)*P1-C(1)
      F1600=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16010()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16010(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16010=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16011()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16011(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16011=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16012()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16012(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16012=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16013()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16013(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16013=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16014()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16014(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16014=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16015()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16015(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16015=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16016()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1413/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1413).EQ.0) CALL CC16016(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16016=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16017()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1414/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1414).EQ.0) CALL CC16017(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16017=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16018()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1414/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1414).EQ.0) CALL CC16018(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16018=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16019()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1414/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1414).EQ.0) CALL CC16019(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16019=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1601()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~o2 |  H+   !  H+ | ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1601(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(1)-C(2)*P1
      F1601=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16020()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1415/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1415).EQ.0) CALL CC16020(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16020=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16021()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1415/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1415).EQ.0) CALL CC16021(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16021=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16022()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1415/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1415).EQ.0) CALL CC16022(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16022=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16023()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1416/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1416).EQ.0) CALL CC16023(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16023=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16024()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1416/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1416).EQ.0) CALL CC16024(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16024=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16025()
*                    ~d1    u    !  u    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1416/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1416).EQ.0) CALL CC16025(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16025=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16026()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1417/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1417).EQ.0) CALL CC16026(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16026=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16027()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1417/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1417).EQ.0) CALL CC16027(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16027=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16028()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1417/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1417).EQ.0) CALL CC16028(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16028=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16029()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1418/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1418).EQ.0) CALL CC16029(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16029=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1602()
*                                !  H+   ~o1                         
*                               /!-->--@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~1+|-P6                          
*                    ~o1    H-  |!  H- | ~o2                         
*                   =====@--<---+!--<--@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~o2 |  H+  |!                                   
*                   =====@-->---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1602(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F1602=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16030()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1418/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1418).EQ.0) CALL CC16030(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16030=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16031()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1418/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1418).EQ.0) CALL CC16031(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16031=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16032()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16032(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16032=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16033()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16033(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16033=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16034()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16034(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16034=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16035()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16035(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16035=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16036()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16036(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16036=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16037()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16037(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16037=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16038()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16038(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16038=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16039()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16039(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16039=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1603()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~o2 |  H+   !  H+ | ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1603(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(1)-C(2)*P1
      F1603=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16040()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16040(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16040=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16041()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16041(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16041=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16042()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                      ~g|P5     !   ~g|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1419/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1419).EQ.0) CALL CC16042(C)
      S1=A(146)**4
      TOTNUM=-8*S1
      TOTDEN=+9
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16042=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16043()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1420/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1420).EQ.0) CALL CC16043(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16043=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16044()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1420/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1420).EQ.0) CALL CC16044(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16044=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16045()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1420/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1420).EQ.0) CALL CC16045(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16045=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16046()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1421/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1421).EQ.0) CALL CC16046(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16046=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16047()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1421/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1421).EQ.0) CALL CC16047(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16047=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16048()
*                    ~d1    c    !  c    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1421/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1421).EQ.0) CALL CC16048(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16048=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16049()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1422/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1422).EQ.0) CALL CC16049(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16049=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1604()
*                                !  H+   ~o1                         
*                               /!-->--@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~2+|-P6                          
*                    ~o1    H-  |!  H- | ~o2                         
*                   =====@--<---+!--<--@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~o2 |  H+  |!                                   
*                   =====@-->---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1604(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F1604=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16050()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1422/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1422).EQ.0) CALL CC16050(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16050=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16051()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1422/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1422).EQ.0) CALL CC16051(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16051=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16052()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1423/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1423).EQ.0) CALL CC16052(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16052=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16053()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1423/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1423).EQ.0) CALL CC16053(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16053=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16054()
*                    ~d1    t    !  t    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1423/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1423).EQ.0) CALL CC16054(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16054=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16055()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16055(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16055=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16056()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~c1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16056(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16056=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16057()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~c2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16057(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16057=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16058()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16058(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16058=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16059()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16059(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16059=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1605()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  Z  | ~o2                      
*                =====@-->----!-->--@---1-@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1605(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(1)-C(2)*P1
      F1605=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16060()
*                                !       ~d1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~d1    H-   !  H- | ~B1                         
*                   -->--@--<----!--<--@--<--                        
*                     P1 |  P4   !  P4 |  P2                         
*                     ~u1|P5     !     |                             
*                    ~B1 |  H+   !  H+ |                             
*                   --<--@-->----!-->--/                             
*                     P2    P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16060(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16060=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16061()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16061(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16061=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16062()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16062(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16062=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16063()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16063(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16063=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16064()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16064(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16064=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16065()
*                                !       ~d1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~d1    H-   !  H- | ~B1                         
*                   -->--@--<----!--<--@--<--                        
*                     P1 |  P4   !  P4 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~B1 |  H+   !  H+ |                             
*                   --<--@-->----!-->--/                             
*                     P2    P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16065(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16065=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16066()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16066(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16066=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16067()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~t1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16067(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16067=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16068()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16068(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16068=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16069()
*                                !       ~d1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~d1    H-   !  H- | ~B1                         
*                   -->--@--<----!--<--@--<--                        
*                     P1 |  P4   !  P4 |  P2                         
*                     ~c2|P5     !     |                             
*                    ~B1 |  H+   !  H+ |                             
*                   --<--@-->----!-->--/                             
*                     P2    P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16069(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16069=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1606()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  h  | ~o2                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1606(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F1606=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16070()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16070(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16070=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16071()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16071(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16071=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16072()
*                                !       ~d1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~d1    H-   !  H- | ~B1                         
*                   -->--@--<----!--<--@--<--                        
*                     P1 |  P4   !  P4 |  P2                         
*                     ~t1|P5     !     |                             
*                    ~B1 |  H+   !  H+ |                             
*                   --<--@-->----!-->--/                             
*                     P2    P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16072(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16072=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16073()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                    ~B1 |  H+   !  H+ | ~B1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16073(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16073=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16074()
*                                !       ~d1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~d1    H-   !  H- | ~B1                         
*                   -->--@--<----!--<--@--<--                        
*                     P1 |  P4   !  P4 |  P2                         
*                     ~t2|P5     !     |                             
*                    ~B1 |  H+   !  H+ |                             
*                   --<--@-->----!-->--/                             
*                     P2    P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16074(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16074=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16075()
*                    ~d1         !       ~d1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~B1 |  H-   !  H- | ~B1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H+   !  H+ |                             
*                        \-->----!-->--/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1424/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1424).EQ.0) CALL CC16075(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16075=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16076()
*              ~d1          A    !  A          ~d1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*               ~g |  d  |  d    !  d  |  d  |  ~g                   
*             =====@==>==@==>====!==>==@==>==@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1425/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1425).EQ.0) CALL CC16076(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+27
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16076=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16077()
*                 ~d1          A    !  A    ~d1                      
*                -->--\     /-1-----!---1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~d1|-P6                       
*                  ~g |  d  |  d    !  d  |  ~g                      
*                =====@==>==@==>====!==>==@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1425/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1425).EQ.0) CALL CC16077(C)
      S1=A(146)**2
      TOTNUM=+C(5)*S1
      TOTDEN=+27
      RNUM=+P1*(C(4)*P2-C(2))+C(1)-C(3)*P2
      F16077=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16078()
*                    ~d1    A    !  A    ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1425/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1425).EQ.0) CALL CC16078(C)
      S1=A(146)**2
      TOTNUM=+C(4)*S1
      TOTDEN=+27
      RNUM=+P2*(C(3)*P2-C(2))+C(1)
      F16078=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16079()
*              ~d1          Z    !  Z          ~d1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*               ~g |  d  |  d    !  d  |  d  |  ~g                   
*             =====@==>==@==>====!==>==@==>==@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1426/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1426).EQ.0) CALL CC16079(C)
      S1=A(146)**2
      TOTNUM=+C(8)*S1
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F16079=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1607()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~1+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  H  | ~o2                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1607(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F1607=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16080()
*                 ~d1          Z    !  Z    ~d1                      
*                -->--\     /-1-----!---1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~d1|-P6                       
*                  ~g |  d  |  d    !  d  |  ~g                      
*                =====@==>==@==>====!==>==@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1426/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1426).EQ.0) CALL CC16080(C)
      S1=A(146)**2
      TOTNUM=+C(8)*S1
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(5)*P2-C(3))+C(1)-C(2)*P1
      F16080=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16081()
*                    ~d1    Z    !  Z    ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1426/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1426).EQ.0) CALL CC16081(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)*P2-C(3))-C(2))+C(1)
      F16081=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16082()
*              ~d1          W-   !  W-         ~d1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*               ~g |  d  |  u    !  u  |  d  |  ~g                   
*             =====@==>==@==>====!==>==@==>==@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1427/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1427).EQ.0) CALL CC16082(C)
      S1=A(146)**2
      TOTNUM=+C(7)*S1
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(C(3)+8*P2)+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F16082=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16083()
*                 ~d1          W-   !  W-   ~d1                      
*                -->--\     /-1<----!--<1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~u1|-P6                       
*                  ~g |  d  |  u    !  u  |  ~g                      
*                =====@==>==@==>====!==>==@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1427/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1427).EQ.0) CALL CC16083(C)
      S1=A(146)**2
      TOTNUM=+C(7)*S1
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(4*P2-C(4))+C(5)*P2-C(3))+C(1)-C(2)*P1
      F16083=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16084()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                     ~g |  u    !  u  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1427/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1427).EQ.0) CALL CC16084(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)*P2-C(3))-C(2))+C(1)
      F16084=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16085()
*              ~d1          W-   !  W-         ~d1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*               ~g |  d  |  c    !  c  |  d  |  ~g                   
*             =====@==>==@==>====!==>==@==>==@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1428/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1428).EQ.0) CALL CC16085(C)
      S1=A(146)**2
      TOTNUM=+C(7)*S1
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(C(3)+8*P2)+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F16085=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16086()
*                 ~d1          W-   !  W-   ~d1                      
*                -->--\     /-1<----!--<1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                  ~g |  d  |  c    !  c  |  ~g                      
*                =====@==>==@==>====!==>==@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1428/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1428).EQ.0) CALL CC16086(C)
      S1=A(146)**2
      TOTNUM=+C(8)*S1
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(5)*P2-C(3))+C(1)-C(2)*P1
      F16086=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16087()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1428/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1428).EQ.0) CALL CC16087(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)*P2-C(3))-C(2))+C(1)
      F16087=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16088()
*              ~d1          W-   !  W-         ~d1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*               ~g |  d  |  t    !  t  |  d  |  ~g                   
*             =====@==>==@==>====!==>==@==>==@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1429/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1429).EQ.0) CALL CC16088(C)
      S1=A(146)**2
      TOTNUM=+C(7)*S1
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(C(3)+8*P2)+C(2)-C(5)*P2)+C(1)-C(4)*P2
      F16088=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16089()
*                 ~d1          W-   !  W-   ~d1                      
*                -->--\     /-1<----!--<1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t1|-P6                       
*                  ~g |  d  |  t    !  t  |  ~g                      
*                =====@==>==@==>====!==>==@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1429/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1429).EQ.0) CALL CC16089(C)
      S1=A(146)**2
      TOTNUM=+C(8)*S1
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(5)*P2-C(3))+C(1)-C(2)*P1
      F16089=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1608()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~o2 |  H-   !  H- | ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1608(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1608=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16090()
*                 ~d1          W-   !  W-   ~d1                      
*                -->--\     /-1<----!--<1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~t2|-P6                       
*                  ~g |  d  |  t    !  t  |  ~g                      
*                =====@==>==@==>====!==>==@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1429/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1429).EQ.0) CALL CC16090(C)
      S1=A(146)**2
      TOTNUM=+C(8)*S1
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(5)*P2-C(3))+C(1)-C(2)*P1
      F16090=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16091()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1429/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1429).EQ.0) CALL CC16091(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)*P2-C(3))-C(2))+C(1)
      F16091=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16092()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1429/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1429).EQ.0) CALL CC16092(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)*P2-C(3))-C(2))+C(1)
      F16092=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16093()
*                    ~d1    W-   !  W-   ~d1                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1429/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1429).EQ.0) CALL CC16093(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)*P2-C(3))-C(2))+C(1)
      F16093=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16094()
*                    ~d1    d    !  d    ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                      ~g|P5     !   ~g|-P6                          
*                     ~g |  G    !  G  |  ~g                         
*                   =====@-1-----!---1-@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1430/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1430).EQ.0) CALL CC16094(C)
      S1=A(146)**4
      TOTNUM=-S1
      TOTDEN=+1
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16094=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16095()
*                             !  G          ~d1                      
*                            /!---1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~d1    d   |!  d  |  d  |  ~g                      
*                -->--@==>===+!==>==@==>==@=====                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                   ~g|P5    |!                                      
*                  ~g |  G   |!                                      
*                =====@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1430/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1430).EQ.0) CALL CC16095(C)
      S1=A(146)**4
      TOTNUM=-S1
      TOTDEN=+1
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16095=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16096()
*                                !  G    ~d1                         
*                               /!---1-@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~d1    d   |!  d  |  ~g                         
*                   -->--@==>===+!==>==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                      ~g|P5    |!                                   
*                     ~g |  G   |!                                   
*                   =====@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1430/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1430).EQ.0) CALL CC16096(C)
      S1=A(146)**4
      TOTNUM=+S1
      TOTDEN=+2
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16096=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16097()
*              ~d1          G    !  G          ~d1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*               ~g |  d  |  d    !  d  |  d  |  ~g                   
*             =====@==>==@==>====!==>==@==>==@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1430/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1430).EQ.0) CALL CC16097(C)
      S1=A(146)**4
      TOTNUM=-4*S1
      TOTDEN=+9
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16097=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16098()
*                 ~d1          G    !  G    ~d1                      
*                -->--\     /-1-----!---1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~d1|-P6                       
*                  ~g |  d  |  d    !  d  |  ~g                      
*                =====@==>==@==>====!==>==@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1430/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1430).EQ.0) CALL CC16098(C)
      S1=A(146)**4
      TOTNUM=-S1
      TOTDEN=+18
      RNUM=+P1*(C(4)*P2-C(2))+C(1)-C(3)*P2
      F16098=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16099()
*                    ~d1    G    !  G    ~d1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1430/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1430).EQ.0) CALL CC16099(C)
      S1=A(146)**4
      TOTNUM=+8*S1
      TOTDEN=+9
      RNUM=+P2*(C(3)*P2-C(2))+C(1)
      F16099=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1609()
*                                !  H-   ~o1                         
*                               /!--<--@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~2+|-P6                          
*                    ~o1    H+  |!  H+ | ~o2                         
*                   =====@-->---+!-->--@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~o2 |  H-  |!                                   
*                   =====@--<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1609(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(2)*P1-C(1)
      F1609=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F160()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  h  |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U4/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(4).EQ.0) CALL CC160(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F160=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(10)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16100()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~u1|P5     !  ~u1|-P6                          
*                     ~g |  u    !  u  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1431/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1431).EQ.0) CALL CC16100(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+C(2)*(P2-P1)-C(1)
      F16100=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16101()
*                    ~d1    h    !  h    ~d1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1432/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1432).EQ.0) CALL CC16101(C)
      S1=A(146)**2
      TOTNUM=-C(3)*S1
      TOTDEN=+6
      RNUM=+C(2)*(P2-P1)-C(1)
      F16101=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16102()
*                    ~d1    H    !  H    ~d1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                     ~g |  d    !  d  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1433/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1433).EQ.0) CALL CC16102(C)
      S1=A(146)**2
      TOTNUM=-C(3)*S1
      TOTDEN=+6
      RNUM=+C(2)*(P2-P1)-C(1)
      F16102=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16103()
*              ~d1          c    !  c          ~d1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*               ~g |  d  |  H-   !  H- |  d  |  ~g                   
*             =====@==>==@--<----!--<--@==>==@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1434/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1434).EQ.0) CALL CC16103(C)
      S1=A(146)**2
      TOTNUM=+C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P1*(4*P2-C(2))+C(3)*P2-C(1)
      F16103=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16104()
*                                   !  H-   ~d1                      
*                                  /!--<--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~d1          c   |!  c  |  ~g                      
*                -->--\     /==>===+!==>==@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                  ~g |  d  |  H-  |!                                
*                =====@==>==@--<---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1434/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1434).EQ.0) CALL CC16104(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F16104=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16105()
*                                   !  H-   ~d1                      
*                                  /!--<--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~d1          c   |!  c  |  ~g                      
*                -->--\     /==>===+!==>==@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                  ~g |  d  |  H-  |!                                
*                =====@==>==@--<---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1434/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1434).EQ.0) CALL CC16105(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F16105=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16106()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1434/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1434).EQ.0) CALL CC16106(C)
      S1=A(146)**2
      TOTNUM=-C(3)*S1
      TOTDEN=+6
      RNUM=+C(2)*(P2-P1)-C(1)
      F16106=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16107()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1434/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1434).EQ.0) CALL CC16107(C)
      S1=A(146)**2
      TOTNUM=-C(3)*S1
      TOTDEN=+3
      RNUM=+C(2)*(P2-P1)-C(1)
      F16107=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16108()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                     ~g |  c    !  c  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1434/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1434).EQ.0) CALL CC16108(C)
      S1=A(146)**2
      TOTNUM=-C(3)*S1
      TOTDEN=+6
      RNUM=+C(2)*(P2-P1)-C(1)
      F16108=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16109()
*              ~d1          t    !  t          ~d1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*               ~g |  d  |  H-   !  H- |  d  |  ~g                   
*             =====@==>==@--<----!--<--@==>==@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1435/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1435).EQ.0) CALL CC16109(C)
      S1=A(146)**2
      TOTNUM=+C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P1*(4*P2-C(2))+C(3)*P2-C(1)
      F16109=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1610()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~o2 |  H-   !  H- | ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1610(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1610=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16110()
*                                   !  H-   ~d1                      
*                                  /!--<--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t1|-P6                       
*                 ~d1          t   |!  t  |  ~g                      
*                -->--\     /==>===+!==>==@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                  ~g |  d  |  H-  |!                                
*                =====@==>==@--<---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1435/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1435).EQ.0) CALL CC16110(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F16110=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16111()
*                                   !  H-   ~d1                      
*                                  /!--<--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~t2|-P6                       
*                 ~d1          t   |!  t  |  ~g                      
*                -->--\     /==>===+!==>==@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                  ~g |  d  |  H-  |!                                
*                =====@==>==@--<---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1435/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1435).EQ.0) CALL CC16111(C)
      S1=A(146)**2
      TOTNUM=-C(4)*S1
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F16111=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16112()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t1|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1435/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1435).EQ.0) CALL CC16112(C)
      S1=A(146)**2
      TOTNUM=-C(3)*S1
      TOTDEN=+6
      RNUM=+C(2)*(P2-P1)-C(1)
      F16112=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16113()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t1|P5     !  ~t2|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1435/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1435).EQ.0) CALL CC16113(C)
      S1=A(146)**2
      TOTNUM=-C(3)*S1
      TOTDEN=+3
      RNUM=+C(2)*(P2-P1)-C(1)
      F16113=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16114()
*                    ~d1    H-   !  H-   ~d1                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~t2|P5     !  ~t2|-P6                          
*                     ~g |  t    !  t  |  ~g                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1435/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1435).EQ.0) CALL CC16114(C)
      S1=A(146)**2
      TOTNUM=-C(3)*S1
      TOTDEN=+6
      RNUM=+C(2)*(P2-P1)-C(1)
      F16114=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16115()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16115(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16115=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16116()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16116(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16116=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16117()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16117(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16117=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16118()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16118(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16118=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16119()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16119(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16119=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1611()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  Z  | ~o2                      
*                =====@-->---+!-->--@---1-@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1611(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1611=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16120()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16120(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16120=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16121()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16121(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16121=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16122()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16122(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16122=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16123()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!   ~g|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16123(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16123=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16124()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16124(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16124=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16125()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16125(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16125=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16126()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16126(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16126=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16127()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16127(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16127=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16128()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16128(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16128=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16129()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16129(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16129=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1612()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  h  | ~o2                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1612(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F1612=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16130()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!   ~g|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16130(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16130=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16131()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16131(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16131=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16132()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16132(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16132=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(7)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16133()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16133(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16133=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16134()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16134(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16134=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16135()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!   ~g|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16135(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16135=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16136()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16136(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16136=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16137()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16137(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16137=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16138()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!   ~g|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16138(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16138=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16139()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                      ~g|P5     !   ~g|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16139(C)
      S1=A(146)**4
      TOTNUM=-16*S1
      TOTDEN=+9
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16139=RNUM*(TOTNUM/TOTDEN)*Q2(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q
     >0(6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1613()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  H  | ~o2                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1613(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F1613=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16140()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!   ~g|-P6                          
*                    ~c1    c   |!  c  | ~c1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                      ~g|P5    |!                                   
*                    ~c1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1436/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1436).EQ.0) CALL CC16140(C)
      S1=A(146)**4
      TOTNUM=-16*S1
      TOTDEN=+27
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16140=RNUM*(TOTNUM/TOTDEN)*Q1(10)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q
     >0(5)*Q0(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16141()
*                    ~c1    A    !  A    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  A    !  A  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1437/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1437).EQ.0) CALL CC16141(C)
      TOTNUM=+C(3)
      TOTDEN=+243
      RNUM=+P2*(P2-C(2))+C(1)
      F16141=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16142()
*                                !  A    ~c1                         
*                               /!---2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    A   |!  A  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  A   |!                                   
*                   --<--@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1437/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1437).EQ.0) CALL CC16142(C)
      TOTNUM=+C(3)
      TOTDEN=+243
      RNUM=+P1*(P1-C(2))+C(1)
      F16142=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16143()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    A    !  A  | ~C1                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~C1 |  A    !  A  |                             
*                   --<--@-2-----!---2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1437/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1437).EQ.0) CALL CC16143(C)
      TOTNUM=-C(2)
      TOTDEN=+243
      RNUM=+P1-C(1)+4*P2
      F16143=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16144()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  A    !  A  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  A    !  A  |                             
*                        \-1-----!---1-/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1437/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1437).EQ.0) CALL CC16144(C)
      TOTNUM=+C(1)
      TOTDEN=+243
      RNUM=+1
      F16144=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16145()
*                    ~c1    A    !  A    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  Z    !  Z  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1438/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1438).EQ.0) CALL CC16145(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)*P2-C(3))-C(2))+C(1)
      F16145=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16146()
*                                !  Z    ~c1                         
*                               /!---2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    A   |!  A  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  Z   |!                                   
*                   --<--@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1438/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1438).EQ.0) CALL CC16146(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      S1=P2**2
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(6)*S1-C(2))+P2*(C(4)-C(5)*P2)+C(1)
      F16146=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16147()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    A    !  A  | ~C1                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~C1 |  Z    !  Z  |                             
*                   --<--@-2-----!---2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1438/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1438).EQ.0) CALL CC16147(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F16147=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16148()
*                    ~c1    Z    !  Z    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  A    !  A  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1438/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1438).EQ.0) CALL CC16148(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(5)*P2-C(4)-C(6)*P1)+P2*(C(3)-C(5)*P2)-C(2))+P2*(P2
     >*(C(6)*P2-C(4))+C(2))+C(1)
      F16148=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16149()
*                    ~c1    Z    !       ~c1                         
*                   -->--@-1---\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~c1|P5   | !     |                             
*                    ~C1 |  A  | !  A  | ~C1                         
*                   --<--@-2---+-!---2-@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  Z  |                             
*                              \-!---1-/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1438/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1438).EQ.0) CALL CC16149(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F16149=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1614()
*                    ~o1    H-   !  H-   ~o1                         
*                   =====@--<----!--<--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~o2 |  H+   !  H+ | ~o2                         
*                   =====@-->----!-->--@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1614(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(1)-C(2)*P1
      F1614=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16150()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  A    !  A  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  Z    !  Z  |                             
*                        \-1-----!---1-/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1438/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1438).EQ.0) CALL CC16150(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F16150=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16151()
*                    ~c1    A    !  A    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  G    !  G  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1439/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1439).EQ.0) CALL CC16151(C)
      S1=A(146)**2
      TOTNUM=+C(3)*S1
      TOTDEN=+81
      RNUM=+P2*(P2-C(2))+C(1)
      F16151=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16152()
*                                !  G    ~c1                         
*                               /!---2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    A   |!  A  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  G   |!                                   
*                   --<--@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1439/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1439).EQ.0) CALL CC16152(C)
      S1=A(146)**2
      TOTNUM=+C(3)*S1
      TOTDEN=+81
      RNUM=+P1*(P1-C(2))+C(1)
      F16152=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16153()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    A    !  A  | ~C1                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~C1 |  G    !  G  |                             
*                   --<--@-2-----!---2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1439/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1439).EQ.0) CALL CC16153(C)
      S1=A(146)**2
      TOTNUM=-C(2)*S1
      TOTDEN=+81
      RNUM=+P1-C(1)+4*P2
      F16153=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16154()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  A    !  A  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1439/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1439).EQ.0) CALL CC16154(C)
      S1=A(146)**2
      TOTNUM=+C(1)*S1
      TOTDEN=+81
      S2=P2**2
      RNUM=+P1*(P1-2*P2)+S2
      F16154=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16155()
*                    ~c1    G    !       ~c1                         
*                   -->--@-1---\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~c1|P5   | !     |                             
*                    ~C1 |  A  | !  A  | ~C1                         
*                   --<--@-2---+-!---2-@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  G  |                             
*                              \-!---1-/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1439/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1439).EQ.0) CALL CC16155(C)
      S1=A(146)**2
      TOTNUM=+C(2)*S1
      TOTDEN=+81
      RNUM=+4*P2-C(1)-5*P1
      F16155=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16156()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  A    !  A  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  G    !  G  |                             
*                        \-1-----!---1-/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1439/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1439).EQ.0) CALL CC16156(C)
      S1=A(146)**2
      TOTNUM=+C(1)*S1
      TOTDEN=+81
      RNUM=+1
      F16156=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16157()
*                    ~c1    A    !  A    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1440/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1440).EQ.0) CALL CC16157(C)
      TOTNUM=+C(2)
      TOTDEN=+27
      RNUM=+P2-C(1)
      F16157=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16158()
*                                !  h    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    A   |!  A  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1440/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1440).EQ.0) CALL CC16158(C)
      TOTNUM=+C(2)
      TOTDEN=+27
      RNUM=+2*P1-C(1)
      F16158=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16159()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  A    !  A  | ~C1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1440/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1440).EQ.0) CALL CC16159(C)
      TOTNUM=-C(2)
      TOTDEN=+27
      RNUM=+2*(P2-P1)+C(1)
      F16159=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1615()
*                                !  H+   ~o1                         
*                               /!-->--@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~2+|-P6                          
*                    ~o1    H-  |!  H- | ~o2                         
*                   =====@--<---+!--<--@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~o2 |  H+  |!                                   
*                   =====@-->---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1615(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(2)*P1-C(1)
      F1615=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16160()
*                    ~c1    A    !  A    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1441/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1441).EQ.0) CALL CC16160(C)
      TOTNUM=+C(2)
      TOTDEN=+27
      RNUM=+P2-C(1)
      F16160=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16161()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    A   |!  A  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1441/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1441).EQ.0) CALL CC16161(C)
      TOTNUM=+C(2)
      TOTDEN=+27
      RNUM=+2*P1-C(1)
      F16161=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16162()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  A    !  A  | ~C1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1441/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1441).EQ.0) CALL CC16162(C)
      TOTNUM=-C(2)
      TOTDEN=+27
      RNUM=+2*(P2-P1)+C(1)
      F16162=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16163()
*                    ~c1    Z    !  Z    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  Z    !  Z  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16163(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      S1=P2**2
      RNUM=+S1*(C(3)*S1-C(2))+C(1)
      F16163=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16164()
*                                !  Z    ~c1                         
*                               /!---2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    Z   |!  Z  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  Z   |!                                   
*                   --<--@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(1442).EQ.0) CALL CC16164(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      S1=P1**2
      RNUM=+P2*(P2*(P1*(C(5)+C(8)*P1-C(7)*P2)+P2*(C(8)*P2-C(6))+C(4))+P1
     >*(-C(2)-C(3)*P1))+C(1)*S1
      F16164=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16165()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    Z    !  Z  | ~C1                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~C1 |  Z    !  Z  |                             
*                   --<--@-2-----!---2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16165(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(5)*P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16165=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16166()
*                 ~c1    Z    !  Z          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  Z    !  Z  |  h  | ~C1                      
*                --<--@-2-----!---2-@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16166(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(5)*P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16166=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16167()
*                 ~c1    Z    !  Z          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  Z    !  Z  |  H  | ~C1                      
*                --<--@-2-----!---2-@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16167(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(5)*P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16167=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16168()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  Z    !  Z  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  Z    !  Z  |                             
*                        \-1-----!---1-/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16168(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F16168=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16169()
*                 ~c1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~C1 |  Z    !  Z          ~c1                      
*                --<--@-2-----!---2-\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  Z    !  Z  |  h  | ~C1                      
*                     \-1-----!---1-@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16169(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F16169=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1616()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  Z  | ~o2                      
*                =====@-->----!-->--@---1-@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1616(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)+C(3))+C(1)-C(2)*P1
      F1616=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16170()
*                 ~c1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~C1 |  Z    !  Z          ~c1                      
*                --<--@-2-----!---2-\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  Z    !  Z  |  H  | ~C1                      
*                     \-1-----!---1-@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16170(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F16170=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16171()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  Z    !  Z  |  h  | ~C1                   
*             --<--@-----@-1-----!---1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16171(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F16171=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16172()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  Z    !  Z  |  H  | ~C1                   
*             --<--@-----@-1-----!---1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16172(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F16172=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16173()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  Z    !  Z  |  H  | ~C1                   
*             --<--@-----@-1-----!---1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1442/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1442).EQ.0) CALL CC16173(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F16173=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16174()
*                    ~c1    Z    !  Z    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  G    !  G  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1443/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1443).EQ.0) CALL CC16174(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(C(4)*P2-C(3))-C(2))+C(1)
      F16174=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16175()
*                                !  G    ~c1                         
*                               /!---2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    Z   |!  Z  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  G   |!                                   
*                   --<--@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1443/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1443).EQ.0) CALL CC16175(C)
      S1=A(146)**2
      TOTNUM=+C(7)*S1
      TOTDEN=+C(6)
      RNUM=+P1*(P2*(C(5)*(P2-P1)-C(3))+C(3)*P1-C(1))+P2*(C(2)-C(4)*P2)
      F16175=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16176()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    Z    !  Z  | ~C1                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~C1 |  G    !  G  |                             
*                   --<--@-2-----!---2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1443/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1443).EQ.0) CALL CC16176(C)
      S1=A(146)**2
      TOTNUM=+C(7)*S1
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F16176=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16177()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  Z    !  Z  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1443/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1443).EQ.0) CALL CC16177(C)
      S1=A(146)**2
      TOTNUM=-C(7)*S1
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(C(4)*P2-C(3)-C(5)*P1)+P2*(C(2)-C(4)*P2)-C(1))+P2*(P2
     >*(C(5)*P2-C(3))+C(1))
      F16177=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16178()
*                    ~c1    G    !       ~c1                         
*                   -->--@-1---\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~c1|P5   | !     |                             
*                    ~C1 |  Z  | !  Z  | ~C1                         
*                   --<--@-2---+-!---2-@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  G  |                             
*                              \-!---1-/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1443/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1443).EQ.0) CALL CC16178(C)
      S1=A(146)**2
      TOTNUM=+C(8)*S1
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F16178=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16179()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  Z    !  Z  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  G    !  G  |                             
*                        \-1-----!---1-/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1443/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1443).EQ.0) CALL CC16179(C)
      S1=A(146)**2
      TOTNUM=+C(3)*S1
      TOTDEN=+C(2)
      RNUM=+C(1)
      F16179=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1617()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  h  | ~o2                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1617(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F1617=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16180()
*                    ~c1    Z    !  Z    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1444/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1444).EQ.0) CALL CC16180(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+C(2)*S1-C(1)
      F16180=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16181()
*                 ~c1    Z    !  Z          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  h    !  h  |  Z  | ~C1                      
*                --<--@-------!-----@---2-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1444/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1444).EQ.0) CALL CC16181(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))+C(1)
      F16181=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16182()
*                                !  h    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    Z   |!  Z  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1444/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1444).EQ.0) CALL CC16182(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(3)*(P2-P1)-C(2))+C(1)*P1
      F16182=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16183()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  h    !  h  |  Z  | ~C1                   
*             --<--@-1---@-------!-----@---3-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1444/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1444).EQ.0) CALL CC16183(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(P1*(-C(4)-C(5)*P1)-C(3))-C(2)-C(7)*P2)+P2*(C(7)*P2-C
     >(6))-C(1)
      F16183=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16184()
*                                   !  h    ~c1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~c1          Z   |!  Z  | ~C1                      
*                -->--\     /-2----+!---2-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  h   |!                                
*                --<--@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1444/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1444).EQ.0) CALL CC16184(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+P2*(C(4)+C(7)*P2)-C
     >(1)
      F16184=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16185()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  Z    !  Z  | ~C1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1444/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1444).EQ.0) CALL CC16185(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F16185=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16186()
*                    ~c1    Z    !  Z    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1445/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1445).EQ.0) CALL CC16186(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+C(2)*S1-C(1)
      F16186=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16187()
*                 ~c1    Z    !  Z          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  H    !  H  |  Z  | ~C1                      
*                --<--@-------!-----@---2-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1445/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1445).EQ.0) CALL CC16187(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(6)*P2)+C(2)-C(5)*P2)+P2*(C(7)*P2-C(4))+C(1)
      F16187=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16188()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    Z   |!  Z  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1445/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1445).EQ.0) CALL CC16188(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(3)*(P2-P1)-C(2))+C(1)*P1
      F16188=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16189()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  H    !  H  |  Z  | ~C1                   
*             --<--@-1---@-------!-----@---3-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1445/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1445).EQ.0) CALL CC16189(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(P1*(-C(4)-C(5)*P1)-C(3))-C(2)-C(7)*P2)+P2*(C(7)*P2-C
     >(6))-C(1)
      F16189=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1618()
*                 ~o1    H-   !  H-         ~o1                      
*                =====@--<----!--<--\     /=====                     
*                  P1 |  P4   !  P4 |     |  P1                      
*                  ~2+|P5     !     |     |                          
*                 ~o2 |  H+   !  H+ |  H  | ~o2                      
*                =====@-->----!-->--@-----@=====                     
*                  P2    P3   !  P3   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1618(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)-C(2)*P1+C(3)*P2
      F1618=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16190()
*                                   !  H    ~c1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~c1          Z   |!  Z  | ~C1                      
*                -->--\     /-2----+!---2-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  H   |!                                
*                --<--@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1445/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1445).EQ.0) CALL CC16190(C)
      TOTNUM=-C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+P2*(C(4)+C(7)*P2)-C
     >(1)
      F16190=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16191()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  Z    !  Z  | ~C1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1445/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1445).EQ.0) CALL CC16191(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F16191=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16192()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H3   !  H3 |  h  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1446/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1446).EQ.0) CALL CC16192(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1)+C(1)
      F16192=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16193()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H3   !  H3 |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1446/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1446).EQ.0) CALL CC16193(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1)+C(1)
      F16193=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16194()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  H3   !  H3 |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1446/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1446).EQ.0) CALL CC16194(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1)+C(1)
      F16194=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16195()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16195(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16195=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16196()
*                             !  W-         ~c1                      
*                            /!--<2-\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    W+  |!  W+ |  A  | ~C1                      
*                -->--@-1>---+!-->1-@---3-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  W-  |!                                      
*                --<--@-2<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16196(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P1*(P2*(C(8)-P1+2*P2)+C(6)*P1-C(5))+P2*(C(7)-C(9)*P2)-C(
     >4))+P1*(C(2)-C(3)*P1)+C(1)
      F16196=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16197()
*                             !  W-         ~c1                      
*                            /!--<2-\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    W+  |!  W+ |  Z  | ~C1                      
*                -->--@-1>---+!-->1-@---3-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  W-  |!                                      
*                --<--@-2<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16197(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P1*(P2*(C(8)-C(9)*P1+C(11)*P2)+C(6)*P1-C(5))+P2*(C(7)-C(
     >10)*P2)-C(4))+P1*(C(2)-C(3)*P1)+C(1)
      F16197=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16198()
*                    ~c1    W+   !       ~c1                         
*                   -->--@-1>--\ !     /-->--                        
*                     P1 |  P3 | !     |  P1                         
*                     ~d1|P5   | !     |                             
*                    ~C1 |  W- | !  W- | ~C1                         
*                   --<--@-2<--+-!--<2-@--<--                        
*                     P2    P4 | !  P4 |  P2                         
*                              | !     |                             
*                              | !  W+ |                             
*                              \-!-->1-/                             
*                                !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16198(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16198=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16199()
*                             !  W-         ~c1                      
*                            /!--<2-\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    W+  |!  W+ |  h  | ~C1                      
*                -->--@-1>---+!-->1-@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  W-  |!                                      
*                --<--@-2<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16199(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16199=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1619()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~o2 |  H-   !  H- | ~o2                         
*                   =====@--<----!--<--@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1619(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1619=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F161()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o1 |  H  |  H3   !  H3 |  H  | ~o1                   
*             =====@-----@-------!-----@-----@=====                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U4/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(4).EQ.0) CALL CC161(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(P1*(C(3)+4*P1)-C(2))-C(1)
      F161=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16200()
*                             !  W-         ~c1                      
*                            /!--<2-\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    W+  |!  W+ |  H  | ~C1                      
*                -->--@-1>---+!-->1-@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  W-  |!                                      
*                --<--@-2<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16200(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16200=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16201()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16201(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16201=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16202()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16202(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16202=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16203()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16203(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16203=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16204()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  W+   !  W+ |  A  | ~C1                   
*             --<--@-1---@-2>----!-->2-@---4-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16204(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(P1*(C(4)+P1-4*P2)+P2*(C(7)+4*P2)-C(3))+P2*(-C(6)-C(9
     >)*P2)+C(2))+P2*(C(8)*P2-C(5))+C(1)
      F16204=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16205()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  W+   !  W+ |  Z  | ~C1                   
*             --<--@-1---@-2>----!-->2-@---4-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16205(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P1*(P1*(P1*(C(4)+C(5)*P1-C(11)*P2)+P2*(C(8)+C(11)*P2)-C(3))+
     >P2*(-C(7)-C(10)*P2)+C(2))+P2*(C(9)*P2-C(6))+C(1)
      F16205=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16206()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          W-   !  W- | ~C1                      
*                -->--\     /-3<----!--<3-@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  A  |  W+   !  W+ |                          
*                --<--@-1---@-2>----!-->2-/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16206(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(2*P2-C(3)-P1)+C(2)+C(5)*P2)+C(1)-C(4)*P2
      F16206=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16207()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  W+   !  W+ |  h  | ~C1                   
*             --<--@-1---@-2>----!-->2-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16207(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(2*P2-C(3)-P1)+C(2)+C(5)*P2)+C(1)-C(4)*P2
      F16207=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16208()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  W+   !  W+ |  H  | ~C1                   
*             --<--@-1---@-2>----!-->2-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16208(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(2*P2-C(3)-P1)+C(2)+C(5)*P2)+C(1)-C(4)*P2
      F16208=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16209()
*                                   !  W+   ~c1                      
*                                  /!-->2-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-3<---+!--<3-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  A  |  W+  |!                                
*                --<--@-1---@-2>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16209(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P1*(P2*(C(8)-P1+2*P2)+C(6)*P1-C(5))+P2*(C(7)-C(9)*P2)-C(
     >4))+P1*(C(2)-C(3)*P1)+C(1)
      F16209=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1620()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  Z  | ~o2                      
*                =====@-->---+!-->--@---1-@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1620(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1620=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16210()
*                                   !  W+   ~c1                      
*                                  /!-->2-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-3<---+!--<3-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  A  |  W+  |!                                
*                --<--@-1---@-2>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16210(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P1*(P2*(C(8)-P1+2*P2)+C(6)*P1-C(5))+P2*(C(7)-C(9)*P2)-C(
     >4))+P1*(C(2)-C(3)*P1)+C(1)
      F16210=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16211()
*                                   !  W+   ~c1                      
*                                  /!-->2-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-3<---+!--<3-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  A  |  W+  |!                                
*                --<--@-1---@-2>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16211(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P1*(P2*(C(8)-P1+2*P2)+C(6)*P1-C(5))+P2*(C(7)-C(9)*P2)-C(
     >4))+P1*(C(2)-C(3)*P1)+C(1)
      F16211=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16212()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  W+   !  W+ |  Z  | ~C1                   
*             --<--@-1---@-2>----!-->2-@---4-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16212(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P1*(P1*(P1*(C(4)+C(5)*P1-C(11)*P2)+P2*(C(8)+C(11)*P2)-C(3))+
     >P2*(-C(7)-C(10)*P2)+C(2))+P2*(C(9)*P2-C(6))+C(1)
      F16212=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16213()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          W-   !  W- | ~C1                      
*                -->--\     /-3<----!--<3-@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  Z  |  W+   !  W+ |                          
*                --<--@-1---@-2>----!-->2-/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16213(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(7)*P2-C(3)-C(4)*P1)+C(2)+C(6)*P2)+C(1)-C(5)*P2
      F16213=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16214()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  W+   !  W+ |  h  | ~C1                   
*             --<--@-1---@-2>----!-->2-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16214(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(7)*P2-C(3)-C(4)*P1)+C(2)+C(6)*P2)+C(1)-C(5)*P2
      F16214=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16215()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  W+   !  W+ |  H  | ~C1                   
*             --<--@-1---@-2>----!-->2-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16215(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(7)*P2-C(3)-C(4)*P1)+C(2)+C(6)*P2)+C(1)-C(5)*P2
      F16215=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16216()
*                                   !  W+   ~c1                      
*                                  /!-->2-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-3<---+!--<3-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  W+  |!                                
*                --<--@-1---@-2>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16216(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P1*(P2*(C(8)-C(9)*P1+C(11)*P2)+C(6)*P1-C(5))+P2*(C(7)-C(
     >10)*P2)-C(4))+P1*(C(2)-C(3)*P1)+C(1)
      F16216=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16217()
*                                   !  W+   ~c1                      
*                                  /!-->2-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-3<---+!--<3-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  W+  |!                                
*                --<--@-1---@-2>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16217(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P1*(P2*(C(8)-C(9)*P1+C(11)*P2)+C(6)*P1-C(5))+P2*(C(7)-C(
     >10)*P2)-C(4))+P1*(C(2)-C(3)*P1)+C(1)
      F16217=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16218()
*                                   !  W+   ~c1                      
*                                  /!-->2-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-3<---+!--<3-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  W+  |!                                
*                --<--@-1---@-2>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(1447).EQ.0) CALL CC16218(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P1*(P2*(C(8)-C(9)*P1+C(11)*P2)+C(6)*P1-C(5))+P2*(C(7)-C(
     >10)*P2)-C(4))+P1*(C(2)-C(3)*P1)+C(1)
      F16218=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16219()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  W+   !  W+ |                             
*                        \-1>----!-->1-/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16219(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F16219=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1621()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  h  | ~o2                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1621(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F1621=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16220()
*                 ~c1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~C1 |  W-   !  W-         ~c1                      
*                --<--@-2<----!--<2-\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  W+   !  W+ |  h  | ~C1                      
*                     \-1>----!-->1-@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16220(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F16220=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16221()
*                 ~c1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~C1 |  W-   !  W-         ~c1                      
*                --<--@-2<----!--<2-\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  W+   !  W+ |  H  | ~C1                      
*                     \-1>----!-->1-@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16221(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F16221=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16222()
*                    ~c1         !  W+   ~c1                         
*                   -->--\      /!-->1-@-->--                        
*                     P1 |      |!  P3 |  P1                         
*                        |      |!  ~s1|-P5                          
*                    ~C1 |  W-  |!  W- | ~C1                         
*                   --<--@-2<---+!--<2-@--<--                        
*                     P2 |  P4  |!  P4    P2                         
*                        |      |!                                   
*                        |  W+  |!                                   
*                        \-1>---/!                                   
*                           P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16222(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16222=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16223()
*                    ~c1         !  W+   ~c1                         
*                   -->--\      /!-->1-@-->--                        
*                     P1 |      |!  P3 |  P1                         
*                        |      |!  ~b1|-P5                          
*                    ~C1 |  W-  |!  W- | ~C1                         
*                   --<--@-2<---+!--<2-@--<--                        
*                     P2 |  P4  |!  P4    P2                         
*                        |      |!                                   
*                        |  W+  |!                                   
*                        \-1>---/!                                   
*                           P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16223(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16223=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16224()
*                    ~c1         !  W+   ~c1                         
*                   -->--\      /!-->1-@-->--                        
*                     P1 |      |!  P3 |  P1                         
*                        |      |!  ~b2|-P5                          
*                    ~C1 |  W-  |!  W- | ~C1                         
*                   --<--@-2<---+!--<2-@--<--                        
*                     P2 |  P4  |!  P4    P2                         
*                        |      |!                                   
*                        |  W+  |!                                   
*                        \-1>---/!                                   
*                           P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16224(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16224=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16225()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  W+   !  W+ |  h  | ~C1                   
*             --<--@-----@-1>----!-->1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16225(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F16225=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16226()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  W+   !  W+ |  H  | ~C1                   
*             --<--@-----@-1>----!-->1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16226(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F16226=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16227()
*                                   !  W+   ~c1                      
*                                  /!-->1-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-2<---+!--<2-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  W+  |!                                
*                --<--@-----@-1>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16227(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16227=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16228()
*                                   !  W+   ~c1                      
*                                  /!-->1-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-2<---+!--<2-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  W+  |!                                
*                --<--@-----@-1>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16228(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16228=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16229()
*                                   !  W+   ~c1                      
*                                  /!-->1-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-2<---+!--<2-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  W+  |!                                
*                --<--@-----@-1>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16229(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16229=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1622()
*                             !  H-         ~o1                      
*                            /!--<--\     /=====                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  H  | ~o2                      
*                =====@-->---+!-->--@-----@=====                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~o2 |  H-  |!                                      
*                =====@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1622(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(2)*P1-C(1)+C(3)*P2
      F1622=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16230()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  W+   !  W+ |  H  | ~C1                   
*             --<--@-----@-1>----!-->1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16230(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F16230=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16231()
*                                   !  W+   ~c1                      
*                                  /!-->1-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-2<---+!--<2-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  W+  |!                                
*                --<--@-----@-1>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16231(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16231=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16232()
*                                   !  W+   ~c1                      
*                                  /!-->1-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-2<---+!--<2-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  W+  |!                                
*                --<--@-----@-1>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16232(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16232=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16233()
*                                   !  W+   ~c1                      
*                                  /!-->1-@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-2<---+!--<2-@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  W+  |!                                
*                --<--@-----@-1>---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16233(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F16233=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16234()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16234(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16234=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16235()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16235(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16235=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16236()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16236(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16236=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16237()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16237(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16237=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16238()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16238(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16238=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16239()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1447/ Q0(7),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1447).EQ.0) CALL CC16239(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F16239=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1623()
*              ~o1          H-   !  H-         ~o1                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  H+   !  H+ |  Z  | ~o2                   
*             =====@-1---@-->----!-->--@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1623(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(8*(P2-P1)-C(3))+C(1)-C(2)*P1
      F1623=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16240()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16240(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16240=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16241()
*                 ~c1    W+   !  W+         ~c1                      
*                -->--@-1>----!-->1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~C1 |  H-   !  H- |  h  | ~C1                      
*                --<--@--<----!--<--@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16241(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16241=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16242()
*                 ~c1    W+   !  W+         ~c1                      
*                -->--@-1>----!-->1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~d1|P5     !     |     |                          
*                 ~C1 |  H-   !  H- |  H  | ~C1                      
*                --<--@--<----!--<--@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16242(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16242=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16243()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16243(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16243=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16244()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16244(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16244=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16245()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16245(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16245=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16246()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H-   !  H- |  h  | ~C1                   
*             --<--@-----@--<----!--<--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16246(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16246=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16247()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H-   !  H- |  H  | ~C1                   
*             --<--@-----@--<----!--<--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16247(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16247=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16248()
*                 ~c1          W+   !  W+   ~c1                      
*                -->--\     /-1>----!-->1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~C1 |  h  |  H-   !  H- | ~C1                      
*                --<--@-----@--<----!--<--@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16248(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16248=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16249()
*                 ~c1          W+   !  W+   ~c1                      
*                -->--\     /-1>----!-->1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~C1 |  h  |  H-   !  H- | ~C1                      
*                --<--@-----@--<----!--<--@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16249(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16249=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1624()
*              ~o1          H-   !  H-         ~o1                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H+   !  H+ |  h  | ~o2                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1624(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F1624=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16250()
*                 ~c1          W+   !  W+   ~c1                      
*                -->--\     /-1>----!-->1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~C1 |  h  |  H-   !  H- | ~C1                      
*                --<--@-----@--<----!--<--@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16250(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16250=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16251()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  H-   !  H- |  H  | ~C1                   
*             --<--@-----@--<----!--<--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16251(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16251=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16252()
*                 ~c1          W+   !  W+   ~c1                      
*                -->--\     /-1>----!-->1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~C1 |  H  |  H-   !  H- | ~C1                      
*                --<--@-----@--<----!--<--@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16252(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16252=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16253()
*                 ~c1          W+   !  W+   ~c1                      
*                -->--\     /-1>----!-->1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b1|-P6                       
*                 ~C1 |  H  |  H-   !  H- | ~C1                      
*                --<--@-----@--<----!--<--@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16253(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16253=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16254()
*                 ~c1          W+   !  W+   ~c1                      
*                -->--\     /-1>----!-->1-@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~b2|-P6                       
*                 ~C1 |  H  |  H-   !  H- | ~C1                      
*                --<--@-----@--<----!--<--@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16254(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16254=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16255()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16255(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16255=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16256()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16256(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16256=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16257()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16257(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16257=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16258()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16258(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16258=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16259()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16259(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16259=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1625()
*              ~o1          H-   !  H-         ~o1                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  H+   !  H+ |  H  | ~o2                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1625(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F1625=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16260()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1448/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1448).EQ.0) CALL CC16260(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16260=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16261()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16261(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16261=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16262()
*                             !  W-         ~c1                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H+  |!  H+ |  h  | ~C1                      
*                -->--@-->---+!-->--@-----@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16262(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16262=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16263()
*                             !  W-         ~c1                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H+  |!  H+ |  H  | ~C1                      
*                -->--@-->---+!-->--@-----@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16263(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16263=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16264()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16264(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16264=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16265()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16265(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16265=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16266()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16266(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16266=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16267()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H+   !  H+ |  h  | ~C1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16267(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16267=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16268()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H+   !  H+ |  H  | ~C1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16268(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16268=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16269()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-1<---+!--<1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16269(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16269=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1626()
*              ~o1          H-   !  H-         ~o1                   
*             =====\     /--<----!--<--\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  H+   !  H+ |  H  | ~o2                   
*             =====@-----@-->----!-->--@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U52/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(52).EQ.0) CALL CC1626(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P1-C(1)
      F1626=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16270()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-1<---+!--<1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16270(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16270=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16271()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-1<---+!--<1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16271(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16271=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16272()
*              ~c1          W-   !  W-         ~c1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  H+   !  H+ |  H  | ~C1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16272(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16272=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16273()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-1<---+!--<1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16273(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16273=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16274()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-1<---+!--<1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16274(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16274=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16275()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          W-  |!  W- | ~C1                      
*                -->--\     /-1<---+!--<1-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16275(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16275=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16276()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16276(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16276=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16277()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16277(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16277=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16278()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16278(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16278=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16279()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16279(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16279=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1627()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  A    !  A  | ~1+                         
*                   ==>==@-2-----!---2-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U53/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(53).EQ.0) CALL CC1627(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)+C(2))+P2*(-C
     >(4)-C(7)*P2)+C(1)
      F1627=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16280()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16280(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16280=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16281()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~C1 |  W-   !  W- | ~C1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1449/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1449).EQ.0) CALL CC16281(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16281=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16282()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  G    !  G  | ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16282(C)
      S1=A(146)**4
      TOTNUM=+256*S1
      TOTDEN=+27
      RNUM=+P2*(P2-C(2))+C(1)
      F16282=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16283()
*                                !  G    ~c1                         
*                               /!---2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    G   |!  G  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  G   |!                                   
*                   --<--@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16283(C)
      S1=A(146)**4
      TOTNUM=-8*S1
      TOTDEN=+27
      RNUM=+P1*(P1-C(2))+C(1)
      F16283=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16284()
*                 ~c1    G    !  G          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  G    !  G  |  G  | ~C1                      
*                --<--@-2-----!---2-@---3-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16284(C)
      S1=A(146)**4
      TOTNUM=-8*S1
      TOTDEN=+3
      S2=P2**2
      RNUM=+P1*(P1-C(2))+4*S2-C(1)
      F16284=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16285()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~0H|-P6                          
*                    ~C1 |  G    !  G  3 ~C1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16285(C)
      S1=A(146)**4
      TOTNUM=-32*S1
      TOTDEN=+27
      RNUM=+P1-C(1)+4*P2
      F16285=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16286()
*                                !  G    ~c1                         
*                               /!---2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~0H|-P6                          
*                    ~c1    G   |!  G  3 ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  G   |!                                   
*                   --<--@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16286(C)
      S1=A(146)**4
      TOTNUM=+4*S1
      TOTDEN=+27
      RNUM=+P1-C(1)+4*P2
      F16286=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16287()
*              ~c1          G    !  G          ~c1                   
*             -->--\     /-3-----!---3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  G  |  G    !  G  |  G  | ~C1                   
*             --<--@-1---@-2-----!---2-@---4-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16287(C)
      S1=A(146)**4
      TOTNUM=+16*S1
      TOTDEN=+3
      RNUM=+P1*(C(2)-P1-4*P2)+P2*(4*P2-C(3))+C(1)
      F16287=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16288()
*                 ~c1          G    !  G    ~c1                      
*                -->--\     /-3-----!---3-@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~0H|-P6                       
*                 ~C1 |  G  |  G    !  G  4 ~C1                      
*                --<--@-1---@-2-----!---2-@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16288(C)
      S1=A(146)**4
      TOTNUM=-8*S1
      TOTDEN=+1
      RNUM=+2*P2-C(1)-P1
      F16288=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16289()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-2-----!---2-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~0H|P5     !  ~0H|-P6                          
*                    ~C1 1  G    !  G  4 ~C1                         
*                   --<--@-3-----!---3-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16289(C)
      S1=A(146)**4
      TOTNUM=+64*S1
      TOTDEN=+27
      RNUM=+1
      F16289=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1628()
*                             !  A          ~o1                      
*                            /!---2-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    W+  |!  W+ |  W+ | ~1+                      
*                =====@-1>---+!-->1-@-->3-@==>==                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~1+ |  A   |!                                      
*                ==>==@-2----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U53/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(53).EQ.0) CALL CC1628(C)
      TOTNUM=+C(12)
      TOTDEN=+C(11)
      RNUM=+P1*(P1*(C(3)-C(4)*P1+C(7)*P2)+P2*(-C(6)-C(9)*P2)+C(2))+P2*(P
     >2*(C(8)+C(10)*P2)+C(5))-C(1)
      F1628=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16290()
*                                !  G    ~c1                         
*                               /!---3-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~0H|-P6                          
*                    ~c1    G   |!  G  4 ~C1                         
*                   -->--@-2----+!---2-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~0H|P5    |!                                   
*                    ~C1 1  G   |!                                   
*                   --<--@-3----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1450/ Q0(2),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1450).EQ.0) CALL CC16290(C)
      S1=A(146)**4
      TOTNUM=-8*S1
      TOTDEN=+27
      RNUM=+1
      F16290=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16291()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1451/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1451).EQ.0) CALL CC16291(C)
      S1=A(146)**2
      TOTNUM=+C(2)*S1
      TOTDEN=+9
      RNUM=+P2-C(1)
      F16291=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16292()
*                                !  h    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    G   |!  G  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1451/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1451).EQ.0) CALL CC16292(C)
      S1=A(146)**2
      TOTNUM=+C(2)*S1
      TOTDEN=+9
      RNUM=+2*P1-C(1)
      F16292=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16293()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  G    !  G  | ~C1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1451/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1451).EQ.0) CALL CC16293(C)
      S1=A(146)**2
      TOTNUM=-C(2)*S1
      TOTDEN=+9
      RNUM=+2*(P2-P1)+C(1)
      F16293=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16294()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1452/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1452).EQ.0) CALL CC16294(C)
      S1=A(146)**2
      TOTNUM=+C(2)*S1
      TOTDEN=+9
      RNUM=+P2-C(1)
      F16294=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16295()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    G   |!  G  | ~C1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1452/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1452).EQ.0) CALL CC16295(C)
      S1=A(146)**2
      TOTNUM=+C(2)*S1
      TOTDEN=+9
      RNUM=+2*P1-C(1)
      F16295=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16296()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  G    !  G  | ~C1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1452/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1452).EQ.0) CALL CC16296(C)
      S1=A(146)**2
      TOTNUM=-C(2)*S1
      TOTDEN=+9
      RNUM=+2*(P2-P1)+C(1)
      F16296=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16297()
*              ~c1          N1   !  N1         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  n1   !  n1 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1453/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1453).EQ.0) CALL CC16297(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16297=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16298()
*              ~c1          N2   !  N2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  n2   !  n2 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1454/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1454).EQ.0) CALL CC16298(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16298=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16299()
*              ~c1          N3   !  N3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  n3   !  n3 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1455/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1455).EQ.0) CALL CC16299(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16299=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1629()
*              ~o1          A    !  A          ~o1                   
*             =====\     /-3-----!---3-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  W+   !  W+ |  W+ | ~1+                   
*             ==>==@-1>--@-2>----!-->2-@-->4-@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U53/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(53).EQ.0) CALL CC1629(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(C(4)*P1-C(3)-C(7)*P2)+P2*(C(6)+C(9)*P2)-C(2))+P2*(-C
     >(5)-C(8)*P2)+C(1)
      F1629=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F162()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o1|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U4/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(4).EQ.0) CALL CC162(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(4*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F162=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16300()
*              ~c1          E1   !  E1         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e1   !  e1 |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1456/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1456).EQ.0) CALL CC16300(C)
      TOTNUM=-C(4)
      TOTDEN=+27
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16300=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16301()
*              ~c1          E1   !  E1         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e1   !  e1 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1456/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1456).EQ.0) CALL CC16301(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16301=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16302()
*              ~c1          E1   !  E1         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  e1   !  e1 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1456/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1456).EQ.0) CALL CC16302(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16302=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16303()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e2   !  e2 |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16303(C)
      TOTNUM=-C(4)
      TOTDEN=+27
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16303=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16304()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e2   !  e2 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16304(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16304=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16305()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e2   !  e2 |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16305(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16305=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16306()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e2   !  e2 |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16306(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16306=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16307()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  e2   !  e2 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16307(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+C(4)*P1)+C(2)-C(6)*P2)+P2*(C(6)*P2-C(5))+C(1)
      F16307=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16308()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  e2   !  e2 |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16308(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16308=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16309()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  e2   !  e2 |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16309(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16309=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1630()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  A    !  A  | ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U54/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(54).EQ.0) CALL CC1630(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1630=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16310()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  e2   !  e2 |  h  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16310(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16310=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16311()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  e2   !  e2 |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16311(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16311=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16312()
*              ~c1          E2   !  E2         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  e2   !  e2 |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1457/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1457).EQ.0) CALL CC16312(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16312=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16313()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e3   !  e3 |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16313(C)
      TOTNUM=-C(4)
      TOTDEN=+27
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16313=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16314()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e3   !  e3 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16314(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16314=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16315()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e3   !  e3 |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16315(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16315=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16316()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  e3   !  e3 |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16316(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16316=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16317()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  e3   !  e3 |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16317(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+C(4)*P1)+C(2)-C(6)*P2)+P2*(C(6)*P2-C(5))+C(1)
      F16317=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16318()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  e3   !  e3 |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16318(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16318=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16319()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  e3   !  e3 |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16319(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16319=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1631()
*                             !  A          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  H+ | ~1+                      
*                =====@-->---+!-->--@-->--@==>==                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~1+ |  A   |!                                      
*                ==>==@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U54/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(54).EQ.0) CALL CC1631(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F1631=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16320()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  e3   !  e3 |  h  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16320(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16320=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16321()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  e3   !  e3 |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16321(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16321=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16322()
*              ~c1          E3   !  E3         ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  e3   !  e3 |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1458/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1458).EQ.0) CALL CC16322(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16322=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16323()
*              ~c1          U    !  U          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  u    !  u  |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1459/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1459).EQ.0) CALL CC16323(C)
      TOTNUM=-C(4)
      TOTDEN=+81
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16323=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16324()
*              ~c1          U    !  U          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  u    !  u  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1459/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1459).EQ.0) CALL CC16324(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16324=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16325()
*              ~c1          U    !  U          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  u    !  u  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1459/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1459).EQ.0) CALL CC16325(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16325=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16326()
*              ~c1          U    !  U          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  G  |  u    !  u  |  G  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1459/ Q0(1),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1459).EQ.0) CALL CC16326(C)
      S1=A(146)**4
      TOTNUM=-32*S1
      TOTDEN=+9
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16326=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16327()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16327(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16327=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16328()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16328(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16328=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16329()
*                             !  D          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    d   |!  d  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  D   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16329(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16329=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1632()
*              ~o1          A    !  A          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  H+ |  H+   !  H+ |  H+ | ~1+                   
*             ==>==@-->--@-->----!-->--@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U54/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(54).EQ.0) CALL CC1632(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+C(3)*P1)-C(1)
      F1632=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16330()
*                             !  D          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    d   |!  d  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  D   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16330(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16330=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16331()
*                             !  D          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    d   |!  d  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  D   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16331(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16331=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16332()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16332(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16332=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16333()
*                             !  D          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    d   |!  d  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  D   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16333(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16333=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16334()
*                             !  D          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    d   |!  d  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  D   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16334(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16334=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16335()
*                             !  D          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    d   |!  d  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  D   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16335(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16335=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16336()
*              ~c1          D    !  D          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  d    !  d  |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16336(C)
      TOTNUM=-C(4)
      TOTDEN=+81
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16336=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16337()
*              ~c1          D    !  D          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  d    !  d  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16337(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16337=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16338()
*              ~c1          D    !  D          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  d    !  d  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16338(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16338=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16339()
*              ~c1          D    !  D          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  G  |  d    !  d  |  G  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1460/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1460).EQ.0) CALL CC16339(C)
      S1=A(146)**4
      TOTNUM=-32*S1
      TOTDEN=+9
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16339=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1633()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-2-----!---2-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1633(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P2*(P1*(P1*(C(7)-C(12)*P1+C(11)*P2)+P2*(-C(9)-C(11)*P2)-C(6)
     >)+P2*(P2*(C(10)+C(12)*P2)+C(8))+C(5))+P1*(P1*(C(3)-C(4)*P1)-C(2))-
     >C(1)
      F1633=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16340()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1461/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1461).EQ.0) CALL CC16340(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16340=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16341()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1461/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1461).EQ.0) CALL CC16341(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16341=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16342()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1461/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1461).EQ.0) CALL CC16342(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16342=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16343()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1462/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1462).EQ.0) CALL CC16343(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16343=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16344()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1462/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1462).EQ.0) CALL CC16344(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16344=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16345()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1462/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1462).EQ.0) CALL CC16345(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16345=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16346()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1463/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1463).EQ.0) CALL CC16346(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16346=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16347()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1463/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1463).EQ.0) CALL CC16347(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16347=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16348()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1463/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1463).EQ.0) CALL CC16348(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16348=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16349()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1464/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1464).EQ.0) CALL CC16349(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16349=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1634()
*                             !  Z          ~o1                      
*                            /!---2-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    W+  |!  W+ |  W+ | ~1+                      
*                =====@-1>---+!-->1-@-->3-@==>==                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~1+ |  Z   |!                                      
*                ==>==@-2----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1634(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P1*(P2*(P1*(C(12)*P1-C(7)-C(10)*P2)+P2*(C(9)+C(12)*P2)+C(6))
     >+P1*(C(4)*P1-C(3))+C(2))+P2*(P2*(-C(8)-C(11)*P2)-C(5))+C(1)
      F1634=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16350()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1464/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1464).EQ.0) CALL CC16350(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16350=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16351()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  D    !  D  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1464/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1464).EQ.0) CALL CC16351(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16351=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16352()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16352(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16352=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16353()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16353(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16353=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16354()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16354(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16354=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16355()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16355(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16355=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16356()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16356(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16356=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16357()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16357(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16357=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16358()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16358(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16358=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16359()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16359(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16359=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1635()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-2-----!---2-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1635(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P2*(P1*(P1*(C(7)-C(12)*P1+C(11)*P2)+P2*(-C(9)-C(11)*P2)-C(6)
     >)+P2*(P2*(C(10)+C(12)*P2)+C(8))+C(5))+P1*(P1*(C(3)-C(4)*P1)-C(2))-
     >C(1)
      F1635=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16360()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16360(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16360=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16361()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16361(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16361=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16362()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16362(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16362=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16363()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16363(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16363=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16364()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16364(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16364=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16365()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16365(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16365=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16366()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16366(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16366=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(9)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16367()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16367(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16367=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16368()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16368(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16368=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16369()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16369(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16369=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1636()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1636(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F1636=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16370()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16370(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16370=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16371()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16371(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16371=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16372()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16372(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16372=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16373()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16373(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16373=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(9)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16374()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16374(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16374=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16375()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16375(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16375=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16376()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16376(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16376=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16377()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16377(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16377=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16378()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16378(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16378=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16379()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16379(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16379=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1637()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1637(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F1637=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16380()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16380(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16380=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16381()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16381(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16381=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16382()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                      ~g|P5     !   ~g|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16382(C)
      S1=A(146)**4
      TOTNUM=-16*S1
      TOTDEN=+9
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16382=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16383()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                   ~g|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16383(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+81
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16383=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16384()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                   ~g|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16384(C)
      S1=A(146)**2
      TOTNUM=-C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16384=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16385()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                   ~g|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16385(C)
      S1=A(146)**4
      TOTNUM=+32*S1
      TOTDEN=+27
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16385=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16386()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                   ~g|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16386(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16386=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16387()
*                             !  C          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    c   |!  c  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                   ~g|P5    |!                                      
*                 ~C1 |  C   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16387(C)
      S1=A(146)**2
      TOTNUM=+C(5)*S1
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16387=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16388()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  c    !  c  |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16388(C)
      TOTNUM=-C(4)
      TOTDEN=+81
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16388=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16389()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  c    !  c  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16389(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16389=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1638()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1638(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F1638=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16390()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  c    !  c  |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16390(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16390=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16391()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  c    !  c  |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16391(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16391=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16392()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  c    !  c  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16392(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+C(4)*P1)+C(2)-C(6)*P2)+P2*(C(6)*P2-C(5))+C(1)
      F16392=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16393()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  c    !  c  |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16393(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16393=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16394()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  c    !  c  |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16394(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16394=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16395()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  G  |  c    !  c  |  G  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16395(C)
      S1=A(146)**4
      TOTNUM=-32*S1
      TOTDEN=+9
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16395=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16396()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  c    !  c  |  h  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16396(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16396=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16397()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  c    !  c  |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16397(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16397=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16398()
*              ~c1          C    !  C          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  c    !  c  |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1465/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1465).EQ.0) CALL CC16398(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16398=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16399()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16399(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16399=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1639()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1639(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F1639=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F163()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~o1 |  H  |  H3   !  H3 | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U4/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(4).EQ.0) CALL CC163(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F163=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16400()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16400(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16400=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16401()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16401(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16401=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16402()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16402(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16402=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16403()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16403(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16403=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16404()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16404(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16404=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16405()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16405(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16405=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16406()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16406(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16406=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16407()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16407(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16407=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16408()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16408(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16408=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16409()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16409(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16409=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1640()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-3-----!---3-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  W+ |  W+   !  W+ |  W+ | ~1+                   
*             ==>==@-1>--@-2>----!-->2-@-->4-@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1640(C)
      TOTNUM=+C(12)
      TOTDEN=+C(11)
      RNUM=+P1*(P1*(P2*(C(10)*(P2-P1)+C(7))+C(3)-C(4)*P1)+P2*(-C(6)-C(9)
     >*P2)-C(2))+P2*(C(5)+C(8)*P2)-C(1)
      F1640=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16410()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16410(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16410=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16411()
*                             !  S          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    s   |!  s  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  S   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16411(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16411=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16412()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  s    !  s  |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16412(C)
      TOTNUM=-C(4)
      TOTDEN=+81
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16412=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16413()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  s    !  s  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16413(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16413=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16414()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  s    !  s  |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16414(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16414=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16415()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  s    !  s  |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16415(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16415=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16416()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  s    !  s  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16416(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+C(4)*P1)+C(2)-C(6)*P2)+P2*(C(6)*P2-C(5))+C(1)
      F16416=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16417()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  s    !  s  |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16417(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16417=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16418()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  s    !  s  |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16418(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16418=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16419()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  G  |  s    !  s  |  G  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16419(C)
      S1=A(146)**4
      TOTNUM=-32*S1
      TOTDEN=+9
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16419=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1641()
*                                   !  W+   ~o1                      
*                                  /!-->2-@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~2+|-P6                       
*                 ~o1          Z   |!  Z  | ~1+                      
*                =====\     /-3----+!---3-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  W+ |  W+  |!                                
*                ==>==@-1>--@-2>---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1641(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P1*(P2*(P1*(C(12)*P1-C(7)-C(10)*P2)+P2*(C(9)+C(12)*P2)+C(6))
     >+P1*(C(4)*P1-C(3))+C(2))+P2*(P2*(-C(8)-C(11)*P2)-C(5))+C(1)
      F1641=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16420()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  s    !  s  |  h  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16420(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16420=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16421()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  s    !  s  |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16421(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16421=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16422()
*              ~c1          S    !  S          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  s    !  s  |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1466/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1466).EQ.0) CALL CC16422(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16422=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16423()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1467/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1467).EQ.0) CALL CC16423(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16423=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16424()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1467/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1467).EQ.0) CALL CC16424(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16424=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16425()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1467/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1467).EQ.0) CALL CC16425(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16425=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16426()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1468/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1468).EQ.0) CALL CC16426(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16426=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16427()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1468/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1468).EQ.0) CALL CC16427(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16427=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16428()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  S    !  S  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1468/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1468).EQ.0) CALL CC16428(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16428=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16429()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  t    !  t  |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16429(C)
      TOTNUM=-C(4)
      TOTDEN=+81
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16429=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1642()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-3-----!---3-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o1|-P6                       
*                 ~1+ |  W+ |  W+   !  W+ | ~1+                      
*                ==>==@-1>--@-2>----!-->2-@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1642(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P1*(P2*(C(10)*(P2-P1)+C(8))+C(5)-C(6)*P1)+P2*(-C(7)-C(9)
     >*P2)+C(4))+P1*(C(3)*P1-C(2))+C(1)
      F1642=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16430()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  t    !  t  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16430(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16430=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16431()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  t    !  t  |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16431(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16431=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16432()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  t    !  t  |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16432(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16432=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16433()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  t    !  t  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16433(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+C(4)*P1)+C(2)-C(6)*P2)+P2*(C(6)*P2-C(5))+C(1)
      F16433=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16434()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  t    !  t  |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16434(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16434=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16435()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  t    !  t  |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16435(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16435=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16436()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  G  |  t    !  t  |  G  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16436(C)
      S1=A(146)**4
      TOTNUM=-32*S1
      TOTDEN=+9
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16436=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16437()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  t    !  t  |  h  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16437(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16437=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16438()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  t    !  t  |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16438(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16438=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16439()
*              ~c1          T    !  T          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  t    !  t  |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1469/ Q0(3),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1469).EQ.0) CALL CC16439(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16439=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1643()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-3-----!---3-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~1+ |  W+ |  W+   !  W+ | ~1+                      
*                ==>==@-1>--@-2>----!-->2-@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1643(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P1*(P2*(C(10)*(P2-P1)+C(8))+C(5)-C(6)*P1)+P2*(-C(7)-C(9)
     >*P2)+C(4))+P1*(C(3)*P1-C(2))+C(1)
      F1643=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16440()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16440(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16440=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16441()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16441(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16441=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16442()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16442(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16442=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16443()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16443(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16443=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16444()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16444(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16444=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16445()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16445(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16445=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16446()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16446(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16446=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16447()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~C1 |  B    !  B  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16447(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16447=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16448()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  A  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16448(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16448=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16449()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  Z  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16449(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16449=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1644()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-3-----!---3-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~1+ |  W+ |  W+   !  W+ | ~1+                      
*                ==>==@-1>--@-2>----!-->2-@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1644(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P1*(P2*(C(10)*(P2-P1)+C(8))+C(5)-C(6)*P1)+P2*(-C(7)-C(9)
     >*P2)+C(4))+P1*(C(3)*P1-C(2))+C(1)
      F1644=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16450()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  G  | ~C1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16450(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16450=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16451()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  h  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16451(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16451=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16452()
*                             !  B          ~c1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    b   |!  b  |  H  | ~C1                      
*                -->--@==>===+!==>==@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~C1 |  B   |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16452(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16452=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16453()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  b    !  b  |  A  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16453(C)
      TOTNUM=-C(4)
      TOTDEN=+81
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16453=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16454()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  b    !  b  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16454(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16454=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16455()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  b    !  b  |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16455(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16455=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16456()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  b    !  b  |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16456(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F16456=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16457()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  b    !  b  |  Z  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16457(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(3)+C(4)*P1)+C(2)-C(6)*P2)+P2*(C(6)*P2-C(5))+C(1)
      F16457=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16458()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  b    !  b  |  h  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16458(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16458=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16459()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  b    !  b  |  H  | ~C1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16459(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16459=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1645()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-3-----!---3-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o4|-P6                       
*                 ~1+ |  W+ |  W+   !  W+ | ~1+                      
*                ==>==@-1>--@-2>----!-->2-@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1645(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P1*(P2*(C(10)*(P2-P1)+C(8))+C(5)-C(6)*P1)+P2*(-C(7)-C(9)
     >*P2)+C(4))+P1*(C(3)*P1-C(2))+C(1)
      F1645=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16460()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  G  |  b    !  b  |  G  | ~C1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16460(C)
      S1=A(146)**4
      TOTNUM=-32*S1
      TOTDEN=+9
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16460=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16461()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  b    !  b  |  h  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16461(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16461=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16462()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  b    !  b  |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16462(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16462=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16463()
*              ~c1          B    !  B          ~c1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  b    !  b  |  H  | ~C1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1470/ Q0(5),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1470).EQ.0) CALL CC16463(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F16463=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16464()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16464(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16464=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16465()
*                                !  h    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    h   |!  h  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16465(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16465=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16466()
*                 ~c1    h    !  h          ~c1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  h    !  h  |  h  | ~C1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16466(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16466=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16467()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    h    !  h  | ~C1                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~C1 |  h    !  h  |                             
*                   --<--@-------!-----/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16467(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16467=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16468()
*                 ~c1    h    !  h          ~c1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  h    !  h  |  H  | ~C1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16468(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16468=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16469()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16469(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16469=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1646()
*                    ~o1    W+   !  W+   ~o1                         
*                   =====@-1>----!-->1-@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-2-----!---2-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(14)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1646(C)
      TOTNUM=+C(14)
      TOTDEN=+C(13)
      RNUM=+P2*(P1*(P1*(C(7)-C(12)*P1+C(11)*P2)+P2*(-C(9)-C(11)*P2)-C(6)
     >)+P2*(P2*(C(10)+C(12)*P2)+C(8))+C(5))+P1*(P1*(C(3)-C(4)*P1)-C(2))-
     >C(1)
      F1646=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16470()
*                                !  h    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    h   |!  h  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16470(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16470=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16471()
*              ~c1          h    !  h          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  h    !  h  |  h  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16471(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16471=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16472()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          h    !  h  | ~C1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  h  |  h    !  h  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16472(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16472=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16473()
*              ~c1          h    !  h          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  h    !  h  |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16473(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16473=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16474()
*                 ~c1          h    !  h    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  h  |  h    !  h  | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16474(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16474=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16475()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  h    !  h  |                             
*                        \-------!-----/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16475(C)
      TOTNUM=+C(1)
      TOTDEN=+6
      RNUM=+1
      F16475=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16476()
*                 ~c1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~C1 |  h    !  h          ~c1                      
*                --<--@-------!-----\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  h    !  h  |  H  | ~C1                      
*                     \-------!-----@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16476(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16476=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16477()
*                    ~c1         !                                   
*                   -->--\       !                                   
*                     P1 |       !                                   
*                        |       !                                   
*                    ~C1 |  h    !  h    ~c1                         
*                   --<--@-------!-----@-->--                        
*                     P2 |  P4   !  P4 |  P1                         
*                        |       !  ~c2|-P5                          
*                        |  h    !  h  | ~C1                         
*                        \-------!-----@--<--                        
*                           P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16477(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16477=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16478()
*              ~c1          h    !  h          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  h    !  h  |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16478(C)
      TOTNUM=+C(1)
      TOTDEN=+6
      RNUM=+1
      F16478=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16479()
*                 ~c1          h    !  h    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  H  |  h    !  h  | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16479(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16479=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1647()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1647(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F1647=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16480()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16480(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16480=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16481()
*                                !  h    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    h   |!  h  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c2|P5    |!                                   
*                    ~C1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1471/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1471).EQ.0) CALL CC16481(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16481=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16482()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16482(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16482=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16483()
*                 ~c1    h    !  h          ~c1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  H    !  H  |  h  | ~C1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16483(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16483=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16484()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    h   |!  h  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16484(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16484=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16485()
*                 ~c1    h    !  h          ~c1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  H    !  H  |  H  | ~C1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16485(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16485=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16486()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    h    !  h  | ~C1                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~C1 |  H    !  H  |                             
*                   --<--@-------!-----/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16486(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16486=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16487()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16487(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16487=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16488()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    h   |!  h  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16488(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16488=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16489()
*              ~c1          h    !  h          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H    !  H  |  h  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16489(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16489=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1648()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1648(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F1648=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16490()
*                                   !  H    ~c1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~c1          h   |!  h  | ~C1                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H   |!                                
*                --<--@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16490(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16490=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16491()
*              ~c1          h    !  h          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H    !  H  |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16491(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16491=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16492()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          h    !  h  | ~C1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  h  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16492(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16492=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16493()
*                 ~c1          h    !  h    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  h  |  H    !  H  | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16493(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16493=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16494()
*                                   !  H    ~c1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~c1          h   |!  h  | ~C1                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H   |!                                
*                --<--@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16494(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16494=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16495()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16495(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16495=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16496()
*                             !  h          ~c1                      
*                            /!-----\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H   |!  H  |  H  | ~C1                      
*                -->--@------+!-----@-----@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~C1 |  h   |!                                      
*                --<--@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16496(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16496=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16497()
*                    ~c1    H    !       ~c1                         
*                   -->--@-----\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~c1|P5   | !     |                             
*                    ~C1 |  h  | !  h  | ~C1                         
*                   --<--@-----+-!-----@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  H  |                             
*                              \-!-----/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16497(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16497=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16498()
*                                !  h    ~c1                         
*                               /!-----@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    H   |!  H  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16498(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16498=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16499()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16499(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16499=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1649()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1649(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F1649=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F164()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o2|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U4/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(4).EQ.0) CALL CC164(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F164=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16500()
*              ~c1          h    !  h          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  H    !  H  |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16500(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16500=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16501()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          h    !  h  | ~C1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  H  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16501(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16501=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16502()
*                 ~c1          h    !  h    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  H  |  H    !  H  | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16502(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16502=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16503()
*                                   !  H    ~c1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~c1          h   |!  h  | ~C1                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  H   |!                                
*                --<--@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16503(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16503=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16504()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  H    !  H  |                             
*                        \-------!-----/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16504(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16504=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16505()
*                    ~c1         !                                   
*                   -->--\       !                                   
*                     P1 |       !                                   
*                        |       !                                   
*                    ~C1 |  h    !  h    ~c1                         
*                   --<--@-------!-----@-->--                        
*                     P2 |  P3   !  P3 |  P1                         
*                        |       !  ~c2|-P5                          
*                        |  H    !  H  | ~C1                         
*                        \-------!-----@--<--                        
*                           P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16505(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16505=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16506()
*                    ~c1         !  H    ~c1                         
*                   -->--\      /!-----@-->--                        
*                     P1 |      |!  P4 |  P1                         
*                        |      |!  ~c2|-P5                          
*                    ~C1 |  h   |!  h  | ~C1                         
*                   --<--@------+!-----@--<--                        
*                     P2 |  P3  |!  P3    P2                         
*                        |      |!                                   
*                        |  H   |!                                   
*                        \------/!                                   
*                           P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16506(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16506=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16507()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16507(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16507=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16508()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    h   |!  h  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c2|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16508(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16508=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16509()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1472/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1472).EQ.0) CALL CC16509(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16509=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1650()
*                                !  Z    ~o1                         
*                               /!---2-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    W+  |!  W+ | ~1+                         
*                   =====@-1>---+!-->1-@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-2----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1650(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P2*(P1*(C(11)*P1-C(8)-C(10)*P2)+P2*(C(9)+C(11)*P2)+C(7))
     >+P1*(C(6)*P1-C(5))-C(4))+P1*(C(2)-C(3)*P1)-C(1)
      F1650=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16510()
*              ~c1          h    !  h          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  H3   !  H3 |  Z  | ~C1                   
*             --<--@-1---@-------!-----@---2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1473/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1473).EQ.0) CALL CC16510(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(-C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F16510=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16511()
*                 ~c1          h    !  h    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  Z  |  H3   !  H3 | ~C1                      
*                --<--@-1---@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1473/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1473).EQ.0) CALL CC16511(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16511=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16512()
*                                   !  H3   ~c1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~c1          h   |!  h  | ~C1                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  H3  |!                                
*                --<--@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1473/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1473).EQ.0) CALL CC16512(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16512=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16513()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H3   !  H3 | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1473/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1473).EQ.0) CALL CC16513(C)
      TOTNUM=-C(1)
      TOTDEN=+3
      RNUM=+1
      F16513=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16514()
*                                !  H3   ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    h   |!  h  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c2|P5    |!                                   
*                    ~C1 |  H3  |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1473/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1473).EQ.0) CALL CC16514(C)
      TOTNUM=-C(1)
      TOTDEN=+3
      RNUM=+1
      F16514=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16515()
*                    ~c1    H3   !  H3   ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  h    !  h  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1473/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1473).EQ.0) CALL CC16515(C)
      TOTNUM=-C(1)
      TOTDEN=+3
      RNUM=+1
      F16515=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16516()
*              ~c1          H    !  H          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H    !  H  |  h  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16516(C)
      TOTNUM=+C(1)
      TOTDEN=+6
      RNUM=+1
      F16516=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16517()
*                 ~c1          H    !  H    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~C1 |  h  |  H    !  H  | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16517(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16517=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16518()
*              ~c1          H    !  H          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H    !  H  |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16518(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16518=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16519()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          H    !  H  | ~C1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  h  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16519(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16519=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1651()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1651(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))-C(5)-C(6)*P1)+C(3)+C(4)*P1)+C
     >(2)*P1-C(1)
      F1651=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16520()
*                 ~c1          H    !  H    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  h  |  H    !  H  | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16520(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16520=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16521()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16521(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16521=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16522()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~c1    H   |!  H  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16522(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16522=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16523()
*                 ~c1    H    !  H          ~c1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~C1 |  H    !  H  |  H  | ~C1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16523(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16523=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16524()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    H    !  H  | ~C1                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~C1 |  H    !  H  |                             
*                   --<--@-------!-----/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16524(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16524=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16525()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16525(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16525=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16526()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    H   |!  H  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16526(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16526=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16527()
*              ~c1          H    !  H          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  H    !  H  |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16527(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16527=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16528()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          H    !  H  | ~C1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  H  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16528(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16528=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16529()
*                 ~c1          H    !  H    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  H  |  H    !  H  | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16529(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16529=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1652()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1652(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1652=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16530()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H    !  H  |                             
*                        \-------!-----/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16530(C)
      TOTNUM=+C(1)
      TOTDEN=+6
      RNUM=+1
      F16530=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16531()
*                    ~c1         !                                   
*                   -->--\       !                                   
*                     P1 |       !                                   
*                        |       !                                   
*                    ~C1 |  H    !  H    ~c1                         
*                   --<--@-------!-----@-->--                        
*                     P2 |  P4   !  P4 |  P1                         
*                        |       !  ~c2|-P5                          
*                        |  H    !  H  | ~C1                         
*                        \-------!-----@--<--                        
*                           P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16531(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16531=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16532()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16532(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16532=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16533()
*                                !  H    ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    H   |!  H  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c2|P5    |!                                   
*                    ~C1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1474/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1474).EQ.0) CALL CC16533(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16533=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16534()
*              ~c1          H    !  H          ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  H3   !  H3 |  Z  | ~C1                   
*             --<--@-1---@-------!-----@---2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1475/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1475).EQ.0) CALL CC16534(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(-C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F16534=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16535()
*                 ~c1          H    !  H    ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  Z  |  H3   !  H3 | ~C1                      
*                --<--@-1---@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1475/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1475).EQ.0) CALL CC16535(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16535=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16536()
*                                   !  H3   ~c1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~c1          H   |!  H  | ~C1                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  H3  |!                                
*                --<--@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1475/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1475).EQ.0) CALL CC16536(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F16536=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16537()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H3   !  H3 | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1475/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1475).EQ.0) CALL CC16537(C)
      TOTNUM=-C(1)
      TOTDEN=+3
      RNUM=+1
      F16537=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16538()
*                                !  H3   ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    H   |!  H  | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c2|P5    |!                                   
*                    ~C1 |  H3  |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1475/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1475).EQ.0) CALL CC16538(C)
      TOTNUM=-C(1)
      TOTDEN=+3
      RNUM=+1
      F16538=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16539()
*                    ~c1    H3   !  H3   ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H    !  H  | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1475/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1475).EQ.0) CALL CC16539(C)
      TOTNUM=-C(1)
      TOTDEN=+3
      RNUM=+1
      F16539=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1653()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1653(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1653=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16540()
*              ~c1          H3   !  H3         ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H3   !  H3 |  h  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16540(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16540=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16541()
*              ~c1          H3   !  H3         ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H3   !  H3 |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16541(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16541=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16542()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          H3   !  H3 | ~C1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  h  |  H3   !  H3 |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16542(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16542=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16543()
*                 ~c1          H3   !  H3   ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  h  |  H3   !  H3 | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16543(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16543=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16544()
*              ~c1          H3   !  H3         ~c1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  H3   !  H3 |  H  | ~C1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16544(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16544=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16545()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          H3   !  H3 | ~C1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  H  |  H3   !  H3 |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16545(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16545=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16546()
*                 ~c1          H3   !  H3   ~c1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~C1 |  H  |  H3   !  H3 | ~C1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16546(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16546=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16547()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  H3   !  H3 | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H3   !  H3 |                             
*                        \-------!-----/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16547(C)
      TOTNUM=+C(1)
      TOTDEN=+6
      RNUM=+1
      F16547=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16548()
*                    ~c1         !                                   
*                   -->--\       !                                   
*                     P1 |       !                                   
*                        |       !                                   
*                    ~C1 |  H3   !  H3   ~c1                         
*                   --<--@-------!-----@-->--                        
*                     P2 |  P4   !  P4 |  P1                         
*                        |       !  ~c2|-P5                          
*                        |  H3   !  H3 | ~C1                         
*                        \-------!-----@--<--                        
*                           P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16548(C)
      TOTNUM=-C(1)
      TOTDEN=+3
      RNUM=+1
      F16548=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16549()
*                    ~c1    H3   !  H3   ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~C1 |  H3   !  H3 | ~C1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16549(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16549=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1654()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1654(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1654=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16550()
*                                !  H3   ~c1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~c1    H3  |!  H3 | ~C1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c2|P5    |!                                   
*                    ~C1 |  H3  |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1476/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1476).EQ.0) CALL CC16550(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16550=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16551()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16551(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16551=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16552()
*                             !  H-         ~c1                      
*                            /!--<--\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H+  |!  H+ |  A  | ~C1                      
*                -->--@-->---+!-->--@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  H-  |!                                      
*                --<--@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16552(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+2*P2-C(1)-P1
      F16552=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(9)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16553()
*                             !  H-         ~c1                      
*                            /!--<--\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H+  |!  H+ |  Z  | ~C1                      
*                -->--@-->---+!-->--@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  H-  |!                                      
*                --<--@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16553(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16553=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16554()
*                             !  H-         ~c1                      
*                            /!--<--\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H+  |!  H+ |  h  | ~C1                      
*                -->--@-->---+!-->--@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  H-  |!                                      
*                --<--@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16554(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16554=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16555()
*                             !  H-         ~c1                      
*                            /!--<--\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H+  |!  H+ |  H  | ~C1                      
*                -->--@-->---+!-->--@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~d1|P5    |!                                      
*                 ~C1 |  H-  |!                                      
*                --<--@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16555(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16555=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16556()
*                    ~c1    H+   !       ~c1                         
*                   -->--@-->--\ !     /-->--                        
*                     P1 |  P3 | !     |  P1                         
*                     ~d1|P5   | !     |                             
*                    ~C1 |  H- | !  H- | ~C1                         
*                   --<--@--<--+-!--<--@--<--                        
*                     P2    P4 | !  P4 |  P2                         
*                              | !     |                             
*                              | !  H+ |                             
*                              \-!-->--/                             
*                                !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16556(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16556=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16557()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16557(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16557=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16558()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~s2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16558(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16558=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16559()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16559(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16559=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1655()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1655(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1655=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16560()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16560(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16560=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16561()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  H+   !  H+ |  A  | ~C1                   
*             --<--@-1---@-->----!-->--@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16561(C)
      TOTNUM=+C(4)
      TOTDEN=+27
      RNUM=+P1*(C(2)+P1-4*P2)+P2*(4*P2-C(3))+C(1)
      F16561=RNUM*(TOTNUM/TOTDEN)*Q2(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16562()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  H+   !  H+ |  Z  | ~C1                   
*             --<--@-1---@-->----!-->--@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16562(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16562=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16563()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  H+   !  H+ |  h  | ~C1                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16563(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+2*P2-C(1)-P1
      F16563=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16564()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  A  |  H+   !  H+ |  H  | ~C1                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16564(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+2*P2-C(1)-P1
      F16564=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16565()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          H-   !  H- | ~C1                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  A  |  H+   !  H+ |                          
*                --<--@-1---@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16565(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+2*P2-C(1)-P1
      F16565=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16566()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  A  |  H+  |!                                
*                --<--@-1---@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16566(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+2*P2-C(1)-P1
      F16566=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16567()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  A  |  H+  |!                                
*                --<--@-1---@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16567(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+2*P2-C(1)-P1
      F16567=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16568()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  A  |  H+  |!                                
*                --<--@-1---@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16568(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+2*P2-C(1)-P1
      F16568=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16569()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  A  |  H+  |!                                
*                --<--@-1---@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16569(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+2*P2-C(1)-P1
      F16569=RNUM*(TOTNUM/TOTDEN)*Q1(9)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1656()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1656(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1656=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16570()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  H+   !  H+ |  Z  | ~C1                   
*             --<--@-1---@-->----!-->--@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16570(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F16570=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16571()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  H+   !  H+ |  h  | ~C1                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16571(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16571=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16572()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  Z  |  H+   !  H+ |  H  | ~C1                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16572(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16572=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16573()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          H-   !  H- | ~C1                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  Z  |  H+   !  H+ |                          
*                --<--@-1---@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16573(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16573=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16574()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  H+  |!                                
*                --<--@-1---@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16574(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16574=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16575()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  H+  |!                                
*                --<--@-1---@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16575(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16575=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16576()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  H+  |!                                
*                --<--@-1---@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16576(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16576=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16577()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  Z  |  H+  |!                                
*                --<--@-1---@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16577(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16577=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(8)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16578()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H+   !  H+ |  h  | ~C1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16578(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16578=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16579()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  h  |  H+   !  H+ |  H  | ~C1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16579(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16579=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1657()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1657(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1657=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16580()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          H-   !  H- | ~C1                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  h  |  H+   !  H+ |                          
*                --<--@-----@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16580(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16580=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16581()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16581(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16581=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16582()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16582(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16582=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16583()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16583(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16583=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16584()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  h  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16584(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16584=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16585()
*              ~c1          H-   !  H-         ~c1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~C1 |  H  |  H+   !  H+ |  H  | ~C1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16585(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16585=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16586()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          H-   !  H- | ~C1                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~C1 |  H  |  H+   !  H+ |                          
*                --<--@-----@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16586(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16586=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16587()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16587(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16587=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16588()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16588(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16588=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16589()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b1|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16589(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16589=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1658()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1658(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1658=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16590()
*                                   !  H+   ~c1                      
*                                  /!-->--@-->--                     
*                                  |!  P3 |  P1                      
*                                  |!  ~b2|-P6                       
*                 ~c1          H-  |!  H- | ~C1                      
*                -->--\     /--<---+!--<--@--<--                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~C1 |  H  |  H+  |!                                
*                --<--@-----@-->---/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16590(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16590=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16591()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H+   !  H+ |                             
*                        \-->----!-->--/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16591(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16591=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16592()
*                    ~c1         !  H+   ~c1                         
*                   -->--\      /!-->--@-->--                        
*                     P1 |      |!  P3 |  P1                         
*                        |      |!  ~s1|-P5                          
*                    ~C1 |  H-  |!  H- | ~C1                         
*                   --<--@--<---+!--<--@--<--                        
*                     P2 |  P4  |!  P4    P2                         
*                        |      |!                                   
*                        |  H+  |!                                   
*                        \-->---/!                                   
*                           P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16592(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16592=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16593()
*                    ~c1         !  H+   ~c1                         
*                   -->--\      /!-->--@-->--                        
*                     P1 |      |!  P3 |  P1                         
*                        |      |!  ~s2|-P5                          
*                    ~C1 |  H-  |!  H- | ~C1                         
*                   --<--@--<---+!--<--@--<--                        
*                     P2 |  P4  |!  P4    P2                         
*                        |      |!                                   
*                        |  H+  |!                                   
*                        \-->---/!                                   
*                           P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16593(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16593=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16594()
*                    ~c1         !  H+   ~c1                         
*                   -->--\      /!-->--@-->--                        
*                     P1 |      |!  P3 |  P1                         
*                        |      |!  ~b1|-P5                          
*                    ~C1 |  H-  |!  H- | ~C1                         
*                   --<--@--<---+!--<--@--<--                        
*                     P2 |  P4  |!  P4    P2                         
*                        |      |!                                   
*                        |  H+  |!                                   
*                        \-->---/!                                   
*                           P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16594(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16594=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16595()
*                    ~c1         !  H+   ~c1                         
*                   -->--\      /!-->--@-->--                        
*                     P1 |      |!  P3 |  P1                         
*                        |      |!  ~b2|-P5                          
*                    ~C1 |  H-  |!  H- | ~C1                         
*                   --<--@--<---+!--<--@--<--                        
*                     P2 |  P4  |!  P4    P2                         
*                        |      |!                                   
*                        |  H+  |!                                   
*                        \-->---/!                                   
*                           P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16595(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16595=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16596()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16596(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16596=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16597()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16597(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16597=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16598()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16598(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16598=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16599()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16599(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16599=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1659()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1659(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1659=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F165()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o3|-P6                       
*                 ~o1 |  H  |  H3   !  H3 | ~o1                      
*                =====@-----@-------!-----@=====                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U4/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(4).EQ.0) CALL CC165(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F165=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16600()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~s2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16600(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16600=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16601()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16601(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16601=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16602()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s2|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16602(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16602=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16603()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b1|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16603(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16603=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16604()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b1|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16604(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16604=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16605()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~b2|P5     !  ~b2|-P6                          
*                    ~C1 |  H-   !  H- | ~C1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1477/ Q0(8),Q1(9),Q2(9)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(1477).EQ.0) CALL CC16605(C)
      TOTNUM=+C(1)
      TOTDEN=+3
      RNUM=+1
      F16605=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16606()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1478/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1478).EQ.0) CALL CC16606(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16606=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16607()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1478/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1478).EQ.0) CALL CC16607(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16607=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16608()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1478/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1478).EQ.0) CALL CC16608(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16608=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16609()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1479/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1479).EQ.0) CALL CC16609(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16609=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1660()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~1+ |  W+   !  W+ | ~1+                         
*                   ==>==@-2>----!-->2-@==>==                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U55/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(55).EQ.0) CALL CC1660(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P2*(C(8)*(P2-P1)+C(7))+C(5)-C(6)*P1)+C(3)-C(4)*P1)-C
     >(1)-C(2)*P1
      F1660=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16610()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1479/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1479).EQ.0) CALL CC16610(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16610=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16611()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1479/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1479).EQ.0) CALL CC16611(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16611=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16612()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1480/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1480).EQ.0) CALL CC16612(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16612=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16613()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1480/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1480).EQ.0) CALL CC16613(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16613=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16614()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  u    !  u  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1480/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1480).EQ.0) CALL CC16614(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16614=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16615()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1481/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1481).EQ.0) CALL CC16615(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16615=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16616()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1481/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1481).EQ.0) CALL CC16616(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16616=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16617()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1481/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1481).EQ.0) CALL CC16617(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16617=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16618()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1482/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1482).EQ.0) CALL CC16618(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16618=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16619()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1482/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1482).EQ.0) CALL CC16619(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16619=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1661()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(56).EQ.0) CALL CC1661(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F1661=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16620()
*                    ~c1    d    !  d    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1482/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1482).EQ.0) CALL CC16620(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16620=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16621()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16621(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16621=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16622()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16622(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16622=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16623()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16623(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16623=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16624()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16624(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16624=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16625()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16625(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16625=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16626()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16626(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16626=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16627()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!   ~g|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16627(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16627=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16628()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16628(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16628=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16629()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16629(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16629=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1662()
*                             !  Z          ~o1                      
*                            /!---1-\     /=====                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~o1    H+  |!  H+ |  H+ | ~1+                      
*                =====@-->---+!-->--@-->--@==>==                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~1+ |  Z   |!                                      
*                ==>==@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1662(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(1)-C(4)*P2
      F1662=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16630()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16630(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16630=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16631()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16631(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16631=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16632()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16632(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16632=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16633()
*                                !  c    ~c1                         
*                               /!==>==@-->--                        
*                               |!  P3 |  P1                         
*                               |!   ~g|-P6                          
*                    ~c1    s   |!  s  | ~s1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~2+|P5    |!                                   
*                    ~s1 |  c   |!                                   
*                   -->--@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16633(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16633=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(7)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16634()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16634(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16634=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16635()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16635(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16635=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16636()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16636(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16636=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16637()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16637(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16637=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16638()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16638(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16638=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16639()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16639(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16639=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1663()
*                    ~o1    H+   !  H+   ~o1                         
*                   =====@-->----!-->--@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~1+ |  Z    !  Z  | ~1+                         
*                   ==>==@-1-----!---1-@==>==                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(56).EQ.0) CALL CC1663(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(3)+C(8)*P1-C(6)*P2)+P2*(C(8)*P2-C(5))+C(2))+P2*(C(
     >4)-C(7)*P2)-C(1)
      F1663=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16640()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16640(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16640=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16641()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16641(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16641=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16642()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16642(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16642=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16643()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16643(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16643=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16644()
*                    ~c1    c    !  c    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                      ~g|P5     !   ~g|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1483/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1483).EQ.0) CALL CC16644(C)
      S1=A(146)**4
      TOTNUM=-8*S1
      TOTDEN=+9
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16644=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16645()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1484/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1484).EQ.0) CALL CC16645(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16645=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16646()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1484/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1484).EQ.0) CALL CC16646(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16646=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16647()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  c    !  c  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1484/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1484).EQ.0) CALL CC16647(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16647=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16648()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1485/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1485).EQ.0) CALL CC16648(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16648=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16649()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1485/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1485).EQ.0) CALL CC16649(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16649=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1664()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~o1    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1664(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F1664=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16650()
*                    ~c1    s    !  s    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1485/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1485).EQ.0) CALL CC16650(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16650=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16651()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1486/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1486).EQ.0) CALL CC16651(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16651=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16652()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1486/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1486).EQ.0) CALL CC16652(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16652=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16653()
*                    ~c1    b    !  b    ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~s1 |  t    !  t  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1486/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1486).EQ.0) CALL CC16653(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16653=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16654()
*                    ~c1    A    !  A    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-2>----!-->2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1487).EQ.0) CALL CC16654(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(P2*(C(3)+4*P2)+C(2))-C(1)
      F16654=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16655()
*                                !  W+   ~c1                         
*                               /!-->2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~c1    A   |!  A  | ~S1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~S1 |  W+  |!                                   
*                   --<--@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1487).EQ.0) CALL CC16655(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(4*(P2-P1)+C(5))+C(2)+C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F16655=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16656()
*                 ~c1    A    !  A          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~S1 |  W+   !  W+ |  W+ | ~S1                      
*                --<--@-2>----!-->2-@-->3-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1487).EQ.0) CALL CC16656(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P1*(-C(5)-C(6)*P1-C(8)*P2)+P2*(C(7)+C(9)*P2)+C(4))+P1*(C
     >(2)+C(3)*P1)+C(1)
      F16656=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16657()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    A    !  A  | ~S1                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~S1 |  W+   !  W+ |                             
*                   --<--@-2>----!-->2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1487).EQ.0) CALL CC16657(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(3)-4*P1+8*P2)+C(1)+C(2)*P1
      F16657=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16658()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~S1 |  A    !  A  | ~S1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1487).EQ.0) CALL CC16658(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(C(4)-2*P1+6*P2)+P2*(-C(3)-6*P2)+C(2))+P2*(P2*(C(4)+2
     >*P2)-C(2))-C(1)
      F16658=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16659()
*                             !  A          ~c1                      
*                            /!---2-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    W+  |!  W+ |  W+ | ~S1                      
*                -->--@-1>---+!-->1-@-->3-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~S1 |  A   |!                                      
*                --<--@-2----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(1487).EQ.0) CALL CC16659(C)
      TOTNUM=+C(12)
      TOTDEN=+C(11)
      RNUM=+P1*(P1*(C(4)*P1-C(3)-C(7)*P2)+P2*(C(6)-C(9)*P2)+C(2))+P2*(P2
     >*(C(8)+C(10)*P2)+C(5))+C(1)
      F16659=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1665()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1665(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F1665=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16660()
*                    ~c1    W+   !       ~c1                         
*                   -->--@-1>--\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~s1|P5   | !     |                             
*                    ~S1 |  A  | !  A  | ~S1                         
*                   --<--@-2---+-!---2-@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  W+ |                             
*                              \-!-->1-/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1487).EQ.0) CALL CC16660(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+2*P1-6*P2)+P2*(C(3)+4*P2)-C(1)
      F16660=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16661()
*              ~c1          A    !  A          ~c1                   
*             -->--\     /-3-----!---3-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  W+   !  W+ |  W+ | ~S1                   
*             --<--@-1>--@-2>----!-->2-@-->4-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1487).EQ.0) CALL CC16661(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(C(3)-C(4)*P1-C(7)*P2)+P2*(C(6)+C(9)*P2)+C(2))+P2*(-C
     >(5)-C(8)*P2)-C(1)
      F16661=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16662()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          A    !  A  | ~S1                      
*                -->--\     /-3-----!---3-@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~S1 |  W+ |  W+   !  W+ |                          
*                --<--@-1>--@-2>----!-->2-/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1487).EQ.0) CALL CC16662(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1+C(5)*P2)-C(1)-C(4)*P2
      F16662=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16663()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~S1 |  A    !  A  | ~S1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  W+   !  W+ |                             
*                        \-1>----!-->1-/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1487/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1487).EQ.0) CALL CC16663(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F16663=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16664()
*                    ~c1    A    !  A    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1488/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1488).EQ.0) CALL CC16664(C)
      TOTNUM=+C(2)
      TOTDEN=+27
      RNUM=+P2-C(1)
      F16664=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16665()
*                                !  H+   ~c1                         
*                               /!-->--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~c1    A   |!  A  | ~S1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~S1 |  H+  |!                                   
*                   --<--@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1488/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1488).EQ.0) CALL CC16665(C)
      TOTNUM=-C(2)
      TOTDEN=+27
      RNUM=+2*P1-C(1)
      F16665=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16666()
*                 ~c1    A    !  A          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~S1 |  H+   !  H+ |  H+ | ~S1                      
*                --<--@-->----!-->--@-->--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1488/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1488).EQ.0) CALL CC16666(C)
      TOTNUM=+C(2)
      TOTDEN=+9
      RNUM=+2*(P2-P1)+C(1)
      F16666=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16667()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~S1 |  A    !  A  | ~S1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1488/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1488).EQ.0) CALL CC16667(C)
      TOTNUM=-C(2)
      TOTDEN=+27
      RNUM=+2*(P2-P1)+C(1)
      F16667=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16668()
*                             !  A          ~c1                      
*                            /!---1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H+  |!  H+ |  H+ | ~S1                      
*                -->--@-->---+!-->--@-->--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~S1 |  A   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1488/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1488).EQ.0) CALL CC16668(C)
      TOTNUM=-C(2)
      TOTDEN=+9
      RNUM=+C(1)+P2
      F16668=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16669()
*              ~c1          A    !  A          ~c1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  H+ |  H+   !  H+ |  H+ | ~S1                   
*             --<--@-->--@-->----!-->--@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1488/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1488).EQ.0) CALL CC16669(C)
      TOTNUM=-C(2)
      TOTDEN=+3
      RNUM=+C(1)+2*P1
      F16669=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1666()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1666(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F1666=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16670()
*                    ~c1    Z    !  Z    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-2>----!-->2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1489).EQ.0) CALL CC16670(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(P2*(C(4)+C(5)*P2)+C(3))-C(2))-C(1)
      F16670=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16671()
*                                !  W+   ~c1                         
*                               /!-->2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~c1    Z   |!  Z  | ~S1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~S1 |  W+  |!                                   
*                   --<--@-2>---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(1489).EQ.0) CALL CC16671(C)
      TOTNUM=-C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P2*(P1*(C(10)*P1-C(7)-C(9)*P2)+P2*(C(8)+C(10)*P2)+C(6))+
     >P1*(C(4)-C(5)*P1)-C(3))+P1*(C(2)*P1-C(1))
      F16671=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16672()
*                 ~c1    Z    !  Z          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~S1 |  W+   !  W+ |  W+ | ~S1                      
*                --<--@-2>----!-->2-@-->3-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(1489).EQ.0) CALL CC16672(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P1*(P2*(C(8)-C(9)*P1+C(11)*P2)+C(6)*P1-C(5))+P2*(-C(7)-C
     >(10)*P2)-C(4))+P1*(-C(2)-C(3)*P1)-C(1)
      F16672=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16673()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    Z    !  Z  | ~S1                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~c1|P5     !     |                             
*                    ~S1 |  W+   !  W+ |                             
*                   --<--@-2>----!-->2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1489).EQ.0) CALL CC16673(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)+C(5)*P2)+C(2)*P1-C(1)
      F16673=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16674()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~S1 |  Z    !  Z  | ~S1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(1489).EQ.0) CALL CC16674(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(P1*(C(9)*P1-C(7)-C(8)*P2)+P2*(C(5)+C(6)*P2)+C(4))+P2
     >*(P2*(-C(5)-C(8)*P2)-C(3))+C(2))+P2*(P2*(P2*(C(7)+C(9)*P2)+C(4))-C
     >(2))-C(1)
      F16674=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16675()
*                             !  Z          ~c1                      
*                            /!---2-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    W+  |!  W+ |  W+ | ~S1                      
*                -->--@-1>---+!-->1-@-->3-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~S1 |  Z   |!                                      
*                --<--@-2----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(16)                                                   
      SAVE
      IF(L(1489).EQ.0) CALL CC16675(C)
      TOTNUM=+C(16)
      TOTDEN=+C(15)
      RNUM=+P1*(P1*(P1*(C(4)-C(5)*P1+C(9)*P2)+P2*(-C(8)-C(12)*P2)+C(3))+
     >P2*(P2*(C(11)+C(14)*P2)+C(7))-C(2))+P2*(P2*(-C(10)-C(13)*P2)-C(6))
     >+C(1)
      F16675=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16676()
*                    ~c1    W+   !       ~c1                         
*                   -->--@-1>--\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~s1|P5   | !     |                             
*                    ~S1 |  Z  | !  Z  | ~S1                         
*                   --<--@-2---+-!---2-@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  W+ |                             
*                              \-!-->1-/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(1489).EQ.0) CALL CC16676(C)
      TOTNUM=+C(10)
      TOTDEN=+C(9)
      RNUM=+P1*(P1*(C(8)*P1-C(3)-C(6)*P2)+P2*(C(5)+C(8)*P2)+C(2))+P2*(C(
     >4)+C(7)*P2)+C(1)
      F16676=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16677()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-3-----!---3-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  W+   !  W+ |  W+ | ~S1                   
*             --<--@-1>--@-2>----!-->2-@-->4-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(1489).EQ.0) CALL CC16677(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P1*(P1*(P1*(C(4)+C(5)*P1-C(11)*P2)+P2*(C(8)+C(11)*P2)-C(3))+
     >P2*(-C(7)-C(10)*P2)+C(2))+P2*(C(6)+C(9)*P2)+C(1)
      F16677=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16678()
*                                   !       ~c1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~c1          Z    !  Z  | ~S1                      
*                -->--\     /-3-----!---3-@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~S1 |  W+ |  W+   !  W+ |                          
*                --<--@-1>--@-2>----!-->2-/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(1489).EQ.0) CALL CC16678(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(4)*P1+C(7)*P2)+C(2)+C(6)*P2)-C(1)-C(5)*P2
      F16678=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16679()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~S1 |  Z    !  Z  | ~S1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  W+   !  W+ |                             
*                        \-1>----!-->1-/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1489/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1489).EQ.0) CALL CC16679(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16679=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1667()
*                                !  Z    ~o1                         
*                               /!---1-@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    H+  |!  H+ | ~1+                         
*                   =====@-->---+!-->--@==>==                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~1+|P5    |!                                   
*                    ~1+ |  Z   |!                                   
*                   ==>==@-1----/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1667(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P2*(C(7)*(P2-P1)-C(5))+C(2)+C(3)*P1)+P2*(C(6)*P2-C(4))+C
     >(1)
      F1667=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16680()
*                    ~c1    Z    !  Z    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1490/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1490).EQ.0) CALL CC16680(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+C(2)*S1-C(1)
      F16680=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16681()
*                                !  H+   ~c1                         
*                               /!-->--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~c1    Z   |!  Z  | ~S1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~S1 |  H+  |!                                   
*                   --<--@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1490/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1490).EQ.0) CALL CC16681(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(3)*(P2-P1)-C(2))+C(1)*P1
      F16681=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16682()
*                 ~c1    Z    !  Z          ~c1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~c1|P5     !     |     |                          
*                 ~S1 |  H+   !  H+ |  H+ | ~S1                      
*                --<--@-->----!-->--@-->--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1490/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1490).EQ.0) CALL CC16682(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F16682=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16683()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~S1 |  Z    !  Z  | ~S1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1490/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1490).EQ.0) CALL CC16683(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F16683=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16684()
*                             !  Z          ~c1                      
*                            /!---1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H+  |!  H+ |  H+ | ~S1                      
*                -->--@-->---+!-->--@-->--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~s1|P5    |!                                      
*                 ~S1 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1490/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1490).EQ.0) CALL CC16684(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16684=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16685()
*              ~c1          Z    !  Z          ~c1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  H+ |  H+   !  H+ |  H+ | ~S1                   
*             --<--@-->--@-->----!-->--@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1490/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1490).EQ.0) CALL CC16685(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1)+C(1)
      F16685=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16686()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-2>----!-->2-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1491/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1491).EQ.0) CALL CC16686(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P1*(P1*(12*P2-C(3)-4*P1)+P2*(C(2)-12*P2)-C(1))+P2*(P2*(4*P2-
     >C(3))+C(1))
      F16686=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16687()
*                                !  W+   ~c1                         
*                               /!-->2-@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~c1    G   |!  G  | ~S1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~S1 |  W+  |!                                   
*                   --<--@-2>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1491/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1491).EQ.0) CALL CC16687(C)
      S1=A(146)**2
      TOTNUM=+C(6)*S1
      TOTDEN=+C(5)
      RNUM=+P1*(P2*(4*(P2-P1)-C(3))+C(1)+C(3)*P1)+P2*(C(4)*P2-C(2))
      F16687=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16688()
*                    ~c1    G    !       ~c1                         
*                   -->--@-1---\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~c1|P5   | !     |                             
*                    ~S1 |  W+ | !  W+ | ~S1                         
*                   --<--@-2>--+-!-->2-@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  G  |                             
*                              \-!---1-/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1491/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1491).EQ.0) CALL CC16688(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P1-12*P2)+P2*(8*P2-C(3))+C(1)
      F16688=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16689()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~S1 |  G    !  G  | ~S1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1491/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1491).EQ.0) CALL CC16689(C)
      S1=A(146)**2
      TOTNUM=+C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(P2*(2*P2-C(3))-C(2))+C(1)
      F16689=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1668()
*              ~o1          Z    !  Z          ~o1                   
*             =====\     /-1-----!---1-\     /=====                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~1+ |  H+ |  H+   !  H+ |  H+ | ~1+                   
*             ==>==@-->--@-->----!-->--@-->--@==>==                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1668(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(P1*(C(3)+C(4)*P1)+C(2))-C(1)
      F1668=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16690()
*                                !       ~c1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~c1    W+   !  W+ | ~S1                         
*                   -->--@-1>----!-->1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~s1|P5     !     |                             
*                    ~S1 |  G    !  G  |                             
*                   --<--@-2-----!---2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1491/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1491).EQ.0) CALL CC16690(C)
      S1=A(146)**2
      TOTNUM=-C(5)*S1
      TOTDEN=+C(4)
      RNUM=+P2*(4*P2-C(3)-2*P1)+C(2)*P1-C(1)
      F16690=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16691()
*                    ~c1         !       ~c1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-2>----!-->2-@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  G    !  G  |                             
*                        \-1-----!---1-/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1491/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1491).EQ.0) CALL CC16691(C)
      S1=A(146)**2
      TOTNUM=+C(2)*S1
      TOTDEN=+C(1)
      RNUM=+1
      F16691=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16692()
*                    ~c1    h    !  h    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16692(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16692=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16693()
*                                !  W+   ~c1                         
*                               /!-->1-@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~c1    h   |!  h  | ~S1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~S1 |  W+  |!                                   
*                   --<--@-1>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16693(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F16693=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16694()
*                             !  W+         ~c1                      
*                            /!-->1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    h   |!  h  |  W+ | ~S1                      
*                -->--@------+!-----@-->2-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~S1 |  W+  |!                                      
*                --<--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16694(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F16694=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16695()
*                             !  W+         ~c1                      
*                            /!-->1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    h   |!  h  |  H+ | ~S1                      
*                -->--@------+!-----@-->--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~S1 |  W+  |!                                      
*                --<--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16695(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16695=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16696()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~S1 |  h    !  h  | ~S1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16696(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16696=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16697()
*                 ~c1    W+   !  W+         ~c1                      
*                -->--@-1>----!-->1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~S1 |  h    !  h  |  W+ | ~S1                      
*                --<--@-------!-----@-->2-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16697(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F16697=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16698()
*                 ~c1    W+   !  W+         ~c1                      
*                -->--@-1>----!-->1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~S1 |  h    !  h  |  H+ | ~S1                      
*                --<--@-------!-----@-->--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16698(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16698=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16699()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-2>----!-->2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  h    !  h  |  W+ | ~S1                   
*             --<--@-1>--@-------!-----@-->3-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16699(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F16699=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1669()
*                                   !  H+   ~o1                      
*                                  /!-->--@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~2+|-P6                       
*                 ~o1          Z   |!  Z  | ~1+                      
*                =====\     /-1----+!---1-@==>==                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~1+ |  H+ |  H+  |!                                
*                ==>==@-->--@-->---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1669(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*(P2-P1)-C(3))+C(5)*P2-C(2))+C(1)-C(4)*P2
      F1669=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F166()
*                                   !  H3   ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o3|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H  |  H3  |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U4/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(4).EQ.0) CALL CC166(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F166=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16700()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-2>----!-->2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  h    !  h  |  H+ | ~S1                   
*             --<--@-1>--@-------!-----@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16700(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+C(4)*P2-C(1)
      F16700=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16701()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  H+ |  h    !  h  |  H+ | ~S1                   
*             --<--@-->--@-------!-----@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1492/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1492).EQ.0) CALL CC16701(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16701=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16702()
*                    ~c1    H    !  H    ~c1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  W+   !  W+ | ~S1                         
*                   --<--@-1>----!-->1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16702(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F16702=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16703()
*                                !  W+   ~c1                         
*                               /!-->1-@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~c1    H   |!  H  | ~S1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~S1 |  W+  |!                                   
*                   --<--@-1>---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16703(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F16703=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16704()
*                             !  W+         ~c1                      
*                            /!-->1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H   |!  H  |  W+ | ~S1                      
*                -->--@------+!-----@-->2-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~S1 |  W+  |!                                      
*                --<--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16704(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F16704=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16705()
*                             !  W+         ~c1                      
*                            /!-->1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~c1    H   |!  H  |  H+ | ~S1                      
*                -->--@------+!-----@-->--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~c1|P5    |!                                      
*                 ~S1 |  W+  |!                                      
*                --<--@-1>---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16705(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F16705=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16706()
*                    ~c1    W+   !  W+   ~c1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~S1 |  H    !  H  | ~S1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16706(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F16706=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16707()
*                 ~c1    W+   !  W+         ~c1                      
*                -->--@-1>----!-->1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~S1 |  H    !  H  |  W+ | ~S1                      
*                --<--@-------!-----@-->2-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16707(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F16707=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16708()
*                 ~c1    W+   !  W+         ~c1                      
*                -->--@-1>----!-->1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~s1|P5     !     |     |                          
*                 ~S1 |  H    !  H  |  H+ | ~S1                      
*                --<--@-------!-----@-->--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16708(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F16708=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16709()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-2>----!-->2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  H    !  H  |  W+ | ~S1                   
*             --<--@-1>--@-------!-----@-->3-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16709(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F16709=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1670()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o1|-P6                       
*                 ~1+ |  H+ |  H+   !  H+ | ~1+                      
*                ==>==@-->--@-->----!-->--@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1670(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F1670=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16710()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-2>----!-->2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  H    !  H  |  H+ | ~S1                   
*             --<--@-1>--@-------!-----@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16710(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+C(4)*P2-C(1)
      F16710=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16711()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  H+ |  H    !  H  |  H+ | ~S1                   
*             --<--@-->--@-------!-----@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1493/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1493).EQ.0) CALL CC16711(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16711=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16712()
*              ~c1          W+   !  W+         ~c1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  H+ |  H3   !  H3 |  H+ | ~S1                   
*             --<--@-->--@-------!-----@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1494/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(1494).EQ.0) CALL CC16712(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F16712=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16713()
*                    ~c1    G    !  G    ~c1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~S1 |  H+   !  H+ | ~S1                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1495/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1495).EQ.0) CALL CC16713(C)
      S1=A(146)**2
      TOTNUM=+C(2)*S1
      TOTDEN=+9
      RNUM=+P2-C(1)
      F16713=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16714()
*                                !  H+   ~c1                         
*                               /!-->--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~c1    G   |!  G  | ~S1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~S1 |  H+  |!                                   
*                   --<--@-->---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1495/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1495).EQ.0) CALL CC16714(C)
      S1=A(146)**2
      TOTNUM=+C(2)*S1
      TOTDEN=+9
      RNUM=+2*P1-C(1)
      F16714=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16715()
*                    ~c1    H+   !  H+   ~c1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~S1 |  G    !  G  | ~S1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1495/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(1495).EQ.0) CALL CC16715(C)
      S1=A(146)**2
      TOTNUM=-C(2)*S1
      TOTDEN=+9
      RNUM=+2*(P2-P1)+C(1)
      F16715=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16716()
*              ~c1          n1   !  n1         ~c1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  E1   !  E1 |  W+ | ~S1                   
*             --<--@-1>--@==<====!==<==@-->2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1496/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1496).EQ.0) CALL CC16716(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16716=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16717()
*              ~c1          n2   !  n2         ~c1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  E2   !  E2 |  W+ | ~S1                   
*             --<--@-1>--@==<====!==<==@-->2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1497/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1497).EQ.0) CALL CC16717(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16717=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16718()
*              ~c1          n2   !  n2         ~c1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  E2   !  E2 |  H+ | ~S1                   
*             --<--@-1>--@==<====!==<==@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1497/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1497).EQ.0) CALL CC16718(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16718=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16719()
*              ~c1          n2   !  n2         ~c1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  H+ |  E2   !  E2 |  H+ | ~S1                   
*             --<--@-->--@==<====!==<==@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1497/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(1497).EQ.0) CALL CC16719(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F16719=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1671()
*                 ~o1          Z    !  Z    ~o1                      
*                =====\     /-1-----!---1-@=====                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~o2|-P6                       
*                 ~1+ |  H+ |  H+   !  H+ | ~1+                      
*                ==>==@-->--@-->----!-->--@==>==                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U56/ Q0(7),Q1(7),Q2(7)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(56).EQ.0) CALL CC1671(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(C(6)*P2-C(3))+C(5)*P2-C(2))+C(4)*P2-C(1)
      F1671=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16720()
*              ~c1          n3   !  n3         ~c1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  E3   !  E3 |  W+ | ~S1                   
*             --<--@-1>--@==<====!==<==@-->2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1498/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(1498).EQ.0) CALL CC16720(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F16720=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16721()
*              ~c1          n3   !  n3         ~c1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  W+ |  E3   !  E3 |  H+ | ~S1                   
*             --<--@-1>--@==<====!==<==@-->--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U1498/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(1498).EQ.0) CALL CC16721(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F16721=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F16722()
*              ~c1          n3   !  n3         ~c1                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~S1 |  H+ |  E3   !  E3 |  H+ | ~S1                   
*             --<--@-->--@==<====!==<==@-->--@--<--              