*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12000()
*                                   !  H    ~e3                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~e3          h   |!  h  | ~E3                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~E3 |  H  |  H   |!                                
*                --<--@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U860/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(860).EQ.0) CALL CC12000(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12000=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12001()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~E3 |  h    !  h  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  H    !  H  |                             
*                        \-------!-----/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U860/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(860).EQ.0) CALL CC12001(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12001=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12002()
*                    ~e3         !                                   
*                   -->--\       !                                   
*                     P1 |       !                                   
*                        |       !                                   
*                    ~E3 |  h    !  h    ~e3                         
*                   --<--@-------!-----@-->--                        
*                     P2 |  P3   !  P3 |  P1                         
*                        |       !  ~e6|-P5                          
*                        |  H    !  H  | ~E3                         
*                        \-------!-----@--<--                        
*                           P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U860/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(860).EQ.0) CALL CC12002(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12002=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12003()
*                    ~e3         !  H    ~e3                         
*                   -->--\      /!-----@-->--                        
*                     P1 |      |!  P4 |  P1                         
*                        |      |!  ~e6|-P5                          
*                    ~E3 |  h   |!  h  | ~E3                         
*                   --<--@------+!-----@--<--                        
*                     P2 |  P3  |!  P3    P2                         
*                        |      |!                                   
*                        |  H   |!                                   
*                        \------/!                                   
*                           P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U860/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(860).EQ.0) CALL CC12003(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12003=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12004()
*                    ~e3    h    !  h    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~E3 |  H    !  H  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U860/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(860).EQ.0) CALL CC12004(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12004=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12005()
*                                !  H    ~e3                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~e3    h   |!  h  | ~E3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~E3 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U860/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(860).EQ.0) CALL CC12005(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12005=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12006()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~E3 |  h    !  h  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U860/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(860).EQ.0) CALL CC12006(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12006=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12007()
*              ~e3          h    !  h          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  Z  |  H3   !  H3 |  Z  | ~E3                   
*             --<--@-1---@-------!-----@---2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U861/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(861).EQ.0) CALL CC12007(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(-C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F12007=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12008()
*                 ~e3          h    !  h    ~e3                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~E3 |  Z  |  H3   !  H3 | ~E3                      
*                --<--@-1---@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U861/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(861).EQ.0) CALL CC12008(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F12008=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12009()
*                                   !  H3   ~e3                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~e3          h   |!  h  | ~E3                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~E3 |  Z  |  H3  |!                                
*                --<--@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U861/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(861).EQ.0) CALL CC12009(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F12009=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1200()
*              ~o1          D    !  D          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  d    !  d  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1200(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F1200=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12010()
*                    ~e3    h    !  h    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~E3 |  H3   !  H3 | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U861/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(861).EQ.0) CALL CC12010(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12010=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12011()
*                                !  H3   ~e3                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~e3    h   |!  h  | ~E3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~E3 |  H3  |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U861/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(861).EQ.0) CALL CC12011(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12011=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12012()
*                    ~e3    H3   !  H3   ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~E3 |  h    !  h  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U861/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(861).EQ.0) CALL CC12012(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12012=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12013()
*              ~e3          H    !  H          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  h  |  H    !  H  |  h  | ~E3                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12013(C)
      TOTNUM=+C(1)
      TOTDEN=+2
      RNUM=+1
      F12013=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12014()
*                 ~e3          H    !  H    ~e3                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e3|-P6                       
*                 ~E3 |  h  |  H    !  H  | ~E3                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12014(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12014=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12015()
*              ~e3          H    !  H          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  h  |  H    !  H  |  H  | ~E3                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12015(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12015=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12016()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H    !  H  | ~E3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~E3 |  h  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12016(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12016=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12017()
*                 ~e3          H    !  H    ~e3                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~E3 |  h  |  H    !  H  | ~E3                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12017(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12017=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12018()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~E3 |  H    !  H  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12018(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12018=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12019()
*                                !  H    ~e3                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~e3|-P6                          
*                    ~e3    H   |!  H  | ~E3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e3|P5    |!                                   
*                    ~E3 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12019(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12019=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1201()
*                 ~o1          D    !  D    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~d1|-P6                       
*                 ~o2 |  Z  |  d    !  d  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1201(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))-C(1)
      F1201=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12020()
*                 ~e3    H    !  H          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~E3 |  H    !  H  |  H  | ~E3                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12020(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12020=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12021()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    H    !  H  | ~E3                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e3|P5     !     |                             
*                    ~E3 |  H    !  H  |                             
*                   --<--@-------!-----/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12021(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12021=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12022()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~E3 |  H    !  H  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12022(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12022=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12023()
*                                !  H    ~e3                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~e3    H   |!  H  | ~E3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e3|P5    |!                                   
*                    ~E3 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12023(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12023=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12024()
*              ~e3          H    !  H          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  H  |  H    !  H  |  H  | ~E3                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12024(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12024=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12025()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H    !  H  | ~E3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~E3 |  H  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12025(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12025=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12026()
*                 ~e3          H    !  H    ~e3                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~E3 |  H  |  H    !  H  | ~E3                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12026(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12026=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12027()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~E3 |  H    !  H  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H    !  H  |                             
*                        \-------!-----/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12027(C)
      TOTNUM=+C(1)
      TOTDEN=+2
      RNUM=+1
      F12027=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12028()
*                    ~e3         !                                   
*                   -->--\       !                                   
*                     P1 |       !                                   
*                        |       !                                   
*                    ~E3 |  H    !  H    ~e3                         
*                   --<--@-------!-----@-->--                        
*                     P2 |  P4   !  P4 |  P1                         
*                        |       !  ~e6|-P5                          
*                        |  H    !  H  | ~E3                         
*                        \-------!-----@--<--                        
*                           P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12028(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12028=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12029()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~E3 |  H    !  H  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12029(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12029=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1202()
*                                   !  d    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~d1|-P6                       
*                 ~o1          D   |!  D  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  d   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1202(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(3)+C(4)*P2)-C(1)-C(2)*P1
      F1202=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12030()
*                                !  H    ~e3                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~e3    H   |!  H  | ~E3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~E3 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U862/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(862).EQ.0) CALL CC12030(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12030=RNUM*(TOTNUM/TOTDEN)*Q1(6)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12031()
*              ~e3          H    !  H          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  Z  |  H3   !  H3 |  Z  | ~E3                   
*             --<--@-1---@-------!-----@---2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U863/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(863).EQ.0) CALL CC12031(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(-C(2)-C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F12031=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12032()
*                 ~e3          H    !  H    ~e3                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P3   !  P3 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~E3 |  Z  |  H3   !  H3 | ~E3                      
*                --<--@-1---@-------!-----@--<--                     
*                  P2    P5    P4   !  P4    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U863/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(863).EQ.0) CALL CC12032(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F12032=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12033()
*                                   !  H3   ~e3                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~e6|-P6                       
*                 ~e3          H   |!  H  | ~E3                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~E3 |  Z  |  H3  |!                                
*                --<--@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U863/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(863).EQ.0) CALL CC12033(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(1)+C(2)*P1+C(3)*P2
      F12033=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12034()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~E3 |  H3   !  H3 | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U863/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(863).EQ.0) CALL CC12034(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12034=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12035()
*                                !  H3   ~e3                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~e3    H   |!  H  | ~E3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~E3 |  H3  |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U863/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(863).EQ.0) CALL CC12035(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12035=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12036()
*                    ~e3    H3   !  H3   ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~E3 |  H    !  H  | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U863/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(863).EQ.0) CALL CC12036(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12036=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12037()
*              ~e3          H3   !  H3         ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  h  |  H3   !  H3 |  h  | ~E3                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12037(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12037=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12038()
*              ~e3          H3   !  H3         ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  h  |  H3   !  H3 |  H  | ~E3                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12038(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12038=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12039()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H3   !  H3 | ~E3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~E3 |  h  |  H3   !  H3 |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12039(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12039=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1203()
*                 ~o1          D    !  D    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~d2|-P6                       
*                 ~o2 |  Z  |  d    !  d  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1203(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(5)*P1-C(4)*P2)+P2*(C(5)*P2-C(3))-C(1)
      F1203=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12040()
*                 ~e3          H3   !  H3   ~e3                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~E3 |  h  |  H3   !  H3 | ~E3                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12040(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12040=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12041()
*              ~e3          H3   !  H3         ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  H  |  H3   !  H3 |  H  | ~E3                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12041(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12041=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12042()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H3   !  H3 | ~E3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~E3 |  H  |  H3   !  H3 |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12042(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12042=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12043()
*                 ~e3          H3   !  H3   ~e3                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~e6|-P6                       
*                 ~E3 |  H  |  H3   !  H3 | ~E3                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12043(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12043=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12044()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~E3 |  H3   !  H3 | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H3   !  H3 |                             
*                        \-------!-----/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12044(C)
      TOTNUM=+C(1)
      TOTDEN=+2
      RNUM=+1
      F12044=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12045()
*                    ~e3         !                                   
*                   -->--\       !                                   
*                     P1 |       !                                   
*                        |       !                                   
*                    ~E3 |  H3   !  H3   ~e3                         
*                   --<--@-------!-----@-->--                        
*                     P2 |  P4   !  P4 |  P1                         
*                        |       !  ~e6|-P5                          
*                        |  H3   !  H3 | ~E3                         
*                        \-------!-----@--<--                        
*                           P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12045(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12045=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12046()
*                    ~e3    H3   !  H3   ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~E3 |  H3   !  H3 | ~E3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12046(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12046=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12047()
*                                !  H3   ~e3                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~e6|-P6                          
*                    ~e3    H3  |!  H3 | ~E3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~E3 |  H3  |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U864/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(864).EQ.0) CALL CC12047(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12047=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12048()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  A  |  H+   !  H+ |  A  | ~E3                   
*             --<--@-1---@-->----!-->--@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12048(C)
      TOTNUM=+C(4)
      TOTDEN=+1
      RNUM=+P1*(C(2)+P1-4*P2)+P2*(4*P2-C(3))+C(1)
      F12048=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12049()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  A  |  H+   !  H+ |  Z  | ~E3                   
*             --<--@-1---@-->----!-->--@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12049(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F12049=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1204()
*                                   !  d    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~d2|-P6                       
*                 ~o1          D   |!  D  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  d   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1204(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(3)+C(4)*P2)-C(1)-C(2)*P1
      F1204=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12050()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  A  |  H+   !  H+ |  h  | ~E3                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12050(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*P2-C(1)-P1
      F12050=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12051()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  A  |  H+   !  H+ |  H  | ~E3                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12051(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*P2-C(1)-P1
      F12051=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12052()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H-   !  H- | ~E3                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~E3 |  A  |  H+   !  H+ |                          
*                --<--@-1---@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12052(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*P2-C(1)-P1
      F12052=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12053()
*                 ~e3          H-   !  H-   ~e3                      
*                -->--\     /--<----!--<--@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~n3|-P6                       
*                 ~E3 |  A  |  H+   !  H+ | ~E3                      
*                --<--@-1---@-->----!-->--@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12053(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*P2-C(1)-P1
      F12053=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12054()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  Z  |  H+   !  H+ |  Z  | ~E3                   
*             --<--@-1---@-->----!-->--@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12054(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F12054=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12055()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  Z  |  H+   !  H+ |  h  | ~E3                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12055(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12055=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12056()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  Z  |  H+   !  H+ |  H  | ~E3                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12056(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12056=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12057()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H-   !  H- | ~E3                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~E3 |  Z  |  H+   !  H+ |                          
*                --<--@-1---@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12057(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12057=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12058()
*                 ~e3          H-   !  H-   ~e3                      
*                -->--\     /--<----!--<--@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~n3|-P6                       
*                 ~E3 |  Z  |  H+   !  H+ | ~E3                      
*                --<--@-1---@-->----!-->--@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12058(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12058=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12059()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  h  |  H+   !  H+ |  h  | ~E3                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12059(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12059=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1205()
*                    ~o1    D    !  D    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~o2 |  d    !  d  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1205(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F1205=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12060()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  h  |  H+   !  H+ |  H  | ~E3                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12060(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12060=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12061()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H-   !  H- | ~E3                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~E3 |  h  |  H+   !  H+ |                          
*                --<--@-----@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12061(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12061=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12062()
*                 ~e3          H-   !  H-   ~e3                      
*                -->--\     /--<----!--<--@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~n3|-P6                       
*                 ~E3 |  h  |  H+   !  H+ | ~E3                      
*                --<--@-----@-->----!-->--@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12062(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12062=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12063()
*              ~e3          H-   !  H-         ~e3                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~E3 |  H  |  H+   !  H+ |  H  | ~E3                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12063(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12063=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12064()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H-   !  H- | ~E3                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~E3 |  H  |  H+   !  H+ |                          
*                --<--@-----@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12064(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12064=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12065()
*                 ~e3          H-   !  H-   ~e3                      
*                -->--\     /--<----!--<--@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~n3|-P6                       
*                 ~E3 |  H  |  H+   !  H+ | ~E3                      
*                --<--@-----@-->----!-->--@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12065(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12065=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12066()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~E3 |  H-   !  H- | ~E3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H+   !  H+ |                             
*                        \-->----!-->--/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12066(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12066=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12067()
*                    ~e3         !                                   
*                   -->--\       !                                   
*                     P1 |       !                                   
*                        |       !                                   
*                    ~E3 |  H-   !  H-   ~e3                         
*                   --<--@--<----!--<--@-->--                        
*                     P2 |  P4   !  P4 |  P1                         
*                        |       !  ~n3|-P5                          
*                        |  H+   !  H+ | ~E3                         
*                        \-->----!-->--@--<--                        
*                           P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12067(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12067=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12068()
*                    ~e3    H-   !  H-   ~e3                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~E3 |  H+   !  H+ | ~E3                         
*                   --<--@-->----!-->--@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U865/ Q0(4),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(865).EQ.0) CALL CC12068(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12068=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12069()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12069(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12069=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1206()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d1|-P6                          
*                    ~o1    D   |!  D  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d1|P5    |!                                   
*                    ~o2 |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1206(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1206=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12070()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12070(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12070=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12071()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12071(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12071=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12072()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12072(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12072=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12073()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12073(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12073=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12074()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12074(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12074=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12075()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12075(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12075=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12076()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12076(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12076=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12077()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12077(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12077=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12078()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U866/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(866).EQ.0) CALL CC12078(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12078=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12079()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U867/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(867).EQ.0) CALL CC12079(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12079=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1207()
*                    ~o1    D    !  D    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d1|P5     !  ~d2|-P6                          
*                    ~o2 |  d    !  d  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1207(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F1207=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12080()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U867/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(867).EQ.0) CALL CC12080(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12080=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12081()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n1 |  e1   !  e1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U867/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(867).EQ.0) CALL CC12081(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12081=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12082()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12082(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12082=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12083()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12083(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12083=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12084()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12084(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12084=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12085()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12085(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12085=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12086()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12086(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12086=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12087()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12087(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12087=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12088()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12088(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12088=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12089()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12089(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12089=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1208()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o1    D   |!  D  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d1|P5    |!                                   
*                    ~o2 |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1208(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1208=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12090()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12090(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12090=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12091()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U868/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(868).EQ.0) CALL CC12091(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12091=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12092()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12092(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12092=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12093()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12093(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12093=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12094()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12094(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12094=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12095()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12095(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12095=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12096()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12096(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12096=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12097()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12097(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12097=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12098()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12098(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12098=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12099()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12099(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12099=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1209()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d1|-P6                          
*                    ~o2 |  D    !  D  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1209(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F1209=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F120()
*                                   !  H    ~o1                      
*                                  /!-----@=====                     
*                                  |!  P4 |  P1                      
*                                  |!  ~o4|-P6                       
*                 ~o1          Z   |!  Z  | ~o1                      
*                =====\     /-1----+!---1-@=====                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~o1 |  H3 |  H   |!                                
*                =====@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC120(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(8*(P2-P1)+C(3))+C(2)+C(5)*P2)+C(1)+C(4)*P2
      F120=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12100()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12100(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12100=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12101()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U869/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(869).EQ.0) CALL CC12101(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12101=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12102()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U870/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(870).EQ.0) CALL CC12102(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12102=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12103()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U870/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(870).EQ.0) CALL CC12103(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12103=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12104()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n2 |  e2   !  e2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U870/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(870).EQ.0) CALL CC12104(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12104=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12105()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12105(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12105=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12106()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12106(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12106=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12107()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12107(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12107=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12108()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12108(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12108=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12109()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12109(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12109=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1210()
*                                !  D    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o1    d   |!  d  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~d1|P5    |!                                   
*                    ~o2 |  D   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1210(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1210=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12110()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12110(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12110=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12111()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12111(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12111=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12112()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12112(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12112=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12113()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12113(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12113=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12114()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U871/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(871).EQ.0) CALL CC12114(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12114=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12115()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12115(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12115=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12116()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12116(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12116=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12117()
*                                !  e3   ~e3                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~e3    n3  |!  n3 | ~n3                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12117(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12117=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12118()
*                                !  e3   ~e3                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~e3    n3  |!  n3 | ~n3                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12118(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12118=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12119()
*                                !  e3   ~e3                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~e3    n3  |!  n3 | ~n3                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12119(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12119=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1211()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d1|P5     !  ~d2|-P6                          
*                    ~o2 |  D    !  D  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1211(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F1211=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12120()
*                                !  e3   ~e3                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~e3    n3  |!  n3 | ~n3                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~1+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12120(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12120=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12121()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~n3 |  e3   !  e3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12121(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12121=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12122()
*                                !  e3   ~e3                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~e3    n3  |!  n3 | ~n3                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12122(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12122=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12123()
*                                !  e3   ~e3                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~e3    n3  |!  n3 | ~n3                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12123(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12123=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12124()
*                                !  e3   ~e3                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~e3    n3  |!  n3 | ~n3                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12124(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12124=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12125()
*                                !  e3   ~e3                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~e3    n3  |!  n3 | ~n3                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~2+|P5    |!                                   
*                    ~n3 |  e3  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12125(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12125=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12126()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12126(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12126=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12127()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12127(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12127=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12128()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12128(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12128=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12129()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12129(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12129=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1212()
*                    ~o1    D    !  D    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                    ~o2 |  d    !  d  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1212(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F1212=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12130()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12130(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12130=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12131()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12131(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12131=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12132()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12132(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12132=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12133()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12133(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12133=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12134()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12134(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12134=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12135()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U872/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(872).EQ.0) CALL CC12135(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12135=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12136()
*                    ~e3    A    !  A    ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U873/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(873).EQ.0) CALL CC12136(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(P2*(C(3)+4*P2)+C(2))-C(1)
      F12136=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12137()
*                 ~e3    A    !  A          ~e3                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~N3 |  W-   !  W- |  W+ | ~N3                      
*                --<--@-2<----!--<2-@--<3-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U873/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(873).EQ.0) CALL CC12137(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P1*(-C(5)-C(6)*P1-C(8)*P2)+P2*(C(7)+C(9)*P2)+C(4))+P1*(C
     >(2)+C(3)*P1)+C(1)
      F12137=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12138()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    A    !  A  | ~N3                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e3|P5     !     |                             
*                    ~N3 |  W-   !  W- |                             
*                   --<--@-2<----!--<2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U873/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(873).EQ.0) CALL CC12138(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(3)-4*P1+8*P2)+C(1)+C(2)*P1
      F12138=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12139()
*              ~e3          A    !  A          ~e3                   
*             -->--\     /-3-----!---3-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  W-   !  W- |  W+ | ~N3                   
*             --<--@-1<--@-2<----!--<2-@--<4-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U873/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(873).EQ.0) CALL CC12139(C)
      TOTNUM=-C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(C(3)-C(4)*P1-C(7)*P2)+P2*(C(6)+C(9)*P2)+C(2))+P2*(-C
     >(5)-C(8)*P2)-C(1)
      F12139=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1213()
*                                !  d    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~d2|-P6                          
*                    ~o1    D   |!  D  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~d2|P5    |!                                   
*                    ~o2 |  d   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1213(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1213=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12140()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          A    !  A  | ~N3                      
*                -->--\     /-3-----!---3-@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N3 |  W+ |  W-   !  W- |                          
*                --<--@-1<--@-2<----!--<2-/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U873/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(873).EQ.0) CALL CC12140(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)-C(3)*P1+C(5)*P2)-C(1)-C(4)*P2
      F12140=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12141()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N3 |  A    !  A  | ~N3                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  W-   !  W- |                             
*                        \-1<----!--<1-/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U873/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(873).EQ.0) CALL CC12141(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12141=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12142()
*                    ~e3    A    !  A    ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U874/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(874).EQ.0) CALL CC12142(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+P2-C(1)
      F12142=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12143()
*                 ~e3    A    !  A          ~e3                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  H+ | ~N3                      
*                --<--@--<----!--<--@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U874/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(874).EQ.0) CALL CC12143(C)
      TOTNUM=+C(2)
      TOTDEN=+1
      RNUM=+2*(P2-P1)+C(1)
      F12143=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12144()
*              ~e3          A    !  A          ~e3                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  H-   !  H- |  H+ | ~N3                   
*             --<--@--<--@--<----!--<--@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U874/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(874).EQ.0) CALL CC12144(C)
      TOTNUM=-C(2)
      TOTDEN=+1
      RNUM=+C(1)+2*P1
      F12144=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12145()
*                    ~e3    Z    !  Z    ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12145(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(P2*(C(4)+C(5)*P2)+C(3))-C(2))-C(1)
      F12145=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12146()
*                    ~e3    Z    !  Z    ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12146(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P2*(P2*(C(4)+C(5)*P2)+C(3))-C(2))-C(1)
      F12146=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12147()
*                                !  W-   ~e3                         
*                               /!--<2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    Z   |!  Z  | ~N3                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e3|P5    |!                                   
*                    ~N3 |  W-  |!                                   
*                   --<--@-2<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(12)                                                   
      SAVE
      IF(L(875).EQ.0) CALL CC12147(C)
      TOTNUM=+C(12)
      TOTDEN=+C(11)
      RNUM=+P2*(P2*(P1*(C(10)*P1-C(7)-C(9)*P2)+P2*(C(8)+C(10)*P2)+C(6))+
     >P1*(C(4)-C(5)*P1)-C(3))+P1*(C(2)*P1-C(1))
      F12147=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12148()
*                 ~e3    Z    !  Z          ~e3                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~N3 |  W-   !  W- |  W+ | ~N3                      
*                --<--@-2<----!--<2-@--<3-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(875).EQ.0) CALL CC12148(C)
      TOTNUM=-C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P1*(P2*(C(8)-C(9)*P1+C(11)*P2)+C(6)*P1-C(5))+P2*(-C(7)-C
     >(10)*P2)-C(4))+P1*(-C(2)-C(3)*P1)-C(1)
      F12148=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12149()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    Z    !  Z  | ~N3                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e3|P5     !     |                             
*                    ~N3 |  W-   !  W- |                             
*                   --<--@-2<----!--<2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12149(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P2*(P1*(C(6)*P2-C(4))+C(3)+C(5)*P2)+C(2)*P1-C(1)
      F12149=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1214()
*                    ~o1    d    !  d    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~d2|P5     !  ~d2|-P6                          
*                    ~o2 |  D    !  D  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U41/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(41).EQ.0) CALL CC1214(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(C(1)+C(2)*P2)
      F1214=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12150()
*                    ~e3    Z    !  Z    ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12150(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P2*(P2*(C(4)+4*P2)+C(3))-C(2))-C(1)
      F12150=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12151()
*                                !  W-   ~e3                         
*                               /!--<2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    Z   |!  Z  | ~N3                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~N3 |  W-  |!                                   
*                   --<--@-2<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(10)                                                   
      SAVE
      IF(L(875).EQ.0) CALL CC12151(C)
      TOTNUM=-C(10)
      TOTDEN=+C(9)
      RNUM=+P2*(P2*(P1*(4*P1-C(7)-8*P2)+P2*(C(8)+4*P2)+C(6))+P1*(C(4)-C(
     >5)*P1)-C(3))+P1*(C(2)*P1-C(1))
      F12151=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12152()
*                 ~e3    Z    !  Z          ~e3                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e6|P5     !     |     |                          
*                 ~N3 |  W-   !  W- |  W+ | ~N3                      
*                --<--@-2<----!--<2-@--<3-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(875).EQ.0) CALL CC12152(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P2*(P1*(P2*(C(8)-C(9)*P1+C(11)*P2)+C(6)*P1-C(5))+P2*(-C(7)-C
     >(10)*P2)-C(4))+P1*(-C(2)-C(3)*P1)-C(1)
      F12152=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12153()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    Z    !  Z  | ~N3                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e6|P5     !     |                             
*                    ~N3 |  W-   !  W- |                             
*                   --<--@-2<----!--<2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12153(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(4*P2-C(4))+C(3)+C(5)*P2)+C(2)*P1-C(1)
      F12153=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12154()
*                    ~e3    W-   !  W-   ~e3                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  Z    !  Z  | ~N3                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12154(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(P1*(4*P1-C(6)-16*P2)+P2*(C(5)+24*P2)+C(4))+P2*(P2*(-
     >C(5)-16*P2)-C(3))+C(2))+P2*(P2*(P2*(C(6)+4*P2)+C(4))-C(2))-C(1)
      F12154=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12155()
*                             !  Z          ~e3                      
*                            /!---2-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    W-  |!  W- |  W+ | ~N3                      
*                -->--@-1<---+!--<1-@--<3-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n3|P5    |!                                      
*                 ~N3 |  Z   |!                                      
*                --<--@-2----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(16)                                                   
      SAVE
      IF(L(875).EQ.0) CALL CC12155(C)
      TOTNUM=-C(16)
      TOTDEN=+C(15)
      RNUM=+P1*(P1*(P1*(C(4)-C(5)*P1+C(9)*P2)+P2*(-C(8)-C(12)*P2)+C(3))+
     >P2*(P2*(C(11)+C(14)*P2)+C(7))-C(2))+P2*(P2*(-C(10)-C(13)*P2)-C(6))
     >+C(1)
      F12155=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12156()
*                    ~e3    W-   !       ~e3                         
*                   -->--@-1<--\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~n3|P5   | !     |                             
*                    ~N3 |  Z  | !  Z  | ~N3                         
*                   --<--@-2---+-!---2-@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  W- |                             
*                              \-!--<1-/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12156(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P1*(4*P1-C(3)-8*P2)+P2*(C(5)+4*P2)+C(2))+P2*(C(4)+C(6)*P
     >2)+C(1)
      F12156=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12157()
*              ~e3          Z    !  Z          ~e3                   
*             -->--\     /-3-----!---3-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  W-   !  W- |  W+ | ~N3                   
*             --<--@-1<--@-2<----!--<2-@--<4-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(13)                                                   
      SAVE
      IF(L(875).EQ.0) CALL CC12157(C)
      TOTNUM=+C(13)
      TOTDEN=+C(12)
      RNUM=+P1*(P1*(P1*(C(4)+C(5)*P1-C(11)*P2)+P2*(C(8)+C(11)*P2)-C(3))+
     >P2*(-C(7)-C(10)*P2)+C(2))+P2*(C(6)+C(9)*P2)+C(1)
      F12157=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12158()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          Z    !  Z  | ~N3                      
*                -->--\     /-3-----!---3-@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N3 |  W+ |  W-   !  W- |                          
*                --<--@-1<--@-2<----!--<2-/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(9)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12158(C)
      TOTNUM=+C(9)
      TOTDEN=+C(8)
      RNUM=+P1*(P1*(C(3)-C(4)*P1+C(7)*P2)+C(2)+C(6)*P2)-C(1)-C(5)*P2
      F12158=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12159()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N3 |  Z    !  Z  | ~N3                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  W-   !  W- |                             
*                        \-1<----!--<1-/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U875/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(875).EQ.0) CALL CC12159(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12159=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1215()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  c    !  c  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1215(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F1215=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12160()
*                    ~e3    Z    !  Z    ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12160(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+C(2)*S1-C(1)
      F12160=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12161()
*                    ~e3    Z    !  Z    ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12161(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+C(2)*S1-C(1)
      F12161=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12162()
*                                !  H-   ~e3                         
*                               /!--<--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    Z   |!  Z  | ~N3                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e3|P5    |!                                   
*                    ~N3 |  H-  |!                                   
*                   --<--@--<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12162(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(3)*(P2-P1)-C(2))+C(1)*P1
      F12162=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12163()
*                 ~e3    Z    !  Z          ~e3                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  H+ | ~N3                      
*                --<--@--<----!--<--@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12163(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F12163=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12164()
*                    ~e3    Z    !  Z    ~e3                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12164(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F12164=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12165()
*                                !  H-   ~e3                         
*                               /!--<--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    Z   |!  Z  | ~N3                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~N3 |  H-  |!                                   
*                   --<--@--<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12165(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F12165=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12166()
*                 ~e3    Z    !  Z          ~e3                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e6|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  H+ | ~N3                      
*                --<--@--<----!--<--@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12166(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F12166=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12167()
*                    ~e3    H-   !  H-   ~e3                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  Z    !  Z  | ~N3                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12167(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12167=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12168()
*                             !  Z          ~e3                      
*                            /!---1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    H-  |!  H- |  H+ | ~N3                      
*                -->--@--<---+!--<--@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n3|P5    |!                                      
*                 ~N3 |  Z   |!                                      
*                --<--@-1----/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12168(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F12168=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12169()
*              ~e3          Z    !  Z          ~e3                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  H-   !  H- |  H+ | ~N3                   
*             --<--@--<--@--<----!--<--@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U876/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(876).EQ.0) CALL CC12169(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1)+C(1)
      F12169=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1216()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  c    !  c  |  H3 | ~o2                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1216(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+C(3)*P1)+C(1)
      F1216=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12170()
*                    ~e3    h    !  h    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12170(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12170=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12171()
*                    ~e3    h    !  h    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12171(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12171=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12172()
*                                !  W-   ~e3                         
*                               /!--<1-@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    h   |!  h  | ~N3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e3|P5    |!                                   
*                    ~N3 |  W-  |!                                   
*                   --<--@-1<---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12172(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F12172=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12173()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    h   |!  h  |  W+ | ~N3                      
*                -->--@------+!-----@--<2-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e3|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12173(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F12173=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12174()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    h   |!  h  |  H+ | ~N3                      
*                -->--@------+!-----@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e3|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12174(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F12174=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12175()
*                    ~e3    h    !  h    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12175(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12175=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12176()
*                                !  W-   ~e3                         
*                               /!--<1-@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    h   |!  h  | ~N3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e6|P5    |!                                   
*                    ~N3 |  W-  |!                                   
*                   --<--@-1<---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12176(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F12176=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12177()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    h   |!  h  |  W+ | ~N3                      
*                -->--@------+!-----@--<2-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e6|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12177(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F12177=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12178()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    h   |!  h  |  H+ | ~N3                      
*                -->--@------+!-----@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e6|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12178(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F12178=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12179()
*                    ~e3    W-   !  W-   ~e3                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  h    !  h  | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12179(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F12179=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1217()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o2 |  Z  |  c    !  c  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1217(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F1217=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12180()
*                 ~e3    W-   !  W-         ~e3                      
*                -->--@-1<----!--<1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n3|P5     !     |     |                          
*                 ~N3 |  h    !  h  |  W+ | ~N3                      
*                --<--@-------!-----@--<2-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12180(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F12180=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12181()
*                 ~e3    W-   !  W-         ~e3                      
*                -->--@-1<----!--<1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n3|P5     !     |     |                          
*                 ~N3 |  h    !  h  |  H+ | ~N3                      
*                --<--@-------!-----@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12181(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F12181=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12182()
*              ~e3          W-   !  W-         ~e3                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  h    !  h  |  W+ | ~N3                   
*             --<--@-1<--@-------!-----@--<3-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12182(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F12182=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12183()
*              ~e3          W-   !  W-         ~e3                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  h    !  h  |  H+ | ~N3                   
*             --<--@-1<--@-------!-----@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12183(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+C(4)*P2-C(1)
      F12183=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12184()
*              ~e3          W-   !  W-         ~e3                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  h    !  h  |  H+ | ~N3                   
*             --<--@--<--@-------!-----@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U877/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(877).EQ.0) CALL CC12184(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12184=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12185()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12185(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12185=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12186()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12186(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12186=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12187()
*                                !  W-   ~e3                         
*                               /!--<1-@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    H   |!  H  | ~N3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e3|P5    |!                                   
*                    ~N3 |  W-  |!                                   
*                   --<--@-1<---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12187(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F12187=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12188()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    H   |!  H  |  W+ | ~N3                      
*                -->--@------+!-----@--<2-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e3|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12188(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F12188=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12189()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    H   |!  H  |  H+ | ~N3                      
*                -->--@------+!-----@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e3|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12189(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F12189=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1218()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o1          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  c   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1218(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F1218=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12190()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12190(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12190=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12191()
*                                !  W-   ~e3                         
*                               /!--<1-@-->--                        
*                               |!  P3 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    H   |!  H  | ~N3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~e6|P5    |!                                   
*                    ~N3 |  W-  |!                                   
*                   --<--@-1<---/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12191(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F12191=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12192()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    H   |!  H  |  W+ | ~N3                      
*                -->--@------+!-----@--<2-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e6|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12192(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F12192=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12193()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    H   |!  H  |  H+ | ~N3                      
*                -->--@------+!-----@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e6|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12193(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F12193=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12194()
*                    ~e3    W-   !  W-   ~e3                         
*                   -->--@-1<----!--<1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  H    !  H  | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12194(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F12194=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12195()
*                 ~e3    W-   !  W-         ~e3                      
*                -->--@-1<----!--<1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n3|P5     !     |     |                          
*                 ~N3 |  H    !  H  |  W+ | ~N3                      
*                --<--@-------!-----@--<2-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12195(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)+C(2)*P1-C(1)
      F12195=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12196()
*                 ~e3    W-   !  W-         ~e3                      
*                -->--@-1<----!--<1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n3|P5     !     |     |                          
*                 ~N3 |  H    !  H  |  H+ | ~N3                      
*                --<--@-------!-----@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12196(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F12196=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12197()
*              ~e3          W-   !  W-         ~e3                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  H    !  H  |  W+ | ~N3                   
*             --<--@-1<--@-------!-----@--<3-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12197(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(6)*P2-C(4))+C(1)
      F12197=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12198()
*              ~e3          W-   !  W-         ~e3                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  H    !  H  |  H+ | ~N3                   
*             --<--@-1<--@-------!-----@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12198(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+C(4)*P2-C(1)
      F12198=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12199()
*              ~e3          W-   !  W-         ~e3                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  H    !  H  |  H+ | ~N3                   
*             --<--@--<--@-------!-----@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U878/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(878).EQ.0) CALL CC12199(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12199=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1219()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o2 |  Z  |  c    !  c  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1219(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F1219=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F121()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC121(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+4*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F121=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12200()
*                    ~e3    H3   !  H3   ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~N3 |  W-   !  W- | ~N3                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U879/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(879).EQ.0) CALL CC12200(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12200=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12201()
*                             !  W-         ~e3                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    H3  |!  H3 |  H+ | ~N3                      
*                -->--@------+!-----@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e6|P5    |!                                      
*                 ~N3 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U879/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(879).EQ.0) CALL CC12201(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F12201=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12202()
*              ~e3          W-   !  W-         ~e3                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  H3   !  H3 |  H+ | ~N3                   
*             --<--@--<--@-------!-----@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U879/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(879).EQ.0) CALL CC12202(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12202=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12203()
*              ~e3          N1   !  N1         ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  e1   !  e1 |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U880/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(880).EQ.0) CALL CC12203(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12203=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12204()
*              ~e3          N2   !  N2         ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  e2   !  e2 |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U881/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(881).EQ.0) CALL CC12204(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12204=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12205()
*              ~e3          N2   !  N2         ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  e2   !  e2 |  H+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U881/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(881).EQ.0) CALL CC12205(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12205=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12206()
*              ~e3          N2   !  N2         ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  e2   !  e2 |  H+ | ~N3                   
*             --<--@--<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U881/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(881).EQ.0) CALL CC12206(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F12206=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12207()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12207(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12207=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12208()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12208(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12208=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12209()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12209(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12209=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1220()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o1          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  c   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1220(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F1220=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12210()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12210(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12210=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12211()
*                             !  N3         ~e3                      
*                            /!==<==\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    e3  |!  e3 |  W+ | ~N3                      
*                -->--@==>===+!==>==@--<1-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12211(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12211=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12212()
*                             !  N3         ~e3                      
*                            /!==<==\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    e3  |!  e3 |  H+ | ~N3                      
*                -->--@==>===+!==>==@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12212(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12212=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12213()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12213(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12213=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12214()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12214(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12214=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12215()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12215(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12215=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12216()
*                             !  N3         ~e3                      
*                            /!==<==\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    e3  |!  e3 |  W+ | ~N3                      
*                -->--@==>===+!==>==@--<1-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12216(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12216=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12217()
*                             !  N3         ~e3                      
*                            /!==<==\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    e3  |!  e3 |  H+ | ~N3                      
*                -->--@==>===+!==>==@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12217(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12217=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12218()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12218(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12218=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12219()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12219(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12219=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1221()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  c    !  c  |  h  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1221(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)-C(1)
      F1221=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12220()
*                             !  N3         ~e3                      
*                            /!==<==\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    e3  |!  e3 |  W+ | ~N3                      
*                -->--@==>===+!==>==@--<1-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12220(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12220=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12221()
*                             !  N3         ~e3                      
*                            /!==<==\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    e3  |!  e3 |  H+ | ~N3                      
*                -->--@==>===+!==>==@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12221(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12221=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12222()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12222(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12222=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12223()
*                             !  N3         ~e3                      
*                            /!==<==\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    e3  |!  e3 |  W+ | ~N3                      
*                -->--@==>===+!==>==@--<1-@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12223(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12223=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12224()
*                             !  N3         ~e3                      
*                            /!==<==\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    e3  |!  e3 |  H+ | ~N3                      
*                -->--@==>===+!==>==@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~N3 |  N3  |!                                      
*                --<--@==<===/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12224(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12224=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12225()
*              ~e3          N3   !  N3         ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  e3   !  e3 |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12225(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12225=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12226()
*              ~e3          N3   !  N3         ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  e3   !  e3 |  H+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12226(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12226=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12227()
*              ~e3          N3   !  N3         ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  e3   !  e3 |  H+ | ~N3                   
*             --<--@--<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U882/ Q0(6),Q1(6),Q2(6)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(882).EQ.0) CALL CC12227(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F12227=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12228()
*              ~e3          U    !  U          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  d    !  d  |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U883/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(883).EQ.0) CALL CC12228(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12228=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12229()
*              ~e3          U    !  U          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  s    !  s  |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U884/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(884).EQ.0) CALL CC12229(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12229=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1222()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  c    !  c  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1222(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)-C(1)
      F1222=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12230()
*              ~e3          U    !  U          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  s    !  s  |  H+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U884/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(884).EQ.0) CALL CC12230(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12230=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12231()
*              ~e3          U    !  U          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  s    !  s  |  H+ | ~N3                   
*             --<--@--<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U884/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(884).EQ.0) CALL CC12231(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F12231=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12232()
*              ~e3          U    !  U          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  b    !  b  |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U885/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(885).EQ.0) CALL CC12232(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12232=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12233()
*              ~e3          U    !  U          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  b    !  b  |  H+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U885/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(885).EQ.0) CALL CC12233(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12233=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12234()
*              ~e3          U    !  U          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  b    !  b  |  H+ | ~N3                   
*             --<--@--<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U885/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(885).EQ.0) CALL CC12234(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F12234=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12235()
*              ~e3          d    !  d          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  C    !  C  |  W+ | ~N3                   
*             --<--@-1<--@==<====!==<==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U886/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(886).EQ.0) CALL CC12235(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12235=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12236()
*              ~e3          d    !  d          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  C    !  C  |  H+ | ~N3                   
*             --<--@-1<--@==<====!==<==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U886/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(886).EQ.0) CALL CC12236(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12236=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12237()
*              ~e3          d    !  d          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  C    !  C  |  H+ | ~N3                   
*             --<--@--<--@==<====!==<==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U886/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(886).EQ.0) CALL CC12237(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F12237=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12238()
*              ~e3          d    !  d          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  T    !  T  |  W+ | ~N3                   
*             --<--@-1<--@==<====!==<==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U887/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(887).EQ.0) CALL CC12238(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12238=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12239()
*              ~e3          d    !  d          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  T    !  T  |  H+ | ~N3                   
*             --<--@-1<--@==<====!==<==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U887/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(887).EQ.0) CALL CC12239(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12239=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1223()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o2 |  h  |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1223(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F1223=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12240()
*              ~e3          d    !  d          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  T    !  T  |  H+ | ~N3                   
*             --<--@--<--@==<====!==<==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U887/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(887).EQ.0) CALL CC12240(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+2*P1
      F12240=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12241()
*              ~e3          C    !  C          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  s    !  s  |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U888/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(888).EQ.0) CALL CC12241(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12241=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12242()
*              ~e3          C    !  C          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  s    !  s  |  H+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U888/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(888).EQ.0) CALL CC12242(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12242=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12243()
*              ~e3          C    !  C          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  s    !  s  |  H+ | ~N3                   
*             --<--@--<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U888/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(888).EQ.0) CALL CC12243(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12243=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12244()
*              ~e3          C    !  C          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  b    !  b  |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U889/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(889).EQ.0) CALL CC12244(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12244=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12245()
*              ~e3          C    !  C          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  b    !  b  |  H+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U889/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(889).EQ.0) CALL CC12245(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12245=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12246()
*              ~e3          C    !  C          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  b    !  b  |  H+ | ~N3                   
*             --<--@--<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U889/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(889).EQ.0) CALL CC12246(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12246=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12247()
*              ~e3          s    !  s          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  T    !  T  |  W+ | ~N3                   
*             --<--@-1<--@==<====!==<==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U890/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(890).EQ.0) CALL CC12247(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12247=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12248()
*              ~e3          s    !  s          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  T    !  T  |  H+ | ~N3                   
*             --<--@-1<--@==<====!==<==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U890/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(890).EQ.0) CALL CC12248(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12248=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12249()
*              ~e3          s    !  s          ~e3                   
*             -->--\     /==>====!==>==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  T    !  T  |  H+ | ~N3                   
*             --<--@--<--@==<====!==<==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U890/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(890).EQ.0) CALL CC12249(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12249=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1224()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o1          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1224(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F1224=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12250()
*              ~e3          T    !  T          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  b    !  b  |  W+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U891/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(891).EQ.0) CALL CC12250(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12250=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12251()
*              ~e3          T    !  T          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  b    !  b  |  H+ | ~N3                   
*             --<--@-1<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U891/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(891).EQ.0) CALL CC12251(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12251=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12252()
*              ~e3          T    !  T          ~e3                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  b    !  b  |  H+ | ~N3                   
*             --<--@--<--@==>====!==>==@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U891/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(891).EQ.0) CALL CC12252(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12252=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12253()
*                    ~e3    h    !  h    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12253(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12253=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12254()
*                    ~e3    h    !  h    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12254(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12254=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12255()
*                 ~e3    h    !  h          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  W+ | ~N3                      
*                --<--@--<----!--<--@--<1-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12255(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12255=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12256()
*                                !  H-   ~e3                         
*                               /!--<--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    h   |!  h  | ~N3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e3|P5    |!                                   
*                    ~N3 |  H-  |!                                   
*                   --<--@--<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12256(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12256=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12257()
*                 ~e3    h    !  h          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  H+ | ~N3                      
*                --<--@--<----!--<--@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12257(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12257=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12258()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    h    !  h  | ~N3                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e3|P5     !     |                             
*                    ~N3 |  H-   !  H- |                             
*                   --<--@--<----!--<--/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12258(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12258=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12259()
*                    ~e3    h    !  h    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12259(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12259=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1225()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o2 |  h  |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1225(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F1225=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12260()
*                 ~e3    h    !  h          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e6|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  W+ | ~N3                      
*                --<--@--<----!--<--@--<1-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12260(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12260=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12261()
*                                !  H-   ~e3                         
*                               /!--<--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    h   |!  h  | ~N3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~N3 |  H-  |!                                   
*                   --<--@--<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12261(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12261=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12262()
*                 ~e3    h    !  h          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e6|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  H+ | ~N3                      
*                --<--@--<----!--<--@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12262(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12262=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12263()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    h    !  h  | ~N3                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e6|P5     !     |                             
*                    ~N3 |  H-   !  H- |                             
*                   --<--@--<----!--<--/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12263(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12263=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12264()
*              ~e3          h    !  h          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  H-   !  H- |  W+ | ~N3                   
*             --<--@-1<--@--<----!--<--@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12264(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F12264=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12265()
*                                   !  H-   ~e3                      
*                                  /!--<--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~n3|-P6                       
*                 ~e3          h   |!  h  | ~N3                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~N3 |  W+ |  H-  |!                                
*                --<--@-1<--@--<---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12265(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12265=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12266()
*              ~e3          h    !  h          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  H-   !  H- |  H+ | ~N3                   
*             --<--@-1<--@--<----!--<--@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12266(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12266=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12267()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          h    !  h  | ~N3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N3 |  W+ |  H-   !  H- |                          
*                --<--@-1<--@--<----!--<--/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12267(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12267=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12268()
*                    ~e3    H-   !  H-   ~e3                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  h    !  h  | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12268(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12268=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12269()
*                             !  h          ~e3                      
*                            /!-----\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    H-  |!  H- |  H+ | ~N3                      
*                -->--@--<---+!--<--@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n3|P5    |!                                      
*                 ~N3 |  h   |!                                      
*                --<--@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12269(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12269=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1226()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o1          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1226(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F1226=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12270()
*                    ~e3    H-   !       ~e3                         
*                   -->--@--<--\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~n3|P5   | !     |                             
*                    ~N3 |  h  | !  h  | ~N3                         
*                   --<--@-----+-!-----@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  H- |                             
*                              \-!--<--/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12270(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12270=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12271()
*              ~e3          h    !  h          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  H-   !  H- |  H+ | ~N3                   
*             --<--@--<--@--<----!--<--@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12271(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12271=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12272()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          h    !  h  | ~N3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N3 |  H+ |  H-   !  H- |                          
*                --<--@--<--@--<----!--<--/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12272(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12272=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12273()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N3 |  h    !  h  | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  H-   !  H- |                             
*                        \--<----!--<--/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U892/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(892).EQ.0) CALL CC12273(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12273=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12274()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e3|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12274(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12274=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12275()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e3|P5     !  ~e6|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12275(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12275=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12276()
*                 ~e3    H    !  H          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  W+ | ~N3                      
*                --<--@--<----!--<--@--<1-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12276(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12276=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12277()
*                                !  H-   ~e3                         
*                               /!--<--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    H   |!  H  | ~N3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e3|P5    |!                                   
*                    ~N3 |  H-  |!                                   
*                   --<--@--<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12277(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12277=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12278()
*                 ~e3    H    !  H          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e3|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  H+ | ~N3                      
*                --<--@--<----!--<--@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12278(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12278=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12279()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    H    !  H  | ~N3                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e3|P5     !     |                             
*                    ~N3 |  H-   !  H- |                             
*                   --<--@--<----!--<--/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12279(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12279=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1227()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  c    !  c  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1227(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)-C(1)
      F1227=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12280()
*                    ~e3    H    !  H    ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12280(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12280=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12281()
*                 ~e3    H    !  H          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e6|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  W+ | ~N3                      
*                --<--@--<----!--<--@--<1-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12281(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12281=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12282()
*                                !  H-   ~e3                         
*                               /!--<--@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n3|-P6                          
*                    ~e3    H   |!  H  | ~N3                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~e6|P5    |!                                   
*                    ~N3 |  H-  |!                                   
*                   --<--@--<---/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12282(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12282=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12283()
*                 ~e3    H    !  H          ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e6|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  H+ | ~N3                      
*                --<--@--<----!--<--@--<--@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12283(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12283=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12284()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    H    !  H  | ~N3                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e6|P5     !     |                             
*                    ~N3 |  H-   !  H- |                             
*                   --<--@--<----!--<--/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12284(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12284=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12285()
*              ~e3          H    !  H          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  H-   !  H- |  W+ | ~N3                   
*             --<--@-1<--@--<----!--<--@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12285(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F12285=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12286()
*                                   !  H-   ~e3                      
*                                  /!--<--@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~n3|-P6                       
*                 ~e3          H   |!  H  | ~N3                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~N3 |  W+ |  H-  |!                                
*                --<--@-1<--@--<---/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12286(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12286=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12287()
*              ~e3          H    !  H          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  H-   !  H- |  H+ | ~N3                   
*             --<--@-1<--@--<----!--<--@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12287(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12287=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12288()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H    !  H  | ~N3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N3 |  W+ |  H-   !  H- |                          
*                --<--@-1<--@--<----!--<--/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12288(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12288=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12289()
*                    ~e3    H-   !  H-   ~e3                         
*                   -->--@--<----!--<--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n3|P5     !  ~n3|-P6                          
*                    ~N3 |  H    !  H  | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12289(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12289=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1228()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o2 |  H  |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1228(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F1228=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12290()
*                             !  H          ~e3                      
*                            /!-----\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~e3    H-  |!  H- |  H+ | ~N3                      
*                -->--@--<---+!--<--@--<--@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n3|P5    |!                                      
*                 ~N3 |  H   |!                                      
*                --<--@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12290(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12290=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12291()
*                    ~e3    H-   !       ~e3                         
*                   -->--@--<--\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~n3|P5   | !     |                             
*                    ~N3 |  H  | !  H  | ~N3                         
*                   --<--@-----+-!-----@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  H- |                             
*                              \-!--<--/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12291(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12291=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12292()
*              ~e3          H    !  H          ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  H+ |  H-   !  H- |  H+ | ~N3                   
*             --<--@--<--@--<----!--<--@--<--@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12292(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12292=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12293()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H    !  H  | ~N3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N3 |  H+ |  H-   !  H- |                          
*                --<--@--<--@--<----!--<--/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12293(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12293=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12294()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N3 |  H    !  H  | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  H-   !  H- |                             
*                        \--<----!--<--/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U893/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(893).EQ.0) CALL CC12294(C)
      TOTNUM=+C(1)
      TOTDEN=+1
      RNUM=+1
      F12294=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12295()
*                    ~e3    H3   !  H3   ~e3                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e6|P5     !  ~e6|-P6                          
*                    ~N3 |  H-   !  H- | ~N3                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U894/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(894).EQ.0) CALL CC12295(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12295=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12296()
*                 ~e3    H3   !  H3         ~e3                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e6|P5     !     |     |                          
*                 ~N3 |  H-   !  H- |  W+ | ~N3                      
*                --<--@--<----!--<--@--<1-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U894/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(894).EQ.0) CALL CC12296(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12296=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12297()
*                                !       ~e3                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~e3    H3   !  H3 | ~N3                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~e6|P5     !     |                             
*                    ~N3 |  H-   !  H- |                             
*                   --<--@--<----!--<--/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U894/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(894).EQ.0) CALL CC12297(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12297=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12298()
*              ~e3          H3   !  H3         ~e3                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N3 |  W+ |  H-   !  H- |  W+ | ~N3                   
*             --<--@-1<--@--<----!--<--@--<2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U894/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(894).EQ.0) CALL CC12298(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))+C(1)
      F12298=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12299()
*                                   !       ~e3                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~e3          H3   !  H3 | ~N3                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N3 |  W+ |  H-   !  H- |                          
*                --<--@-1<--@--<----!--<--/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U894/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(894).EQ.0) CALL CC12299(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+C(3)*P2-C(1)-C(2)*P1
      F12299=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1229()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o1          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1229(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F1229=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F122()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC122(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F122=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(7
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12300()
*                    ~e3         !       ~e3                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N3 |  H3   !  H3 | ~N3                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  H-   !  H- |                             
*                        \--<----!--<--/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U894/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(1)                                                    
      SAVE
      IF(L(894).EQ.0) CALL CC12300(C)
      TOTNUM=-C(1)
      TOTDEN=+1
      RNUM=+1
      F12300=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12301()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U895/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(895).EQ.0) CALL CC12301(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12301=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12302()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U895/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(895).EQ.0) CALL CC12302(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12302=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12303()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  d    !  d  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U895/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(895).EQ.0) CALL CC12303(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12303=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12304()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U896/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(896).EQ.0) CALL CC12304(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12304=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12305()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U896/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(896).EQ.0) CALL CC12305(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12305=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12306()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  s    !  s  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U896/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(896).EQ.0) CALL CC12306(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12306=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12307()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U897/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(897).EQ.0) CALL CC12307(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12307=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12308()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U897/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(897).EQ.0) CALL CC12308(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12308=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12309()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~u1 |  b    !  b  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U897/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(897).EQ.0) CALL CC12309(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12309=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1230()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o2 |  H  |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1230(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F1230=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12310()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12310(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12310=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12311()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12311(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12311=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12312()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12312(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12312=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12313()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12313(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12313=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12314()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12314(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12314=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12315()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12315(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12315=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12316()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12316(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12316=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12317()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12317(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12317=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12318()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12318(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12318=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12319()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U898/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(898).EQ.0) CALL CC12319(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12319=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1231()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o1          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1231(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F1231=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12320()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12320(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12320=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12321()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12321(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12321=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12322()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12322(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12322=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12323()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12323(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12323=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12324()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12324(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12324=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12325()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12325(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12325=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12326()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12326(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12326=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12327()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12327(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12327=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12328()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12328(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12328=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12329()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U899/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(899).EQ.0) CALL CC12329(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12329=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1232()
*              ~o1          C    !  C          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  c    !  c  |  H3 | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1232(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F1232=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12330()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12330(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12330=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12331()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12331(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12331=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12332()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12332(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12332=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12333()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12333(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12333=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12334()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12334(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12334=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12335()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12335(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12335=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12336()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12336(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12336=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12337()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12337(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12337=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12338()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12338(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12338=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12339()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U900/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(900).EQ.0) CALL CC12339(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12339=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1233()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c1|-P6                       
*                 ~o2 |  H3 |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1233(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F1233=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12340()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~D1 |  U    !  U  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U901/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(901).EQ.0) CALL CC12340(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12340=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12341()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~D1 |  U    !  U  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U901/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(901).EQ.0) CALL CC12341(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12341=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12342()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~D1 |  U    !  U  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U901/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(901).EQ.0) CALL CC12342(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12342=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12343()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~D1 |  C    !  C  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U902/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(902).EQ.0) CALL CC12343(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12343=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12344()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~D1 |  C    !  C  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U902/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(902).EQ.0) CALL CC12344(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12344=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12345()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~D1 |  C    !  C  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U902/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(902).EQ.0) CALL CC12345(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12345=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12346()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~D1 |  T    !  T  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U903/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(903).EQ.0) CALL CC12346(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12346=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12347()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~D1 |  T    !  T  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U903/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(903).EQ.0) CALL CC12347(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12347=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12348()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~D1 |  T    !  T  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U903/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(903).EQ.0) CALL CC12348(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12348=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12349()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12349(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12349=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1234()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c1|-P6                       
*                 ~o1          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1234(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F1234=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12350()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12350(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12350=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12351()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12351(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12351=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12352()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12352(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12352=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12353()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12353(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12353=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12354()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12354(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12354=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12355()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12355(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12355=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12356()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12356(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12356=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12357()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12357(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12357=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12358()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~D1 |  D    !  D  | ~D1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U904/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(904).EQ.0) CALL CC12358(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12358=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12359()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~c1 |  d    !  d  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U905/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(905).EQ.0) CALL CC12359(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12359=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1235()
*                 ~o1          C    !  C    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~c2|-P6                       
*                 ~o2 |  H3 |  c    !  c  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1235(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F1235=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12360()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~c1 |  d    !  d  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U905/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(905).EQ.0) CALL CC12360(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12360=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12361()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~c1 |  d    !  d  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U905/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(905).EQ.0) CALL CC12361(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12361=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12362()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~c1 |  s    !  s  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U906/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(906).EQ.0) CALL CC12362(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12362=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12363()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~c1 |  s    !  s  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U906/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(906).EQ.0) CALL CC12363(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12363=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12364()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~c1 |  s    !  s  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U906/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(906).EQ.0) CALL CC12364(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12364=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12365()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U907/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(907).EQ.0) CALL CC12365(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12365=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12366()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U907/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(907).EQ.0) CALL CC12366(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12366=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12367()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~c1 |  b    !  b  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U907/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(907).EQ.0) CALL CC12367(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12367=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12368()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12368(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12368=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12369()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12369(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12369=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1236()
*                                   !  c    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~c2|-P6                       
*                 ~o1          C   |!  C  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  c   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1236(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F1236=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12370()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12370(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12370=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12371()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12371(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12371=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12372()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12372(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12372=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12373()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12373(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12373=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12374()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12374(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12374=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12375()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12375(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12375=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12376()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12376(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12376=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12377()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~c1 |  c    !  c  | ~c1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U908/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(908).EQ.0) CALL CC12377(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12377=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12378()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12378(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12378=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12379()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12379(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12379=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1237()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~o2 |  c    !  c  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1237(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F1237=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12380()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12380(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12380=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12381()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12381(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12381=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12382()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12382(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12382=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12383()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12383(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12383=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12384()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12384(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12384=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12385()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12385(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12385=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12386()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12386(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12386=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12387()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~C1 |  C    !  C  | ~C1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U909/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(909).EQ.0) CALL CC12387(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12387=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12388()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12388(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12388=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12389()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12389(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12389=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1238()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c1|-P6                          
*                    ~o1    C   |!  C  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~o2 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1238(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1238=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12390()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12390(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12390=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12391()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12391(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12391=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12392()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12392(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12392=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12393()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12393(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12393=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12394()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12394(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12394=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12395()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12395(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12395=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12396()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12396(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12396=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12397()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~s1 |  s    !  s  | ~s1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U910/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(910).EQ.0) CALL CC12397(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12397=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12398()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~S1 |  U    !  U  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U911/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(911).EQ.0) CALL CC12398(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12398=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12399()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~S1 |  U    !  U  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U911/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(911).EQ.0) CALL CC12399(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12399=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1239()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~o2 |  c    !  c  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1239(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F1239=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F123()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC123(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F123=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(8)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12400()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~S1 |  U    !  U  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U911/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(911).EQ.0) CALL CC12400(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12400=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12401()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~S1 |  C    !  C  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U912/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(912).EQ.0) CALL CC12401(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12401=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12402()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~S1 |  C    !  C  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U912/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(912).EQ.0) CALL CC12402(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12402=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12403()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~S1 |  C    !  C  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U912/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(912).EQ.0) CALL CC12403(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12403=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12404()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~S1 |  T    !  T  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U913/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(913).EQ.0) CALL CC12404(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12404=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12405()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~S1 |  T    !  T  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U913/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(913).EQ.0) CALL CC12405(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12405=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12406()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~S1 |  T    !  T  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U913/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(913).EQ.0) CALL CC12406(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12406=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12407()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12407(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12407=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12408()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12408(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12408=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12409()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12409(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12409=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1240()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    C   |!  C  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c1|P5    |!                                   
*                    ~o2 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1240(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1240=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12410()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12410(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12410=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12411()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12411(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12411=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12412()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12412(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12412=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12413()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12413(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12413=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12414()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12414(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12414=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12415()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12415(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12415=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12416()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~S1 |  S    !  S  | ~S1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U914/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(914).EQ.0) CALL CC12416(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12416=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12417()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U915/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(915).EQ.0) CALL CC12417(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12417=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12418()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U915/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(915).EQ.0) CALL CC12418(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12418=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12419()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  d    !  d  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U915/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(915).EQ.0) CALL CC12419(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12419=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1241()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c1|-P6                          
*                    ~o2 |  C    !  C  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1241(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F1241=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12420()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U916/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(916).EQ.0) CALL CC12420(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12420=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12421()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U916/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(916).EQ.0) CALL CC12421(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12421=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12422()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  s    !  s  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U916/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(916).EQ.0) CALL CC12422(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12422=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12423()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U917/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(917).EQ.0) CALL CC12423(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12423=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12424()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U917/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(917).EQ.0) CALL CC12424(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12424=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12425()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~t1 |  b    !  b  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U917/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(917).EQ.0) CALL CC12425(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12425=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12426()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12426(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12426=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12427()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12427(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12427=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12428()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12428(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12428=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12429()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12429(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12429=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1242()
*                                !  C    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    c   |!  c  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~c1|P5    |!                                   
*                    ~o2 |  C   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1242(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1242=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12430()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12430(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12430=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12431()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12431(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12431=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12432()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12432(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12432=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12433()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12433(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12433=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12434()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12434(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12434=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12435()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~t1 |  t    !  t  | ~t1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U918/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(918).EQ.0) CALL CC12435(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12435=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12436()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12436(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12436=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12437()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12437(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12437=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12438()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12438(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12438=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12439()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12439(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12439=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1243()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c1|P5     !  ~c2|-P6                          
*                    ~o2 |  C    !  C  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1243(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F1243=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12440()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12440(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12440=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12441()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12441(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12441=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12442()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12442(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12442=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12443()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12443(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12443=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12444()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12444(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12444=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12445()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~T1 |  T    !  T  | ~T1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U919/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(919).EQ.0) CALL CC12445(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12445=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12446()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12446(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12446=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12447()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12447(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12447=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12448()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12448(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12448=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12449()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12449(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12449=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1244()
*                    ~o1    C    !  C    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~o2 |  c    !  c  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1244(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F1244=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12450()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12450(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12450=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12451()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12451(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12451=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12452()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12452(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12452=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12453()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12453(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12453=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12454()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12454(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12454=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12455()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~b1 |  b    !  b  | ~b1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U920/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(920).EQ.0) CALL CC12455(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12455=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12456()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U921/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(921).EQ.0) CALL CC12456(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12456=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12457()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U921/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(921).EQ.0) CALL CC12457(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12457=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12458()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  U    !  U  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U921/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(921).EQ.0) CALL CC12458(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12458=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12459()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U922/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(922).EQ.0) CALL CC12459(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12459=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1245()
*                                !  c    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~c2|-P6                          
*                    ~o1    C   |!  C  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~c2|P5    |!                                   
*                    ~o2 |  c   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1245(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1245=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12460()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U922/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(922).EQ.0) CALL CC12460(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12460=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12461()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  C    !  C  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U922/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(922).EQ.0) CALL CC12461(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12461=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12462()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U923/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(923).EQ.0) CALL CC12462(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12462=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12463()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U923/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(923).EQ.0) CALL CC12463(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12463=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12464()
*                    ~e3    n3   !  n3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~B1 |  T    !  T  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U923/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(923).EQ.0) CALL CC12464(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12464=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12465()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12465(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12465=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12466()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12466(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12466=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12467()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12467(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12467=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12468()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12468(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12468=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12469()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12469(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12469=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1246()
*                    ~o1    c    !  c    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~c2|P5     !  ~c2|-P6                          
*                    ~o2 |  C    !  C  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U42/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(42).EQ.0) CALL CC1246(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F1246=RNUM*(TOTNUM/TOTDEN)*Q2(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12470()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12470(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12470=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12471()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12471(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12471=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12472()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12472(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12472=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12473()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12473(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12473=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12474()
*                    ~e3    e3   !  e3   ~e3                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~B1 |  B    !  B  | ~B1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U924/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(924).EQ.0) CALL CC12474(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12474=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12475()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12475(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12475=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12476()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o1|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12476(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12476=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12477()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12477(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12477=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12478()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12478(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12478=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12479()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12479(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12479=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1247()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  s    !  s  |  Z  | ~o2                   
*             =====@-1---@==>====!==>==@---2-@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1247(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(C(2)+C(3)*P1-C(5)*P2)+P2*(C(5)*P2-C(4))-C(1)
      F1247=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12480()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12480(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12480=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12481()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12481(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12481=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(7)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12482()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o1|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12482(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12482=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(8)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12483()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12483(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12483=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12484()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o2|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12484(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12484=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12485()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12485(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12485=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12486()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12486(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12486=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12487()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12487(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12487=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(7)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12488()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12488(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12488=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(8)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12489()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12489(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12489=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1248()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  Z  |  s    !  s  |  H3 | ~o2                   
*             =====@-1---@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1248(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+C(3)*P1)+C(1)
      F1248=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12490()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12490(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12490=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12491()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12491(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12491=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12492()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o3|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12492(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12492=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12493()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n1 |  n1   !  n1 | ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12493(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12493=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0
     >(6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12494()
*                                !  n1   ~n1                         
*                               /!==>==@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~n1    n1  |!  n1 | ~n1                         
*                   -->--@==>===+!==>==@-->--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o4|P5    |!                                   
*                    ~n1 |  n1  |!                                   
*                   -->--@==>===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U925/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(925).EQ.0) CALL CC12494(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12494=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0
     >(5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12495()
*                    ~n1    Z    !  Z    ~n1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  Z    !  Z  | ~N1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12495(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F12495=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12496()
*                                !  Z    ~n1                         
*                               /!---2-@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~n1    Z   |!  Z  | ~N1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~n1|P5    |!                                   
*                    ~N1 |  Z   |!                                   
*                   --<--@-2----/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12496(C)
      TOTNUM=+C(8)
      TOTDEN=+C(7)
      S1=P1**2
      RNUM=+P2*(P2*(P1*(C(5)+P1-2*P2)+P2*(P2-C(6))+C(4))+P1*(-C(2)-C(3)*
     >P1))+C(1)*S1
      F12496=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12497()
*                                !       ~n1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~n1    Z    !  Z  | ~N1                         
*                   -->--@-1-----!---1-@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~n1|P5     !     |                             
*                    ~N1 |  Z    !  Z  |                             
*                   --<--@-2-----!---2-/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12497(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F12497=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12498()
*                 ~n1    Z    !  Z          ~n1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  Z    !  Z  |  h  | ~N1                      
*                --<--@-2-----!---2-@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12498(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F12498=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12499()
*                 ~n1    Z    !  Z          ~n1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  Z    !  Z  |  H  | ~N1                      
*                --<--@-2-----!---2-@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12499(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F12499=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1249()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o2 |  Z  |  s    !  s  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1249(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F1249=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F124()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o3|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC124(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F124=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(9)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12500()
*                    ~n1         !       ~n1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N1 |  Z    !  Z  | ~N1                         
*                   --<--@-2-----!---2-@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  Z    !  Z  |                             
*                        \-1-----!---1-/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12500(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F12500=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12501()
*                 ~n1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~N1 |  Z    !  Z          ~n1                      
*                --<--@-2-----!---2-\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  Z    !  Z  |  h  | ~N1                      
*                     \-1-----!---1-@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12501(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F12501=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12502()
*                 ~n1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~N1 |  Z    !  Z          ~n1                      
*                --<--@-2-----!---2-\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  Z    !  Z  |  H  | ~N1                      
*                     \-1-----!---1-@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12502(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F12502=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12503()
*              ~n1          Z    !  Z          ~n1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  Z    !  Z  |  h  | ~N1                   
*             --<--@-----@-1-----!---1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12503(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F12503=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12504()
*              ~n1          Z    !  Z          ~n1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  Z    !  Z  |  H  | ~N1                   
*             --<--@-----@-1-----!---1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12504(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F12504=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12505()
*              ~n1          Z    !  Z          ~n1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  Z    !  Z  |  H  | ~N1                   
*             --<--@-----@-1-----!---1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U926/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(926).EQ.0) CALL CC12505(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+P1)+C(1)
      F12505=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12506()
*                    ~n1    Z    !  Z    ~n1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  h    !  h  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U927/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(927).EQ.0) CALL CC12506(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F12506=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12507()
*                 ~n1    Z    !  Z          ~n1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  h    !  h  |  Z  | ~N1                      
*                --<--@-------!-----@---2-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U927/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(927).EQ.0) CALL CC12507(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(4*P2-C(3)-2*P1)+C(2)*P1-C(1)
      F12507=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12508()
*                                !  h    ~n1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~n1    Z   |!  Z  | ~N1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~n1|P5    |!                                   
*                    ~N1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U927/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(927).EQ.0) CALL CC12508(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F12508=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12509()
*              ~n1          Z    !  Z          ~n1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  h    !  h  |  Z  | ~N1                   
*             --<--@-1---@-------!-----@---3-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U927/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(927).EQ.0) CALL CC12509(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P1-16*P2)+P2*(16*P2-C(3))+C(1)
      F12509=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1250()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o1          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  s   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1250(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F1250=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12510()
*                                   !  h    ~n1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~n1|-P6                       
*                 ~n1          Z   |!  Z  | ~N1                      
*                -->--\     /-2----+!---2-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~N1 |  Z  |  h   |!                                
*                --<--@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U927/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(927).EQ.0) CALL CC12510(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P1-12*P2)+P2*(8*P2-C(3))+C(1)
      F12510=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12511()
*                    ~n1    h    !  h    ~n1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  Z    !  Z  | ~N1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U927/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(927).EQ.0) CALL CC12511(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12511=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12512()
*                    ~n1    Z    !  Z    ~n1                         
*                   -->--@-1-----!---1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  H    !  H  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U928/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(928).EQ.0) CALL CC12512(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F12512=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12513()
*                 ~n1    Z    !  Z          ~n1                      
*                -->--@-1-----!---1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  H    !  H  |  Z  | ~N1                      
*                --<--@-------!-----@---2-@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U928/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(928).EQ.0) CALL CC12513(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(4*P2-C(3)-2*P1)+C(2)*P1-C(1)
      F12513=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12514()
*                                !  H    ~n1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~n1    Z   |!  Z  | ~N1                         
*                   -->--@-1----+!---1-@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~n1|P5    |!                                   
*                    ~N1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U928/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(928).EQ.0) CALL CC12514(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P2*(2*(P2-P1)-C(2))+C(1)*P1
      F12514=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12515()
*              ~n1          Z    !  Z          ~n1                   
*             -->--\     /-2-----!---2-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  H    !  H  |  Z  | ~N1                   
*             --<--@-1---@-------!-----@---3-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U928/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(928).EQ.0) CALL CC12515(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P1-16*P2)+P2*(16*P2-C(3))+C(1)
      F12515=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12516()
*                                   !  H    ~n1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~n1|-P6                       
*                 ~n1          Z   |!  Z  | ~N1                      
*                -->--\     /-2----+!---2-@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~N1 |  Z  |  H   |!                                
*                --<--@-1---@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U928/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(928).EQ.0) CALL CC12516(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P1-12*P2)+P2*(8*P2-C(3))+C(1)
      F12516=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12517()
*                    ~n1    H    !  H    ~n1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  Z    !  Z  | ~N1                         
*                   --<--@-1-----!---1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U928/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(928).EQ.0) CALL CC12517(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12517=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12518()
*              ~n1          Z    !  Z          ~n1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H3   !  H3 |  h  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U929/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(929).EQ.0) CALL CC12518(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1)+C(1)
      F12518=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12519()
*              ~n1          Z    !  Z          ~n1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H3   !  H3 |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U929/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(929).EQ.0) CALL CC12519(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1)+C(1)
      F12519=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1251()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o2 |  Z  |  s    !  s  | ~o2                      
*                =====@-1---@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1251(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(C(5)*P2-C(2)-C(3)*P1)+P2*(C(4)+C(6)*P2)-C(1)
      F1251=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12520()
*              ~n1          Z    !  Z          ~n1                   
*             -->--\     /-1-----!---1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  H3   !  H3 |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U929/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(929).EQ.0) CALL CC12520(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1)+C(1)
      F12520=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12521()
*                    ~n1    W+   !  W+   ~n1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~N1 |  W-   !  W- | ~N1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12521(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      S1=P2**2
      RNUM=+S1*(S1-C(2))+C(1)
      F12521=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12522()
*                             !  W-         ~n1                      
*                            /!--<2-\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    W+  |!  W+ |  Z  | ~N1                      
*                -->--@-1>---+!-->1-@---3-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~N1 |  W-  |!                                      
*                --<--@-2<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(930).EQ.0) CALL CC12522(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P2*(P1*(P2*(C(8)-P1+2*P2)+C(6)*P1-C(5))+P2*(C(7)-C(9)*P2)-C(
     >4))+P1*(C(2)-C(3)*P1)+C(1)
      F12522=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12523()
*                    ~n1    W+   !       ~n1                         
*                   -->--@-1>--\ !     /-->--                        
*                     P1 |  P3 | !     |  P1                         
*                     ~e1|P5   | !     |                             
*                    ~N1 |  W- | !  W- | ~N1                         
*                   --<--@-2<--+-!--<2-@--<--                        
*                     P2    P4 | !  P4 |  P2                         
*                              | !     |                             
*                              | !  W+ |                             
*                              \-!-->1-/                             
*                                !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12523(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F12523=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12524()
*                             !  W-         ~n1                      
*                            /!--<2-\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    W+  |!  W+ |  h  | ~N1                      
*                -->--@-1>---+!-->1-@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~N1 |  W-  |!                                      
*                --<--@-2<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12524(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F12524=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12525()
*                             !  W-         ~n1                      
*                            /!--<2-\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    W+  |!  W+ |  H  | ~N1                      
*                -->--@-1>---+!-->1-@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~N1 |  W-  |!                                      
*                --<--@-2<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12525(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(P1*(P2-C(3))+C(4)*P2-C(2))+C(1)*P1
      F12525=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12526()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  W+   !  W+ |  Z  | ~N1                   
*             --<--@-1---@-2>----!-->2-@---4-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(11)                                                   
      SAVE
      IF(L(930).EQ.0) CALL CC12526(C)
      TOTNUM=+C(11)
      TOTDEN=+C(10)
      RNUM=+P1*(P1*(P1*(C(4)+P1-4*P2)+P2*(C(7)+4*P2)-C(3))+P2*(-C(6)-C(9
     >)*P2)+C(2))+P2*(C(8)*P2-C(5))+C(1)
      F12526=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12527()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          W-   !  W- | ~N1                      
*                -->--\     /-3<----!--<3-@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  Z  |  W+   !  W+ |                          
*                --<--@-1---@-2>----!-->2-/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12527(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(2*P2-C(3)-P1)+C(2)+C(5)*P2)+C(1)-C(4)*P2
      F12527=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12528()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  W+   !  W+ |  h  | ~N1                   
*             --<--@-1---@-2>----!-->2-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12528(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(2*P2-C(3)-P1)+C(2)+C(5)*P2)+C(1)-C(4)*P2
      F12528=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12529()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-3<----!--<3-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  W+   !  W+ |  H  | ~N1                   
*             --<--@-1---@-2>----!-->2-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12529(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P1*(P1*(2*P2-C(3)-P1)+C(2)+C(5)*P2)+C(1)-C(4)*P2
      F12529=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1252()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o1          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  Z  |  s   |!                                
*                =====@-1---@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1252(C)
      TOTNUM=-C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(C(5)*P2-C(3)-C(4)*P1)-C(1)-C(2)*P1
      F1252=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(6)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12530()
*                    ~n1         !       ~n1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N1 |  W-   !  W- | ~N1                         
*                   --<--@-2<----!--<2-@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  W+   !  W+ |                             
*                        \-1>----!-->1-/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12530(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F12530=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12531()
*                 ~n1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~N1 |  W-   !  W-         ~n1                      
*                --<--@-2<----!--<2-\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  W+   !  W+ |  h  | ~N1                      
*                     \-1>----!-->1-@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12531(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F12531=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12532()
*                 ~n1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~N1 |  W-   !  W-         ~n1                      
*                --<--@-2<----!--<2-\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  W+   !  W+ |  H  | ~N1                      
*                     \-1>----!-->1-@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12532(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F12532=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12533()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  W+   !  W+ |  h  | ~N1                   
*             --<--@-----@-1>----!-->1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12533(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F12533=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12534()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  W+   !  W+ |  H  | ~N1                   
*             --<--@-----@-1>----!-->1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12534(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F12534=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12535()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-2<----!--<2-\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  W+   !  W+ |  H  | ~N1                   
*             --<--@-----@-1>----!-->1-@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U930/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(930).EQ.0) CALL CC12535(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(P1-C(2))+C(1)
      F12535=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12536()
*                    ~n1    W+   !  W+   ~n1                         
*                   -->--@-1>----!-->1-@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~N1 |  H-   !  H- | ~N1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U931/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(931).EQ.0) CALL CC12536(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      S1=P2**2
      RNUM=+S1-C(1)
      F12536=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12537()
*                 ~n1    W+   !  W+         ~n1                      
*                -->--@-1>----!-->1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e1|P5     !     |     |                          
*                 ~N1 |  H-   !  H- |  h  | ~N1                      
*                --<--@--<----!--<--@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U931/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(931).EQ.0) CALL CC12537(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F12537=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12538()
*                 ~n1    W+   !  W+         ~n1                      
*                -->--@-1>----!-->1-\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~e1|P5     !     |     |                          
*                 ~N1 |  H-   !  H- |  H  | ~N1                      
*                --<--@--<----!--<--@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U931/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(931).EQ.0) CALL CC12538(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(2*P2-C(2))+C(3)*P2-C(1)
      F12538=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12539()
*              ~n1          W+   !  W+         ~n1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H-   !  H- |  h  | ~N1                   
*             --<--@-----@--<----!--<--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U931/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(931).EQ.0) CALL CC12539(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12539=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1253()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  s    !  s  |  h  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1253(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)-C(1)
      F1253=RNUM*(TOTNUM/TOTDEN)*Q2(7)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12540()
*              ~n1          W+   !  W+         ~n1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H-   !  H- |  H  | ~N1                   
*             --<--@-----@--<----!--<--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U931/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(931).EQ.0) CALL CC12540(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12540=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12541()
*              ~n1          W+   !  W+         ~n1                   
*             -->--\     /-1>----!-->1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  H-   !  H- |  H  | ~N1                   
*             --<--@-----@--<----!--<--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U931/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(931).EQ.0) CALL CC12541(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12541=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12542()
*                    ~n1    H+   !  H+   ~n1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~N1 |  W-   !  W- | ~N1                         
*                   --<--@-1<----!--<1-@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U932/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(932).EQ.0) CALL CC12542(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+4*P1-8*P2)+P2*(4*P2-C(2))+C(1)
      F12542=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12543()
*                             !  W-         ~n1                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    H+  |!  H+ |  h  | ~N1                      
*                -->--@-->---+!-->--@-----@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~N1 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U932/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(932).EQ.0) CALL CC12543(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F12543=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12544()
*                             !  W-         ~n1                      
*                            /!--<1-\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    H+  |!  H+ |  H  | ~N1                      
*                -->--@-->---+!-->--@-----@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~N1 |  W-  |!                                      
*                --<--@-1<---/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U932/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(932).EQ.0) CALL CC12544(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(4*(P2-P1)-C(2))+C(3)*P2-C(1)
      F12544=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12545()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H+   !  H+ |  h  | ~N1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U932/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(932).EQ.0) CALL CC12545(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12545=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12546()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H+   !  H+ |  H  | ~N1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U932/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(932).EQ.0) CALL CC12546(C)
      TOTNUM=-C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12546=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12547()
*              ~n1          W-   !  W-         ~n1                   
*             -->--\     /-1<----!--<1-\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  H+   !  H+ |  H  | ~N1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U932/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(932).EQ.0) CALL CC12547(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(4*P1-C(2))+C(1)
      F12547=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12548()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12548(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12548=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12549()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12549(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12549=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1254()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  h  |  s    !  s  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1254(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)-C(1)
      F1254=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(6)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12550()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12550(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12550=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12551()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12551(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12551=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12552()
*                             !  N1         ~n1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    n1  |!  n1 |  Z  | ~N1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o1|P5    |!                                      
*                 ~N1 |  N1  |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12552(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12552=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(5)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12553()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12553(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12553=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12554()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12554(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12554=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12555()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12555(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12555=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12556()
*                             !  N1         ~n1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    n1  |!  n1 |  Z  | ~N1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o2|P5    |!                                      
*                 ~N1 |  N1  |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12556(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12556=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12557()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12557(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12557=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12558()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12558(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12558=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12559()
*                             !  N1         ~n1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    n1  |!  n1 |  Z  | ~N1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o3|P5    |!                                      
*                 ~N1 |  N1  |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12559(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12559=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1255()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o2 |  h  |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1255(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F1255=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12560()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~N1 |  N1   !  N1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12560(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12560=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12561()
*                             !  N1         ~n1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    n1  |!  n1 |  Z  | ~N1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~o4|P5    |!                                      
*                 ~N1 |  N1  |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12561(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12561=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12562()
*              ~n1          N1   !  N1         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  n1   !  n1 |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U933/ Q0(5),Q1(5),Q2(5)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(933).EQ.0) CALL CC12562(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12562=RNUM*(TOTNUM/TOTDEN)*Q2(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12563()
*              ~n1          N2   !  N2         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  n2   !  n2 |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U934/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(934).EQ.0) CALL CC12563(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12563=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12564()
*              ~n1          N3   !  N3         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  n3   !  n3 |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U935/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(935).EQ.0) CALL CC12564(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12564=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12565()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~N1 |  E1   !  E1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U936/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(936).EQ.0) CALL CC12565(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12565=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12566()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~N1 |  E1   !  E1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U936/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(936).EQ.0) CALL CC12566(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12566=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12567()
*                             !  E1         ~n1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    e1  |!  e1 |  Z  | ~N1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~1+|P5    |!                                      
*                 ~N1 |  E1  |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U936/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(936).EQ.0) CALL CC12567(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12567=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12568()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~N1 |  E1   !  E1 | ~N1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U936/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(936).EQ.0) CALL CC12568(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(2*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12568=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12569()
*                             !  E1         ~n1                      
*                            /!==<==\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    e1  |!  e1 |  Z  | ~N1                      
*                -->--@==>===+!==>==@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~2+|P5    |!                                      
*                 ~N1 |  E1  |!                                      
*                --<--@==<===/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U936/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(936).EQ.0) CALL CC12569(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12569=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1256()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o1          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1256(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F1256=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12570()
*              ~n1          E1   !  E1         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  e1   !  e1 |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U936/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(936).EQ.0) CALL CC12570(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12570=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12571()
*              ~n1          E2   !  E2         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  e2   !  e2 |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U937/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(937).EQ.0) CALL CC12571(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12571=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12572()
*              ~n1          E2   !  E2         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  e2   !  e2 |  h  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U937/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(937).EQ.0) CALL CC12572(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12572=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12573()
*              ~n1          E2   !  E2         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  e2   !  e2 |  H  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U937/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(937).EQ.0) CALL CC12573(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12573=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12574()
*              ~n1          E2   !  E2         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  e2   !  e2 |  h  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U937/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(937).EQ.0) CALL CC12574(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12574=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12575()
*              ~n1          E2   !  E2         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  e2   !  e2 |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U937/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(937).EQ.0) CALL CC12575(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12575=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12576()
*              ~n1          E2   !  E2         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  e2   !  e2 |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U937/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(937).EQ.0) CALL CC12576(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12576=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12577()
*              ~n1          E3   !  E3         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  e3   !  e3 |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U938/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(938).EQ.0) CALL CC12577(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12577=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12578()
*              ~n1          E3   !  E3         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  e3   !  e3 |  h  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U938/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(938).EQ.0) CALL CC12578(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12578=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12579()
*              ~n1          E3   !  E3         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  e3   !  e3 |  H  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U938/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(938).EQ.0) CALL CC12579(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12579=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1257()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o2 |  h  |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1257(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F1257=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12580()
*              ~n1          E3   !  E3         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  e3   !  e3 |  h  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U938/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(938).EQ.0) CALL CC12580(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12580=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12581()
*              ~n1          E3   !  E3         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  e3   !  e3 |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U938/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(938).EQ.0) CALL CC12581(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12581=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12582()
*              ~n1          E3   !  E3         ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  e3   !  e3 |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U938/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(938).EQ.0) CALL CC12582(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12582=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12583()
*              ~n1          U    !  U          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  u    !  u  |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U939/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(939).EQ.0) CALL CC12583(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12583=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12584()
*              ~n1          D    !  D          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  d    !  d  |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U940/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(940).EQ.0) CALL CC12584(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12584=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12585()
*              ~n1          C    !  C          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  c    !  c  |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U941/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(941).EQ.0) CALL CC12585(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12585=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12586()
*              ~n1          C    !  C          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  c    !  c  |  h  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U941/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(941).EQ.0) CALL CC12586(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12586=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12587()
*              ~n1          C    !  C          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  c    !  c  |  H  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U941/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(941).EQ.0) CALL CC12587(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12587=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12588()
*              ~n1          C    !  C          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  c    !  c  |  h  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U941/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(941).EQ.0) CALL CC12588(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12588=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12589()
*              ~n1          C    !  C          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  c    !  c  |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U941/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(941).EQ.0) CALL CC12589(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12589=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1258()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o1          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  h  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1258(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F1258=RNUM*(TOTNUM/TOTDEN)*Q1(7)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12590()
*              ~n1          C    !  C          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  c    !  c  |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U941/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(941).EQ.0) CALL CC12590(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12590=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12591()
*              ~n1          S    !  S          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  s    !  s  |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U942/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(942).EQ.0) CALL CC12591(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12591=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12592()
*              ~n1          S    !  S          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  s    !  s  |  h  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U942/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(942).EQ.0) CALL CC12592(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12592=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12593()
*              ~n1          S    !  S          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  s    !  s  |  H  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U942/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(942).EQ.0) CALL CC12593(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12593=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12594()
*              ~n1          S    !  S          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  s    !  s  |  h  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U942/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(942).EQ.0) CALL CC12594(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12594=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12595()
*              ~n1          S    !  S          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  s    !  s  |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U942/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(942).EQ.0) CALL CC12595(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12595=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12596()
*              ~n1          S    !  S          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  s    !  s  |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U942/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(942).EQ.0) CALL CC12596(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12596=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12597()
*              ~n1          T    !  T          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  t    !  t  |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U943/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(943).EQ.0) CALL CC12597(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12597=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12598()
*              ~n1          T    !  T          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  t    !  t  |  h  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U943/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(943).EQ.0) CALL CC12598(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12598=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12599()
*              ~n1          T    !  T          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  t    !  t  |  H  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U943/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(943).EQ.0) CALL CC12599(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12599=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1259()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H  |  s    !  s  |  H  | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1259(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)-C(1)
      F1259=RNUM*(TOTNUM/TOTDEN)*Q2(8)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F125()
*                    ~o1    Z    !  Z    ~o1                         
*                   =====@-1-----!---1-@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~o1 |  H    !  H  | ~o1                         
*                   =====@-------!-----@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(7)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC125(C)
      TOTNUM=+C(7)
      TOTDEN=+C(6)
      RNUM=+P2*(P1*(C(4)+8*P2)+C(3)-C(5)*P2)+C(2)*P1-C(1)
      F125=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(9)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(6
     >)*Q0(7)*Q0(8)*Q0(10)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12600()
*              ~n1          T    !  T          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  t    !  t  |  h  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U943/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(943).EQ.0) CALL CC12600(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12600=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12601()
*              ~n1          T    !  T          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  t    !  t  |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U943/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(943).EQ.0) CALL CC12601(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12601=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12602()
*              ~n1          T    !  T          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  t    !  t  |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U943/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(943).EQ.0) CALL CC12602(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12602=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12603()
*              ~n1          B    !  B          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  b    !  b  |  Z  | ~N1                   
*             --<--@-1---@==>====!==>==@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U944/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(944).EQ.0) CALL CC12603(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12603=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12604()
*              ~n1          B    !  B          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  b    !  b  |  h  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U944/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(944).EQ.0) CALL CC12604(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12604=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12605()
*              ~n1          B    !  B          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  b    !  b  |  H  | ~N1                   
*             --<--@-1---@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U944/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(944).EQ.0) CALL CC12605(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12605=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12606()
*              ~n1          B    !  B          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  b    !  b  |  h  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U944/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(944).EQ.0) CALL CC12606(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12606=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12607()
*              ~n1          B    !  B          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  b    !  b  |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U944/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(944).EQ.0) CALL CC12607(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12607=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12608()
*              ~n1          B    !  B          ~n1                   
*             -->--\     /==<====!==<==\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  b    !  b  |  H  | ~N1                   
*             --<--@-----@==>====!==>==@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U944/ Q0(3),Q1(3),Q2(3)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(944).EQ.0) CALL CC12608(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+C(1)+P1
      F12608=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12609()
*                    ~n1    h    !  h    ~n1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  h    !  h  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12609(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12609=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1260()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o2 |  H  |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1260(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F1260=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12610()
*                                !  h    ~n1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~n1    h   |!  h  | ~N1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~n1|P5    |!                                   
*                    ~N1 |  h   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12610(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12610=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12611()
*                 ~n1    h    !  h          ~n1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  h    !  h  |  h  | ~N1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12611(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12611=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12612()
*                                !       ~n1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~n1    h    !  h  | ~N1                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~n1|P5     !     |                             
*                    ~N1 |  h    !  h  |                             
*                   --<--@-------!-----/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12612(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12612=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12613()
*                 ~n1    h    !  h          ~n1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  h    !  h  |  H  | ~N1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12613(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12613=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12614()
*              ~n1          h    !  h          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  h    !  h  |  h  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12614(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12614=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12615()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          h    !  h  | ~N1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  h  |  h    !  h  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12615(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12615=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12616()
*              ~n1          h    !  h          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  h    !  h  |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12616(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12616=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12617()
*                    ~n1         !       ~n1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N1 |  h    !  h  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  h    !  h  |                             
*                        \-------!-----/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12617(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12617=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12618()
*                 ~n1         !                                      
*                -->--\       !                                      
*                  P1 |       !                                      
*                     |       !                                      
*                 ~N1 |  h    !  h          ~n1                      
*                --<--@-------!-----\     /-->--                     
*                  P2 |  P4   !  P4 |     |  P1                      
*                     |       !     |     |                          
*                     |  h    !  h  |  H  | ~N1                      
*                     \-------!-----@-----@--<--                     
*                        P3   !  P3   -P5    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12618(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12618=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12619()
*              ~n1          h    !  h          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  h    !  h  |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U945/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(945).EQ.0) CALL CC12619(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12619=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1261()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o1          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1261(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F1261=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12620()
*                    ~n1    h    !  h    ~n1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  H    !  H  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12620(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12620=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12621()
*                 ~n1    h    !  h          ~n1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  H    !  H  |  h  | ~N1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12621(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12621=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12622()
*                                !  H    ~n1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~n1    h   |!  h  | ~N1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~n1|P5    |!                                   
*                    ~N1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12622(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12622=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12623()
*                 ~n1    h    !  h          ~n1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  H    !  H  |  H  | ~N1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12623(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12623=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12624()
*                                !       ~n1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~n1    h    !  h  | ~N1                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~n1|P5     !     |                             
*                    ~N1 |  H    !  H  |                             
*                   --<--@-------!-----/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12624(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12624=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12625()
*              ~n1          h    !  h          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H    !  H  |  h  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12625(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12625=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12626()
*                                   !  H    ~n1                      
*                                  /!-----@-->--                     
*                                  |!  P4 |  P1                      
*                                  |!  ~n1|-P6                       
*                 ~n1          h   |!  h  | ~N1                      
*                -->--\     /------+!-----@--<--                     
*                  P1 |     |  P3  |!  P3    P2                      
*                     |     |      |!                                
*                 ~N1 |  h  |  H   |!                                
*                --<--@-----@------/!                                
*                  P2    P5    P4   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12626(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12626=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12627()
*              ~n1          h    !  h          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H    !  H  |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12627(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12627=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12628()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          h    !  h  | ~N1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  h  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12628(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12628=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12629()
*                    ~n1    H    !  H    ~n1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  h    !  h  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12629(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12629=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1262()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o2 |  H  |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1262(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(1)+C(3)*P2
      F1262=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12630()
*                             !  h          ~n1                      
*                            /!-----\     /-->--                     
*                            |!  P3 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    H   |!  H  |  H  | ~N1                      
*                -->--@------+!-----@-----@--<--                     
*                  P1 |  P4  |!  P4   -P6    P2                      
*                  ~n1|P5    |!                                      
*                 ~N1 |  h   |!                                      
*                --<--@------/!                                      
*                  P2    P3   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12630(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12630=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12631()
*                    ~n1    H    !       ~n1                         
*                   -->--@-----\ !     /-->--                        
*                     P1 |  P4 | !     |  P1                         
*                     ~n1|P5   | !     |                             
*                    ~N1 |  h  | !  h  | ~N1                         
*                   --<--@-----+-!-----@--<--                        
*                     P2    P3 | !  P3 |  P2                         
*                              | !     |                             
*                              | !  H  |                             
*                              \-!-----/                             
*                                !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12631(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12631=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12632()
*              ~n1          h    !  h          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  H    !  H  |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12632(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12632=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12633()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          h    !  h  | ~N1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P3   !  P3 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  H  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P4   !  P4                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12633(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12633=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12634()
*                    ~n1         !       ~n1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N1 |  h    !  h  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P3   !  P3 |  P2                         
*                        |       !     |                             
*                        |  H    !  H  |                             
*                        \-------!-----/                             
*                           P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U946/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(946).EQ.0) CALL CC12634(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12634=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12635()
*              ~n1          h    !  h          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  H3   !  H3 |  Z  | ~N1                   
*             --<--@-1---@-------!-----@---2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U947/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(947).EQ.0) CALL CC12635(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P1-16*P2)+P2*(16*P2-C(3))+C(1)
      F12635=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12636()
*              ~n1          H    !  H          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H    !  H  |  h  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12636(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12636=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12637()
*                 ~n1          H    !  H    ~n1                      
*                -->--\     /-------!-----@-->--                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~n1|-P6                       
*                 ~N1 |  h  |  H    !  H  | ~N1                      
*                --<--@-----@-------!-----@--<--                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12637(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12637=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12638()
*              ~n1          H    !  H          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H    !  H  |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12638(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12638=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12639()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          H    !  H  | ~N1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  h  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12639(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12639=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1263()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o1          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H  |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1263(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*P2-C(2))+C(3)*P2-C(1)
      F1263=RNUM*(TOTNUM/TOTDEN)*Q1(8)*Q1(6)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >5)*Q0(7)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12640()
*                    ~n1    H    !  H    ~n1                         
*                   -->--@-------!-----@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~n1|P5     !  ~n1|-P6                          
*                    ~N1 |  H    !  H  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12640(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12640=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12641()
*                                !  H    ~n1                         
*                               /!-----@-->--                        
*                               |!  P4 |  P1                         
*                               |!  ~n1|-P6                          
*                    ~n1    H   |!  H  | ~N1                         
*                   -->--@------+!-----@--<--                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~n1|P5    |!                                   
*                    ~N1 |  H   |!                                   
*                   --<--@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12641(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12641=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(2)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12642()
*                 ~n1    H    !  H          ~n1                      
*                -->--@-------!-----\     /-->--                     
*                  P1 |  P3   !  P3 |     |  P1                      
*                  ~n1|P5     !     |     |                          
*                 ~N1 |  H    !  H  |  H  | ~N1                      
*                --<--@-------!-----@-----@--<--                     
*                  P2    P4   !  P4   -P6    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12642(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12642=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(3)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12643()
*                                !       ~n1                         
*                                !     /-->--                        
*                                !     |  P1                         
*                                !     |                             
*                    ~n1    H    !  H  | ~N1                         
*                   -->--@-------!-----@--<--                        
*                     P1 |  P3   !  P3 |  P2                         
*                     ~n1|P5     !     |                             
*                    ~N1 |  H    !  H  |                             
*                   --<--@-------!-----/                             
*                     P2    P4   !  P4                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12643(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12643=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12644()
*              ~n1          H    !  H          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  H    !  H  |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12644(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12644=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12645()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          H    !  H  | ~N1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  H  |  H    !  H  |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12645(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12645=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12646()
*                    ~n1         !       ~n1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N1 |  H    !  H  | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H    !  H  |                             
*                        \-------!-----/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U948/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(948).EQ.0) CALL CC12646(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12646=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12647()
*              ~n1          H    !  H          ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P3   !  P3 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  H3   !  H3 |  Z  | ~N1                   
*             --<--@-1---@-------!-----@---2-@--<--                  
*               P2    P5    P4   !  P4   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U949/ Q0(1),Q1(1),Q2(1)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(949).EQ.0) CALL CC12647(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+4*P1-16*P2)+P2*(16*P2-C(3))+C(1)
      F12647=RNUM*(TOTNUM/TOTDEN)*Q2(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12648()
*              ~n1          H3   !  H3         ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H3   !  H3 |  h  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U950/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(950).EQ.0) CALL CC12648(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12648=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12649()
*              ~n1          H3   !  H3         ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H3   !  H3 |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U950/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(950).EQ.0) CALL CC12649(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12649=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1264()
*              ~o1          S    !  S          ~o1                   
*             =====\     /==<====!==<==\     /=====                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~o2 |  H3 |  s    !  s  |  H3 | ~o2                   
*             =====@-----@==>====!==>==@-----@=====                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1264(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+P1*(C(2)+2*P1)+C(1)
      F1264=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12650()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          H3   !  H3 | ~N1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  h  |  H3   !  H3 |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U950/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(950).EQ.0) CALL CC12650(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12650=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12651()
*              ~n1          H3   !  H3         ~n1                   
*             -->--\     /-------!-----\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  H3   !  H3 |  H  | ~N1                   
*             --<--@-----@-------!-----@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U950/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(950).EQ.0) CALL CC12651(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12651=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12652()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          H3   !  H3 | ~N1                      
*                -->--\     /-------!-----@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  H  |  H3   !  H3 |                          
*                --<--@-----@-------!-----/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U950/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(950).EQ.0) CALL CC12652(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12652=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12653()
*                    ~n1         !       ~n1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N1 |  H3   !  H3 | ~N1                         
*                   --<--@-------!-----@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H3   !  H3 |                             
*                        \-------!-----/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U950/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(950).EQ.0) CALL CC12653(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12653=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12654()
*                    ~n1    H+   !  H+   ~n1                         
*                   -->--@-->----!-->--@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~e1|P5     !  ~e1|-P6                          
*                    ~N1 |  H-   !  H- | ~N1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12654(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12654=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12655()
*                             !  H-         ~n1                      
*                            /!--<--\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    H+  |!  H+ |  Z  | ~N1                      
*                -->--@-->---+!-->--@---1-@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~N1 |  H-  |!                                      
*                --<--@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12655(C)
      TOTNUM=-C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12655=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12656()
*                             !  H-         ~n1                      
*                            /!--<--\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    H+  |!  H+ |  h  | ~N1                      
*                -->--@-->---+!-->--@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~N1 |  H-  |!                                      
*                --<--@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12656(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12656=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12657()
*                             !  H-         ~n1                      
*                            /!--<--\     /-->--                     
*                            |!  P4 |     |  P1                      
*                            |!     |     |                          
*                 ~n1    H+  |!  H+ |  H  | ~N1                      
*                -->--@-->---+!-->--@-----@--<--                     
*                  P1 |  P3  |!  P3   -P6    P2                      
*                  ~e1|P5    |!                                      
*                 ~N1 |  H-  |!                                      
*                --<--@--<---/!                                      
*                  P2    P4   !                                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12657(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12657=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12658()
*                    ~n1    H+   !       ~n1                         
*                   -->--@-->--\ !     /-->--                        
*                     P1 |  P3 | !     |  P1                         
*                     ~e1|P5   | !     |                             
*                    ~N1 |  H- | !  H- | ~N1                         
*                   --<--@--<--+-!--<--@--<--                        
*                     P2    P4 | !  P4 |  P2                         
*                              | !     |                             
*                              | !  H+ |                             
*                              \-!-->--/                             
*                                !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12658(C)
      TOTNUM=-C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12658=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12659()
*              ~n1          H-   !  H-         ~n1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  H+   !  H+ |  Z  | ~N1                   
*             --<--@-1---@-->----!-->--@---2-@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12659(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P1*(C(2)+P1-4*P2)+P2*(4*P2-C(3))+C(1)
      F12659=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1265()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s1|-P6                       
*                 ~o2 |  H3 |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1265(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F1265=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12660()
*              ~n1          H-   !  H-         ~n1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  H+   !  H+ |  h  | ~N1                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12660(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12660=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12661()
*              ~n1          H-   !  H-         ~n1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  Z  |  H+   !  H+ |  H  | ~N1                   
*             --<--@-1---@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12661(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12661=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12662()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          H-   !  H- | ~N1                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  Z  |  H+   !  H+ |                          
*                --<--@-1---@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(3)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12662(C)
      TOTNUM=+C(3)
      TOTDEN=+C(2)
      RNUM=+2*P2-C(1)-P1
      F12662=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12663()
*              ~n1          H-   !  H-         ~n1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H+   !  H+ |  h  | ~N1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12663(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12663=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12664()
*              ~n1          H-   !  H-         ~n1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  h  |  H+   !  H+ |  H  | ~N1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12664(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12664=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12665()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          H-   !  H- | ~N1                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  h  |  H+   !  H+ |                          
*                --<--@-----@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12665(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12665=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12666()
*              ~n1          H-   !  H-         ~n1                   
*             -->--\     /--<----!--<--\     /-->--                  
*               P1 |     |  P4   !  P4 |     |  P1                   
*                  |     |       !     |     |                       
*              ~N1 |  H  |  H+   !  H+ |  H  | ~N1                   
*             --<--@-----@-->----!-->--@-----@--<--                  
*               P2    P5    P3   !  P3   -P6    P2                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12666(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12666=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12667()
*                                   !       ~n1                      
*                                   !     /-->--                     
*                                   !     |  P1                      
*                                   !     |                          
*                 ~n1          H-   !  H- | ~N1                      
*                -->--\     /--<----!--<--@--<--                     
*                  P1 |     |  P4   !  P4 |  P2                      
*                     |     |       !     |                          
*                 ~N1 |  H  |  H+   !  H+ |                          
*                --<--@-----@-->----!-->--/                          
*                  P2    P5    P3   !  P3                            
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12667(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12667=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12668()
*                    ~n1         !       ~n1                         
*                   -->--\       !     /-->--                        
*                     P1 |       !     |  P1                         
*                        |       !     |                             
*                    ~N1 |  H-   !  H- | ~N1                         
*                   --<--@--<----!--<--@--<--                        
*                     P2 |  P4   !  P4 |  P2                         
*                        |       !     |                             
*                        |  H+   !  H+ |                             
*                        \-->----!-->--/                             
*                           P3   !  P3                               
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U951/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(2)                                                    
      SAVE
      IF(L(951).EQ.0) CALL CC12668(C)
      TOTNUM=+C(2)
      TOTDEN=+C(1)
      RNUM=+1
      F12668=RNUM*(TOTNUM/TOTDEN)*Q0(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12669()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12669(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12669=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1266()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s1|-P6                       
*                 ~o1          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1266(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F1266=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12670()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12670(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12670=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12671()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12671(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12671=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12672()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12672(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12672=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12673()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12673(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12673=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12674()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12674(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12674=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12675()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12675(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12675=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12676()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12676(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12676=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12677()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12677(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12677=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12678()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n2 |  n2   !  n2 | ~n2                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U952/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(952).EQ.0) CALL CC12678(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12678=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12679()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12679(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12679=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1267()
*                 ~o1          S    !  S    ~o1                      
*                =====\     /==<====!==<==@=====                     
*                  P1 |     |  P4   !  P4 |  P1                      
*                     |     |       !  ~s2|-P6                       
*                 ~o2 |  H3 |  s    !  s  | ~o2                      
*                =====@-----@==>====!==>==@=====                     
*                  P2    P5    P3   !  P3    P2                      
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1267(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(4)*(P2-P1)-C(2))+C(3)*P2-C(1)
      F1267=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(5)*Q0(1)*Q0(3)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12680()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12680(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12680=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12681()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12681(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12681=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12682()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12682(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12682=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12683()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12683(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12683=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12684()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12684(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12684=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12685()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12685(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12685=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12686()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12686(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12686=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12687()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12687(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12687=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12688()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~N2 |  N2   !  N2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U953/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(953).EQ.0) CALL CC12688(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12688=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12689()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~N2 |  E2   !  E2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U954/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(954).EQ.0) CALL CC12689(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12689=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1268()
*                                   !  s    ~o1                      
*                                  /!==>==@=====                     
*                                  |!  P3 |  P1                      
*                                  |!  ~s2|-P6                       
*                 ~o1          S   |!  S  | ~o2                      
*                =====\     /==<===+!==<==@=====                     
*                  P1 |     |  P4  |!  P4    P2                      
*                     |     |      |!                                
*                 ~o2 |  H3 |  s   |!                                
*                =====@-----@==>===/!                                
*                  P2    P5    P3   !                                
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1268(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P2)+C(1)+C(3)*P2
      F1268=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(6)*Q0(1)*Q0(3)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12690()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~N2 |  E2   !  E2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U954/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(954).EQ.0) CALL CC12690(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12690=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12691()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~N2 |  E2   !  E2 | ~N2                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U954/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(954).EQ.0) CALL CC12691(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12691=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12692()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12692(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12692=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12693()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12693(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12693=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12694()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12694(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12694=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12695()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12695(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12695=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12696()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12696(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12696=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12697()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12697(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12697=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12698()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12698(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12698=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12699()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12699(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12699=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1269()
*                    ~o1    S    !  S    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~o2 |  s    !  s  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1269(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F1269=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F126()
*                                !  H    ~o1                         
*                               /!-----@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~o4|-P6                          
*                    ~o1    Z   |!  Z  | ~o1                         
*                   =====@-1----+!---1-@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~o2|P5    |!                                   
*                    ~o1 |  H   |!                                   
*                   =====@------/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U3/ Q0(10),Q1(10),Q2(10)
      DIMENSION C(8)                                                    
      SAVE
      IF(L(3).EQ.0) CALL CC126(C)
      TOTNUM=-C(8)
      TOTDEN=+C(7)
      RNUM=+P1*(P2*(8*(P2-P1)-C(5))+C(3)*P1-C(2))+P2*(C(6)*P2-C(4))+C(1)
      F126=RNUM*(TOTNUM/TOTDEN)*Q1(5)*Q1(10)*Q0(1)*Q0(2)*Q0(3)*Q0(4)*Q0(
     >6)*Q0(7)*Q0(8)*Q0(9)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12700()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12700(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12700=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12701()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~n3 |  n3   !  n3 | ~n3                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U955/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(4)                                                    
      SAVE
      IF(L(955).EQ.0) CALL CC12701(C)
      TOTNUM=+C(4)
      TOTDEN=+C(3)
      RNUM=+C(1)+C(2)*P1
      F12701=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12702()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12702(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12702=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12703()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12703(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12703=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12704()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12704(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12704=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12705()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12705(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12705=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12706()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12706(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12706=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12707()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12707(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12707=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12708()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12708(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12708=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12709()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12709(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12709=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1270()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s1|-P6                          
*                    ~o1    S   |!  S  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                    ~o2 |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1270(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1270=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12710()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12710(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12710=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12711()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~N3 |  N3   !  N3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U956/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(956).EQ.0) CALL CC12711(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12711=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12712()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U957/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(957).EQ.0) CALL CC12712(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12712=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12713()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U957/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(957).EQ.0) CALL CC12713(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12713=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12714()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~N3 |  E3   !  E3 | ~N3                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U957/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(957).EQ.0) CALL CC12714(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12714=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12715()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12715(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12715=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12716()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12716(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12716=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12717()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12717(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12717=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12718()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12718(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12718=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12719()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12719(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12719=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1271()
*                    ~o1    S    !  S    ~o1                         
*                   =====@==<====!==<==@=====                        
*                     P1 |  P4   !  P4 |  P1                         
*                     ~s1|P5     !  ~s2|-P6                          
*                    ~o2 |  s    !  s  | ~o2                         
*                   =====@==>====!==>==@=====                        
*                     P2    P3   !  P3    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1271(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P1*(C(2)+C(4)*P1-C(3)*P2)+P2*(C(4)*P2-C(2))+C(1)
      F1271=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(5)*Q0(1)*Q0(2)*Q0(4)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12720()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12720(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12720=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12721()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12721(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12721=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12722()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12722(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12722=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12723()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12723(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12723=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12724()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~u1 |  u    !  u  | ~u1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U958/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(958).EQ.0) CALL CC12724(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12724=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12725()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12725(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12725=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12726()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12726(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12726=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12727()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12727(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12727=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12728()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12728(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12728=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12729()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12729(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12729=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1272()
*                                !  s    ~o1                         
*                               /!==>==@=====                        
*                               |!  P3 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    S   |!  S  | ~o2                         
*                   =====@==<===+!==<==@=====                        
*                     P1 |  P4  |!  P4    P2                         
*                     ~s1|P5    |!                                   
*                    ~o2 |  s   |!                                   
*                   =====@==>===/!                                   
*                     P2    P3   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1272(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1272=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(6)*Q0(1)*Q0(2)*Q0(4)*Q0(5)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12730()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12730(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12730=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12731()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12731(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12731=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12732()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12732(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12732=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12733()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12733(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12733=RNUM*(TOTNUM/TOTDEN)*Q1(3)*Q1(4)*Q0(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12734()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o4|P5     !  ~o4|-P6                          
*                    ~U1 |  U    !  U  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U959/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(959).EQ.0) CALL CC12734(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12734=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12735()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U960/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(960).EQ.0) CALL CC12735(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12735=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12736()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U960/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(960).EQ.0) CALL CC12736(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12736=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12737()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  D    !  D  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U960/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(960).EQ.0) CALL CC12737(C)
      TOTNUM=-C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(4*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12737=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12738()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U961/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(961).EQ.0) CALL CC12738(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12738=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12739()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U961/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(961).EQ.0) CALL CC12739(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12739=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1273()
*                    ~o1    s    !  s    ~o1                         
*                   =====@==>====!==>==@=====                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~s1|P5     !  ~s1|-P6                          
*                    ~o2 |  S    !  S  | ~o2                         
*                   =====@==<====!==<==@=====                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(5)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1273(C)
      TOTNUM=+C(5)
      TOTDEN=+C(4)
      RNUM=+P2*(C(2)+C(3)*P2)+C(1)
      F1273=RNUM*(TOTNUM/TOTDEN)*Q2(4)*Q0(1)*Q0(2)*Q0(3)*Q0(5)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12740()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  S    !  S  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U961/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(961).EQ.0) CALL CC12740(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12740=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12741()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~1+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U962/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(962).EQ.0) CALL CC12741(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12741=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12742()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~1+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U962/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(962).EQ.0) CALL CC12742(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12742=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12743()
*                    ~n1    e1   !  e1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~2+|P5     !  ~2+|-P6                          
*                    ~U1 |  B    !  B  | ~U1                         
*                   --<--@==<====!==<==@--<--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U962/ Q0(2),Q1(2),Q2(2)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(962).EQ.0) CALL CC12743(C)
      TOTNUM=+C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12743=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12744()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o1|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U963/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(963).EQ.0) CALL CC12744(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12744=RNUM*(TOTNUM/TOTDEN)*Q2(1)*Q0(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12745()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U963/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(963).EQ.0) CALL CC12745(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12745=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(2)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12746()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U963/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(963).EQ.0) CALL CC12746(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12746=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(3)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12747()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o1|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U963/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(963).EQ.0) CALL CC12747(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12747=RNUM*(TOTNUM/TOTDEN)*Q1(1)*Q1(4)*Q0(2)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12748()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o2|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U963/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(963).EQ.0) CALL CC12748(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12748=RNUM*(TOTNUM/TOTDEN)*Q2(2)*Q0(1)*Q0(3)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12749()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U963/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(963).EQ.0) CALL CC12749(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12749=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(3)*Q0(1)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F1274()
*                                !  S    ~o1                         
*                               /!==<==@=====                        
*                               |!  P4 |  P1                         
*                               |!  ~s2|-P6                          
*                    ~o1    s   |!  s  | ~o2                         
*                   =====@==>===+!==>==@=====                        
*                     P1 |  P3  |!  P3    P2                         
*                     ~s1|P5    |!                                   
*                    ~o2 |  S   |!                                   
*                   =====@==<===/!                                   
*                     P2    P4   !                                   
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U43/ Q0(8),Q1(8),Q2(8)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(43).EQ.0) CALL CC1274(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F1274=RNUM*(TOTNUM/TOTDEN)*Q1(4)*Q1(5)*Q0(1)*Q0(2)*Q0(3)*Q0(6)*Q0(
     >7)*Q0(8)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12750()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o2|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U963/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(963).EQ.0) CALL CC12750(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12750=RNUM*(TOTNUM/TOTDEN)*Q1(2)*Q1(4)*Q0(1)*Q0(3)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12751()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o3|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*                   -->--@==>====!==>==@-->--                        
*                     P2    P4   !  P4    P2                         
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      COMMON/LOGG/L(1820)
      COMMON/VARS/A(1800)
      COMMON/SCLR/P1,P2,P3,P4,P5,P6,P7,P8,P9,PA,PB,PC,PD,PE,PF,PG,PH
     .,PI,PJ,PK,PL,PM,PN,PO,PP,PQ,PR,PS
      COMMON /U963/ Q0(4),Q1(4),Q2(4)
      DIMENSION C(6)                                                    
      SAVE
      IF(L(963).EQ.0) CALL CC12751(C)
      TOTNUM=-C(6)
      TOTDEN=+C(5)
      RNUM=+P2*(C(4)*(P2-P1)-C(3))+C(1)+C(2)*P1
      F12751=RNUM*(TOTNUM/TOTDEN)*Q2(3)*Q0(1)*Q0(2)*Q0(4)
      RETURN
      END

*******************************
*    CompHEP version 33.24    *
*******************************
      FUNCTION F12752()
*                    ~n1    n1   !  n1   ~n1                         
*                   -->--@==>====!==>==@-->--                        
*                     P1 |  P3   !  P3 |  P1                         
*                     ~o3|P5     !  ~o4|-P6                          
*                    ~d1 |  d    !  d  | ~d1                         
*  