#include "PILOT.inc"
      FUNCTION STRUCW(XW,IW,IH)
C
C          LONGITUDINAL W STRUCTURE FUNCTIONS CALCULATED BY CONVOLUTION
C          OF EHLQ STRUCTURE FUNCTIONS AT Q**2=AMW**2 WITH F(W/Q) FROM
C          DAWSON, N.P. B249, 42 (1985).
C          IW = 1   2   3   4
C               GM  W+  W-  Z0
C          WARNING: DEFAULT VALUES ONLY FOR LAMBDA, SIN2W, ETC.
C
#ifdef DOUBLE_X
      DOUBLE PRECISION X,XLOG
#endif
C          FOLLOWING CONSTANTS ARE (CV**2+CA**2)/(4*PI**2)
      DATA CVAW/2.701E-3/,CVAZUU/1.017E-3/,CVAZDD/1.298E-3/
C
C          STATEMENT FUNCTIONS CALCULATED BY INTEGRATING EACH TERM IN
C          EHLQ PARAMETERIZATION USING SMP 1.5.0.
C
C          FROM STRUCW2.EX
      FUVAL(X) = 5.769575427 - 10.13681547*X + 3.042561145*XLOG -
     $ 0.2798411214*(1./X) - 0.3404284678*(XLOG/X) + 8.296794608*(X**2)
     $ - 6.017283047*(X**3) + 3.548706099*(X**4) - 1.560232679*(X**5)
     $ + 0.4342326806*(X**6) - 0.05513649922*(X**7)
C
      FDVAL(X) = 2.533753356 - 4.57001915*X + 0.9589133982*XLOG -
     $ 0.307417692*(1./X) - 0.1793690733*(XLOG/X) + 4.566485508*(X**2)
     $ - 3.937617129*(X**3) + 2.773480477*(X**4) - 1.540248513*(X**5)
     $ + 0.6183097947*(X**6) - 0.1542126064*(X**7) +
     $ 0.0174859553*(X**8)
C
      FUSEA(X) = -5.503869566 + 15.20985662*X - 5.166205929*XLOG -
     $ 1.728208206*(1./X) - 0.4215945253*(XLOG/X) - 18.82164974*(X**2)
     $ + 24.27679709*(X**3) - 27.22445715*(X**4) + 24.98752188*(X**5)
     $ - 18.12394891*(X**6) + 10.06144542*(X**7) - 4.106763252*(X**8)
     $ + 1.15847115*(X**9) - 0.2014529514*(X**10) +
     $ 0.01625760301*(X**11)
C
      FDSEA(X) = -5.478593775 + 15.1097528*X - 5.581750835*XLOG -
     $ 1.987547927*(1./X) - 0.4944113864*(XLOG/X) - 17.23528157*(X**2)
     $ + 20.59071315*(X**3) - 21.48775889*(X**4) + 18.40750425*(X**5)
     $ - 12.46901771*(X**6) + 6.45303238*(X**7) - 2.445316084*(X**8) +
     $ 0.6363027326*(X**9) - 0.1011660335*(X**10) +
     $ 0.007376682094*(X**11)
C
      GUVAL1(X) = 6.650062246 + 1.480836233*X - 3.536793901*XLOG -
     $ 5.08758928*(1./X) - 2.458893299*(XLOG/X) -
     $ 0.4159265541*(XLOG**2/X) - 0.03949356966*(XLOG**3/X) -
     $ 0.002175877338*(XLOG**4/X) - 6.382577207E-5*(XLOG**5/X) -
     $ 7.324244818E-7*(XLOG**6/X) + 0.575121435*(X*XLOG) +
     $ 0.09704190061*(X*XLOG**2) + 791./90953.*(X *XLOG**3)
      GUVAL2(X) =
     $ 3.962955366E-4*(X*XLOG**4) + 6.591820335E-6*(X *XLOG**5) -
     $ 0.07706665525*(X**2*XLOG) - 0.01260088982*(X**2*XLOG**2) -
     $ 0.001080476729*(X**2*XLOG**3) - 4.647425231E-5*(X**2*XLOG**4) -
     $ 7.324244829E-7*(X**2*XLOG**5) - 0.2027508558*(X**2) -
     $ 0.6721633358*(XLOG**2) - 0.07339139987*(XLOG**3) -
     $ 0.004744695259*(XLOG**4) - 1.651100349E-4*XLOG**5 -
     $ 2.197273446E-6*XLOG**6
C
      GDVAL1(X) = 2.403815112 + 1.359504335*X - 2.144999226*XLOG -
     $ 2.357471591*(1./X) - 1.13339787*(XLOG/X) -
     $ 0.2003574358*(XLOG**2/X) - 0.02221455952*(XLOG**3/X) -
     $ 0.001601991722*(XLOG**4/X) - 6.878677010E-5*(XLOG**5/X) -
     $ 1.323789434E-6*(XLOG**6/X) + 0.4984901703*(X*XLOG) +
     $ 0.09080940556*(X*XLOG**2) + 0.01045471879*(X *XLOG**3)
      GDVAL2(X) =
     $ 7.339489291E-4*(X*XLOG**4) + 2.382820980E-5*(X *XLOG**5) -
     $ 0.1348586553*(X**2*XLOG) - 0.02441501092*(X**2*XLOG**2) -
     $ 0.002734669503*(X**2*XLOG**3) - 1.807502877E-4*(X**2*XLOG**4) -
     $ 5.295157736E-6*(X**2*XLOG**5) + 0.01826324487*(X**3*XLOG) +
     $ 0.003291926818*(X**3*XLOG**2) + 3.636001057E-4*(X**3*XLOG**3) +
     $ 2.342115438E-5*(X**3*XLOG**4) + 6.618947159E-7*(X**3*XLOG**5) -
     $ 0.3679347826*(X**2) + 0.04985470259*(X**3) -
     $ 0.3928663839*(XLOG**2) - 0.04732954832*(XLOG**3) -
     $ 0.003974205548*( XLOG**4) - 2.116051876E-4*XLOG**5 -
     $ 5.295157736E-6*XLOG**6
C
      GUSEA1(X) = -0.8251281831 + 1.555766474*X - 0.476618796*XLOG -
     $ 0.157877015*(1./X) + 0.3273497735*(XLOG/X) +
     $ 0.1184829659*(XLOG**2/X) + 0.01147973292*(XLOG**3/X) +
     $ 0.001370332595*(XLOG**4/X) + 4.084139287E-5*(XLOG**5/X) +
     $ 2.284079310E-6*(XLOG**6/X) - 1.681676555*(X*XLOG) +
     $ 0.01771802464*(X*XLOG**2) - 0.04546554244*(X *XLOG**3) -
     $ 3.454606694E-4*(X*XLOG**4) - 1.438969965E-4*(X *XLOG**5) +
     $ 0.8875664376*(X**2*XLOG) + 0.04051742981*(X**2 *XLOG**2)
      GUSEA2(X) =
     $ 0.0254151271*(X**2*XLOG**3) + 4.583985126E-4*(X**2*XLOG**4) +
     $ 7.994277584E-5*(X**2*XLOG**5) - 0.4492144518*(X**3*XLOG) -
     $ 0.02965496152*(X**3*XLOG**2) - 0.01288679853*(X**3*XLOG**3) -
     $ 2.791634921E-4*(X**3*XLOG**4) - 3.997138792E-5*(X**3*XLOG**5) +
     $ 0.1638328221*(X**4*XLOG) + 0.01250393016*(X**4*XLOG**2) +
     $ 0.004685172364*(X**4*XLOG**3) + 1.100919901E-4*(X**4*XLOG**4) +
     $ 1.438969967E-5*(X**4*XLOG**5) - 0.0367848506*(X**5*XLOG) -
     $ 0.003035305139*(X**5*XLOG**2) - 0.001048416117*(X**5*XLOG**3) -
     $ 2.579726667E-5*(X**5*XLOG**4) - 3.197711036E-6*(X**5*XLOG**5) +
     $ 0.003783780648*(X**6*XLOG) + 3.278296157E-4*(X**6*XLOG**2) +
     $ 1.075296502E-4*(X**6*XLOG**3) + 2.725601849E-6*(X**6*XLOG**4)
      GUSEA3(X) =
     $ 3.262970444E-7*(X**6*XLOG**5) - 0.2259054436*(X**2) +
     $ 0.003364712414*(X**3) + 0.01992787001*(X**4) - 0.007399430903*
     $ (X**5) + 9.652150086E-4*X**6 + 0.554652844*(XLOG**2) +
     $ 0.011217842*(XLOG**3) + 0.007692743973*(XLOG**4) +
     $ 9.402708800E-5*XLOG**5 + 1.598855517E-5*XLOG**6
C
      GDSEA1(X) = -0.9201807217 + 2.243479849*X - 0.899698589*XLOG -
     $ 0.3970657521*(1./X) + 0.2818290666*(XLOG/X) +
     $ 0.120664241*(XLOG**2/X) + 0.01043451714 *(XLOG**3/X) +
     $ 0.001191246128*(XLOG**4/X) + 3.001102810E-5*(XLOG**5/X) +
     $ 2.039937816E-6*(XLOG**6/X) - 1.787863927*(X*XLOG) +
     $ 826./63247.*(X*XLOG**2) - 0.04263009293*(X*XLOG**3) +
     $ 3.087205491E-5*( X*XLOG**4) - 1.285160824E-4*(X*XLOG**5) +
     $ 0.9517638436*(X**2*XLOG) + 0.04047432532*(X**2*XLOG**2) +
     $ 0.02332032497*(X**2*XLOG**3) + 2.208416029E-4*(X**2*XLOG**4)
      GDSEA2(X) =
     $ 7.139782355E-5*(X**2*XLOG**5) - 0.4816526149*(X**3*XLOG) -
     $ 0.02893293689*(X**3*XLOG**2) - 0.01172595961*(X**3*XLOG**3) -
     $ 1.550444419E-4*(X**3*XLOG**4) - 3.569891178E-5*(X**3*XLOG**5) +
     $ 0.1755025883*(X**4*XLOG) + 0.01209064681*(X**4*XLOG**2) +
     $ 0.004244259809*(X**4*XLOG**3) + 6.438373778E-5*(X**4*XLOG**4) +
     $ 1.285160826E-5*(X**4*XLOG**5) - 0.03937044174*(X**5*XLOG) -
     $ 0.002920614679*(X**5*XLOG**2) - 9.471446970E-4*(X**5*XLOG**3) -
     $ 1.549746135E-5*(X**5*XLOG**4) - 2.855912944E-6*(X**5*XLOG**5)
      GDSEA3(X) =
     $ 0.004046756409*(X**6*XLOG) + 3.144555106E-4*(X**6*XLOG**2) +
     $ 9.696129739E-5*(X**6*XLOG**3) + 1.664636351E-6*(X**6*XLOG**4) +
     $ 2.914196881E-7*(X**6*XLOG**5) - 0.5703745807*(X**2) +
     $ 0.1676594704*(X**3) - 0.03765961644*(X**4) +
     $ 0.005180399826*(X**5) - 3.032419889E-4*X**6 +
     $ 0.5916013402*(XLOG**2) + 0.0113078292*(XLOG**3) +
     $ 0.007094724813*( XLOG**4) + 3.872242009E-5*XLOG**5 +
     $ 1.427956471E-5*XLOG**6
C
      EUVAL(X) = -3.398748694 + 0.6266420937*(1./X)
      EDVAL(X) = -1.300464877 + 0.2267175031*(1./X)
      EUSEA(X) = -0.4281951222 + 0.0600001177*(1./X)
      EDSEA(X) = -0.5744690066 + 0.08143317382*(1./X)
C
C          ENTRY
C
      IF(XW.LE.0..OR.XW.GE.1.) THEN
        STRUCW=0.
        RETURN
      ENDIF
      X=XW
      XLOG=LOG(X)
C
      IIW=IW
      IF(IH.EQ.-1120) THEN
        IF(IW.EQ.2) IIW=3
        IF(IW.EQ.3) IIW=2
      ELSEIF(IH.EQ.1220) THEN
        IF(IW.EQ.2) IIW=3
        IF(IW.EQ.3) IIW=2
      ENDIF
C
      IF(XW.GT..1) GO TO 1000
C
C          STRUCW = XW*F(XW) FOR IIW=W+ IN PROTON, XW<.1
      IF(IIW.EQ.2) THEN
        G1=GUVAL1(X)
        G1=G1+GUVAL2(X)
        G2=GUSEA1(X)
        G2=G2+GUSEA2(X)
        G2=G2+GUSEA3(X)
        G3=GDSEA1(X)
        G3=G3+GDSEA2(X)
        G3=G3+GDSEA3(X)
        SUM=G1+G2+G3+EUVAL(X)+EUSEA(X)+EDSEA(X)
        STRUCW=X*CVAW*SUM
C          STRUCW = XW*F(XW) FOR IIW=W- IN PROTON, XW<.1
      ELSEIF(IIW.EQ.3) THEN
        G1=GDVAL1(X)
        G1=G1+GDVAL2(X)
        G2=GDSEA1(X)
        G2=G2+GDSEA2(X)
        G2=G2+GDSEA3(X)
        G3=GUSEA1(X)
        G3=G3+GUSEA2(X)
        G3=G3+GUSEA3(X)
        SUM=G1+G2+G3+EDVAL(X)+EDSEA(X)+EUSEA(X)
        STRUCW=X*CVAW*SUM
C          STRUCW=XW*F(XW) FOR IIW=Z0 IN PROTON, XW<.1
      ELSEIF(IIW.EQ.4) THEN
        G1=GUVAL1(X)
        G1=G1+GUVAL2(X)
        G2=GUSEA1(X)
        G2=G2+GUSEA2(X)
        G2=G2+GUSEA3(X)
        SUMU=G1+2.*G2+EUVAL(X)+2.*EUSEA(X)
        G1=GDVAL1(X)
        G1=G1+GDVAL2(X)
        G2=GDSEA1(X)
        G2=G2+GDSEA2(X)
        G2=G2+GDSEA3(X)
        SUMD=G1+2.*G2+EDVAL(X)+2.*EDSEA(X)
        STRUCW=X*(CVAZUU*SUMU+CVAZDD*SUMD)
      ENDIF
      IF(STRUCW.LT.0.) STRUCW=0.
      RETURN
C
1000  CONTINUE
C
C            STRUCW=XW*F(XW) FOR IIW=W+ IN PROTON, XW>.1
      IF(IIW.EQ.2) THEN
        F1=FUVAL(X)
        F2=FUSEA(X)
        F3=FDSEA(X)
        SUM=F1+F2+F3
        STRUCW=X*CVAW*SUM
C          STRUCW=XW*F(XW) FOR IIW=W- IN PROTON, XW>.1
      ELSEIF(IIW.EQ.3) THEN
        F1=FDVAL(X)
        F2=FDSEA(X)
        F3=FUSEA(X)
        SUM=F1+F2+F3
        STRUCW=X*CVAW*SUM
C          STRUCW=XW*F(XW) FOR IIW=Z0 IN PROTON, XW>.1
      ELSEIF(IIW.EQ.4) THEN
        F1=FUVAL(X)
        F2=FUSEA(X)
        SUMU=F1+2.*F2
        F1=FDVAL(X)
        F2=FDSEA(X)
        SUMD=F1+2.*F2
        STRUCW=X*(CVAZUU*SUMU+CVAZDD*SUMD)
      ENDIF
      IF(STRUCW.LT.0.) STRUCW=0.
      RETURN
      END
