#include "PILOT.inc"
      SUBROUTINE MBSET
C
C          SET PARAMETERS FOR GENERATING MINBIAS EVENTS OR BEAM JETS,
C          ALLOWING DIFFERENT PARAMETERS FOR TWO CASES.
C
#include "itapes.inc"
#include "mbpar.inc"
#include "mbgen.inc"
#include "primar.inc"
#include "totals.inc"
#include "keys.inc"
C
C
C          DN/DY INCREASES WITH LOG(S). INCLUDED IN SPLITTING FUNCTION
C          BECAUSE AVERAGE MULTIPLICITY COMES FROM SINGLE CHAIN GRAPH.
      XGEN0(1)=.9
      XGEN0(2)=1.+0.35*ALOG(ECM/60.)
C
C          POMWT ARE (RELATIVE) PROBABILITIES FOR N CUT POMERONS.
C          PDIFFR IS DIFFRACTIVE PROBABILITY.
C          SIGQT0 IS MEAN PT.
      IF(KEYS(4)) THEN
        PDIFFR=.15
        SIGQT0=.35
        PSUM=0.
        DO 100 I=1,LIMPOM
        POMWT(I)=(1.+4.*I**2)*EXP(-1.8*I)
        PSUM=PSUM+POMWT(I)
100     CONTINUE
      ELSE
        PDIFFR=0.
        SIGQT0=.45
        PSUM=0.
        DO 110 I=1,LIMPOM
        POMWT(I)=(1.+4.*I**2)*EXP(-1.8*I)
        PSUM=PSUM+POMWT(I)
110     CONTINUE
        POMWT(1)=.1*POMWT(1)
        POMWT(2)=.2*POMWT(2)
        POMWT(3)=.5*POMWT(3)
      ENDIF
C
C          RENORMALIZE POMWT.
      PSUM=1./PSUM
      DO 200 I=1,LIMPOM
      POMWT(I)=PSUM*POMWT(I)
200   CONTINUE
      PSUM=0.
      DO 210 I=MNPOM,MXPOM
      PSUM=PSUM+POMWT(I)
210   CONTINUE
C
C          POMGEN IS USED TO SELECT NUMBER OF POMERONS.
      PGEN=0.
      PSUM=1./PSUM
      DO 300 I=1,LIMPOM
      POMGEN(I)=0.
300   CONTINUE
      DO 310 I=MNPOM,MXPOM
      PGEN=PGEN+PSUM*POMWT(I)
      POMGEN(I)=PGEN
310   CONTINUE
      POMGEN(MXPOM)=1.
C
C          SET /TOTALS/ FOR MINBIAS EVENTS USING LOG**2(S) FIT TO
C          TOTAL CROSS SECTION.
      IF(KEYS(4)) THEN
        SIGTOT=25.65*(1.+.0102*ALOG(SCM/1.76)**2)
        SIGTOT=PSUM*SIGTOT
        NKINPT=NEVENT
        SUMWT=SIGTOT*NKINPT
      ENDIF
C
      RETURN
      END
